/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/parallel/par1284/parioctl.h, par1284, c.basedd 96/06/25" */
/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  PARIOCTL.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  PARALLEL port device driver IOCTL include file.       */
/*                                                                            */
/*   FUNCTION: This module is the PARALLEL port device driver                 */
/*             IOCTL include file.                                            */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          96/03/01  Frank Schroeder Original developer.                     */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/
/*----------------------------------------------*/
/* IOCtl commands (from ioctl.inc)              */
/*----------------------------------------------*/
#define IOC_PC                0x05     /* Printer Control */
#define IOLW_IL               0x41     /* Illegal Command */
#define IOLW_FC               0x42     /* Set Frame Control (CPL, LPI) */
#define IOLW_RD               0x43     /* Set Redirection */
#define IOLW_IR               0x44     /* Set Infinite Retry */
#define IOLW_IC               0x45     /* Illegal Command */
#define IOLW_IP               0x46     /* Initialize Printer */
#define IOLW_J1               0x47     /* Reserved OS/2-Japan */
#define IOLW_AF               0x48     /* Activate Code Page and Font */
#define IOLW_17               0x4B     /* Set Int 17h Printing Timeout */
#define IOLW_MS               0x4C     /* Set Spooler Status */
#define IOLW_ST               0x4D     /* Set Print Job Title */
#define IOLW_TO               0x4E     /* Set Timeout Value */
#define IOLW_J2               0x4F     /* Reserved OS/2-Japan */
#define IOLW_DM               0x51     /* Set Direct Mode Access */
#define IOLW_CM               0x52     /* Set Communications Mode */
#define IOLW_DT               0x53     /* Set Data Transfer Mode */
#define IOLR_FC               0x62     /* Query Frame Control (CPL, LPI) */
#define IOLR_RD               0x63     /* Query Redirection */
#define IOLR_IR               0x64     /* Query Infinite Retry */
#define IOLR_GS               0x66     /* Query Printer Status */
#define IOLR_J1               0x67     /* Reserved OS/2-Japan */
#define IOLR_QF               0x69     /* Query Code Page and Font */
#define IOLR_VF               0x6A     /* Verify Code Page and Font */
#define IOLR_17               0x6B     /* Query Int 17h Printing Timeout */
#define IOLR_MS               0x6C     /* Query Spooler Status */
#define IOLR_TO               0x6E     /* Query Timeout Value */
#define IOLR_J2               0x6F     /* Reserved OS/2-Japan */
#define IOLR_DM               0x71     /* Query Direct Mode Access */
#define IOLR_CM               0x72     /* Query Communications Mode */
#define IOLR_DT               0x73     /* Query Data Transfer Mode */
#define IOLR_ID               0x74     /* Query Device ID (IEEE1284) */

typedef enum _strFlush {
        STR_FLUSH_ACTIVE_REQUEST,
        STR_FLUSH_ALL
} strFlush_t;

/*----------------------------------------------*/
/* GENERIC IOCtl Data Pointer Structures        */
/* Category 5: Printer Control IOCtl Commands   */
/*----------------------------------------------*/

/*----------------------------------------------*/
/* 42/62 Set/Query Frame Control                */
/*----------------------------------------------*/
typedef struct _parFrameCtrlPkt
{
   UCHAR    CharsPerLine;              /* characters per line */
   UCHAR    LinesPerInch;              /* lines per inch */

} parFrameCtrlSetPkt, parFrameCtrlQryPkt;

#define CPS_80       80                /* 80 chars per line horiz. spacing */
#define CPS_132      132               /* 132 chars per line horiz. spacing */
#define LPI_6        6                 /* 6 lines per inch vertical spacing */
#define LPI_8        8                 /* 8 lines per inch vertical spacing */

/*----------------------------------------------*/
/* 44/64 Set/Query Infinite Retry               */
/*----------------------------------------------*/
typedef struct _parInfinRetryPkt
{
   UCHAR    InfiniteRetry;             /* infinite retry flag */

} parInfinRetrySetPkt, parInfinRetryQryPkt;

#define DISABLE_IR   0                 /* disable infinite retry */
#define ENABLE_IR    1                 /* enable infinite retry */

/*----------------------------------------------*/
/* 46/66 Device Reset/Status Query              */
/*----------------------------------------------*/
typedef struct _parDeviceResetPkt
{
   UCHAR    Reserved;                  /* reserved */

} parDeviceResetPkt;

typedef struct _parStatusPortPkt
{
   UCHAR    StatusPort;                /* status port */

} parStatusPortQryPkt;

/*----------------------------------------------*/
/* 4E/6E Set/Query Write Timeout Value          */
/*----------------------------------------------*/
typedef struct _parWriteTimeoutPkt
{
   USHORT   WriteTimeout;              /* write timeout value */

} parWriteTimeoutSetPkt, parWriteTimeoutQryPkt;

/*----------------------------------------------*/
/* 51/71 Set/Query Direct Mode Access           */
/*----------------------------------------------*/
typedef struct _parDirectModePkt
{
   UCHAR    DirectAccess;              /* user specified direct access mode */

} parDirectModeSetPkt, parDirectModeQryPkt;

#define ENABLEDM     0x01              /* enable direct access */
#define DISABLEDM    0x00              /* disable direct access */

/*----------------------------------------------*/
/* 52/72 Set/Query Communication Mode           */
/*----------------------------------------------*/
typedef enum _PAR_COMM_MODES
{
  PAR_COMPATIBILITY = 1,
  PAR_NIBBLE,
  PAR_BYTE,
  PAR_ECP_WITHOUT_RLE,
  PAR_ECP_WITH_RLE,
  PAR_EPP,
  PAR_MAX_COMM_MODE = PAR_EPP

} PAR_COMM_MODES;

typedef struct _parCommModePkt
{
   PAR_COMM_MODES    CommModes;        /* communication mode */
} parCommModeSetPkt, parCommModeQryPkt;

/*----------------------------------------------*/
/* 53/73 Set/Query Data Transfer Mode           */
/*----------------------------------------------*/
typedef enum _parChannel
{
  PAR_DATA_CHANNEL         = 1,
  PAR_ADDRESS_CHANNEL      = 2

} parChannel;

typedef struct _parTimeoutParms
{
   ULONG             IdleTimeoutValue;
   ULONG             TimeoutValue;

} parTimeoutParms;

typedef struct _parDataXferModePkt
{
   parTimeoutParms   ReadTimeout;      /* read timeout values */
   parTimeoutParms   WriteTimeout;     /* write timeout values */
   parChannel        ParChannel;       /* logical channel */

} parDataXferModeSetPkt, parDataXferModeQryPkt;

/*----------------------------------------------*/
/* 74 Query Device ID String                    */
/*----------------------------------------------*/
typedef struct _parDeviceIDQryPkt
{
   USHORT   DataLength;                /* length of device id */

} parDeviceIDQryPkt;

