/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/parallel/par1284/parconst.h, par1284, c.basedd 96/11/14" */
/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  PARCONST.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Constants defined for the PARALLEL port device        */
/*                      driver.                                               */
/*                                                                            */
/*   FUNCTION: This module is the PARALLEL port device driver constants       */
/*             include file.                                                  */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          96/03/01  Frank Schroeder                                         */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#define MAX_PARALLEL_PORTS    3        /* maximum ports in BIOS data area */
#define MAX_PORTS             3        /* maximum reserved ports */
#define MAX_IRQS              2        /* maximum reserved irqs */

#define DECODE_WIDTH          16

/*----------------------------------------------*/
/* parallel port IRQ levels                     */
/*----------------------------------------------*/
#define IRQ5                  5        /* parallel port irq level */
#define IRQ7                  7        /* parallel port irq level */

/*----------------------------------------------*/
/* parallel port base addresses                 */
/*----------------------------------------------*/
#define PORT3BC               0x3bc    /* parallel port base port address */
#define PORT378               0x378    /* parallel port base port address */
#define PORT278               0x278    /* parallel port base port address */

/*----------------------------------------------*/
/* parallel port register set                   */
/*----------------------------------------------*/
#define DATA_REG              0x00     /* offset of data port from base */
#define STATUS_REG            0x01     /* offset of status port from base */
#define CTRL_REG              0x02     /* offset of control port from base */

/*----------------------------------------------*/
/* parallel port status register definitions    */
/*----------------------------------------------*/
#define STATUS_BUSY           0x80     /* busy bit */
#define STATUS_ACK            0x40     /* ack bit */
#define STATUS_PE             0x20     /* paper end bit */
#define STATUS_SLCT           0x10     /* select bit */
#define STATUS_FAULT          0x08     /* error bit */
#define STATUS_IRQ            0x04     /* irq pending bit */

#define STATUS_INVERT         0x48     /* flip a couple bits */
#define STATUS_UNUSED         0x07     /* unused bits */
#define STATUS_READY          (STATUS_BUSY | STATUS_SLCT)

/*----------------------------------------------*/
/* parallel port control register definitions   */
/*----------------------------------------------*/
#define CONTROL_DIR           0x20     /* direction bit */
#define CONTROL_IRQEN         0x10     /* irq enable bit */
#define CONTROL_SELECT        0x08     /* select bit */
#define CONTROL_INIT          0x04     /* initialize bit */
#define CONTROL_AUTOFD        0x02     /* auto feed bit */
#define CONTROL_STROBE        0x01     /* strobe bit */

/*----------------------------------------------*/
/* Printer Control Commands                     */
/*----------------------------------------------*/
#define FRMCTRLCNT      3        /* bytes count needed to set frmctrl */
#define ESCAPE          0x1B     /* escape printer command */
#define COMPRESSED      0x0F     /* compressed printer command */
#define ENDCOMPRESSED   0x12     /* end compressed printer command */
#define ONESIXTH        50       /* one sixth printer command */
#define ONEEIGHTH       48       /* one eighth printer command */

/*----------------------------------------------*/
/* assembler commands                           */
/*----------------------------------------------*/
#define CLI()  _asm{cli}
#define STI()  _asm{sti}
#define CLC()  _asm{clc}
#define STC()  _asm{stc}

/*----------------------------------------------*/
/* Device ID strings                            */
/*----------------------------------------------*/
#define Compare1        "MODEL:"
#define Compare2        "MDL:"


