;/*************************************************************************
;*
;* SOURCE FILE NAME = DATA.ASM
;*
;* DESCRIPTIVE NAME = Mouse Device Driver Data Segment.
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              Copyright Microsoft Corporation, 1990
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         02/29/92
;*
;* DESCRIPTION  Mouse Device Driver Data Segment.
;*
;* FUNCTIONS
;*
;*
;*
;*
;*
;* NOTES        This file contains all Mouse Device Driver
;*              Data segment.  It is the 1st module in the linker
;*              list.
;*
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   02/29/92  @V2.0XXX01  DCR 1555
;*   04/04/93  @V2.1XXX02  53232  Add support for Logitech middle button
;*   04/21/93  @V2.1XXX03  67424  Lose mouse when coming back from suspend
;*                                mode on Dell 325nc laptop.
;*   06/03/93  @V2.1XXX04  69671  Lose pointing stick when coming back from
;*                                suspend mode on IBM 700 series laptops.
;*   10/20/95  @140921            Add new parameter to report presence of PDI
;*                                even when there is none.
;**************************************************************************

.386p

DSEG   SEGMENT   WORD  PUBLIC  USE16 'DATA'
DSEG   ENDS
_DATA  SEGMENT   WORD  PUBLIC  USE16 'DATA'
_DATA  ENDS
CONST  SEGMENT   WORD  PUBLIC  USE16 'CONST'
CONST  ENDS
_BSS   SEGMENT   WORD  PUBLIC  USE16 'BSS'
_BSS   ENDS
DGROUP GROUP DSEG, _DATA,CONST, _BSS


CSEG   SEGMENT   WORD  PUBLIC  USE16 'CODE'
CSEG   ENDS

_TEXT  SEGMENT   WORD  PUBLIC  USE16 'CODE'
_TEXT  ENDS

CSEG2  SEGMENT   WORD  PUBLIC  USE16 'SWAPCODE'
CSEG2  ENDS

CGROUP GROUP CSEG


INCL_WINPROGRAMLIST    equ          1      ; define for pmshl.inc defines
INCL_ERRORS            equ          1      ; define for pmshl.inc defines
SESMGR                 equ          1      ; define for pmshl.inc defines

.xlist
       include mouse.inc
       include pmshl.inc
       include emiidc.inc                  ; emi
.list


;*
;* External Mouse Referneces From this Module
;*

       extrn  Strat_Entry       : NEAR

       extrn  IOMW_SM           : far
       extrn  IOMW_SS           : far
       extrn  IOMW_EM           : far
       extrn  IOMW_TH           : far
       extrn  IOMW_PS           : far
       extrn  IOMW_DP           : far
       extrn  IOMW_RP           : far
       extrn  IOMW_SP           : far
       extrn  IOMW_SD           : far
       extrn  IOMW_DS           : far
       extrn  IOMW_MD           : far
       extrn  IOMW_RG           : far       ; GRADD

       extrn  IOMR_NB           : far
       extrn  IOMR_MC           : far
       extrn  IOMR_GS           : far
       extrn  IOMR_RD           : far
       extrn  IOMR_QS           : far
       extrn  IOMR_GM           : far
       extrn  IOMR_GF           : far
       extrn  IOMR_GP           : far
       extrn  IOMR_PS           : far
       extrn  IOMR_TH           : far
       extrn  IOMR_GV           : far
       extrn  IOMR_ID           : far
       extrn  IOMR_XY           : far       ;GRADD
       extrn  IOMW_CS           : far
       extrn  IOMR_CQ           : far

       extrn  REQ_ERR           : NEAR
       extrn  FLUSH             : NEAR
       extrn  OPEN              : NEAR
       extrn  CLOSE             : NEAR
       extrn  IOCTL             : NEAR
       extrn  DEINS             : NEAR
       extrn  INITCOMPLETE      : NEAR       ; @V2.1XXX03
       extrn  GIDC_Entry        : near
       extrn  PDDCMD_Register   : near
       extrn  PDDCMD_DeRegister : near
       extrn  PDDCMD_QueryType  : near
       extrn  Security_Hook1    : near       ; @V2.OXXX01
       extrn  Security_End1     : near       ; @V2.OXXX01
       extrn  Security_Hook2    : near       ; @V2.OXXX01
       extrn  Security_End2     : near       ; @V2.OXXX01


DSEG     SEGMENT

;*
;*      CP/DOS Device Driver Header
;*

MouseHDR    LABEL   WORD
            DW       -1                    ; Device header pointer
            DW       -1                    ; Device header pointer
            DW       DEV_IOCTL+DEV_CHAR_DEV+DEVLEV_3+DEV_30 ; DD attributes
            DW       Strat_Entry           ; Strategy Routine Offset
            DW       GIDC_Entry            ; Reserved
            DB       'MOUSE$  '            ; Device Name
            DW       0                     ; Protect-mode CS Strategy Selector
            DW       0                     ; Protect-mode DS selector
            DW       0                     ; Real-mode CS Strategy Segment
            DW       0                     ; Real-mode DS segment
            DD       DEV_16MB+DEV_INITCOMPLETE+DEV_SAVERESTORE ; Can handle > 16MB physical
                                           ; memory and Wants to be notified
                                           ; @V2.1XXX03 when all PDD's are initialized.

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;              C A L L   T A B L E  ==>  Protect Mode Functions            *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

;*      Mouse CP/DOS Request Block Command Code jump table
;*      Note: This table is only used after Initialization

 RBlk_Tbl    LABEL    WORD            ; 20 Word Label Offset Table
              DW      REQ_ERR         ; Unsupported Command            0
              DW      REQ_ERR         ; Unsupported Command            1
              DW      REQ_ERR         ; Unsupported Command            2
              DW      REQ_ERR         ; Unsupported Command            3
              DW      REQ_ERR         ; Unsupported Command            4
              DW      REQ_ERR         ; Unsupported Command            5
              DW      REQ_ERR         ; Unsupported Command            6
              DW      FLUSH           ; Input Flush Command Rtn        7
              DW      REQ_ERR         ; Unsupported Command            8
              DW      REQ_ERR         ; Unsupported Command            9
              DW      REQ_ERR         ; Unsupported Command            A
              DW      REQ_ERR         ; Unsupported Command            B
              DW      REQ_ERR         ; Unsupported Command            C
              DW      OPEN            ; Open Command Rtn               D
              DW      CLOSE           ; Close Command Rtn              E
              DW      REQ_ERR         ; Unsupported Command            F
              DW      IOCTL           ; Generic IOCTL Command Rtn      10
              DW      REQ_ERR         ; Unsupported Command            11
              DW      REQ_ERR         ; Unsupported Command            12
              DW      REQ_ERR         ; Unsupported Command            13
              DW      DEINS           ; DeInstall Command Rtn          14
              DW      REQ_ERR         ; Unsupported Command            15
              DW      REQ_ERR         ; Unsupported Command            16
              DW      REQ_ERR         ; Unsupported Command            17
              DW      REQ_ERR         ; Unsupported Command            18
              DW      REQ_ERR         ; Unsupported Command            19
              DW      REQ_ERR         ; Unsupported Command            1A
              DW      REQ_ERR         ; Unsupported Command            1B
              DW      REQ_ERR         ; Unsupported Command            1C
              DW      REQ_ERR         ; Undefined Command              1D
              DW      REQ_ERR         ; Undefined Command              1E
              DW      INITCOMPLETE    ; IniComplete Command Rtn        1F
                                      ; @V2.1XXX03
;*
;*      Mouse Generic IOCtl Function jump table
;*

 Func_Tbl    LABEL    WORD            ; 22 Word Label offset table
              DW      REQ_ERR         ; Function IOMW_SC, 50H removed
              DW      IOMW_SM         ; Function IOMW_SM, 51H
              DW      REQ_ERR         ; Function IOMW_SN, 52H removed
              DW      IOMW_SS         ; Function IOMW_SS, 53H
              DW      IOMW_EM         ; Function IOMW_EM, 54H
              DW      IOMW_TH         ; Function IOMW_TH, 55H
              DW      IOMW_PS         ; Function IOMW_PS, 56H
              DW      IOMW_DP         ; Function IOMW_DP, 57H
              DW      IOMW_RP         ; Function IOMW_RP, 58H
              DW      IOMW_SP         ; Function IOMW_SP, 59H
              DW      IOMW_SD         ; Function IOMW_SD, 5AH
              DW      REQ_ERR         ; removed           5Bh
              DW      IOMW_DS         ; Function IOMW_DS, 5CH
              DW      IOMW_MD         ; Function IOMW_MD, 5Dh
              DW      IOMW_RG         ; Function IOMW_RG, 5Eh (GRADD)
              DW      REQ_ERR         ; 5FH - unsupported
              DW      IOMR_NB         ; Function IOMR_NB, 60H
              DW      IOMR_MC         ; Function IOMR_MC, 61H
              DW      IOMR_GS         ; Function IOMR_GS, 62H
              DW      IOMR_RD         ; Function IOMR_RD, 63H
              DW      IOMR_QS         ; Function IOMR_QS, 64H
              DW      IOMR_GM         ; Function IOMR_GM, 65H
              DW      IOMR_GF         ; Function IOMR_GF, 66H
              DW      IOMR_GP         ; Function IOMR_GP, 67H
              DW      IOMR_PS         ; Function IOMR_PS, 68H
              DW      IOMR_TH         ; Function IOMR_TH, 69H
              DW      IOMR_GV         ; Function IOMR_GV, 6Ah
              DW      IOMR_ID         ; Function IOMR_ID, 6Bh
              DW      IOMW_CS         ; Function IOMR_CS, 6Ch
              DW      IOMR_CQ         ; Function IOMR_CQ, 6Dh
              DW      IOMR_XY         ; Function IOMR_XY, 6Eh  (GRADD)

;*
;* Mouse Generic IOCtl access table.  This table used to check access
;* to data and parameter areas for IOCtl calls.  Each supported IOCtl
;* has a 2 byte key.  The fisrt byte is the key for the parameter
;* packet and the second is for the data packet.
;* A key has the following format:
;*
;*      0 n t c l l l l   l - Indicate length of area to check (4 bits).
;*                            Can only check upto 16 bytes
;*                        c - 1 indicates access check is needed.
;*                        t - 1 for r/w, 0 for r check type
;*                        n - 1 indicates skip check if selector is NULL
;*

 AccessTbl   LABEL    byte
              DB      0,0                              ; IOMW_SC, 50H
              DB      READCHECK,READCHECK+NULLOK       ; IOMW_SM, 51H
              DB      0,0                              ; IOMW_SN, 52H
              DB      READCHECK+4,0                    ; IOMW_SS, 53H
              DB      READCHECK+2,0                    ; IOMW_EM, 54H
              DB      READCHECK,0                      ; IOMW_TH, 55H
              DB      0,0                              ; IOMW_PS, 56H
              DB      0,0                              ; IOMW_DP, 57H
              DB      READCHECK+8,0                    ; IOMW_RP, 58H
              DB      READCHECK+4,0                    ; IOMW_SP, 59H
              DB      READCHECK+6,READCHECK+NULLOK+6   ; IOMW_SD, 5AH
              DB      0,READCHECK+NULLOK               ; IOMW_RS, 5BH
              DB      READCHECK+2,0                    ; IOMW_DS, 5CH
              DB      0,0                              ; IOMW_MD, 5Dh
              DB      READCHECK+4,0                    ; IOMW_RG, 5Eh (GRADD)
              DB      0,0                              ; unused,  5FH
              DB      0,WRITECHECK+2                   ; IOMR_NB, 60H
              DB      0,WRITECHECK+2                   ; IOMR_MC, 61H
              DB      0,WRITECHECK+2                   ; IOMR_GS, 62H
              DB      READCHECK+2,0                    ; IOMR_RD, 63H
              DB      0,WRITECHECK+4                   ; IOMR_QS, 64H
              DB      0,WRITECHECK+2                   ; IOMR_GM, 65H
              DB      0,WRITECHECK+4                   ; IOMR_GF, 66H
              DB      0,WRITECHECK+4                   ; IOMR_GP, 67H
              DB      0,WRITECHECK+10                  ; IOMR_PS, 68H
              DB      0,WRITECHECK                     ; IOMR_TH, 69H
              DB      0,WRITECHECK+2                   ; IOMR_GV, 6Ah
              DB      0,WRITECHECK+4                   ; IOMR_ID, 6Bh

              db      0,READCHECK+4                    ; IOMW_CS, 6Ch
              db      0,WRITECHECK+4                   ; IOMW_CQ, 6Dh

              DB      0,WRITECHECK+10                  ; IOMR_XY, 6Eh (GRADD)

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;                 V A R I A B L E S  ==>  Protect Mode                     *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

                 even                 ; goto word address
MSEVDDEntry      df           0       ; vdd entry point

Ctl_Sem          DD           0       ; Processing Control Semaphore
Sem_Time         DD          -1       ; Forever process block/sleep time
Device_Help      DD           0       ; DEVHLP Entry Point Routine Address
InfoSegAddr      dd           0       ; Selector:Offset to the Local Infoseg

FgndCB           dd         SG1       ; foreground control block (start in 1)

Sem_PID          DW           0       ; Mouse DD Semaphore owner PID
ShellPID         dw           0       ; shell PID
CallPID          DW           0       ; Callers PID for a request
SQ_Pid           DW           0       ; Pid of process starting SQ mode
Eq_Length        DW   10*ElRec_Size   ; Max Total Event Queue byte size
IntEntry         dw           0       ; counter to entry in process_packet
StratEntry       dw           0
GDT_Seg          DW           0       ; GDT Info Seg Selector
DDDInit          dw           0       ; initialize flag for DDDD
EMaskMax         dw       007fh       ; max allowed event mask    @V2.1XXX02
VDM_Flags        dw           0       ; Flags for the state of all VDMs

CurCommand       db           0       ; current command for debugging
CurRequest       db           0       ; current request for debugging
TypeName         db    8 dup(' '),0,0 ; device name of Dep DD
STypeName        db    8 dup(' '),0,0 ; device name of Dep DD
CallSessn        DB           0       ; Callers session ID
FgndSessn        DB         01H       ; Foreground session ID (start in 1)
DeInstall        DB         OFF       ; DeInstallation Flag = not processed
Detach_Proc      DB         OFF       ; Detached Process Flag when ON
SQDDName         DB  'SINGLEQ$',0     ; SQ DD ASCIIZ Name
usQSize          dw           0       ; Queue size defaults to 10
TypeOverRider    db        TRUE       ; User specified a TYPE= overrider
SType            db       FALSE       ; User specified secondary type (STYPE)
ForceMouseON     db       FALSE       ; User request to report a PDI when no mouse found ;@140921 DCAF
Num_Grps         DB           0       ; # of SGs Supported by Mouse DD
Ptr_Overide      DB         OFF       ; SG Switch Pointer Draw Over-Ride Flag
Mouse$           db    'MOUSE$',0     ; mouse device name (add even bytes)
APMDDName        db    'APM$    ',0   ; APM device driver name ; @V2.1XXX03
APMIDCHandle     dw           0       ; IDC Handle to communicate with APM.SYS
APMIDCReg    APMIDC_REGISTER_PKT <>   ; APM IDC register packet
APMIDCDereg  APMIDC_DEREGISTER_PKT <> ; APM IDC register packet
Init_Time        db           0       ; Initialization routine flag
fNullMouse       db    FALSE          ; TRUE = No other device found, null mouse installed ;SRD
fNullMouseParm   db    FALSE          ; TRUE = User specified a null mouse     ;SRD

; emi stuff
EmiDDName        DB  'EMI$    ',0     ; Emi DD ASCIIZ Name              ;emi
EmiFlags         db           0       ; emi flags(defined in emi.inc)   ;emi
EmiMvt   MOUVARTABLE <>               ; mouse var table                 ;emi
EmiSSI   SESSWITCHINFO <>             ; session info                    ;emi


                        ; BEGIN @V2.OXXX01
DD 09CBE9F9Eh           ; 1st half DD end signature for MOUSE$
DD 0AFAB8BACh           ; 2nd half DD end signature for MOUSE$
DD Security_Hook1       ; Used for Process_Packet security hook area start
DD Security_End1        ; Used for Process_Packet security hook area end
DD Security_Hook2       ; Used for Process_Absolute security hook area start
DD Security_End2        ; Used for Process_Absolute security hook area end
DD 0A19CBEAEh           ; 1st half DD start signature for MOUSE$
DD 09E9FAB8Ch           ; 2nd half DD start signature for MOUSE$
                        ; END @V2.OXXX01


                 even

MEvent           Mon_Rec     <>       ; Current Mouse Monitor Data Record
Last_Event       Mon_Rec     <>       ; Last Mouse Monitor Data Record
DDD              Atch_DD     <>       ; record for attaching do dependent DD
DDD2             Atch_DD     <>       ; record for attaching do 2nd DDD
SQDD             Atch_DD     <>       ; SQ DD Interface Data Record
APMDD            Atch_DD     <>       ; APM DD Interface Data Record ; @V2.1XXX03
EmiDD            Atch_DD     <>       ; EMI DD Interface Data Record      ;emi
Ptr_Rec          Call_5Blk   <>       ; Ptr Draw DD multi-parm Addr struct


;*                                                                         ;emi
;* The SInt_Packet is filled in by the built in support or by the          ;emi
;* dependent mouse driver specified in the TYPE= config.sys parameter.     ;emi
;* The Int_Packet is used by the rest of the driver to proces the packet.  ;emi
;* They need to be independent incase EMI sends packets while the          ;emi
;* SInt_Packet is asynchronously being filled in.                          ;emi
;*

Int_Packet       Abs_Data    <>       ; Interrupt packet to process
SInt_Packet      Abs_Data    <>       ; Interrupt packet to process       ;emi

DeviceData       Dev_Data    <9,80,2,0,0,0,0>   ; mouse device data

Modes            Mode_Data   <>       ; VIO Mode Data Record Structure

FullScrCBs       CBPtrStruc  <SG0,0>
                 CBPtrStruc  <SG1,0>
                 CBPtrStruc  <0,0>
                 CBPtrStruc  <SG3,0>
                 db          12 * size CBPtrStruc dup (0)

;*
;* This in the event CB for all full screen VDMs
;*

VDM_Cols         dw          0        ; Number of columns in the FS VDM
VDM_Rows         dw          0        ; Number of rows in the FS VDM
VEvent           db (size VDMEvent_) dup (0)

;*
;*These are the entries for every handle given by the Open_Mouse call.
;*The Open_Mouse call is available to any DD that does an AttachDD
;*on MOUSE$. This call is function 0004h. We are allowing a maximum
;*of 5 open handles at any given time. The handle is a required parameter
;*for all other IDC functions greater then 00004h.
;*

even

IDC_CB           IDC_Entry <0,0>
                 IDC_Entry <0,0>
                 IDC_Entry <0,0>
                 IDC_Entry <0,0>
                 IDC_Entry <0,0>

SN_Flags         db          0        ; Special Needs flags


;*
;* This is the extended mode data and config data stuff.
;*

                 even
cfgdatalabel     label    word        ; insure word alignment

free_offset      dw       cfg_data_start
free_space       dw       end_cfg_data - cfg_data_start
cfg_offset       dw       8 dup (0)
ext_mode_data    db       16 * ExtModeLen dup (0)
cfg_data_start   db       560 dup (0)
end_cfg_data     db       0

;*************************************************************************
;*    Below is all the data used by the hardware dependent routines      *
;*************************************************************************

DevStatus     dw         0               ; current device status
                                         ; High byte: reserved 0
                                         ; Low byte:
                                         ;   0000000x  Read enabled
                                         ;   000000x0  MOUSE$ attach done
                                         ;   00000x00  IRQ enabled
                                         ;   0000x000  We've been deinstalled
                                         ;   00000000
                                         ;   00000000
                                         ;   00000000
ByteCount     dw         0               ; packet counter
SynchFlag     dw         0               ; packet synch flag ;53248 ;@V2.1XXX03
                                         ; High byte: reserved 0
                                         ; Low byte:
                                         ;   0000000x
                      ;@V2.1XXX04        ;   000000x0  Hot Plug stage one
                      ;@V2.1XXX04        ;   00000x00  Hot Plug stage two
                      ;@V2.1XXX04        ;   0000x000  APM Active/Inactive
                      ;@V2.1XXX04        ;   000x0000  APM Mouse Reset flag
                                         ;   00x00000
                                         ;   0x000000
                                         ;   x0000000
Dev_LID       dw         0
HotPlugHandle dd         0               ; Context hook routine Handle ;56543
                                         ; @V2.1XXX02
MiddleButFlag db         0               ; processing 4th data byte (mid butt)

Relaxed       db         0               ; do sync checking? (0=yes, 1=no)
SynchMask     db         0               ; packet synch mask     ;53248
gMEvent       db    5 dup (0)
_ABIOS_Mch    label  byte                ; "C" accessibility
ABIOS_Mch     db    FALSE                ; FALSE = Non ABIOS machine
                                         ; TRUE  = ABIOS machine

TranslateMode db    40h                  ; keyboard translate mode

AUXPortExists db    FALSE                ; FALSE = no AUX port
                                         ; TRUE  = an AUX port exists

PrescottDsp   db    FALSE                ; FALSE = not a Prescott Display
                                         ; TRUE  = Prescott Display installed

ScreenKeypad  db    FALSE                ; FALSE = not a screen reader pad
                                         ; TRUE  = screen reader pad attached

PortBase      dw         ?               ; Port Base Address
First_Port    dw         ?               ; Port Base Address in use
PrevEvent     dw         0               ; previous mouse event
InportAddr    dw         0               ; INP
InpVersion    db         ?               ; version/revision of Inport Mouse

LATLSBSave    DB        ?               ; Variables used to save and restore
LATMSBSave    DB        ?               ;  the COM port being tested.
LCRSave       DB        ?               ;  ...
MCRSave       DB        ?               ;  ...
IERSave       DB        ?               ;  ...

Enable_8259   DB        0               ;  ...
Disable_8259  DB        0               ;  ...
Enable_28259  db        0               ; Enable byte for 2nd controller
Disable_28259 db        0               ; Disable byte for 2nd controller
actvirqbit    db        16 dup (0)      ; active IRQ counts

;;****************** - Security Begin

Public Security_DS, Security_Off, Security_Enable, Security_Open
Security_DS         dw     ?
Security_Off        dd     ?
Security_Enable     db     0
Security_Open       dw    0FFFFh

;;****************** - Security End

        public  oddpts
oddpts        dw         238h, 338h,3220h,3228h
              dw        4220h,4228h,5220h,5228h,0

;*************************************************************************
;*    These are the pre allocated special screen group CBs               *
;*************************************************************************

SG0       db (size ScrGp_Data) dup (?)        ; default harderror sg
SG1       db (size ScrGp_Data) dup (?)        ; default harderror sg
SG3       db (size ScrGp_Data) dup (?)        ; default harderror sg


;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;*      V A R I A B L E S  ==>  Used Only until DD is fully loaded         *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

DfltEQs       DB (((SIZE Event_Rec) * 100) * 3) DUP (0)

SMData        dw          8h            ; length = 8
              dw   TERMINATION+CREATION+PRESWITCH+POSTSWITCH+AIMPOSTSAVE
              dd      Mouse$            ; address of mouse$ DD name

DSEG     ENDS


;*
;* Data Segment Variables Made Public for other Mouse Modules
;*

       PUBLIC  SQDD
       PUBLIC  EmiDD                                      ; emi
       PUBLIC  SQDDName
       PUBLIC  EmiDDName                                  ; emi
       PUBLIC  APMDDName                                  ; @V2.1XXX03
       PUBLIC  APMIDCHandle                               ; @V2.1XXX03
       PUBLIC  APMIDCReg                                  ; @V2.1XXX03
       PUBLIC  APMIDCDereg                                ; @V2.1XXX03
       PUBLIC  EmiMvt                                     ; emi
       PUBLIC  EmiSSI                                     ; emi
       PUBLIC  Ptr_Rec
       PUBLIC  Ctl_Sem
       PUBLIC  Sem_Time
       PUBLIC  Device_Help
       PUBLIC  InfoSegAddr
       PUBLIC  CallSessn
       PUBLIC  FgndSessn
       PUBLIC  Eq_Length
       PUBLIC  Ptr_Overide
       PUBLIC  MEvent
       PUBLIC  Num_Grps
       PUBLIC  RBlk_Tbl
       PUBLIC  Func_Tbl
       PUBLIC  GDT_Seg
       PUBLIC  Modes
       PUBLIC  DeInstall
       PUBLIC  Sem_PID
       PUBLIC  Last_Event
       PUBLIC  Detach_Proc
       PUBLIC  SQ_Pid
       PUBLIC  CallPID
       public  ShellPID
       public  free_offset
       public  free_space
       public  cfg_offset
       public  ext_mode_data
       public  TypeName
       public  STypeName
       public  DDD
       public  DDD2
       public  APMDD
       public  usQSize
       public  DeviceData
       public  DDDInit
       public  CurCommand
       public  CurRequest
       public  IntEntry
       public  StratEntry
       public  AccessTbl
       public  Int_Packet
       public  SInt_Packet                             ;emi
       public  EMaskMax
       public  MSEVDDEntry
       public  VEvent
       public  VDM_Rows
       public  VDM_Cols
       public  IDC_CB
       public  SN_Flags
       public  Mouse$
       public  FgndCB
       public  FullScrCBs
       public  VDM_Flags
       public  SMData
       public  SG0
       public  SG1
       public  SG3
       public  DfltEQs
       public  TypeOverRider
       public  EmiFlags                                ; emi
       public  SType
       public  ForceMouseON                        ;@140921 DCAF
       public  DevStatus
       public  gMEvent
       public  ByteCount
       public  MiddleButFlag                       ; @V2.1XXX02
       public  Relaxed
       public  _ABIOS_Mch
       public  ABIOS_Mch
       public  TranslateMode
       public  AUXPortExists
       public  PrescottDsp
       public  ScreenKeypad
       public  PortBase
       public  First_Port
       public  LATLSBSave
       public  LATMSBSave
       public  LCRSave
       public  MCRSave
       public  IERSave
       public  PrevEvent
       public  InportAddr
       public  Enable_8259
       public  Disable_8259
       public  Enable_28259
       public  Disable_28259
       public  InpVersion
       public  Dev_LID
       public  SynchMask
       public  SynchFlag
       public  HotPlugHandle
       public  actvirqbit
       public  Init_Time
       public  fNullMouse                                                  ;SRD
       public  fNullMouseParm                                              ;SRD

END
