; SCCSID = src/dev/kbd/kbdbase.ssc/kbdioct.asm, kbd, c.basedd 98/01/16
     Page  58,132
     Title   KBDIOCTL - IOCTL Request Processor
     Name    KBDIOCTL

;/*************************************************************************
;*
;* SOURCE FILE NAME =    KBDIOCT.ASM
;*
;* DESCRIPTIVE NAME =  Keyboard Generic IOCTL request processor.
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              Copyright Microsoft Corporation, 1990
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         08/09/91
;*
;* DESCRIPTION  This file routes all Keyboard IOCTLs to the appropriate
;*              worker routine.
;*
;* NOTES        DEPENDENCIES:  A valid Request Packet upon entry.
;*              RESTRICTIONS:  Machine must be a 386 or compatible with a 386.
;*
;*
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*             @V2.0XXX01         786969
;*   UNKNOWN   J-DBCS001          DBCS enabling (J-001)
;*   10-13-92  J-AXKBD01          Use Function DAh to support KANA-LED on AX-KBD instead of 5Ah (M.Hirosawa)
;*   10/27/94  J-AXKBD02          Change 'IF ASCII_KBD' -> 'IFDEF AX_KBD' (H.Mori)
;*
;**************************************************************************


.286p
.xcref
.sall

;The following files are included, but XLIST'd:
.xlist
  Include     basemaca.inc            ; DOS macros.
  Include     osmaca.inc              ; Macro file for OS/2 kernel
  CPUMODE     286                     ;
  Include     struc.inc               ; Structured assembly macros.
  Include     devhlp.inc              ; DevHlp & Signal equates, char queue structure.
  Include     devsym.inc              ; Device driver header definitions.
  Include     kbdseg.inc              ; Segment definitions.
  Include     kbdddr.inc              ; Keyboard Device Driver structures & equates.
  Include     smrextrn.inc            ; Session Man. and
  Include     pmshl.inc               ; Session type includes
.list

  ;*
  ;* Set up to use the local variables on the stack.  BP must NOT be
  ;* altered if these vars. are to be used.
  ;*

StkFrameVars                           ; Macro to set up proper equates.

;* External Routines
;* SET IOCTLS
    Extrn SetXlateTbl           :Far
    Extrn SetInputMode          :Far
    Extrn SetICFlags            :Far
    Extrn SetShiftState         :Far
    Extrn SetTypa               :Far
    Extrn MonRegister           :Far
    Extrn SetSMHotKey           :Far
    Extrn SetKCB                :Far
    Extrn SetInUseCP            :Far
    Extrn SetReadNotify         :Far
    Extrn SetKbdLEDs            :Far
ifdef DBCSKBD
IFDEF    AX_KBD                                                         ;@IBM J-AXKBD02(A)
    Extrn SetKanaLED            :Far                                    ;@IBM J-AXKBD01(A)
ENDIF                                                                   ;@IBM J-AXKBD01(A)
if W_KBD_ESC                                                            ;@IBM J-DBCS001(A)
    Extrn SetKbdCTL             :Far                                    ;@IBM J-DBCS001(A)
endif                                                                   ;@IBM J-DBCS001(A)
endif ;DBCSKBD
    Extrn SetCodePage           :Far
    Extrn CreateKbd             :Far
    Extrn DestroyKbd            :Far
    Extrn SGController          :Far
    Extrn WriteKbdStrg          :Far      ;DCR 1494 @IBM

;* GET IOCTLS
    Extrn GetInputMode          :Far
    Extrn GetICFlags            :Far
    Extrn GetShiftState         :Far
    Extrn XReadOrPeek           :Far
    Extrn GetSMHotKey           :Far
    Extrn GetInUseCP            :Far
    Extrn XlateSC               :Far
    Extrn GetKbdHWID            :Far
    Extrn GetKbdCPInfo          :Far
    Extrn GetKeyboardType       :Far

    Extrn InitPSG               :Far
    Extrn KbdCmdErr             :Near
    Extrn SGActivation          :Near

;* External Variables
    Extrn IntFlagArea           :Byte
    Extrn DeviceHelp            :DWord

BREAK <KBDIOCTL code>
Code Segment ; *****\

  Assume CS:Code,DS:DGROUP,ES:Nothing,SS:Nothing

BREAK <KBDIOCTL routine>


;/***************************************************************************
;*
;* FUNCTION NAME = KbdIOCTL
;*
;* DESCRIPTION   = Keyboard Generic IOCTL request processor.
;*                 Performs one of the following IOCTL functions:
;*
;*                   Category 4 (Keyboard Control):
;*
;*                       50h Set translate table for hardware default code
;*                           page.
;*                    51/71h Set/Get input mode to Binary/raw or
;*                           ASCII/cooked
;*                    52/72h Set/Get interim character flags
;*                    53/73h Set/Get shift state
;*                       54h Set Typematic rate & delay
;*                       74h Extended Read
;*                       55h Set Current Session
;*                       75h Extended Peek
;*                    56/76h Set/Get Session Manager Hot Key
;*                       57h Set KCB
;*                       58h Set Translate Table ID
;*                       59h Set Read or Peek Notification
;*                       5Ah Set Keyboard LED lights for PM
;*                       5Bh Reserved for Japan
;*                       5Ch Set Code Page
;*                       5Dh Create Keyboard
;*                       5Eh Destroy Keyboard
;*                       77h Get Keyboard ID
;*                       78h Get In Use Code Page
;*                       79h Translate Scan Code to ASCII
;*                       7Ah Get Keyboard Hardware ID Bytes
;*                       7Bh Get Keyboard Code Page Information
ifdef DBCSKBD
;*                       DAh Set Keyboard KANA-LED for PM               ;@IBM J-AXKBD01(A)
endif ;DBCSKBD
;*
;*                   Category 0Ah (Monitor Control):
;*
;*                       40h Register Keystroke monitor
;*
;*                   Category 0Bh (General Device Control):
;*
;*                     60h Query Keystroke Monitor Support
;*
;*                    A label, IOCtlErr, is jumped to if the command is not
;*                    supported.
;*
;*
;* INPUT         =  RequestBlock, with parms depending on request.
;*
;*
;* OUTPUT        =  Depending on function, one or more of the followin
;*                    - Translate table is replaced.
;*                    - Input mode flags are altered.
;*                    - Shift state is altered.
;*                    - Keyboard typematic rate is altered.
;*                    - Session monitor hot key value is changed.
;*                    - Different Per-Session data areas selected.
;*                    - KIB for current session has records removed.
;*                    - Monitor flags and counter is updated.
;*                    - KCB is changed.
;*                    - An Optional Code Page is replaced.
;*                    - The LED lights for the PM session are altered.
;*
;*
;*
;* RETURN-NORMAL = RequestBlock.Status = CompleteNoError
;*                 Depending on request, returns data asked for.
;*
;*
;* RETURN-ERROR  = Most cases can't return error, but Register Monitor
;*                 and Monitor I/O return status from Monitor Dispatcher.
;*                 CCIError if thread is abnormally interrupted.
;*                 Unknown command IOCtl error can be returned.
;*
;*
;* EXTERNAL REFERENCES:
;*    ROUTINES:
;*                 SetTypa                      GetKeyboardType
;*                 SetXlateTbl    SetInputMode  GetInputMode
;*                 SetICFlags     GetICFlags    MonRegister
;*                 SetShiftState  GetShiftState SetSMHotKey
;*                 GetSMHotKey    XreadOrPeek   SetReadNotify
;*                 SetKCB         SetCodePage   GetInUseCP
;*                 XlateSC        CreateKbd     DestroyKbd
;*                 GetKbdHWID     SetKbdLEDs    GetKbdCPInfo
;*                                              SGController
;**************************************************************************/


Public KBDIOCTL
KbdIOCTL Proc

 Mov    DH,ES:[BX+GIOCategory]            ; Get request category.
 Mov    DL,ES:[BX+GIOFunction]            ; Get request function.
 .If <DL ae 50h> AND                      ; If in valid SET IOCTL range
 .If <DL be 5Fh> AND                      ; AND a Category 4 IOCTL      ;@IBM J-AXKBD01(A)
;@IBM J-AXKBD01(D)  .If <DL le 5Fh> AND         ; AND a Category 4 IOCTL
 .If <DH eq 04h>
   Xor    DH,DH                           ; Clear DX upper byte.
   Mov    SI,DX                           ; Put function number into index reg.
   Sub    SI,50h                          ; Normalize function number.
   Shl    SI,2                            ; Make number an index.
   Call   dword ptr CS:[SI+SetJumps]      ; DCR 652 made this a FAR call @IBM
                                          ; Call function via call table.

 .Elseif <DL ae 71h> AND                  ; If in valid GET IOCTL range
 .If <DL be 7Bh> AND                      ; AND a Category 4 IOCTL      ;@IBM J-AXKBD01(A)
;@IBM J-AXKBD01(D)  .If <DL le 7Bh> AND         ; AND a Category 4 IOCTL
 .If <DH eq 04h>
   Xor    DH,DH                           ; Clear DX upper byte.
   Mov    SI,DX                           ; Put function number into index reg.
   Sub    SI,70h                          ; Normalize function number.
   Shl    SI,2                            ; Make number an index.
   Call   dword ptr CS:[SI+GetJumps]      ; DCR 652 made this a FAR call @IBM
                                          ; Call function via call table.

ifdef DBCSKBD
IFDEF    AX_KBD                                                         ;@IBM J-AXKBD02(A)
 .ElseIf <DX eq 04DAh>                    ; Set KANA-LED for PM         ;@IBM J-AXKBD01(A)
   Call   SetKanaLED                      ; AX and J3100 Function       ;@IBM J-AXKBD01(A)
ENDIF                                                                   ;@IBM J-AXKBD01(A)
endif ;DBCSKBD

 .ElseIf <DX eq 0A40h>                    ; Monitor Control category
   Call    MonRegister                    ; Register a monitor

 .ElseIf <DX eq 0B60h>                    ; If Query Monitor
                                          ; Do nothing
 .ElseIf <DL eq 41h> AND                  ; DCR 549: If Cat. B Func. 41h @IBM
 .If <DH eq 0Bh>                          ; Call SGController to handle session
   Call    SGController                   ; creation, termination, or switch.
 .Else                                    ;
   Mov    ES:[BX+PktStatus],CmdError      ; Set Command error in status byte
 .Endif

 Ret
KbdIOCTL Endp

BREAK <Kbd IOCTL Jump Tables>

   ;*
   ;* Jump Table for IOCtl Set requests.
   ;*

         Even                             ; Put jump table on a word boundary.
SetJumps label Word
         dd    SetXlateTbl                ; 50h = Set translate table.
         dd    SetInputMode               ; 51h = Set input mode.
         dd    SetICFlags                 ; 52h = Set interim character flags.
         dd    SetShiftState              ; 53h = Set shift state.
         dd    SetTypa                    ; 54h = Set typamatic rate & delay.
         dd    KbdCmdErr                  ; 55h = %% DCR 549 Returned to Free IOCs list.
         dd    SetSMHotKey                ; 56h = Set Session Manager HotKey.
         dd    SetKCB                     ; 57h = Set Keyboard Control Block.
         dd    SetInUseCP                 ; 58h = Set In Use Code Page.
         dd    SetReadNotify              ; 59h = Set Read or Peek Notification
         dd    SetKbdLEDs                 ; 5Ah = Set the LED lights for PM.
ifndef DBCSKBD
         dd    KbdCmdErr                  ; 5Bh = RESERVED (for Japan).
else
if W_KBD_ESC                                                            ;@IBM J-DBCS001(A)
         dd    SetKbdCTL                  ; 5Bh = Kbd Control           ;@IBM J-DBCS001(A)
else                                                                    ;@IBM J-DBCS001(A)
         dd    KbdCmdErr                  ; 5Bh = RESERVED (for Japan).
endif                                                                   ;@IBM J-DBCS001(A)
endif ;DBCSKBD
         dd    SetCodePage                ; 5Ch = Set Code Page.
         dd    CreateKbd                  ; 5Dh = Create logical keyboard.
         dd    DestroyKbd                 ; 5Eh = Destroy logical keyboard.
         dd    WriteKbdStrg               ; 5Fh = Write KBD string  DCR 1494
MaxSetFunc Equ $-SetJumps                 ; Max index for "Set" jump table.

   ;*
   ;* Jump Table for IOCtl Get requests.
   ;*

GetJumps label Word
         dd    ?                           ; 70h = Not Defined
         dd    GetInputMode                ; 71h = Get input mode.
         dd    GetICFlags                  ; 72h = Get interim character flags.
         dd    GetShiftState               ; 73h = Get shift state.
         dd    XReadOrPeek                 ; 74h = Extended Kbd Read.
         dd    XReadOrPeek                 ; 75h = Extended Kbd Peek.
         dd    GetSMHotKey                 ; 76h = Get Session Manager HotKey.
         dd    GetKeyboardType             ; 77h = Get keyboard ID number.
         dd    GetInUseCP                  ; 78h = Get In Use Code Page.
         dd    XlateSC                     ; 79h = Translate a scan code.
         dd    GetKbdHWID                  ; 7Ah = Get Keyboard Hardware ID bytes.
         dd    GetKbdCPInfo                ; 7Bh = Get Keyboard Code Page Info.
MaxGetFunc Equ $-GetJumps                  ; Max index for "Get" jump table.

Code Ends

     End
