; SCCSID = src/dev/kbd/kbdbase.ssc/kbdidc.asm, kbd, c.basedd 98/01/16
  Page  58,132
  Title   KBDIDC - OS/2 2.2 Device Driver
  Name    KBDIDC
;/*****************************************************************************
;*
;* SOURCE FILE NAME = KBDIDC.ASM
;*
;* DESCRIPTIVE NAME = Keyboard Device Driver for OS/2
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              Copyright Microsoft Corporation, 1990
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.X
;*
;* DATE         ????
;*
;* DESCRIPTION  This device driver handles all physical I/O between OS/2
;*              and the keyboard device.
;*
;* FUNCTIONS
;*
;* NOTES   DEPENDENCIES:
;*
;*
;*         RESTRICTIONS:
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*                    ROUTINES:    None.
;*                    DEVHELPS:    Jumps to ThrowMeAway, which calls:
;*                                 DevHlp (GetLIDEntry, SetIRQ, UnSetIRQ,
;*                                         ABIOSCall, GetDOSVar, AllocPhys,
;*                                         AllocGDTSelector, PhysToGDTSelector,
;*                                         TickCount, ResetTimer, ABIOSGetParms,
;*                                         RegisterPDD)
;*
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG         APAR        CHANGE DESCRIPTION
;*   --------  ----------  -------      --------------------------------------
;*   05/17/21  155047                   Remove Unneeded Handle_Check call
;*   08/12/92  J-AXKBD01   AX-KBD and J3100-KBD support for OEM     (M.Hirosawa) ;j-@mh01
;*   11/17/92              J3100 support for TOSHIBA                (M.Hirosawa) ;j-@mh02
;*   08/04/93  J-DCR287    US 101 Keyboard support on DBCS OS/2         (K.Itoh)
;*   11/16/93  JS06066     PJS06066 right CTRL + ` does not toggle Zen/Hankaku (M.Ida)
;*                                  for 101 keyboard only
;*   11/17/93  JS06173     PJS06173 Zen/Han scan code combi. is not effective  (M.Ida)
;*                                  for ES and 101 keyboard combi.
;*   02/15/94  JS06343     PJS06343 right ALT + CapsLock resets Roman status.  (M.Ida)
;*   09/27/94  J-DBCSWARP  Base code change for WARP                    (H.Mori)
;*   10/27/94              Remove Toshiba J3100 support code            (H.Mori)
;*   11/07/94  J-AXKBD02   Change 'IF ASCII_KBD' -> 'IFDEF AX_KBD'      (H.Mori)
;*   03/16/95  J-DCR375    Change NumLock status at System start up     (H.Mori)
;*****************************************************************************/
;*
BREAK   <Masm   directives, Included files>
.286p
.sall
.xcref
;/*
;**The following files are included, but XLISTed:
;*/
.xlist
;        Include iodelay.inc    ; DevIODelay replaced IODelay
        Include mvdm.inc       ;
        Include basemaca.inc   ;DOS macros.
        Include osmaca.inc     ;Macro file for OS/2 kernel
        CPUMODE 286
        Include struc.inc      ;Structured assembly macros.
        Include devhlp.inc     ;DevHlp & Signal equates, char queue structure
;        Include dosmac.inc    ; translation table equates.
        Include infoseg.inc    ;InfoSeg structure.
        Include devsym.inc     ;Device driver header definitions.
        Include kbdseg.inc     ;Segment definitions.
        Include kbdddr.inc     ;Keyboard Device Driver structures & equates.
        Include kbddi.inc      ;
        Include vkbdpdd.inc    ;VKBD structures
;        Include kbdaim.inc     ;AIM equates
.list

StkFrameVars                   ; Macro to define the local stack
                               ; variables.

;/*****************************/
;/*   External Routines       */
;/*****************************/

  Extrn    ProcessScanCode   :Near
  Extrn    SetLocalVar       :Near
  Extrn    VDDEntryPoint     :Near
  Extrn    AccessKCB         :Near
  Extrn    PENIDC            :Near
ifdef DBCSKBD
  Extrn    SetKBDIDs         :NEAR   ;Set DBCS KBD Type & IDs            ;@IBM J-DBCSWARP(A)
endif ;DBCSKBD

;/*****************************/
;/*   External Variables      */
;/*****************************/

  Extrn    PDataSel          :WORD
  Extrn    DeviceHelp        :DWORD
  Extrn    IDC_CB            :WORD
  Extrn    KeyboardType      :WORD
  Extrn    Open_IDC          :BYTE
  Extrn    Close_IDC         :BYTE
  Extrn    Process_Keystroke :BYTE
  Extrn    Process_Reinit    :BYTE
  Extrn    Pen_Functions     :BYTE
  Extrn    Query_ID          :BYTE
  Extrn    OtherFlags        :BYTE
  Extrn    Keystroke         :BYTE
  Extrn    Keystroke2        :BYTE
  Extrn    VDMFocus          :BYTE
  Extrn    IDFlags           :BYTE
  Extrn    MiscFlags         :BYTE
  Extrn    IntFlags          :BYTE
  Extrn    IDstructure       :WORD
  Extrn    KbdHWIDs          :WORD
  Extrn    PDDtoVDDSCPkt     :WORD
  Extrn    SCCount           :BYTE
  Extrn    KeyHistBuf        :BYTE
  Extrn    KBDDDcall         :DWORD
  Extrn    CheckKBDDD        :WORD
ifdef DBCSKBD
  Extrn    prevScanCode      :Byte        ;@IBM J-DCR287(A)
  Extrn    keystate          :Byte        ;@IBM J-DCR287(A)
  Extrn    fkey              :Byte        ;@IBM J-DCR287(A)
  Extrn    DefaultNumLock    :Word        ;@IBM J-DCR375(A)
  Extrn    dbcs_cp           :Word        ;j-ssc

IFDEF      AX_KBD                         ;@IBM J-AXKBD02(A)
  Extrn    IntFlagArea       :Word        ;@IBM J-AXKBD01(A)
  Extrn    CurSG             :Word        ;@IBM J-AXKBD01(A)
  Extrn    PSGPointers       :Word        ;@IBM J-AXKBD01(A)
ENDIF                                     ;@IBM J-AXKBD01(A)
endif ;DBCSKBD

;;****************** - Security Begin

  Extrn    Security_DS       :WORD
  Extrn    Security_Off      :DWORD
  Extrn    Security_Enable   :BYTE
  Extrn    Security_Open     :WORD
  Extrn    TrustedPath       :WORD

;;****************** - Security End

;/*************************************************************************/

Code Segment
Assume  CS:Code,DS:DGROUP,ES:Nothing

;**********************************************************************
;*
;* FUNCTION NAME  DD_Entry
;*
;* DESCRIPTION    Interface to other device dependent drivers.
;*
;*       This routine interfaces to the other hardware dependent drivers.
;*       It will send the information to any device that is registered,
;*       unless that device registered with a zero code segment.  This means
;*       that the driver doesn't want to receive updates.
;*
;* INPUT       Three variables on the stack:
;*                1- variable for execution.
;*                2- Variable for execution.
;*                3- Function to be executed.
;*
;* Exit-normal  Return information in Registry IDC_Return structure.
;*
;* Exit-error   None
;*
;* Effects      Registered devices are updated.
;*
;* Internal Calls: None.
;*
;* External Calls: Far call to KBDDDcall (address of registered devices).
;*
;**********************************************************************

Public DD_Entry
Procedure DD_Entry, FAR

  ArgVar Var0 WORD
  ArgVar Var1 WORD
  ArgVar Var2 WORD

  EnterProc

  Pusha                                ; Save registers
  Push si
  push es

  .if <Var0 eq DD_Cmd_Typematic>       ; Check to see if word needs adjusting
     mov bx, Var1                      ; It does so shift word into a byte
     mov ah, bh                        ;  that is correct for the IDC.
     shl ah, 5
     or  bl, ah
     xor bh, bh
     mov Var1, bx
  .endif
  .if <bit OtherFlags nz InterruptTime> ; Is this called during interrupt time
     mov ax, Var0
     or ax, 8000h                       ; Set interrupt bit in variable
     mov Var0, ax
  .endif
;;
;; call to device dependent functions
;;
  lea  si, IDC_CB                      ; Offset to the block of handles
  xor cx,cx                            ; Initialize counter
  .while <cx lt MAXIDCS>               ; Check all register locations
     .if <bit [si].IDC_Flags nz IDC_ACTIVE>   ; If handle is active
        push si                        ; If registration is active
        push cx                        ; Save registers
        mov bx, [si].IDC_Offset        ; Get offset of IDC
        mov word ptr KBDDDcall[0], bx  ; Store it in pointer
        mov bx, [si].IDC_Segment       ; Get segment of IDC
        mov word ptr KBDDDcall[2], bx  ; Save it in pointer
        .if <bx ne 0>                  ; If Code seg equals zero then driver
                                       ;  doesn't want to be notified.
                                   ; C func - KBDDDcall(Var2, Var1, Var0);
          push Var2                    ; Push third parameter
          push Var1                    ; Push second parameter
          push Var0                    ; Push first parameter
          call dword ptr [KBDDDcall]   ; Call function
          add sp, 6                    ; Add to stack to get rid of parameters
        .endif

        pop cx                         ; Restore counter
        pop si                         ; Restore pointer to registry
        mov [si].IDC_Return, ax        ; Save value returned
     .endif
     inc cx                            ; Increment counter
     add si, size IDC_Entry            ; Point to next registered device
  .endwhile                            ; End while loop
  pop es                               ; Restore ES
  pop si                               ; Restore SI
  Popa                                 ; Restore registers
  LeaveProc                            ; Clean up stack
  Ret 6                                ; Clean up the 3 words passed in

EndProc DD_Entry                       ; End IDC interface to Device Dependents


;**********************************************************************
;*
;* FUNCTION NAME  KbdIDC
;*
;* DESCRIPTION    IDC entry from other device dependent drivers.
;*
;*       This routine interfaces to the other hardware dependent drivers.
;*       It receives commands from the drivers and then executes them.
;*
;* INPUT        Four variables on the stack:
;*                  1- Function to be executed.
;*                  2- Offset
;*                  3- Data Segment
;*                  4- Handle or Code Segment
;*              If device dependent driver does not need to notified of
;*              changes, ie. LED changes, then set the code segment to
;*              zero when requesting an open.  Data segment should be
;*              callers segment.
;*
;* Exit-normal  AX = 0 or Handle
;*
;* Exit-error   AX = 1
;*
;* Internal Calls: ProcessScanCode
;*                 PENIDC
;*
;* External Calls: None
;*
;**********************************************************************
;*
;/*************************************************************************/
;/*                                                                       */
;/*      Pseudo-code for KBDIDC.ASM                                       */
;/*                                                                       */
;/*   USHORT KBDICD(USHORT IDC_CMD)                                       */
;/*   {                                                                   */
;/*       switch (IDC_CMD)                                                */
;/*       {   case CMD_Open : Get offset and segment                      */
;/*                           Compare to other handles to make sure that  */
;/*                              there isn't a duplicate.                 */
;/*                           Assign a new handle if not duplicate.       */
;/*                           break;                                      */
;/*                                                                       */
;/*           case CMD_Close : Get handle.                                */
;/*                            Verify that it is valid.                   */
;/*                               If not valid return error.              */
;/*                            Delete handle from list.                   */
;/*                            break;                                     */
;/*                                                                       */
;/*           case CMD_KeyStroke : Get handle.                            */
;/*                                Verify that it is valid.               */
;/*                                    If not valid return error.         */
;/*                                Get offset and segment of scancode.    */
;/*                                Send to be processed.                  */
;/*                                break;                                 */
;/*                                                                       */
;/*           case CMD_Reinit : Get handle.                               */
;/*                             Verify that it is valid.                  */
;/*                                If not valid return error.             */
;/*                             Get keyboard ID.                          */
;/*                             Set LEDs.                                 */
;/*                             Set type rate.                            */
;/*                             Notify others of reinit.                  */
;/*                                                                       */
;/*           case PEN_FUNCTIONS : ...                                    */
;/*                                break;                                 */
;/*                                                                       */
;/*           default : error.                                            */
;/*                     break;                                            */
;/*                                                                       */
;/*       }                                                               */
;/*   }                                                                   */
;/*                                                                       */
;/*************************************************************************/

Public KbdIDC
Procedure KbdIDC, FAR

  ArgVar HandleNum  WORD               ; Handle or Code Segment
  ArgVar DD_Seg     WORD               ; Data Segment
  ArgVar DD_Off     WORD               ; Offset
  ArgVar func       WORD               ; Function requested

  EnterProc

  push ax
  mov ax, ds
  .if <ax eq KbdData>                  ; Do we have a pen 1.0 request?
     pop ax                            ; Yes so use backward compatible
     ;;****************** - Security Begin
.386p
     push     ax                       ; @SEC
     mov ax, KbdData                   ; @SEC Get our own Data Segment
     mov ds, ax                        ; @SEC And set it
     pop      ax                       ; @SEC
     .if <ax eq Security_Open>  AND    ; Are we requesting to Enable Security
     .if <Security_Enable eq 0>
        mov ax, word ptr ss:[bp+6]
        mov Security_DS, ax            ; Data segment
        mov eax, dword ptr ss:[bp+8]
        mov Security_Off, eax          ; Offset
        mov Security_Enable, 1
        mov ax, offset TrustedPath     ; Return offset to data word that turns
        ; clean up stack and exit
        jmp EndPen
     .endif
     ;;****************** - Security End
     call PENIDC                       ;  interface
.386p
     pop bx
     pop eax
     sub sp, 8
     push eax
     push bx
     mov bp, sp
.286p
     jmp EndPen
  .endif

  pop ax
  push ds                              ; Save Data Segment of incoming driver
  mov ax, KbdData                      ; Get our own Data Segment
  mov ds, ax                           ; And store it
  mov ax, func                         ; Check MSB to see if the we are running
  .if <bit ax eq 8000h>                ;  during interrupt time
     or OtherFlags, InterruptTime      ; If we are then set interrupt flag
  .endif

  .if <ah eq Pen_Functions>            ; Are we requesting to process a Pen Func?
     mov di, DD_Off                    ; Load registers
     mov es, DD_Seg
     mov bx, Handlenum
     call PENIDC
                                       ; Note: this is hit most so put it first.
  .elseif <al eq Process_Keystroke>    ; Are we requesting to process a keystroke?
     call Handle_Check                 ; Check the handle given
     .if <c>                           ; Is it a valid handle?
        call Proc_Keystroke            ; It is so process keystroke
     .else
        mov ax, -1                     ; It's not so flag an error
     .endif

  .elseif <al eq Open_IDC>             ; Are we requesting to register a device?
     call Open_KBD                     ; Go and register it
     .if <c>                           ; Check to see if it failed
        mov ax, bx                     ; It is registered, return handle in AX
     .else
        mov ax, -1                     ; It failed, return -1
     .endif

  .elseif <al eq Close_IDC>            ; Are we requesting to close a device?
     call Handle_Check                 ; Check the handle given
     .if <c>                           ; Is it a valid handle?
        and  [si].IDC_Flags, NOT IDC_ACTIVE ; This handle is now open
     .endif

  .elseif <al eq Process_Reinit>       ; Are we requesting to process a Hot Plug?
     call Handle_Check                 ; Check the handle given
     .if <c>                           ; Is it a valid handle?
        call Proc_Reinit               ; Go process the Hot Plug
     .endif

  .else
     mov ax, -1                        ; Error
  .endif
  pop ds                               ; Restore Data Segment
EndPen:
  LeaveProc                            ; Clean up stack
  Ret 8                                ; Clean up the 4 words passed in

KbdIDC  Endp


;**********************************************************************
;*
;*  FUNCTION NAME :  Open_KBD
;*
;*  DESCRIPTION   :  Start an Inter Device Communication link
;*                     with the keyboard device independent device
;*                     driver (KBDDI$).
;*
;*                   This function is invoked by another Device
;*                   driver to get a keyboard IDC interface handle.
;*                   This function supports a max of 5 open keyboard
;*                   IDC handles at any one time. If a 6th keyboard IDC
;*                   handle is requested a NO_HANDLES_AVAILABLE error
;*                   code will be returned.
;*
;*  ENTRY POINT  :  Open_KBD        LINKAGE:  CALL NEAR
;*
;*  ENTRY        :  AX = Function code
;*                  Open_KBD = 00h
;*                  DS = KBDDI$ DD DS value
;*                  ES = Calling DD DS value
;*                  All other reqs are undefined
;*
;*  RETURN-NORMAL: Carry Flag clear. Register listed below;
;*
;*                   BX = Keyboard IDC handle
;*                   DS = KBDDI$ DD DS value
;*                   ES = Calling DD DS value
;*                   All other reqs are undefined
;*
;*  RETURN-ERROR :  Carry set, registers listed below;
;*
;*                  AX = Error return code if carry set
;*                  DS = KBDDI DD DS value
;*                  ES = Calling DD DS value
;*                  All other reqs are undefined
;*
;*  EFFECTS      :  Registers modified.
;*
;*  INTERNAL REFERENCES:
;*     ROUTINES:  NONE.
;*
;*  EXTERNAL REFERENCES:
;*     ROUTINES:  NONE.
;*     DevHelps:  NONE.
;*
;**********************************************************************
;*  PSEUDOCODE :
;*
;* BeginSub  Open_KBD
;*
;*
;*    Get CB for handle 0
;*    REPEAT
;*       IF <this handle is free>
;*          Mark this handle as active in CB
;*          LEAVE
;*       ENDIF
;*       Get CB for next handle
;*    UNTIL <MAXIDCS have been checked>
;*
;*    IF <a new handle has been given>
;*       Clear carry flag
;*    ELSE
;*       move into AX register (ERROR_NO_MORE_HANDLES)
;*       Set carry flag
;*    ENDIF
;*
;*  return
;*
;* EndSub  Open_KBD
;*
;************************************************************************

Public Open_KBD
Open_KBD  proc  near

   lea  si, IDC_CB                       ; Offset to the block of handles.
   xor  bx, bx                           ; Start with handle zero.

   .repeat
      .if <bit [si].IDC_Flags z IDC_ACTIVE>    ; If handle is free.
         or [si].IDC_Flags, IDC_ACTIVE   ; This handle is now in use.
         mov ax, DD_Off                  ; Get IDC Offset
         mov [si].IDC_Offset, ax         ; Load IDC Offset
         mov ax, DD_Seg                  ; Get IDC Data Segment
         mov [si].IDC_ds, ax             ; Load IDC Data Segment
         mov ax, HandleNum               ; Get IDC Code Segment
         mov [si].IDC_Segment, ax        ; Load IDC Code Segment
         .leave                          ; We found a slot so get out
      .endif
      inc  bx                            ; Try next handle
      add  si, size IDC_Entry            ; Get next slot
   .until <bx eq MAXIDCS>                ; Zero based (6th entry is invalid)

   .if <bx lt MAXIDCS>                   ; If a new handle has been given
      mov CheckKBDDD, 0001h              ; Flag that we have a device registered
      stc                                ; Set carry
   .else
      mov  ax, 8024h                     ; ERROR_NO_MORE_HANDLES
      clc                                ; Clear carry
   .endif
   Ret

Open_KBD  endp

;**********************************************************************
;*
;*  FUNCTION NAME :  Handle_Check
;*
;*  DESCRIPTION   :
;*
;**********************************************************************

Public Handle_Check
Handle_Check  proc  near

   mov bx, HandleNum                      ; Load handle value
   .if <bx lt MAXIDCS>                    ; If handle is less then MAX IDCs
      lea  si, IDC_CB                     ; Offset to the block of handles
      imul bx, size IDC_Entry             ; Get offset to this entry
      add  si, bx                         ; We now point to the handle entry
      mov  bx, DD_Seg                     ; Load Data Segment
      .if <bit [si].IDC_Flags nz IDC_ACTIVE> AND   ; Check if handle is active.
      .if <[si].IDC_ds eq bx>             ; And if data segments are the same
         stc                              ; Yes they are, Handle is OK
      .else
         clc                              ; They aren't so clear carry
      .endif
   .else
                     ; The value of 502 will need to be changed to say invalid
                     ; keyboard instead of mouse (502 is from the mouse code)
      mov  ax, 502                        ; ERROR_KBD_INVALID_HANDLE
      clc                                 ; Failed to find correct handle
   .endif
   Ret

Handle_Check  endp

;**********************************************************************
;*
;*  FUNCTION NAME :  Proc_Keystroke
;*
;*  DESCRIPTION   :
;*
;******************************************************************************

Public Proc_Keystroke
Proc_Keystroke Proc Near

  Enter  0022, 00                      ; Set stack space for SetLocal Var

    mov ax, -1                         ; Set AX to -1 for SetLocalVar
    call SetLocalVar                   ; Set up the local stack variables
    mov di, StkPSG                     ; Load DI

    push ds                            ; Save DS
    mov si, DD_Off+6                   ; Point to key stroke data offset
    mov ds, DD_Seg+6                   ; Load Driver's DS
    mov al, [si]                       ; Get first scan code
    mov bl, [si]+1                     ; Get second scan code
    pop ds                             ; Restore my DS

ifdef DBCSKBD
ifdef kbd101 ;101X
    test    fkey,inhibit_xlate         ; Xlate function is disabled?         ;@IBM J-DCR287(A)
    jnz     noXlateMode                ; Jump if disabled                    ;@IBM J-DCR287(A)
    test    fkey,dos_fep               ; DOS-FEP is focused?                 ;@IBM J-DCR287(A)
    jnz     noXlateMode                ; Jump if DOS-FEP is focused.         ;@IBM J-DCR287(A)
    call    xlateFor101                ; Do Xlate for 101 keyboard           ;@IBM J-DCR287(A)
    jnc     doneXlate                  ; Jump if Scan code is processed      ;@IBM J-DCR287(A)
;@IBM J-DBCSWARP(D)    jmp     short noXlate              ; AX doesn't carry a shift state ;@IBM J-DCR287(A)
                                       ; Skip shift state handling           ;@IBM J-DCR287(A)
noXlateMode:                                                                 ;@IBM J-DCR287(A)
endif ;kbd101 ;101X
IFDEF  KLFX103                                                          ;@IBM K-HHSPARK
   .If <al eq 0F0H>                       ;Hangeul 720 SMP               ;@IBM K-HHSPARK
    mov al, 0F2H                                                         ;
   .endif                                                               ;@IBM K-HHSPARK
ENDIF                                                                   ;@IBM K-HHSPARK
endif ;DBCSKBD

    mov Keystroke, al                  ; Store first scan code
    mov Keystroke2, bl                 ; Store second scan code

ifdef DBCSKBD
ifdef AX_KBD
  Call XlateScan                ; Translate physical key code to Logical;@IBM J-AXKBD01(A)
endif ;AX_KBD
endif ;DBCSKBD

    Call ProcessScanCode               ; Go process first scan code

ifdef DBCSKBD
ifdef kbd101 ;101X
doneXlate:                             ;                                ;@IBM J-DCR287(A)
endif ;kbd101 ;101X
endif ;DBCSKBD

    mov bl, Keystroke
    .if <bl eq OtherKey>
       mov al, Keystroke2

ifdef DBCSKBD
ifdef kbd101 ;101X
       test    fkey,inhibit_xlate      ; Xlate function is disabled?    ;@IBM J-DCR287(A)
       jnz     noXlateMode2            ; Jump if disabled               ;@IBM J-DCR287(A)
       test    fkey,dos_fep            ; DOS-FEP is focused?            ;@IBM J-DCR287(A)
       jnz     noXlateMode2            ; Jump if DOS-FEP is focused.    ;@IBM J-DCR287(A)
       call    xlateFor101             ; Do Xlate for 101 keyboard      ;@IBM J-DCR287(A)
       jnc     doneXlate2              ; Jump if Scan code is processed ;@IBM J-DCR287(A)
;j-ssc jmp     short noXlate           ; AX doesn't carry a shift state ;@IBM J-DCR287(A)
;j-ssc                                 ; Skip shift state handling      ;@IBM J-DCR287(A)
noXlateMode2:                                                           ;@IBM J-DCR287(A)
endif ;kbd101 ;101X

ifdef AX_KBD
  Call XlateScan                ; Translate physical key code to Logical;@IBM J-AXKBD01(A)
endif ;AX_KBD
endif ;DBCSKBD

       Call ProcessScanCode

ifdef DBCSKBD
ifdef kbd101 ;101X
doneXlate2:                            ;                                ;@IBM J-DCR287(A)
endif ;kbd101
endif ;DBCSKBD ;101X

    .endif
    .If <VDMFocus eq 0> AND            ; If VDM does NOT have focus AND
    .If <bit IntFlags nz Up_LEDs>      ; If LEDs need to be updated
       And IntFlags,NOT Up_LEDs        ; Clear flag
       Shr AX,4                        ; Move LED bits to low nibble
       And AX,7                        ; Turn off all unwanted bits

ifdef DBCSKBD
ifdef AX_KBD
       push cx                                                          ;@IBM J-AXKBD01(A)
       push di                                                          ;@IBM J-AXKBD01(A)
       Mov CX,CurSG             ;Set SG number for use by KbdXlate.     ;@IBM J-AXKBD01(A)
      .If <CX ge sgidFirstVDM>  ;%% If a VDM SGID                       ;@IBM J-AXKBD01(A)
          Mov CX,Dos3xBoxSG     ;%% We will be using SG 2 for VDMs      ;@IBM J-AXKBD01(A)
      .Endif                                                            ;@IBM J-AXKBD01(A)
       Mov DI,CX                ;%% Get Current Screen Group Number     ;@IBM J-AXKBD01(A)
       Shl DI,1                 ;%% Make it an offset                   ;@IBM J-AXKBD01(A)
       Mov DI,[PSGPointers+DI]  ;%% Get Pointer to this SGs PSG         ;@IBM J-AXKBD01(A)

       Test byte ptr [DI].DBCSShift, KATAKANA                           ;@IBM J-AXKBD01(A)
      .If <nz>                  ; If KATAKANA set Bit 3                 ;@IBM J-AXKBD01(A)
          Or AX,8               ; for KANA LED                          ;@IBM J-AXKBD01(A)
      .Endif                                                            ;@IBM J-AXKBD01(A)

       pop di                                                           ;@IBM J-AXKBD01(A)
       pop cx                                                           ;@IBM J-AXKBD01(A)
endif ;AX_KBD
endif ;DBCSKBD

       Push 2222h                      ; Var2 (Not used for this call)
       Push AX                         ; Var1 (LED state)
       Push DD_Cmd_IndicatorsI         ; Function, INTERRUPT TIME @V2.0XXX01
       Call DD_Entry                   ; Device Independent Entry Point
    .Endif

ifdef DBCSKBD
ifdef kbd101 ;101X
noXlate:                               ;@IBM J-DCR287(A)
endif ;kbd101
endif ;DBCSKBD ;101X

    And OtherFlags, NOT InterruptTime  ; Clear Interrupt Time flag
   Leave
   Ret

Proc_Keystroke endp



;**********************************************************************
;*
;*  FUNCTION NAME :  Proc_Reinit
;*
;*  DESCRIPTION   :
;*
;**********************************************************************

Public Proc_Reinit
Proc_Reinit proc near

  Enter  0022, 00                      ; Set stack space for SetLocal Var

    mov ax, -1                         ; Set AX to -1 for SetLocalVar
    call SetLocalVar                   ; Set up the local stack variables
    mov di, StkPSG                     ; Load DI
;*Ŀ
;* Reinit certain data areas   
;*
;* This is copied from KBDHWDD.ASM version 2.1
  Mov  SCCount, 00                    ; Set SCCount to zero,prevent BLOCKS on it
                                      ;    Clear out the KeyHistBuf because
                                      ;    sometimes the hardware sends junk
  Push SI                             ; MAKES when the hot plug is done before
  Push BX                             ; the ffh aah sequence.  Otherwise SG's
  Xor  AX, AX                         ; would be blocked waiting for the BREAKS
  Xor  BX, BX                         ; of the junk scan codes which will
  Mov  SI, Offset KeyHistBuf          ; never happen.
 .While <AX le 9>                     ;
   Mov Byte Ptr [SI], BL              ;
   Inc SI                             ;
   Inc AX                             ;
 .Endwhile                            ; Endwhile KeyHistBuf not cleared out
  Pop BX                              ; Restore reg
  Pop SI                              ; Restore reg
                                      ; Reinit these BEFORE ReadIDHP in case
                                      ; of a resend, values must be preserved
  Mov IDFlags, 00                     ; Reinitialize flags
  Mov Byte Ptr [KbdHWIDs], 00h        ; Reinitialize KbdHWIDs
  Mov Byte Ptr [KbdHWIDs + 1], 00h    ; Reinitialize KbdHWIDs

;*Ŀ
;* Get the new hardware ID bytes.                                     
;*

  push ds                              ; Push Data Segment
  mov ax, Offset KbdData:IDstructure   ; Get offset to structure of KBD ID
  push ax                              ; Push Offset to structure
  mov al, Query_ID                     ; Get Keyboard ID
  xor ah,ah                            ;
  push ax                              ; Push Function
  Call DD_Entry                        ; Device Independent Entry Point
                                       ;
  mov ax, word ptr IDstructure.idbytes ; Get ID word

ifdef DBCSKBD
ifndef AX_KBD
;* DCR375 for PTR JS07446                                              ;@IBM J-DCR375(A)
;* DefaultNumLock has NumLock status which POS set at H/W initialize.  ;@IBM J-DCR375(A)
;* This DCR affect only Phuket Full-size and US Full-size Keyboard.    ;@IBM J-DCR375(A)
  .if <DefaultNumLock eq 0000h>        ; If default NumLock is off     ;@IBM J-DCR375(A)
     .if <AH eq ID2>                   ;   If Full-size Keyboard       ;@IBM J-DCR375(A)
        Mov ah, ID2A                   ;      change ID to Pad-less    ;@IBM J-DCR375(A)
     .elseif <ah eq ID2_2>             ;   If Full-size Keyboard       ;@IBM J-DCR375(A)
        Mov ah, ID2A_2                 ;      change ID to Pad-less    ;@IBM J-DCR375(A)
     .endif                            ;                               ;@IBM J-DCR375(A)
  .endif                               ;                               ;@IBM J-DCR375(A)
endif ;AX_KBD
endif ;DBCSKBD

  mov word ptr KbdHWIDs, ax            ; Store ID word
  .if <ah eq ID2B>                     ; Is it a Super Sport Keyboard?
     or IDFlags, SuperSport            ; If yes then set flag
  .endif                               ;
  mov keyboardtype, 1                  ; Set Keyboard type to 1
  or  IDFlags, EnhancedKbd             ; Default ID Flag to Enhanced
  or MiscFlags, EnhancedKbd            ; Set Misc Flag to Enhanced
  .if <ax eq 0100h>                    ; If an AT keyboard
     and  IDFlags, NOT EnhancedKbd     ; Unset default
     or  IDFlags, ATKbd                ; Set ID bit
     and MiscFlags, NOT EnhancedKbd    ; Make it not Enhanced
     mov KeyboardType, 0               ; Set keyboard type to 0
  .endif

ifdef DBCSKBD
  ;----------  Set DBCS KeyboardID according to KBD H/W ID  ---------- ;@IBM J-DBCSWARP(A)
  Mov AL, byte ptr [KbdHWIDs + 1]      ;Get second byte value of ID.   ;@IBM J-DBCSWARP(A)
  Call SetKBDIDs                       ;set DBCS KBD Type and IDs      ;@IBM J-DBCSWARP(A)
endif ;DBCSKBD

;*Ŀ
;* UPDATE THE LEDS                                                    
;*

  Mov    DH,ES_DI                      ;* Tell PhysToVirt where to put it.
  Call   AccessKCB                     ;* Go get access to this SG's KCB
  Mov    BX,DI                         ;* Put KCB offset in BX
  Mov    ax ,ES:[BX].KCBShift          ;* Put them in the KCB
  Shr AX,4                             ; Move LED bits to low nibble
  And AX,7                             ; Turn off all unwanted bits
  Push 2222h                           ; Var2 (Not used for this call)
  Push AX                              ; Var1 (LED state)
  Push DD_Cmd_IndicatorsI              ; Function, INTERRUPT TIME @V2.0XXX01
  Call DD_Entry                        ; Device Independent Entry Point

;*Ŀ
;* TELL THE VKBD A HOT PLUG OCCURRED                                  
;*
;* This is copied from KBDHWDD.ASM version 2.1

 .If < <word ptr VDDEntryPoint+2> ne 0 >  ;* If the VDD's high word isn't 0
                                          ;* Then VKBD has registered.
    Mov  PDDtoVDDSCPkt.khp_len, KHP_PKT_LEN ;*  Set up the parms for call to VKBD
    Mov  AX, KbdHWIDs                       ;*
    Mov  PDDtoVDDSCPkt.khp_usKbdHWID, AX ;* Set up the parms for call to VKBD
    pusha                               ;* Push all regs (VDDEntryPoint) trashes
    SaveReg<ES>                         ;* VDD is also trashing ES
    Push Word Ptr 0                     ;* Send zero in high word
    Push Word Ptr VKBDCMD_HOTPLUG       ;* VKBDCMD_HOTPLUG event
    Push DS                             ;* Send our Data Selector
    Push Offset PDDtoVDDSCPkt           ;* Send offset to packet from our DS
    Push Word Ptr 0                     ;* Send zero in high word
    Push Word Ptr 0                     ;* Send zero in high word
    .386p                               ;*
       Call Fword Ptr VDDEntryPoint     ;* Call the VDD entry point
    .286p                               ;*
    RestoreReg<ES>                      ;* Get VDDs data sel back
    Mov PDDtoVDDSCPkt.khp_len,  6       ;*
    popa                                ;* Pop all regs (VDDEntryPoint)
 .Endif

;*Ŀ
;* SEND DEVHLP TO TELL SYSTEM A HOT PLUG OCCURED                      
;*
;* This is copied from KBDHWDD.ASM version 2.1

  Mov  AH, event_HOT_PLUG               ;* Specify DevHlp function
  Xor  BX, BX                           ;* Set argument to zero
  Mov  DL,DevHlp_SendEvent              ;* Set DevHlp function for SendEvent.
  Call DeviceHelp                       ;* Call Device Help

  Leave
  Ret

Proc_Reinit endp

ifdef DBCSKBD
ifdef kbd101 ;101X
;@IBM J-DCR287(A) -- Start
;*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=
; xlateFor101
;
;   Description: Scan Code translation for IBM U.S. 101 Keyboard
;
;   Entry:  AL = Scan Code
;   Exit:   CY if ignore Scan code, AX is not updated.
;           NC if process Scan code, AX has new shift state
;           All registers are preserved, except AX
;
;*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=
Public xlateFor101
xlateFor101     proc    near

;
; Japan:  translation       -> handled by this routine
; Korea:  translation       -> handled by this routine
; Taiwan: translation       -> handled by this routine
; China:  no translation    -> return with carry bit on
;
        cmp     dbcs_cp,CP_SCHINESE                                      ;j-ea222973
        jne     xlateFor101GO                                            ;j-ea222973

        stc                             ; not processed yet.             ;j-ssc
        jmp     short exitXlateFor101                                    ;j-ssc

xlateFor101GO:                                                           ;j-ssc
        push    ax                      ; Save Original Scan code
        call    setKeyState             ; Update keystate
        and     al,01111111b            ; Mask Break bit
Key1:
        cmp     al,29h                  ; Key #1 ?
        jne     CapsLock                ; Jump to check CapsLock
        pop     ax                      ; Retrieve Original Scan code
        mov     prevScanCode,al         ; Save Original Scan code
        call    ProcessKey1             ; Process Key #1
        jmp     short exitXlateFor101

CapsLock:
        cmp     al,3ah                  ; CapsLock ?
        jne     ShiftConv               ; Jump to check ShiftConv status
        pop     ax                      ; Retrieve Original Scan code
        mov     prevScanCode,al         ; Save Original Scan code
        call    ProcessCapsLock         ; Process CapsLock
        jmp     short exitXlateFor101


ShiftConv:
        test    fkey,inhibit_shift_conv ;
        jnz     anotherKey              ; Jump if ShiftConv is disabled.

RShift:
        cmp     al,36h                  ; Right Shift ?
        jne     LShift                  ; Jump to check Left Shift
        pop     ax                      ; Retrieve Original Scan code
        call    ProcessShift            ; Process Shift (pure break)
        jmp     short exitXlateFor101
LShift:
        cmp     al,2ah                  ; Left Shift ?
        jne     anotherKey              ; Jump if not a DBCS special key
        pop     ax                      ; Retrieve Original Scan code
        call    ProcessShift            ; Process Shift (pure break)
        jmp     short exitXlateFor101

anotherKey:
        pop     ax                      ; Retrieve Original Scan code
        mov     prevScanCode,al
        call    ProcessScanCode
exitXlateFor101:
        ret
xlateFor101     endp
;
;-----------------------------------------------
;  Set keyState
;
;       Entry: AL = Scan Code
;       Exit:  keystate has actual key state
;              All registers are preserved.
;
;-----------------------------------------------
setKeyState     proc    near
        push    bx                      ;
        mov     bx,0                    ;
        cmp     al,0e0h                 ; Scan code is Secondary Prefix?
        jne     notSecondaryPrefix      ; Jump if not secondary prefix
        or      keystate,10000000b      ; Mark next key is SecondaryKey.
        jmp     short exitSetKeyState   ; Nothing to do. Return to caller

notSecondaryPrefix:
        push    ax
        and     al,01111111b
        call    AltCtrlShift            ;  Scan code is the Alt/Ctrl/Shift?
        pop     ax
        jnc     breakChk                ; Jump if Scan code is Alt/Ctrl/Shift
        jmp     short resetPrefixMarker

breakChk:
        test    al,10000000b            ; Make Code?
        jz      makeCode                ; Jump if Scan Code is Make
        not     bl                      ;
        and     keystate,bl             ;
        jmp     short resetPrefixMarker

makeCode:
        or      keystate,bl

resetPrefixMarker:
        and     keystate,01111111b

exitSetKeyState:
        pop     bx
        ret
setKeyState     endp
;
;-----------------------------------------------
; Scan code checker
;
; Entry: AL = Scan code (Break bit should be zero)
; Exit:  CY - if scan code is not Alt/Ctrl/Shift key
;             then carry flag is on.
;        BL = 00000001 - Alt key
;           = 00000010 - Ctrl key
;           = 00000100 - Left Shift key
;           = 00001000 - E0 Alt key
;           = 00010000 - E0 Ctrl key
;           = 00100000 - Right Shift key
;
;        All registers are preserved, except BL.
;
;-----------------------------------------------
AltCtrlShift    proc    near
RightShiftChk:
        cmp     al,36h                  ; Right Shift ?
        jne     LeftShiftChk
        or      bl,00100000b
        jmp     short exitAltCtrlShift
LeftShiftChk:
        cmp     al,2ah                  ; Left Shift?
        jne     AltChk
        or      bl,00000100b
        jmp     short exitAltCtrlShift

AltChk:
        cmp     al,38h                  ; Alt ?
        jne     CtrlChk
        mov     bl,00000001b
        jmp     short secondaryPrefixChk
CtrlChk:
        cmp     al,1dh                  ; Ctrl ?
        jne     notAltCtrlShift
        mov     bl,00000010b
;
secondaryPrefixChk:
        test    keystate,10000000b      ; The previous scan code is E0?
        jz      notSecPrefix
        shl     bl,3
notSecPrefix:
exitAltCtrlShift:
        clc
        ret
notAltCtrlShift:
        stc
        ret
AltCtrlShift    endp
;
;-----------------------------------------------
;
; Process Key#1
;
; Entry: AL = Scan code (w/ break bit)
;        prevScanCode = Scan code
; Exit:  AX carries the new shift state
;
;-----------------------------------------------
Public ProcessKey1
Tscan   equ     73h

ProcessKey1     proc    near

                mov     ah,keystate
                and     ah,01111111b            ; AH = keystatus

                test    al,10000000b
                jnz     pkBreak

                cmp     ah,2                    ; Left Ctrl?
                je      pkLCtrl
                cmp     ah,10h                  ; Right Ctrl?
                je      pkRCtrl
                cmp     ah,1                    ; Left Alt?
                je      pkAltCtrl
                cmp     ah,8                    ; Right Alt?
                je      pkAltCtrl
                cmp     ah,1+2                  ; Left Alt + Left Ctrl?
                je      pkAltCtrl
                cmp     ah,1+10h                ; Left Alt + Right Ctrl?
                je      pkAltCtrl
                cmp     ah,8+2                  ; Right Alt + Left Ctrl?
                je      pkAltCtrl
                cmp     ah,8+10h                ; Right Alt + Right Ctrl?
                je      pkAltCtrl

pkBreak:
                test    fkey,2                  ; Ignore break?
                jz      pkNop
                and     fkey,11111101b
                stc                             ; Mark ignore state
                jmp     short exitProcessKey1
pkNop:

                call    ProcessScanCode         ; Send Scan code
exitProcessKey1:
                ret


pkRCtrl:
                mov     al,0e0h
                call    ProcessScanCode         ; Send secondary Prefix
;@IBM JS06066(D)     mov     al,TScan+10000000b      ;
                mov     al,1dh+10000000b        ;                       ;@IBM JS06066(A)
                call    ProcessScanCode         ; Send Ctrl(break) code

                mov     al,TScan                ;
                call    ProcessScanCode         ; Send Temp. Scan code
                mov     al,0e0h                 ;                       ;@IBM JS06173(A)
                call    ProcessScanCode         ; Send secondary Prefix ;@IBM JS06173(A)
                mov     al,1dh                  ;                       ;@IBM JS06173(A)
                call    ProcessScanCode         ; Send Ctrl(make) code  ;@IBM JS06173(A)
                mov     al,TScan+10000000b      ;
                call    ProcessScanCode         ; Send Temp. Scan code
                or      fkey,00000010b          ; Set Ignore flag

;@IBM JS06173(D)      mov     al,0e0h
;@IBM JS06173(D)      call    ProcessScanCode         ; Send secondary Prefix
;@IBM JS06173(D)      mov     al,1dh                  ;
;@IBM JS06173(D)      call    ProcessScanCode         ; Send Ctrl(make) code
                jmp     short exitProcessKey1

pkLCtrl:
                mov     al,1dh+10000000b        ;
                call    ProcessScanCode         ; Send Ctrl(break) code

                mov     al,TScan                ;
                call    ProcessScanCode         ; Send Temp. Scan code
                mov     al,1dh                  ;                       ;@IBM JS06173(A)
                call    ProcessScanCode         ; Send Ctrl(make) code  ;@IBM JS06173(A)
                mov     al,TScan+10000000b      ;
                call    ProcessScanCode         ; Send Temp. Scan code
                or      fkey,00000010b          ; Set Ignore flag

;@IBM JS06173(D)      mov     al,1dh                  ;
;@IBM JS06173(D)      call    ProcessScanCode         ; Send Ctrl(make) code
                jmp     short exitProcessKey1


pkAltCtrl:
                mov     al,TScan                ;
                call    ProcessScanCode         ; Send Temp. Scan code
                mov     al,TScan+10000000b      ;
                call    ProcessScanCode         ; Send Temp. Scan code
                or      fkey,00000010b          ; Set Ignore flag
                jmp     short exitProcessKey1

ProcessKey1     endp
;
;-----------------------------------------------
;
; Process CapsLock
;
; Entry: AL = Scan code (w/ break bit)
;        prevScanCode = Scan code
; Exit:  AX carries the new shift state
;
;-----------------------------------------------
Public ProcessCapsLock
ProcessCapsLock proc    near

                push    bx
                mov     ah,keystate
                and     ah,01111111b            ; AH = keystatus

                test    al,10000000b
                jnz     pcBreak

                cmp     ah,0ch
                ja      noUseJumpTbl
                mov     bh,0
                mov     bl,ah
                shl     bx,1
                jmp     word ptr cs:jumpTbl.[bx]

jumpTbl:
                dw      offset pcBase           ; 0 -
                dw      offset pcLAlt           ; 1 -
                dw      offset pcLCtrl          ; 2 -
                dw      offset pcLCtrlAlt       ; 3 -
                dw      offset pcLShift         ; 4 -
                dw      offset pcLShiftAlt      ; 5 -
                dw      offset pcNop            ; 6 -
                dw      offset pcNop            ; 7 -
                dw      offset pcRAlt           ; 8 -
                dw      offset pcNop            ; 9 -
                dw      offset pcLCtrlAlt       ; A -
                dw      offset pcNop            ; B -
                dw      offset pcLShiftAlt      ; C -



noUseJumpTbl:
                cmp     ah,20h                  ; Right Shift ?
                jne     short rightCtrl
                jmp     pcRShift

rightCtrl:
                cmp     ah,10h                  ; Right Ctrl?
                jne     short rightShiftLAlt
                jmp     pcRCtrl

rightShiftLAlt:
                cmp     ah,21h                  ; Right Shift + Left Alt
                jne     short rightShiftRAlt
                jmp     pcRShiftAlt

rightShiftRAlt:
                cmp     ah,28h                  ; Right Shift + Right Alt
                jne     short rightCtrlLAlt
                jmp     pcRShiftAlt

rightCtrlLAlt:
                cmp     ah,11h                  ; Right Ctrl + Left Alt
                jne     short rightCtrlRAlt
                jmp     pcRCtrlAlt

rightCtrlRAlt:
                cmp     ah,18h                  ; Right Ctrl + Right Alt
                jne     short pcNop
                jmp     pcRCtrlAlt


pcBreak:
                test    fkey,1                  ; Ignore break?
                jz      pcNop
                and     fkey,11111110b
                stc                             ; Mark ignore state
                jmp     short exitProcessCapsLock
pcNop:
                call    ProcessScanCode
exitProcessCapsLock:
                pop     bx
                ret
;
;  Base CapsLock --> Shift CapsLock
;
pcBase:
                mov     al,2ah
                call    ProcessScanCode         ; Send Left Shift(make) packet
                mov     al,prevScanCode
                call    ProcessScanCode         ; Send original Scan code
                mov     al,2ah+10000000b
                call    ProcessScanCode         ; Send Left Shift(break) packet
                jmp     short exitProcessCapsLock
;
;  Shift + CapsLock --> Base CapsLock
;
pcLShift:
                mov     al,2ah+10000000b
                call    ProcessScanCode
                mov     al,prevScanCode
                call    ProcessScanCode
                mov     al,2ah
                call    ProcessScanCode
                jmp     short exitProcessCapsLock

pcRShift:
                mov     al,36h+10000000b
                call    ProcessScanCode
                mov     al,prevScanCode
                call    ProcessScanCode
                mov     al,36h
                call    ProcessScanCode
                jmp     short exitProcessCapsLock
;
;  Ctrl + CapsLock --> Hiragana
;
pcLCtrl:
                mov     al,1dh+10000000b
                call    ProcessScanCode
                call    pcSendHiragana
                mov     al,1dh
                call    ProcessScanCode
                jmp     short exitProcessCapsLock

pcRCtrl:
                mov     al,0e0h
                call    ProcessScanCode
                mov     al,1dh+10000000b
                call    ProcessScanCode
                call    pcSendHiragana
                mov     al,0e0h
                call    ProcessScanCode
                mov     al,1dh
                call    ProcessScanCode
                jmp     short exitProcessCapsLock
;
;  Alt + CapsLock --> Shift + Hiragana
;
pcLAlt:
                mov     al,2ah
                call    ProcessScanCode         ; Send Left Shift(make) packet
                mov     al,38h+10000000b
                call    ProcessScanCode
                call    pcSendHiragana
                mov     al,38h
                call    ProcessScanCode         ; Send Left Alt(make) packet
                mov     al,2ah+10000000b
                call    ProcessScanCode         ; Send Left Shift(break) packet
                jmp     exitProcessCapsLock

pcRAlt:
                mov     al,2ah
                call    ProcessScanCode         ; Send Left Shift(make) packet
;@IBM JS06343(D)      mov     al,0eh
                mov     al,0e0h                                     ;@IBM JS06343(A)
                call    ProcessScanCode
                mov     al,38h+10000000b
                call    ProcessScanCode
                call    pcSendHiragana
;@IBM JS06343(D)      mov     al,0eh
                mov     al,0e0h                                     ;@IBM JS06343(A)
                call    ProcessScanCode
                mov     al,38h
                call    ProcessScanCode
                mov     al,2ah+10000000b
                call    ProcessScanCode         ; Send Left Shift(break) packet
                jmp     exitProcessCapsLock

;
;  Alt + Shift + CapsLock --> Alt + CapsLock
;
pcRShiftAlt:
                mov     al,36h+10000000b
                call    ProcessScanCode
                mov     al,prevScanCode
                call    ProcessScanCode
                mov     al,36h
                call    ProcessScanCode
                jmp     exitProcessCapsLock

pcLShiftAlt:
                mov     al,2ah+10000000b
                call    ProcessScanCode
                mov     al,prevScanCode
                call    ProcessScanCode
                mov     al,2ah
                call    ProcessScanCode
                jmp     exitProcessCapsLock
;
;  Alt + Ctrl + CapsLock --> Alt + Hiragana
;
pcRCtrlAlt:
                mov     al,0e0h
                call    ProcessScanCode
                mov     al,1dh+10000000b
                call    ProcessScanCode
                call    pcSendHiragana
                mov     al,0e0h
                call    ProcessScanCode
                mov     al,1dh
                call    ProcessScanCode
                jmp     exitProcessCapsLock

pcLCtrlAlt:
                mov     al,1dh+10000000b
                call    ProcessScanCode
                call    pcSendHiragana
                mov     al,1dh
                call    ProcessScanCode
                jmp     exitProcessCapsLock
;
;  Send Hiragana key (make and break)
;
pcSendHiragana:
                mov     al,70h
                call    ProcessScanCode         ; Send Hiragana(make)
                mov     al,70h+10000000b
                call    ProcessScanCode         ; Send Hiragana(break)
                or      fkey,00000001b          ; Set Ignore flag
                ret
ProcessCapsLock endp
;
;-----------------------------------------------
;
; Process Right/Left Shift
;
; Entry: AH = keystate
;        AL = Scan Code (w/ break bit)
; Exit:  AX carries the new shift state
;
;-----------------------------------------------
Public ProcessShift
ProcessShift    proc    near
        cmp     prevScanCode,36h
        jne     LeftShift
        mov     prevScanCode,al
        cmp     al,0b6h
        jne     notPureBreak
                                        ; RightShift Pure Break!
        call    ProcessScanCode
        mov     al,79h
        call    ProcessScanCode
        mov     al,0f9h
        call    ProcessScanCode
        jmp     short exitProcessShift

LeftShift:
        cmp     prevScanCode,2ah
        mov     prevScanCode,al
        jne     notPureBreak
        cmp     al,0aah
        jne     notPureBreak
                                        ; LeftShift Pure Break!
        call    ProcessScanCode
        mov     al,7bh
        call    ProcessScanCode
        mov     al,0fbh
        call    ProcessScanCode
        jmp     short exitProcessShift

notPureBreak:
        call    ProcessScanCode

exitProcessShift:
        ret
ProcessShift    endp
;@IBM J-DCR287(A) -- End
endif ;kbd101 ;101X

ifdef AX_KBD
Public XlateScan                                                        ;@IBM J-AXKBD01(A)
XlateScan   Proc                                                        ;@IBM J-AXKBD01(A)
comment !                                                               ;@IBM J-AXKBD01(A)
******************* START OF SPECIFICATIONS *********************       ;@IBM J-AXKBD01(A)
*                                                               *       ;@IBM J-AXKBD01(A)
*  SUBROUTINE NAME:  XlateScan                                  *       ;@IBM J-AXKBD01(A)
*                                                               *       ;@IBM J-AXKBD01(A)
*  DESCRIPTIVE NAME:  Translate physical key code to logical one*       ;@IBM J-AXKBD01(A)
*                                                               *       ;@IBM J-AXKBD01(A)
*  ENTRY POINT:  XlateScan     LINKAGE:  CALL NEAR (For now)    *       ;@IBM J-AXKBD01(A)
*                                                               *       ;@IBM J-AXKBD01(A)
*  INPUT:  AL = Scan Code                                       *       ;@IBM J-AXKBD01(A)
*                                                               *       ;@IBM J-AXKBD01(A)
*  EXIT-NORMAL:  Function performed                             *       ;@IBM J-AXKBD01(A)
*                                                               *       ;@IBM J-AXKBD01(A)
*  EXIT-ERROR:  ........................                        *       ;@IBM J-AXKBD01(A)
*                                                               *       ;@IBM J-AXKBD01(A)
*  INTERNAL REFERENCES:                                         *       ;@IBM J-AXKBD01(A)
*     ROUTINES: NONE.                                           *       ;@IBM J-AXKBD01(A)
*                                                               *       ;@IBM J-AXKBD01(A)
*  EXTERNAL REFERENCES:                                         *       ;@IBM J-AXKBD01(A)
*     ROUTINES:  NONE.                                          *       ;@IBM J-AXKBD01(A)
*                                                               *       ;@IBM J-AXKBD01(A)
******************* END  OF  SPECIFICATIONS ********************* !     ;@IBM J-AXKBD01(A)

Push DI                                                                 ;@IBM J-AXKBD01(A)
Mov  DI, CurSG                                                          ;@IBM J-AXKBD01(A)

.If < DI lt sgidFirstVDM >                                              ;@IBM J-AXKBD01(A)
  Mov  AH, AL                     ; Make scan code                      ;@IBM J-AXKBD01(A)
  And  AH, 7Fh                                                          ;@IBM J-AXKBD01(A)

  .If < AH eq 38H > OR            ; Alt/Ctrl Key Check                  ;@IBM J-AXKBD01(A)
  .If < AH eq 1Dh >                                                     ;@IBM J-AXKBD01(A)
    Test IntFlagArea.XKeyFlags, SecPrefix       ; E0/E1 code Check      ;@IBM J-AXKBD01(A)
    .If <nz> AND                                                        ;@IBM J-AXKBD01(A)
    Test IntFlagArea.XlateFlags,E1Prefix   ; E1 code Check              ;@IBM J-AXKBD01(A)
    .If < z >                                                           ;@IBM J-AXKBD01(A)
      .If < AH eq 38H >           ; If Right ALT                        ;@IBM J-AXKBD01(A)
        Mov AH, 68H               ;     translate it to Kanji Code      ;@IBM J-AXKBD01(A)
        And IntFlagArea.XKeyFlags, NOT SecPrefix        ;Reset E0 bit   ;@IBM J-AXKBD01(A)
      .Else                       ; If right Ctrl                       ;@IBM J-AXKBD01(A)
        Mov AH, 70H               ;     translate it to Katakana Code   ;@IBM J-AXKBD01(A)
        And IntFlagArea.XKeyFlags, NOT SecPrefix        ;Reset E0 bit   ;@IBM J-AXKBD01(A)
      .Endif                                                            ;@IBM J-AXKBD01(A)
    .Endif                                                              ;@IBM J-AXKBD01(A)

  .Elseif < AH eq 56h >         ; if #56 key(RO)                        ;@IBM J-AXKBD01(A)
    Mov  AH, 73h                ;       translate it to 73h             ;@IBM J-AXKBD01(A)
  .Elseif < AH eq 5Ah >         ; if No-Conv.                           ;@IBM J-AXKBD01(A)
    Mov  AH, 7Bh                ;       translate it to 7Bh             ;@IBM J-AXKBD01(A)
  .Elseif < AH eq 5Bh >         ; if Conv.                              ;@IBM J-AXKBD01(A)
    Mov  AH, 79h                ;       translate it to 79h             ;@IBM J-AXKBD01(A)
  .Elseif < AH eq 5Ch >         ; if AX key                             ;@IBM J-AXKBD01(A)
    Mov  AH, 5Eh                ;       translate it to 5Eh             ;@IBM J-AXKBD01(A)
  .Endif                        ; End of Scan Code check                ;@IBM J-AXKBD01(A)
  And  AL, 80H                                                          ;@IBM J-AXKBD01(A)
  Or   AL, AH                                                           ;@IBM J-AXKBD01(A)
.Endif                          ; End of Screen Group check             ;@IBM J-AXKBD01(A)

Pop DI                                                                  ;@IBM J-AXKBD01(A)
Ret                                                                     ;@IBM J-AXKBD01(A)


XlateScan ENDP                                                          ;@IBM J-AXKBD01(A)
                                                                        ;@IBM J-AXKBD01(A)
endif ;AX_KBD
endif ;DBCSKBD

Code    Ends

        End
