/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
#ifndef _kbdusb_h_
   #define _kbdusb_h_
/* SCCSID = "src/dev/kbd/ibmkbd/kbdusb.h, kbd, c.basedd 98/08/03" */
/*
*
*   OCO Source Materials
*
*
*   The source code for this program is not published or otherwise divested of its
*   tradesecrets, irrespective of what has been deposited with the U.S. Copyright Office.
*/

/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  KBDUSB.H                                              */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Header file for USB Keyboard Client support           */
/*                                                                            */
/*   FUNCTION:                                                                */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*  Mark    yy/mm/dd  Programmer Comment                                      */
/*  ----    --------  ---------- -------                                      */
/*          98/06/20  LR                                                      */
/*  LR0531  01/05/31  LR         Added BIOS Data Area definitions and         */
/*                               ReadBIOSKey function to support boot on      */
/*                               legacy free PC.                              */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/*
    USBKBD specific debug definitions
*/
   #ifdef DEBUG
      #define     dsPrint(l,s)          dsPrint5x(gLKBDMsg,(l),(s),0,0,0,0,0)
      #define     dsPrint1(l,s,a)       dsPrint5x(gLKBDMsg,(l),(s),(a),0,0,0,0)
      #define     dsPrint2(l,s,a,b)     dsPrint5x(gLKBDMsg,(l),(s),(a),(b),0,0,0)
      #define     dsPrint3(l,s,a,b,c)   dsPrint5x(gLKBDMsg,(l),(s),(a),(b),(c),0,0)
      #define     dsPrint4(l,s,a,b,c,d) dsPrint5x(gLKBDMsg,(l),(s),(a),(b),(c),(d),0)
   #endif

   #ifdef KBDUSB
      #include <usbcmmon.h>
   #else
/*
    debug message level definitions (usbdebug.h)
*/
      #define  DBG_CRITICAL      0
      #define  DBG_HLVLFLOW      1  // all strategy calls, hardware IRQ, timer interrupt calls
      #define  DBG_IRQFLOW       2
      #define  DBG_DETAILED      4
      #define  DBG_SPECIFIC      8
      #define  DBG_DBGSPCL       16

/*
    usbdebug.h
*/
void dsPrint5x (USHORT  currLevel, USHORT  msgLevel, PSZ s, ULONG par1, ULONG par2, ULONG par3, ULONG par4, ULONG par5);

/*
    usbidc.h
*/
typedef VOID (USBIDCEntry) (PRP_GENIOCTL pRP_GENIOCTL);
typedef USBIDCEntry FAR *PUSBIDCEntry;
   #endif

   #define MK_FP(seg,off) (void FAR *)(((ULONG)(((ULONG)(seg)<<16)+(ULONG)(off))))

USHORT SetUSBLEDs      (BYTE NewLEDState);
USHORT SetUSBTypematic (BYTE NewTypeRate);

VOID PASCAL FAR HookHandler (VOID);

/*LR0531begin  BIOS Data Area:
                  Keyboard Buffer
*/
#define  BIOS_DATA_SEG  0x0040
#define  BIOS_KBD_HEAD  0x001A/2
#define  BIOS_KBD_TAIL  0x001C/2
#define  BIOS_KBD_START 0x001E/2
#define  BIOS_KBD_END   0x003E/2

void ReadBIOSKey (void);
//LRO531end

extern PUSBIDCEntry gpUSBIDC;
extern USHORT       gdsUSBIDC;

extern BYTE gLegKbd;
extern BYTE gUSBKbd;
extern BYTE LED_State;
extern BYTE Type_Rate;
extern BYTE DisableFlag;

extern ULONG gHookHandle;

   #ifdef DEBUG
extern USHORT gLKBDMsg;
   #endif

#endif

