/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*
*
*   OCO Source Materials
*
*
*   The source code for this program is not published or otherwise divested of its
*   tradesecrets, irrespective of what has been deposited with the U.S. Copyright Office.
*/

/*****************************************************************************/
/*                                                                           */
/* SOURCE FILE NAME = KBDDATA.C                                              */
/*                                                                           */
/* DESCRIPTIVE NAME = Physical Keyboard Device Dependent Data                */
/*                                                                           */
/* VERSION      V2.2                                                         */
/*                                                                           */
/* DATE         01/11/94                                                     */
/*                                                                           */
/* DESCRIPTION  Data for Device Dependent Driver.                            */
/*                                                                           */
/* NOTES       DEPENDENCIES:  Controller or keyboard must be set to the      */
/*                            PC compatible scan code set.                   */
/*             RESTRICTIONS:  Machine must be a 386 or compatible with       */
/*                            a 386.                                         */
/*                                                                           */
/* STRUCTURES   PRPH                                                         */
/*              AttachDDStr                                                  */
/*              KeyStroke                                                    */
/*                                                                           */
/*   CHANGE ACTIVITY =                                                       */
/*     DATE      FLAG        APAR   CHANGE DESCRIPTION                       */
/*     --------  ----------  -----  ----------------------------------       */
/*     08/28/95  JS08356            Disable Set_LEDs on 5576-001&-002(H.Mori)*/
/*     07/08/97  CN181212           Added flag to know when you are in init  */
/*     06/20/98  LR_USB             Modified to support USB Keyboard Client. */
/*     10/20/98  IC22271            Added Flag - ShiftCondition              */
/*     03/26/01  254822             Added variable - Silent; also, the       */       
/*                                  OPTIONTABLE is updated with new /silent  */
/*                                  option.                                  */
/*****************************************************************************/

/*-----------------------------*/
/*   Include files             */
/*-----------------------------*/

 #include "os2.h"
 #include "strat2.h"
 #include "reqpkt.h"
 #include "kbddd.h"
 #include "dskinit.h"
 #include "cmdparse.h"
 #include "cmdpdefs.h"
 #include "dhcalls.h"
 #include "kbdusb.h"    //LR_USB

/*-----------------*/
/*   Variables     */
/*-----------------*/

 PRPH  pRPH;                      /* Pointer to RPH (Request Packet Header)  */
 PFN   Device_Help         = 0L;  /* Pointer to DevHelp routines.            */
 AttachDDStr KbdDI;               /* Structure to store AttachDD addresses.  */
 KeyStroke KeyBuffer;             /* Structure to store key stroke bytes.    */
 PFN   KbdDI_Entry;               /* Pointer to KbdDI IDC entry point.       */

//LR_USB begin
PUSBIDCEntry gpUSBIDC   = 0L;
USHORT       gdsUSBIDC  = 0;

BYTE gLegKbd = TURNON;
BYTE gUSBKbd = TURNOFF;

ULONG gHookHandle;

#ifdef DEBUG
USHORT gLKBDMsg = DBG_CRITICAL; // debug message level
#endif
//LR_USB end

USHORT KbdCS          = 0xFFFF;  /* Code Segment value.                     */
USHORT KbdDS          = 0xFFFF;  /* Data Segment value.                     */
USHORT Keycount;                 /* Number of keys on the keyboard.         */
USHORT Offset_Int_Handler;       /* Offset of State_Mach_Ctl.               */
USHORT Offset_IDC_Handler;       /* Offset of IDC_Entry_Point.              */
USHORT Offset_Timer_Handler;     /* Offset of KbdTimerHandler.              */
USHORT Offset_BTTimer_handler;   /* 148922 Offset of Block thread handler   */

USHORT KbdDI_Handle=0xFFFF;       /* Handle to KBDDI.                        */

 BYTE  Current_State;             /* Holds current state value.              */
 BYTE  LED_State;                 /* Current LED state.                      */
 BYTE  Type_Rate;                 /* Current type rate.                      */
 BYTE  DataByte1            = 0;  /* First ID byte.                          */
 BYTE  DataByte2            = 0;  /* Second ID byte.                         */
 BYTE  PendingReinitNotify;       // Need to notify KBDBASE of reinit event
 BYTE  AsyncInterruptTime;
 BYTE  SyncInterruptTime;
 BYTE  InitTime;                  //CN181212
 BYTE  TIMERFLAG;                 /* Set when waiting for the timer.     Bool*/
 BYTE  BTTIMERFLAG;             //SM148922: Set when waiting for the block thread timer
                                //SM148922: Cleared by th KbdBTTimerHandler
 BYTE  KbdResend;                 /* Set after a resend is sent from KBD.Bool*/
 BYTE  KbdError;                  /* Flags that an error has occured.    Bool*/
 BYTE  DisableFlag;               /* Set when the kbd is disabled.       Bool*/
 BYTE  FirstByte;                 /* Stores first scan code (E0 or E1).      */
 BYTE  PrevState;                 /* Previous state.                         */
 BYTE  Save_LED;                  /* Saved LED state.                        */
 BYTE  Save_Type;                 /* Saved Type rate.                        */
 BYTE  Next_Block;                /* Pointer to signify a thread is blocked. */
 BYTE  Next_Run;                  /* Pointer to next thread to run.          */
 BYTE  SCSet;                     /* Scan-Code Set.                          */
 BYTE  FakeKbd;                   /* flag set means fake an ibm enhanced kbd */
 BYTE  NumLock;                   /* If set Numlock should be set on at boot time */
#ifdef DBCSKBD
 BYTE  InitialSetLED        = 0;  /* First SetLed call                       */ 
#endif
 BYTE  DeferScans[DEFSIZ];        //queue for deferred scan-codes
 BYTE  DeferPos;                  //Position in deferral buffer
 BYTE  KbdIsLocked = FALSE;       // AP-199827 1998-06-29
 BYTE  ShiftCondition = 0;	  //IC22271 Flag means: Shift pressed/released
 BYTE  Silent = 0;		  /* 1 - no beeping at all (silent mode), 0 - default */ //254822 

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Command Line Parser Data                                     */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

#define TOKVBUF_LEN 255

PSZ        pcmdline1              = 0;
PSZ        pcmdline_slash         = 0;
PSZ        pcmdline_start         = 0;
INT        tokv_index             = 0;
INT        state_index            = 0;
INT        length                 = 0;
CHARBYTE   tokvbuf[TOKVBUF_LEN]  ;
POPT       pend_option            = 0;
POPT       ptable_option          = 0;
PBYTE      poutbuf1               = 0; //LR_USB    BYTE *poutbuf1    = 0;
PBYTE      poutbuf_end            = 0; //LR_USB    BYTE *poutbuf_end = 0;
CC         cc                     = { 0, 0 };

#define OUTBUF_LEN       255

BYTE   outbuf[OUTBUF_LEN] = {0};
USHORT outbuf_len         = OUTBUF_LEN + 1;
PBYTE  poutbuf            = outbuf;

#define ENTRY_STATE        0
#define MAX_STATES         3

UCHAR ParmErrMsg[] = " Warning: IBMKBD.SYS - Invalid CONFIG.SYS parameters";

/*                                  opt.state[] initialization definitions    */
/*                                                                            */
/*                                              ____ entry state              */
/*                                              |                   previous  */
/*                                              v                     opt |   */
/*  ----Command Line Option --------           ----- STATE TABLE -----    |   */
/*  token id          string   type             0   1   2   3             |   */
/*                                                                        |   */
/*                                              *  /A:  /I  /U: <-----------  */
/*                                                          /GEO:             */
/*                                                          /T:               */

OPT OPT_KEYBOARD =
    {TOK_ID_NONE,       "/NONE", TYPE_0,        {0,  1,  2,  3}};


OPT OPT_NUMLOCK_ON =
    {TOK_ID_NUMLOCK_ON, "/NUMON",     TYPE_0,   {0,  1,  2,  3}};

OPT OPT_NUMLOCK_OFF =
    {TOK_ID_NUMLOCK_OFF, "/NUMOFF",   TYPE_0,   {0,  1,  2,  3}};

/* New command line option added. */                               //254822 
OPT OPT_SILENT =                                                   //254822 
    {TOK_ID_SILENT,      "/SILENT",   TYPE_0,   {0,  1,  2,  3}};  //254822 

OPT OPT_END =
    {TOK_ID_END,     "\0",      TYPE_0,        {O,  O,  O,  O}};

/*                                                                      */
/*   The following is a generic OPTIONTABLE for the Keyboard            */
/*                                                                      */
OPTIONTABLE  opttable =

{   ENTRY_STATE, MAX_STATES,
    { (POPT) &OPT_KEYBOARD,
      (POPT) &OPT_NUMLOCK_ON,
      (POPT) &OPT_NUMLOCK_OFF,
      (POPT) &OPT_SILENT,       /* New command line option added. */  //254822 
      (POPT) &OPT_END
    }
};
#define MSG_REPLACEMENT_STRING  1178

MSGTABLE  InitMsg = { MSG_REPLACEMENT_STRING,
                      1,
                      0,
                          };

