;       SCCSID = @(#)clkabios.inc	6.2 91/04/29
;SCCSID = @(#)clkabios.inc	6.2 91/04/29


;
; This include file defines structures for setting up ABIOS request blocks
; used to affect the Real Time Clock (RTC).
;

; ABIOS RTC Function Codes

ABRETLIDP  EQU  01h             ; ABIOS Return Lid Parameters
ABSETPERI  EQU  0Dh             ; ABIOS Set Periodic Interrupt
ABCANALI   EQU  0Ch             ; ABIOS Cancel Alarm Interrupt
ABCANPERI  EQU  0Eh             ; ABIOS Cancel Periodic Interrupt
ABSETUPDI  EQU  0Fh             ; ABIOS Set Update-Ended Interrupt
ABCANUPDI  EQU  10h             ; ABIOS Cancel Update-Ended Interrupt
ABREADTD   EQU  11h             ; ABIOS Read Time and Date
ABWRITTD   EQU  12h             ; ABIOS Write Time and Date
MAXBRB     EQU  64              ; max size of ABIOS RTC Request Block
RETCODE_IN EQU  0ffffh          ; return code passed to abios in Request Block



ReqBlk  struc
; functional:
        RBLen           dw      ?       ; length of request block
        LogID           dw      ?       ;  Logical ID (address)
        Unit            dw      ?       ; Unit Number (= 0000 )
        Function        dw      ?       ; Function value
        RBFlags         dw      ?       ; ABIOS Internal call info
        ELLOffset       dw      ?       ; reserved
        ReturnCode      dw      ?       ; Return status
        TimeOut         dw      ?       ; Time out for stage on interrupt = 000
; Service Specific:
        Parms           dw 24 dup (?)   ; function-specific parameters
ReqBlk  ends

;*  Return LID Parameters function-specific parm struc

LIDParms struc
        RTCIntLvl       db      ?       ; harware interrupt level
        RTCArb          db      ?       ; arbitration level
        RTCDevice       dw      ?       ; Type of device
        RTCUnits        dw      ?       ; Number of units supported  = 01
        RTCLIDF         dw      ?       ; Bit information = 0000h
        RTCRBL          dw      ?       ; RB length (offset 18h)
LIDParms ends


;*  Read Device Parameters function-specific parm struc

RTParms struc
        RTC_Prat1       db      ?       ; Periodic Interrupt rate set
        RTC_SetF        db      ?       ; RTC set status
        Hrs             db      ?       ; Alarm interrupt set hour value
        Mins            db      ?       ;                     minute value
        Secs            db      ?       ;                     second value
        Resrvd1         db 6 Dup (?)    ; Reserved bytes
RTParms ends


;*  Set Periodic Interrupt function-specific RETURN parameter structure

SETPER  struc
        Resrvd5         db 10 dup (?)   ; reserved bytes
        C_Reg           db      ?       ; RTC C Register value.
SETPER  ends

;*  Set Periodic Interrupt function-specific REQUEST parameter structure

SETPI   struc
        RTC_Prat2       db      ?       ; Periodic Interrupt rate set
        Resrvd2         db 10 dup (?)   ; reserved bytes
SETPI   ends


;*  Read/Write Time and Date  function-specific parm struc

RWTD    struc
        resrvd3         dw      ?       ; reserved bytes
        Hours           db      ?       ; Time Set Values:  Hour
        Minutes         db      ?       ;                   Minute
        Seconds         db      ?       ;                   Second
        Century         db      ?       ;                   Century
        Year            db      ?       ;                   Year
        Month           db      ?       ;                   Month
        Day             db      ?       ;                   Day
        resrvd4         dw      ?       ; reserved space
RWTD    ends

