/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/dev/clock/clkfix.c, clk, c.basedd 99/02/04" */
/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  CLKFIX.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  CLKFIX - Enable SMM flag in CLOCK01                   */
/*                                                                            */
/*   FUNCTION:  Enable SMM flag in CLOCK01 driver to work                     */
/*              around problem documented in defects 196665/212762            */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: clkdata.inc                                             */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             None                                                           */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#include <os2.h>

// WARNING: Change the constant in clkdata.inc if you change IOCK_SM here
#define IOCK_SM		0x61            // SysMgmt Mode enabled
#define IOC_CK		0x0d		//from ioctl.inc -- not in ioctl.h!

int main ()
{
     USHORT usAction;
     HFILE hClk;
     APIRET rc;

     rc = DosOpen ("Clock$", &hClk, &usAction, 0, 0,
              FILE_OPEN, OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE, 0);
     if (!rc) {
         if(rc = DosDevIOCtl (NULL, NULL, IOCK_SM, IOC_CK, hClk))
	     printf("DosDevIOCTL error: return code = %u\n", rc);
     }
     else printf("DosOpen error: return code = %u\n", rc);

     return rc;
}
