;       SCCSID = @(#)ateisa.inc	6.1 91/04/08
; This structure is used for an array of information on COM ports that
; was obtained from EISA configuration information.

EISACom struc
        COMport_number  db      ?       ; unit number (1-8)
        IRQ_number      db      ?       ; interrupt line
        sharable_IRQ    db      ?       ; indicates if interrupt line sharable
        In_use          db      ?       ; EISA info. matches up with BIOS
        base_addr       dw      ?       ; first hw port address
        end_addr        dw      ?       ; ending hw port address
EISACom ends
LEN_EISACOM_STRUC       equ     SIZE EISACom

; Mask for determining if interrupt sharing is supported or not.
INT_SHARING     equ     1

; Mask for the INT pending bit in the COM port
INT_PENDING     equ     01h

; Max. number of ISA and EISA COM ports supported
MAXECOMPORTS    equ     4

; Max. number of ISA COM ports defined in the BIOS data area
MAXISACOMPORTS  equ     2

; ASCII code for a TAB character
TAB             equ     9
