/**************************************************************************
 *
 * SOURCE FILE NAME = VTVDDREQ.C
 *
 * DESCRIPTIVE NAME = Virtual Touch Device Driver VDD Requests
 *
 * Copyright   COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE        07/12/91
 *
 * DESCRIPTION
 *             This module contains the VTD's VDD entry point for use by other
 *             VDDs via VDHOpenVDD/VDHRequestVDD.
 *
 *
 * FUNCTIONS   VTVddReqProc,     vtVddSetFocus,       vtVddPostTouch.
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 *  03/01/91                     drw     Created.
 ****************************************************************************/

#include "vtdef.h"

/*
** Externals
*/

extern PFNVTVDDREQ apfnVddReq[];
extern BOOL        fTouchEnabled;
extern ULONG       ulSstate;

#pragma  BEGIN_SWAP_CODE


/****************************************************************************
 *
 * FUNCTION NAME = VTVddReqProc
 *
 * DESCRIPTION   = VDHRequestVDD function dispatcher.
 *     pfnVddReq - function for use by VDHRequestVDD,
 *                 BOOL pfnVddReq(hvdm, ulCmd, pReqIn, pReqOut)
 *             ENTRY
 *                 HVDM    hvdm    - VDM handle
 *                 ULONG   ulCmd   - Command
 *                 PVOID   pReqIn  - Input packet
 *                 PVOID   pReqOut - output packet
 *             EXIT
 *                 VDDREQ_PASS - VDM manager will call the next routine
 *                               registered under same name.
 *                 TRUE        - return success (For VDH services 1 is success)
 *                 FALSE       - return the caller failure
 *
 *   PSEUDO-CODE - NONE
 *
 *
 * INPUT         = hvdm    - VDM handle
 *                 ulCmd   - Command
 *                 pReqIn  - Input packet
 * OUTPUT        = pReqOut - output packet
 *
 * RETURN-NORMAL = TRUE
 * RETURN-ERROR  = FALSE
 *
 ****************************************************************************/

BOOL EXPENTRY VTVddReqProc( HVDM hvdm, ULONG ulCmd, PVOID pReqIn,PVOID pReqOut )
{
  if( ulCmd < VTVDDREQ_MAX )
    return( ( *apfnVddReq[ulCmd] )( hvdm, pReqIn, pReqOut ) );
  else
    return( FALSE );
}


/****************************************************************************
 *
 * FUNCTION NAME = vtVddSetFocus
 *
 * DESCRIPTION   = Set Foreground/Background focus.
 *   PSEUDO-CODE - NONE
 *
 *
 * INPUT         = hvdm    - VDM handle
 *                 pReqIn  - zero, set background
 *                           non-zero, set foreground
 * OUTPUT        = pReqOut - not used
 *
 * RETURN-NORMAL = TRUE
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

BOOL PRIVENTRY vtVddSetFocus( HVDM hvdm, PVOID pReqIn, PVOID pReqOut )
{
  if( pReqIn )
    REFHVDM( hvdm, ULONG, ulSstate ) |= SESSION_FOREGROUND;
  else
    REFHVDM( hvdm, ULONG, ulSstate ) &= ~SESSION_FOREGROUND;
  return( TRUE );
}


/****************************************************************************
 *
 * FUNCTION NAME = vtVddPostTouch
 *
 * DESCRIPTION   = Post a Touch event to a VDM.
 *   PSEUDO-CODE - NONE
 *
 *
 * INPUT         = hvdm    -  VDM handle
 *                 pReqIn  -> 0:32 address of structure as defined by MONREC
 * OUTPUT        = pReqOut -  not used
 *
 * RETURN-NORMAL = TRUE
 * RETURN-ERROR  = FALSE
 *
 ****************************************************************************/

BOOL PRIVENTRY vtVddPostTouch( HVDM hvdm, PVOID pReqIn, PVOID pReqOut )
{
  if( REFHVDM( hvdm, BOOL, fTouchEnabled ) )
  {
    vtAddEvent( hvdm, ( &((PMONREC)pReqIn)->QEvent ) );
    return( TRUE );
  }
  else
    return( FALSE );
}

#pragma  END_SWAP_CODE
