/**************************************************************************
 *
 * SOURCE FILE NAME = VTDEF.H
 *
 * DESCRIPTIVE NAME = Virtual Touch Device Driver Type and Constant
 *                    Definitions.
 *
 * Copyright   COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE        09/20/91
 *
 * DESCRIPTION
 *             This module contains the VTD's Types and Constants.
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 *  03/01/91                     drw     Created.
 *  21/11/91                     drw     VMBoot additions.
 ****************************************************************************/

#include <mvdm.h>
#include "vtdptd.h"

#ifdef  REVISION_NO
#define VTDEBUG
#endif

#define VTD_VERSION             "2.00"
#define VTD_VERSION_MAJOR       0x02
#define VTD_VERSION_MINOR       0x00
#define VTD_VERSION_REVISION    REVISION_NO

#define INVALID_HVDM            ((HVDM)-2)
#define PM_SCREENGROUP          ((USHORT)1)

#define SESSION_FOREGROUND      0x01
#define SESSION_WINDOWED        0x02
#define SESSION_EXCLUSIVE       0x04

#define TOUCHINT                0x7f

#define MAX_XY                  4095
#define MAX_Z                   255
#define MAX_HYST                32767
#define MAX_REPORT_RATE         4
#define MAX_CALLMASK            0x1ff   /* bits 5 thru 0 are valid         */
#define MAX_FILTERTYPE          1       /* touch display, touch panel      */
#define MAX_FILTERFREQUENCY     4       /* cut-off frequency               */

#define QEVENTBUFFSIZE          16
#define SPBUFFERMAX             40

#define PROPBEEP_FREQUENCY      3520    /* properties warning/error        */
#define PROPBEEP_DURATION       40

#define EMULBEEP_FREQUENCY      880
#define EMULBEEP_DURATION       80
#define EMULTYPE_RELATIVE       0
#define EMULTYPE_ABSOLUTE       1
#define EMULTYPE_GLASSMOUSE     2

/*
** VTDosReqProc commands
*/

#define VTDOSREQ_SETFOCUS       0
#define VTDOSREQ_POSTTOUCH      1
#define VTDOSREQ_MAX            2

/*
** VTVddReqProc commands
*/

#define VTVDDREQ_SETFOCUS       0
#define VTVDDREQ_POSTTOUCH      1
#define VTVDDREQ_MAX            2

/*
** System Errors ??? aren't these somewhere else ???
*/

#define ERROR_NONE              0
#define ERROR_NOT_ENABLED       1
#define ERROR_INVALID_SGID      2

#define ERROR_ACCESS_DENIED     5
#define ERROR_INVALID_PARAMETER 87

/*
** Int 7fh Specific Constants
*/

#define INT7FERROR_NOERROR      0       /* No Error                        */
#define INT7FERROR_INVALIDINPUT 1       /* Invalid Input                   */
#define INT7FERROR_INTERFACE    2       /* Interface Error                 */
#define INT7FERROR_SEEPARMS     3       /* Other error/status              */

#define INT7F_MINUS_ONE         0xffff

#define ORIGIN_TOPLEFT          0
#define ORIGIN_BOTTOMLEFT       1

#define BLOCKMASK_ALL_DATA      0x01
#define BLOCKMASK_PEGGED_DATA   0x04

#define XYZDATA_READ            0x8000  /* top bit for get curr pos        */

/*
** Call Mask bit definitions
*/

#define CALLMASK_XY_CHANGED     0x01    /* X, Y position changed           */
#define CALLMASK_Z_CHANGED      0x02    /* Z position changed              */
#define CALLMASK_SELECT_TO_OFF  0x04    /* Selection transition ON to OFF  */
#define CALLMASK_SELECT_TO_ON   0x08    /* Selection transition OFF to ON  */
#define CALLMASK_LIFT_OFF       0x10    /* Lift-Off occurred               */
#define CALLMASK_TOUCH_DOWN     0x20    /* Touch-Down occurred             */
#define CALLMASK_VALID          0x3f    /* Valid Call Mask bits(all the above)*/

/*
** Selection Mechanism method bit definitions
*/

#define SM_PUSH_HARDER          0
#define SM_LIFT_OFF             1
#define SM_ONETOUCH             2
#define SM_STABLE_POINT         4
#define SM_MAX                  5

#define SM_FLAG_SENT            1
#define SM_FLAG_DETECTED        2

/*
** Per VDM data defaults (int 7f functions).
*/

#define DEFAULT_EMUL_TYPE               1
#define DEFAULT_EMUL_ONOFF              TRUE
#define DEFAULT_EMUL_BEEP               1
#define DEFAULT_EMUL_MICKEYS            200
/* #define DEFAULT_EMUL_TYPE            0       */
/* #define DEFAULT_EMUL_ONOFF           FALSE   */
#define DEFAULT_BLOCKMASK               0
#define DEFAULT_CALLMASK                0
#define DEFAULT_FILTER_TYPE             0
#define DEFAULT_FILTER_FREQ             0
#define DEFAULT_REPORT_RATE             4
#define DEFAULT_ORIGIN_TOPLEFT          TRUE
#define DEFAULT_TRACK_VIDEOMODE         TRUE
#define DEFAULT_COORD_XMIN              1
#define DEFAULT_COORD_XMAX              80
#define DEFAULT_COORD_YMIN              1
#define DEFAULT_COORD_YMAX              25
#define DEFAULT_COORD_ZMIN              0
#define DEFAULT_COORD_ZMAX              255
#define DEFAULT_COORD_XHYSTERESIS       500
#define DEFAULT_COORD_YHYSTERESIS       500
#define DEFAULT_THRESHOLD_ONSCREEN      46
#define DEFAULT_THRESHOLD_HYSTERESIS    80
#define DEFAULT_THRESHOLD_PUSH          96
#define DEFAULT_SELECTION_METHOD        SM_PUSH_HARDER
#define DEFAULT_SELECTION_FLAG          0
#define DEFAULT_SELECTION_TOLERANCE     3
#define DEFAULT_SELECTION_COUNT         5
#define DEFAULT_SELECTION_LIMIT         20
#define DEFAULT_CLICK_ONOFF             1
#define DEFAULT_CLICK_TIMEOUT           550
#define DEFAULT_CLICK_XLOCKAREA         20
#define DEFAULT_CLICK_YLOCKAREA         20

/*
** - Local Macros
*/

#define QBUFFBEGIN              (&atevBuffer[0])
#define QBUFFEND                (&atevBuffer[QEVENTBUFFSIZE-1])
#define NEXTQPTR(p)             ((p==QBUFFEND) ? QBUFFBEGIN : ((p)+1))

#define MAPCOORD(val,min,max,r) (min+(USHORT)(((ULONG)val*(ULONG)(max-min)+(ULONG)r/2)/(ULONG)r))

/* if (r != 0) output an assertion message and break via an int 3 */

#ifdef  VTDEBUG
extern  PSZ                     AssertMsg;
#define Assert(r)               {if(r){printf(AssertMsg, __FILE__, __LINE__);INT3();}}
#else
#define Assert(r)               /* nothing */
#endif

/*
** Type Definitions of structures etc.
*/

typedef struct          /* Set up for call to VDM User-Subroutine with data   */
{
  USHORT       ConditionMask;
  USHORT       Status;
  USHORT       z;
  USHORT       y;
  USHORT       x;
} USERSUBSTACK, *PUSERSUBSTACK;

typedef struct
{
  USHORT       Count;
  USHORT       Status;
  USHORT       x;
  USHORT       y;
  USHORT       z;
} XYZDATA, *PXYZDATA;

typedef struct
{
  USHORT       len;
  USHORT       SGId;
} ICBIN, *PICBIN;

typedef struct _INT7FPARM
{
  USHORT       p0, p1, p2, p3, p4, p5, p6, p7;
} INT7FPARM, *PINT7FPARM;

typedef struct _SPBUFFER
{
  USHORT       x, y;
} SPBUFFER, *PSPBUFFER;

typedef struct _SELMECH
{
  USHORT       usMethod;                /* selection method                */
  USHORT       usFlag;                  /*                                 */
  USHORT       usTolerance;             /* tolerance in pels               */
  USHORT       usCount;                 /* no of stable points             */
  USHORT       usOTCount;               /* onetouch count                  */
  USHORT       usLimit;                 /* buffer search limit             */
  USHORT       usMethod_Default;
  USHORT       usTol_Default;
  USHORT       usCount_Default;
  USHORT       usLimit_Default;
  USHORT       usSPBuffHead;
  USHORT       usSPBuffTail;
  SPBUFFER     SPBuffer[SPBUFFERMAX];
} SELMECH, *PSELMECH;

typedef struct _COORDS
{
  USHORT       usXMin, usXMax;
  USHORT       usYMin, usYMax;
  USHORT       usZMin, usZMax;
  USHORT       usXHysteresis;
  USHORT       usYHysteresis;
} COORDS, *PCOORDS;

typedef struct _THRESHOLDS
{
  USHORT       usOnScreen;
  USHORT       usPushHysteresis;
  USHORT       usPushSelection;
} THRESHOLDS, *PTHRESHOLDS;

typedef struct _CLICKLOCK
{
  USHORT       usClickOnOff;
  USHORT       usClickTimeout;
  USHORT       usXLockArea;
  USHORT       usYLockArea;
} CLICKLOCK, *PCLICKLOCK;

typedef struct _EMULSTATE
{
  USHORT       usEmulType;
  USHORT       fEmulBeep;
  USHORT       usMickeys;
} EMULSTATE, *PEMULSTATE;

typedef struct _PERVDMDATA
{
  EMULSTATE    EmulState;               /* Emulation State                 */
  BOOL         fEmulationOn;            /* Emulation On/Off                */
  ULONG        flBlockMask;             /* Data Block mask                 */
  ULONG        flCallMask;              /* User sub Call mask              */
/* Nicky VPVOID       vpUserSub;           // User sub address to call     */
  FPFN         fpfnUserSub;             /* User sub address to call        */
  USERSUBSTACK UserSubStack;            /* Current event to send           */
  ULONG        ulFilterType;            /* Filter type                     */
  ULONG        ulFilterFreq;            /* Filter cut-off frequency        */
  ULONG        ulReportRate;            /* Report rate                     */
  BOOL         fOriginTopLeft;          /* Co-ordinate origin              */
  BOOL         fTrackVideoMode;         /* Auto co-ordinate ranging        */
  COORDS       coData;                  /* XYZ min/max as per Set Co-Ords  */
  THRESHOLDS   thData;                  /* Current thresholds              */
  SELMECH      smData;                  /* Selection mechanism data        */
  CLICKLOCK    clData;                  /* Click-Locking data              */
  XYZDATA      xyzCurrent;              /* XYZ Data - Current              */
  XYZDATA      xyzLastLiftOff;          /*          - Last Lift Off        */
  XYZDATA      xyzLastTouchDown;        /*          - Last Touch Down      */
  XYZDATA      xyzLastSelectOn;         /*          - Last Select to On    */
  XYZDATA      xyzLastSelectOff;        /*          - Last Select to Off   */
  XYZDATA      xyzStablePoint;          /*          - Last Stable Point    */
  XYZDATA      xyzSingleTouch;          /*          - Last Single Touch    */
} PERVDMDATA, *PVDMDATA;

typedef RETCODE (PRIVENTRY * PVTINT7FFN)(PINT7FPARM, PINT7FPARM);
typedef LONG (PRIVENTRY * PFNVTDOSREQ)(HVDM, ULONG, PVOID, ULONG, PVOID);
typedef BOOL (PRIVENTRY * PFNVTVDDREQ)(HVDM, PVOID, PVOID);
/* end */

#pragma BEGIN_INSTANCE_DATA
extern  PERVDMDATA      VMData;
#define VDMData         VMData
#pragma END_INSTANCE_DATA

/*
** Prototypes private and exported.
*/

/* vtevent.c   */
VOID    VDDENTRY  VTEventProc( ULONG, F16PVOID, F16PVOID );
VOID    PRIVENTRY vtNotifyEmulState( HVDM );
VOID    PRIVENTRY vtNotifyExclusiveState( HVDM, BOOL );
VOID    PRIVENTRY vtAddEvent( HVDM, PQEVENT );
BOOL    PRIVENTRY vtFilterEvent( HVDM, PQEVENT );
VOID    HOOKENTRY vtSendEvent( PHVDM, PCRF );
BOOL    PRIVENTRY vtPeekEvent( HVDM, PQEVENT );
VOID    PRIVENTRY vtRemoveEvent( HVDM, PQEVENT );
BOOL    PRIVENTRY vtNeedEvent( HVDM, PQEVENT, PULONG );
VOID    PRIVENTRY vtProcessEvent( HVDM, PQEVENT );

/* vthook.c    */
BOOL    HOOKENTRY VTCreate( HVDM );
BOOL    HOOKENTRY VTDestroy( HVDM );
BOOL    HOOKENTRY VTSetFgnd( HVDM );
BOOL    HOOKENTRY VTSetBgnd( HVDM );
BOOL    HOOKENTRY VTUserSubIntHook( PCRF );
VOID    HOOKENTRY VTUserSubReturnHook( PVOID, PCRF );
VOID    HOOKENTRY VTInt7fhook( PVOID, register PCRF );
RETCODE EXPENTRY  VTExclusiveTouch( ULONG, HVDM, ULONG, PSZ );
BOOL    HOOKENTRY VTInt10Hook( register PCRF );
VOID    HOOKENTRY VTDOSLink( PVOID, PCRF );

/* vtdosreq.c  */
RETCODE EXPENTRY  VTDosReqProc( SGID, ULONG, ULONG, PVOID, ULONG, PVOID );
LONG    PRIVENTRY vtDosSetFocus( HVDM, ULONG, PVOID, ULONG, PVOID );
LONG    PRIVENTRY vtDosPostTouch( HVDM, ULONG, PVOID, ULONG, PVOID );

/* vtvddreq.c  */
BOOL    EXPENTRY  VTVddReqProc( HVDM, ULONG, PVOID, PVOID );
BOOL    PRIVENTRY vtVddSetFocus( HVDM, PVOID, PVOID );
BOOL    PRIVENTRY vtVddPostTouch( HVDM, PVOID, PVOID );

/* vtint7f.c   */
RETCODE PRIVENTRY vtInt7fReset( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fEmulReset( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fEmulOnOff( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fSetCoOrdinates( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fSetOrigin( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fSetThresholds( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fSetSelection( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fSetReportRate( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fSetBlockMask( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetTouchDown( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetLiftOff( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetSelectOn( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetSelectOff( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetCurrent( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fSetUserSub( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fSwapUserSub( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fSetFilterType( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fQueryStorage( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fSaveState( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fRestoreState( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetEmulState( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetEmulOnOff( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetCoOrdinates( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetOrigin( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetThresholds( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetSelection( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetReportRate( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetBlockMask( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetFilterType( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetDriverInfo( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fGetClickLock( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fSetClickLock( PINT7FPARM, PINT7FPARM );
RETCODE PRIVENTRY vtInt7fDldCalibConsts( PINT7FPARM, PINT7FPARM );
