
/**************************************************************************
 *
 * SOURCE FILE NAME = VMLPEN.C
 *
 * DESCRIPTIVE NAME = Virtual Mouse Device Driver Int 33h Light-pen Services 
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             Copyright Microsoft Corporation, 1990
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION =   V2.0
 *
 * DATE        05/28/90
 *
 * DESCRIPTION This module contains the VMD's Int 33h light-pen services.
 *             
 *
 * FUNCTIONS   
 *       vmInt33EnableLightPen()   Int 33h Enable Light-pen (function 13)     
 *       vmInt33DisableLightPen()  Int 33h Disable Light-pen (function 13)
 *       vmSetLightPen()           Set light-pen notification
 *       VMQueryStatus()           VDM light-pen query
 *
 *
 * ENTRY POINTS: 
 *
 * DEPENDENCIES:  
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 *
 *  01/31/89  @V2.0JTP01  JTP     Created.
 ****************************************************************************/

#include "vmdp.h"

#ifdef   VDDSTRICT
MODNAME = __FILE__;
#endif

/*
**    External References
*/

extern PVVINFO pvvinfoHead;
#pragma  BEGIN_SWAP_CODE

 /****************************************************************************
 *
 * FUNCTION NAME  : vmInt33EnableLightPen() 
 *
 * DESCRIPTION    : Int 33h Enable Light-pen (function 13) 
 *
 * INPUT          :
 *                    pcrf -> VDM register frame
 * OUTPUT         :
 *                   EMULATED
 *                       TRUE
 *                   NOT EMULATED
 *                       FALSE (pass control to next VDD and/or ROM)
 *  USES          :
 *                  32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                   VDM Task-time
 *
 *  PSEUDO-CODE   :                                 REFERENCES
 *      enable light pen emulation;
 *
 ***************************************************************************/

BOOL PRIVENTRY vmInt33EnableLightPen(register PCRF pcrf)
{
  vmSetLightPen(CURRENT_VDM, TRUE);
  return  TRUE;
}                                      /* vmInt33EnableLightPen              */

 /*************************************************************************
 *
 * FUNCTION NAME  : vmInt33DisableLightPen() 
 *
 * DESCRIPTION    : Int 33h Disable Light-pen (function 13) 
 *
 * INPUT          :
 *                  pcrf -> VDM register frame
 * OUTPUT         :
 *                  EMULATED
 *                     TRUE
 *                 NOT EMULATED
 *                     FALSE (pass control to next VDD and/or ROM)
 *  USES          :
 *                 32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                    VDM Task-time
 *
 *  PSEUDO-CODE   :                                  REFERENCES
 *                  disable light pen emulation;
 ***************************************************************************/

BOOL PRIVENTRY vmInt33DisableLightPen(register PCRF pcrf)
{
  vmSetLightPen(CURRENT_VDM, FALSE);
  return  TRUE;
}                                      /* vmInt33DisableLightPen             */

 /***************************************************************************
 *
 * FUNCTION NAME  :  vmSetLightPen() 
 *
 * DESCRIPTION    : Set light-pen notification 
 *
 * INPUT          :
 *                  hvdm -> VDM
 *                  fEnable == TRUE to enable notification, FALSE to not
 *
 * OUTPUT         :  NONE.
 *                        
 *  USES          :
 *      32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *      Task-time
 *
 *  PSEUDO-CODE                                     REFERENCES
 *      store light pen enable state;
 *      call virtual video to enable/disable light pen emulation;
 *****************************************************************************/

VOID PRIVENTRY vmSetLightPen( HVDM hvdm,BOOL fEnable )
{
  register PVVINFO pvvinfo = pvvinfoHead;
  pVDMData(hvdm)->mstates.fLPenEmulate = fEnable;

  while ( pvvinfo )
  {
    if ( pvvinfo->vvi_vmreg.vmreg_pfnSetLPenEm )
      (*pvvinfo->vvi_vmreg.vmreg_pfnSetLPenEm)(hvdm, fEnable);
    pvvinfo = pvvinfo->vvi_pvvinfoNext;
  } 
}                                      /* vmSetLightPen                      */

 /***************************************************************************
 *
 * FUNCTION NAME :  VMQueryStatus() 
 *
 * DESCRIPTION   : VDM light-pen query 
 *
 *  Note that this request is not limited to light-pen emulation calls
 *  from the video driver (it can be called at any time), but that is all
 *  we use it for.
 *
 *  INPUT         :
 *                  pvmstat -> record
 *  OUTPUT        :
 *                  status record filled in
 *  USES          :
 *                  32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                  Task-time
 *
 *  PSEUDO-CODE                                     REFERENCES
 *      fill in given status record with mouse state data;
 *
 ***************************************************************************/

BOOL EXPENTRY VMQueryStatus(HVDM hvdm,register PVMSTAT pvmstat)
{
  register PVDMDATA pvd = pVDMData(hvdm);
  pvmstat->vmstat_fPtrHidden = pvd->mstates.fPtrHidden;

  pvmstat->vmstat_flButtons = pvd->flButtons;
  pvmstat->vmstat_x = pvd->mstates.xCur;

  pvmstat->vmstat_y = pvd->mstates.yCur;
  return  TRUE;
}                                      /* VMQueryStatus                      */
#pragma  END_SWAP_CODE
