/*static char *SCCSID = "@(#)vlptin.c   6.3 91/05/14";*/
#pragma linesize(132)
#pragma pagesize(60)
#pragma title("VLPTIN.C")
/****************************************************************************/
/*                                                                          */
/*                       IBM/Microsoft Confidential                         */
/*                                                                          */
/*                 Copyright (c) IBM Corporation  1987, 1990                */
/*                 Copyright (c) Microsoft Corp.  1987, 1990                */
/*                           All Rights Reserved                            */
/*                                                                          */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  VLPTIN.C                                              */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Process VDM parallel printer and planar port input    */
/*                                                                            */
/*   FUNCTION: These routines process all IN instructions                     */
/*             to parallel printer ports.                                     */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: Spooler is running                                      */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             VLPT1DaIn - LPT1 Data port IN instruction handler              */
/*             VLPT2DaIn - LPT2 Data port IN instruction handler              */
/*             VLPT3DaIn - LPT3 Data port IN instruction handler              */
/*             VLPT1StIn - LPT1 Status port IN instruction handler            */
/*             VLPT2StIn - LPT2 Status port IN instruction handler            */
/*             VLPT3StIn - LPT3 Status port IN instruction handler            */
/*             VLPT1CoIn - LPT1 Control port IN instruction handler           */
/*             VLPT2CoIn - LPT2 Control port IN instruction handler           */
/*             VLPT3CoIn - LPT3 Control port IN instruction handler           */
/*             VLPTResIn - LPT Reserve port IN instruction handler            */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include <mvdm.h>                       /* VDH services, etc.        */
#include "vlptp.h"                      /* VLPT data defines         */
#include "vlptdata.h"                   /* VLPT external data        */

#pragma BEGIN_SWAP_CODE

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT1DaIn                                        */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT1 Data Port In Instruction Handler           */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            IN instruction for LPT1 if the IN to the data port      */
/*            is the first occurrence of I/O. If it is not the        */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the IN instruction.         */
/*                                                                    */
/* NOTES:  VLPT1DaIn handles byte instructions only.                  */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT1DaIn                                            */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         portaddr -    port address                                 */
/*         pcrf     -    client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  returns byte of data from data port for LPT1         */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
BYTE HOOKENTRY VLPT1DaIn(portaddr, pcrf)
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif
    BYTE dataread;                     /* set up byte to return      */

    dataread=0;
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTONE]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted all future I/O to the -*/
    /*- data port will go directly to the port. Now do an IN to     -*/
    /*- satisfy the application that caused this routine to be      -*/
    /*- executed.                                                   -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTONE].flags & DIRECT_MODE_FLAG) {

        dataread = INB(portaddr);

    } /* endif */

    return(dataread);                  /* return data read           */
}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT2DaIn                                        */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT2 Data Port In Instruction Handler           */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            IN instruction for LPT2 if the IN to the data port      */
/*            is the first occurrence of I/O. If it is not the        */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the IN instruction.         */
/*                                                                    */
/* NOTES:  VLPT2DaIn handles byte instructions only.                  */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT2DaIn                                            */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         portaddr -    port address                                 */
/*         pcrf     -    client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  returns byte of data from data port for LPT2         */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
BYTE HOOKENTRY VLPT2DaIn(portaddr, pcrf)
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif
    BYTE dataread;                     /* set up byte to return      */

    dataread=0;
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTTWO]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted all future I/O to the -*/
    /*- data port will go directly to the port. Now do an IN to     -*/
    /*- satisfy the application that caused this routine to be      -*/
    /*- executed.                                                   -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTTWO].flags & DIRECT_MODE_FLAG) {

        dataread = INB(portaddr);

    } /* endif */

    return(dataread);                  /* return data read           */

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT3DaIn                                        */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT3 Data Port In Instruction Handler           */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            IN instruction for LPT3 if the IN to the data port      */
/*            is the first occurrence of I/O. If it is not the        */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the IN instruction.         */
/*                                                                    */
/* NOTES:  VLPT3DaIn handles byte instructions only.                  */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT3DaIn                                            */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         portaddr -    port address                                 */
/*         pcrf     -    client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  returns byte of data from data port for LPT3         */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
BYTE HOOKENTRY VLPT3DaIn(portaddr, pcrf)
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif
    BYTE dataread;                     /* set up byte to return      */

    dataread=0;
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTTHREE]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted all future I/O to the -*/
    /*- data port will go directly to the port. Now do an IN to     -*/
    /*- satisfy the application that caused this routine to be      -*/
    /*- executed.                                                   -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTTHREE].flags & DIRECT_MODE_FLAG) {

        dataread = INB(portaddr);

    } /* endif */

    return(dataread);                  /* return data read           */

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT1StIn                                        */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT1 Status Port In Instruction Handler         */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            IN instruction for LPT1 if the IN to the status port    */
/*            is the first occurrence of I/O. If it is not the        */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the IN instruction.         */
/*                                                                    */
/* NOTES:  VLPT1StIn handles byte instructions only.                  */
/*         See vlptp.h for bit-level detail of the status port.       */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT1StIn                                            */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         portaddr -    port address                                 */
/*         pcrf     -    client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  returns byte of data from status port for LPT1       */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
BYTE HOOKENTRY VLPT1StIn(portaddr, pcrf)
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif

    BYTE dataread;                     /* set up byte to return      */

    dataread=0;
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTONE]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted all future I/O to the -*/
    /*- status port will go directly to the port. Now do an IN to   -*/
    /*- satisfy the application that caused this routine to be      -*/
    /*- executed.                                                   -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTONE].flags & DIRECT_MODE_FLAG) {

        dataread = INB(portaddr);

    } /* endif */

    return(dataread);                  /* return data read           */

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT2StIn                                        */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT2 Status Port In Instruction Handler         */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            IN instruction for LPT2 if the IN to the status port    */
/*            is the first occurrence of I/O. If it is not the        */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the IN instruction.         */
/*                                                                    */
/* NOTES:  VLPT2StIn handles byte instructions only.                  */
/*         See vlptp.h for bit-level detail of the status port.       */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT2StIn                                            */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         portaddr -    port address                                 */
/*         pcrf     -    client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  returns byte of data from status port for LPT2       */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
BYTE HOOKENTRY VLPT2StIn(portaddr, pcrf)
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif

    BYTE dataread;                     /* set up byte to return      */

    dataread=0;
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTTWO]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted all future I/O to the -*/
    /*- status port will go directly to the port. Now do an IN to   -*/
    /*- satisfy the application that caused this routine to be      -*/
    /*- executed.                                                   -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTTWO].flags & DIRECT_MODE_FLAG) {

        dataread = INB(portaddr);

    } /* endif */

    return(dataread);                  /* return data read           */

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT3StIn                                        */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT3 Status Port In Instruction Handler         */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            IN instruction for LPT3 if the IN to the status port    */
/*            is the first occurrence of I/O. If it is not the        */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the IN instruction.         */
/*                                                                    */
/* NOTES:  VLPT3StIn handles byte instructions only.                  */
/*         See vlptp.h for bit-level detail of the status port.       */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT3StIn                                            */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         portaddr -    port address                                 */
/*         pcrf     -    client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  returns byte of data from status port for LPT3       */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
BYTE HOOKENTRY VLPT3StIn(portaddr, pcrf)
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif

    BYTE dataread;                     /* set up byte to return      */

    dataread=0;
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTTHREE]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted all future I/O to the -*/
    /*- status port will go directly to the port. Now do an IN to   -*/
    /*- satisfy the application that caused this routine to be      -*/
    /*- executed.                                                   -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTTHREE].flags & DIRECT_MODE_FLAG) {

        dataread = INB(portaddr);

    } /* endif */

    return(dataread);                  /* return data read           */

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT1CoIn                                        */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT1 Control Port In Instruction Handler        */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            IN instruction for LPT1 when the IN to the control      */
/*            port is the first occurrence of I/O. If it is not the   */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the IN instruction.         */
/*            For compatibility, if virtual port 102 is not in        */
/*            bidirectional mode then bit 5 (direction) will always   */
/*            be set to 1 before returning the value read.            */
/*                                                                    */
/* NOTES:  VLPT1CoIn handles byte instructions only.                  */
/*         See vlptp.h for bit-level detail of the control port.      */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT1CoIn                                            */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         portaddr -    port address                                 */
/*         pcrf     -    client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  returns byte of data from control port for LPT1      */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
BYTE HOOKENTRY VLPT1CoIn(portaddr, pcrf)
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif

    BYTE dataread;                     /* set up byte to return      */

    dataread=0;
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTONE]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted do an IN to the       -*/
    /*- control port to satisfy the application that caused this    -*/
    /*- routine to be executed.                                     -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTONE].flags & DIRECT_MODE_FLAG) {

        dataread = INB(portaddr);

    /*---------------------------------------------------------------*/
    /*- If port 102 is not in bidirectional (extended) mode then    -*/
    /*- mask off the direction bit (bit 5). Bit 5 is write only.    -*/
    /*---------------------------------------------------------------*/
        if (MachineType == MACHINE_TYPE_PS2) {
            if ((pvddvbiospos->PlanarPOS.aPOSReg[2]) & NOT_BIDI_MODE) {
                dataread &= (~CTRL_DIRECTION_BIT);
            } /* endif */
        }


    } /* endif */

    return(dataread);                  /* return data read           */

}


/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT2CoIn                                        */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT2 Control Port In Instruction Handler        */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            IN instruction for LPT2 when the IN to the control      */
/*            port is the first occurrence of I/O. If it is not the   */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the IN instruction.         */
/*            For compatibility, if virtual port 102 is not in        */
/*            bidirectional mode then bit 5 (direction) will always   */
/*            be set to 1 before returning the value read.            */
/*                                                                    */
/* NOTES:  VLPT2CoIn handles byte instructions only.                  */
/*         See vlptp.h for bit-level detail of the control port.      */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT2CoIn                                            */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         portaddr -    port address                                 */
/*         pcrf     -    client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  returns byte of data from control port for LPT2      */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
BYTE HOOKENTRY VLPT2CoIn(portaddr, pcrf)
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif

    BYTE dataread;                     /* set up byte to return      */

    dataread=0;
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTTWO]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted do an IN to the       -*/
    /*- control port to satisfy the application that caused this    -*/
    /*- routine to be executed.                                     -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTTWO].flags & DIRECT_MODE_FLAG) {

        dataread = INB(portaddr);

    /*---------------------------------------------------------------*/
    /*- If port 102 is not in bidirectional (extended) mode then    -*/
    /*- mask off the direction bit (bit 5). Bit 5 is write only.    -*/
    /*---------------------------------------------------------------*/
        if (MachineType == MACHINE_TYPE_PS2) {
            if ((pvddvbiospos->PlanarPOS.aPOSReg[2]) & NOT_BIDI_MODE) {
                dataread &= (~CTRL_DIRECTION_BIT);
            } /* endif */
        }

    } /* endif */

    return(dataread);                  /* return data read           */

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPT3CoIn                                        */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT3 Control Port In Instruction Handler        */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            IN instruction for LPT3 when the IN to the control      */
/*            port is the first occurrence of I/O. If it is not the   */
/*            first occurrence then the hook for this port will       */
/*            have been disabled. This routine requests I/O direct    */
/*            mode and if successful does the IN instruction.         */
/*            For compatibility, if virtual port 102 is not in        */
/*            bidirectional mode then bit 5 (direction) will always   */
/*            be set to 1 before returning the value read.            */
/*                                                                    */
/* NOTES:  VLPT3CoIn handles byte instructions only.                  */
/*         See vlptp.h for bit-level detail of the control port.      */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPT3CoIn                                            */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         portaddr -    port address                                 */
/*         pcrf     -    client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  returns byte of data from control port for LPT3      */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  doOpenDirect                                 */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
BYTE HOOKENTRY VLPT3CoIn(portaddr, pcrf)
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif

    BYTE dataread;                     /* set up byte to return      */

    dataread=0;
    /*---------------------------------------------------------------*/
    /*- Call to set up direct access mode for the port address      -*/
    /*- passed in.                                                  -*/
    /*---------------------------------------------------------------*/
    doOpenDirect(&pvd_area[LPTTHREE]);

    /*---------------------------------------------------------------*/
    /*- If direct I/O access mode was granted do an IN to the       -*/
    /*- control port to satisfy the application that caused this    -*/
    /*- routine to be executed.                                     -*/
    /*---------------------------------------------------------------*/
    if (pvd_area[LPTTHREE].flags & DIRECT_MODE_FLAG) {

        dataread = INB(portaddr);

    /*---------------------------------------------------------------*/
    /*- If port 102 is not in bidirectional (extended) mode then    -*/
    /*- mask off the direction bit (bit 5). Bit 5 is write only.    -*/
    /*---------------------------------------------------------------*/
        if (MachineType == MACHINE_TYPE_PS2) {
            if ((pvddvbiospos->PlanarPOS.aPOSReg[2]) & NOT_BIDI_MODE) {
                dataread &= (~CTRL_DIRECTION_BIT);
            } /* endif */
        }

    } /* endif */

    return(dataread);                  /* return data read           */

}

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  VLPTResIn                                        */
/*                                                                    */
/* DESCRIPTIVE NAME:  LPT Reserve Port In Instruction Handler         */
/*                                                                    */
/* FUNCTION:  The function of this routine is to service the VDM      */
/*            IN instruction for all LPT Reserve ports. This routine  */
/*            returns 0ffh.                                           */
/*                                                                    */
/* NOTES:  VLPTResIn handles byte instructions only.                  */
/*                                                                    */
/* CONTEXT: VDM task time                                             */
/*                                                                    */
/* ENTRY POINT:  VLPTResIn                                            */
/*    LINKAGE:  CALL NEAR 32                                          */
/*                                                                    */
/* INPUT:  (PARAMETERS)  (passed on the stack)                        */
/*         portaddr -    port address                                 */
/*         pcrf     -    client register frame pointer                */
/*                                                                    */
/* EXIT-NORMAL:  returns a masked byte of data                        */
/*                                                                    */
/* EXIT-ERROR:  NONE                                                  */
/*                                                                    */
/* EFFECTS:  NONE                                                     */
/*                                                                    */
/* INTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/* EXTERNAL REFERENCES:  NONE                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
BYTE HOOKENTRY VLPTResIn(portaddr, pcrf)
ULONG portaddr;
PCRF pcrf;
{

#ifdef DEBUG
     vdhInt3();
#endif

    /*---------------------------------------------------------------*/
    /*- Returns a CBIOS compatible value. This value is returned    -*/
    /*- when reserved ports are read.                               -*/
    /*---------------------------------------------------------------*/
    return((BYTE)RESERVE_MASK);
}

#pragma END_SWAP_CODE
