/*static char *SCCSID = "@(#)vlptdata.c 6.10 92/03/20";*/
#pragma linesize(132)
#pragma pagesize(60)
#pragma title("VLPTDATA.C")
/****************************************************************************/
/*                                                                          */
/*                       IBM/Microsoft Confidential                         */
/*                                                                          */
/*                 Copyright (c) IBM Corporation  1987, 1990                */
/*                 Copyright (c) Microsoft Corp.  1987, 1990                */
/*                           All Rights Reserved                            */
/*                                                                          */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  VLPTDATA.C                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  VLPT data allocation                                  */
/*                                                                            */
/*   FUNCTION: This routine allocates the instance data area and the          */
/*             global data area for VLPT.                                     */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: Any data structure changes made to VLPTDATA.H must      */
/*                    also be changed in this file. VLPTDATA.H contains       */
/*                    the external definitions that match the data in         */
/*                    this file.                                              */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             None                                                           */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include <mvdm.h>                       /* VDH services, etc.              */
#include <basemid.h>                    /* VLPT spooler message id         */
#include <error.h>                      /* OS/2 error numbers              */
#include "vlptp.h"                      /* VLPT data defines               */
#include "propname.h"                   /* Advanced Properties Strings     */

#pragma BEGIN_SWAP_INSTANCE

struct instance_data pvd_area[MAXPRTS+1];  /* per VDM data area            */
HVDM this_VDM;                             /*  actual VDM handle           */
UINT resp_val;                             /*  response value from popup   */
HVDHSEM vlpt_sem_handle;                   /*  semaphore handle for delays */
PCHAR lptname = LPTNAME;                   /* device name prefix           */
HHOOK hhookVLPTIRet5;                      /* handle for VDHArmReturnHook  */
VLPTPDB pdbCurrent;                        /* current PDB,Process Data Blk.*/
ULONG nmsLptTimeout = VLPT_SPOOL_CLOSE*1000; /* per vdm lpt starting value */
FLAGS VLPTFlags;                           /* VLPT flags (see vlptp.h)     */

#pragma END_SWAP_INSTANCE

#pragma BEGIN_SWAP_DATA

ULONG ulbuffersize[] = {(ULONG)BUFSIZ,          /* Size of print data bffr */
                        (ULONG)BUFSIZ,
                        (ULONG)BUFSIZ};
HVDD hvddvbios = (HVDD)NULL;                    /* Addr. of VBIOS entry pt.*/
PPOSREGS pvddvbiospos = (PPOSREGS)NULL;         /* Address of POS Regs     */
ULONG MachineType = (ULONG)0;                   /* Machine Type            */
FPFNPDD PLPTPDDProc = (FPFNPDD)0;               /* addr of PDD entry point */

struct vlpt_ioh_table_s v_ioh[]={                 /* LPT IO handle table   */
       { VLPT1DaIn,VLPT1DaOut,NULL,NULL,NULL },
       { VLPT1StIn,VLPT1StOut,NULL,NULL,NULL },
       { VLPT1CoIn,VLPT1CoOut,NULL,NULL,NULL },
       { VLPTResIn,VLPTResOut,NULL,NULL,NULL },
       { VLPT2DaIn,VLPT2DaOut,NULL,NULL,NULL },
       { VLPT2StIn,VLPT1StOut,NULL,NULL,NULL },
       { VLPT2CoIn,VLPT2CoOut,NULL,NULL,NULL },
       { VLPTResIn,VLPTResOut,NULL,NULL,NULL },
       { VLPT3DaIn,VLPT3DaOut,NULL,NULL,NULL },
       { VLPT3StIn,VLPT3StOut,NULL,NULL,NULL },
       { VLPT3CoIn,VLPT3CoOut,NULL,NULL,NULL },
       { VLPTResIn,VLPTResOut,NULL,NULL,NULL }
};

struct port_address vpa_table[MAXPRTS];         /* VLPT port address table */

struct error_table_record other_table[MAXERROR]={ /* OTHER error table     */
  { ERROR_BAD_UNIT,     MSG_ERROR_BAD_UNIT,     POPUP, (ABORT|RETRY|IGNORE), RETRY, TIMEOUT_VAL, RETRY_VAL, NULL, NULL},
  { ERROR_BAD_COMMAND,  MSG_ERROR_BAD_COMMAND,  POPUP, (ABORT|RETRY|IGNORE), RETRY, TIMEOUT_VAL, RETRY_VAL, NULL, NULL},
  { ERROR_OUT_OF_PAPER, MSG_ERROR_OUT_OF_PAPER, POPUP, (ABORT|RETRY|IGNORE), RETRY, TIMEOUT_VAL, RETRY_VAL, NULL, NULL},
  { ERROR_WRITE_FAULT,  MSG_ERROR_WRITE_FAULT,  POPUP, (ABORT|RETRY|IGNORE), RETRY, TIMEOUT_VAL, RETRY_VAL, NULL, NULL},
  { ERROR_INTERRUPT,    NULL,                   NO_POPUP, NULL, NULL, NULL, NULL, NULL, NULL},
  { NULL,               MSG_ERROR_WRITE_FAULT,  POPUP, (ABORT|RETRY|IGNORE), RETRY, TIMEOUT_VAL, RETRY_VAL, NULL, NULL},
};

struct error_table_record direct_table[1]={       /* DIRECT error table    */
    NULL,                   MSG_VLPT_DEVICE_BUSY,   POPUP, (ABORT|RETRY),             RETRY, TIMEOUT_VAL, RETRY_VAL, NULL, NULL
};

/*** Property names
 */
SZ szProplpt1timeout = PROP_NAME_LPT1TIMEOUT;
SZ szProplptseparate = PROP_NAME_LPTSEPARATE;

#pragma END_SWAP_DATA
