;      /*****************************************************************/
;      /*                                                               */
;      /*           Copyright (c) IBM Corporation  1987, 1992           */
;      /*                     All Rights Reserved                       */
;      /*                                                               */
;      /*****************************************************************/
;      /******************* START OF SPECIFICATIONS *********************/
;      /*                                                               */
;      /*  SOURCE FILE NAME: STRAT.ASM                                  */
;      /*                                                               */
;      /*  DESCRIPTIVE NAME: Strategy entry point                       */
;      /*                                                               */
;      /*  COPYRIGHT:  IBM Corp. 1992                                   */
;      /*                                                               */
;      /*  STATUS:  Version 1.0                                         */
;      /*                                                               */
;      /*  NOTES: This module contains the OS/2 device driver header    */
;      /*         and the strategy entry point. Minimal support is      */
;      /*         provided. Additional support can be acheived by       */
;      /*         replacing the entry point in the device driver        */
;      /*         header with a device dependent routine that does      */
;      /*         additional function then calls the provided routine   */
;      /*         for other functions.                                  */
;      /*                                                               */
;      /*         Routines are provided by the INIT.ASM module to       */
;      /*         change the device driver name in the device driver    */
;      /*         header and unit 0 header. Another routine is provided */
;      /*         to change the unit 0 device name.                     */
;      /*                                                               */
;      /*  ENTRY POINTS:                                                */
;      /*      See public statements                                    */
;      /*  EXTERNAL REFERENCES:                                         */
;      /*      See extrn statements                                     */
;      /*                                                               */
;      /******************* END  OF  SPECIFICATIONS *********************/
.xlist
  include pensegs.inc
  include pen.inc
  include devsym.inc
  include struc.inc
.list

.286p

;------------------------------------------------------------------------------
; external routines
;------------------------------------------------------------------------------

  extrn GIO_Entry : near
  extrn Init_Init : near
  extrn Null_rtn_far :near

;------------------------------------------------------------------------------
; external data
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; Global data declarations
;------------------------------------------------------------------------------

DSEG segment
public DDHdr1
DDHdr1   LABEL   WORD
  DW       -1                    ; Device header pointer
  DW       -1                    ; Device header pointer
  DW       DEV_IOCTL+DEV_CHAR_DEV+DEVLEV_3 ; Device Driver attributes
  DW       strat                 ; Strategy Routine Offset
  DW       Null_rtn_far          ; IDC entry point
  DB       'PENDD$  '            ; Device Name
  DW       0                     ; Protect-mode CS Strategy Selector
  DW       0                     ; Protect-mode DS selector
  DW       0                     ; Real-mode CS Strategy Segment
  DW       0                     ; Real-mode DS segment
  DD       2                     ; Can handle > 16MB physical memory

installFlag db 0
OpenCount   dw 0

DSEG ends


CSEG     SEGMENT
         ASSUME    CS:CSEG, SS:nothing, ES:nothing, DS:DSEG
;------------------------------------------------------------------------------
; This to catch branches to zero which are likely due to a blank in the DCB
;------------------------------------------------------------------------------
public Call_To_Zero
Call_To_Zero proc
  PANIC PANIC_CALL0
  ret
Call_To_Zero endp

;---- OS/2 STRATEGY ENTRY POINT -----------------------------------------------
; Handle OS/2 device driver interface commands
;  es:bx = request packet
;  si    = dcb
; note: called from device dependent stub in order to pass dcb for this device
;------------------------------------------------------------------------------
public strat
strat  proc far
; First check to see if we have been initialized.  If not then the only
; command that is allowed is an Init command.  If we have been de-installed
; then no commands are allowed.

  mov  es:[bx].PktStatus, 0
  .if <installFlag ne 0>                          ; already installed
     .if <es:[bx].PktCmd eq CMDDeInstall>
        call deInstall                            ; go deinstall
     .else
        mov al, es:[bx].PktCmd
        .if <al eq CMDGenIOCTL>
           call GIO_Entry                 ; Generic IOCTL
        .elseif <al eq CMDOpen>
           inc  OpenCount        ; Keep track of how many opens
        .elseif <al eq CMDClose>
           dec  OpenCount        ; Keep track of how many opens
        .else
           mov  es:[bx].PktStatus, STDON+STERR+STECODE
        .endif
     .endif
  .else                                   ; we have not installed
     .if <es:[bx].PktCmd eq CMDInit>      ; if this is an Init command
        call Init_Init                    ; call generic init command
        mov  installFlag,1
     .else                                ; else no other commands allowed
        mov  es:[bx].PktStatus, STDON+STERR+STECODE ; set error condition
     .endif
  .endif
  or   es:[bx].PktStatus, STDON           ; Set Blk Complete Flag
  ret                                     ; return to system
strat  endp


;------------------------------------------------------------------------------
; deinstall device (someday)
;  es:bx = request packet
;  si    = dcb
;------------------------------------------------------------------------------
public deInstall
deInstall  PROC  NEAR

  mov  installFlag,0

  ret
deInstall  ENDP


CSEG ENDS
END
