/*************************************************************************/
/*                                                                       */
/*           Copyright (c) IBM Corporation  1987, 1992                   */
/*                     All Rights Reserved                               */
/*                                                                       */
/*************************************************************************/
/******************* START OF SPECIFICATIONS *****************************/
/*                                                                       */
/*  SOURCE FILE NAME: PENIOCTL.H                                         */
/*                                                                       */
/*  DESCRIPTIVE NAME: Pen IOCTL interface                                */
/*                                                                       */
/*  COPYRIGHT:  IBM Corp. 1992                                           */
/*                                                                       */
/*  STATUS:  Version 1.0                                                 */
/*                                                                       */
/*  NOTES:                                                               */
/*                                                                       */
/*  ENTRY POINTS:                                                        */
/*      See public statements                                            */
/*  EXTERNAL REFERENCES:                                                 */
/*      See extrn statements                                             */
/*                                                                       */
/******************* END  OF  SPECIFICATIONS *****************************/
/*****************************************************************************/
/* Generic IOCTL Summary                                                     */
/*                                                                           */
/* This is the list of architected IOCTL calls.                              */
/*                                                                           */
/* Category  Code    Description                                             */
/*                                                                           */
/* 90H - DRIVER                                                              */
/*                                                                           */
/*           50H     Set Unit Specific Data                                  */
/*           51H     Set Unit Variable                                       */
/*           52H     Reset Trace Table                                       */
/*           53H     Set Trace Table Size                                    */
/*                                                                           */
/*           60H     Query Unit Specific Data                                */
/*           61H     Query Unit Variable                                     */
/*           62H     Query Unit Capabilities                                 */
/*           63H     Query Trace Table                                       */
/*           64H     Query Trace Table Size                                  */
/*                                                                           */
/* 91H - LOCATOR                                                             */
/*                                                                           */
/*           51H     Set Locator Offset                                      */
/*           52H     Set Locator Pass Rate                                   */
/*           53H     Set Locator Sample Rate                                 */
/*                                                                           */
/*           60H     Query Locator Variables                                 */
/*           61H     Query Locator Raw Coordinate                            */
/*           62H     Query Default Locator Extents                           */
/*                                                                           */
/* 92H - BUTTON                                                              */
/*                                                                           */
/*           50H     Set Button Assignment                                   */
/*                                                                           */
/*           60H     Query Button Assignment                                 */
/*                                                                           */
/* 93H - DISPLAY                                                             */
/*                                                                           */
/*           50H     Set Display State                                       */
/*           51H     Set Display Inactivity Period                           */
/*                                                                           */
/*           60H     Query Display State                                     */
/*                                                                           */
/*                                                                           */
/* ERROR_INVALID_PARAMETER (0x087h) is return for invalid unit or for        */
/* parameters out of the specified range.                                    */
/*                                                                           */
/* General defines                                                           */

#define PEN_CAT_DRIVER  0x090     /* Driver category        */
#define PEN_CAT_LOCATOR 0x091     /* Locator category       */
#define PEN_CAT_BUTTON  0x092     /* Button category        */
#define PEN_CAT_DISPLAY 0x093     /* Display category       */

#define PEN_IOCTL_LEV_MAJOR 0     /* IOCTL interface level  */
#define PEN_IOCTL_LEV_MINOR 4     /* IOCTL interface level  */

/*****************************************************************************/
/* Category 90H - Function 50H: Set Unit Specific Data                       */
/*                                                                           */
/* This command sets the device specific data for the requested unit.        */

/* Parameter Packet Format */
typedef struct _P_SUSD       {    /* psusd */
  ULONG   unit;                   /* requested unit  */
  ULONG   byteCount;              /* byte count of the device specific data area */
} PSUSD;

/* Data Packet Format - Device Specific Structure, first LONG has btye count */

/* Defines */
#define PEN_FUNC_SUSD 0x050        /* Set Unit Specific Data */


/****************************************************************************/
/* Category 90H - Function 51H: Set Unit Variable                           */
/*                                                                          */
/* This command sets the device specific variable for the requested unit.   */

/* Parameter Packet Format */
typedef struct _P_SUV        {    /* psuv */
  ULONG   unit;                   /* requested unit     */
  ULONG   index;                  /* index of variable to set */
  LONG    value;                  /* value to set             */
} PSUV;

/* Data Packet Format - None */

/* Defines */
#define PEN_FUNC_SUV 0x051        /* Set unit variable */

/*****************************************************************************/
/* Category 90H - Function 52H: Reset Trace Table                            */
/*                                                                           */
/* This resets the transaction trace buffer.Reseting the trace buffer        */
/* is a convenient way view only current stroke data.                        */
/* Parameter Packet Format - None                                            */
/* Data Packet Format - None                                                 */
/* Defines                                                                   */
#define PEN_FUNC_RTT 0x052        /* Reset Trace Table                       */

/*****************************************************************************/
/* Category 90H - Function 53H: Set Trace Table Size                         */
/*                                                                           */
/* This command allocates a trace table for use of traceing.                 */

/* Parameter Packet Format */
typedef struct _P_STTS       {    /* pstts */
  ULONG   size;                   /* Number of LONG values in table */
                                  /*  (number of bytes / 4) */
} PSTTS;

/* Data Packet Format - None                                                 */

/* Defines                                                                   */
#define PEN_FUNC_STTS 0x053        /* Set Trace Table Size                   */

/**************************************************************************  */
/* Category 90H - Function 60H: Query Unit Specific Data                     */
/*                                                                           */
/* This command reads the device specific data for the requested unit. The   */
/* device specific data area is truncated when the pqusd.byteCount is less   */
/* than the length of device specific data. The first ULONG in unit specific */
/* is by convention the entire length of the area. This is not reduced to    */
/* reflect a truncated query.                                                */

/* Parameter Packet Format                                                   */
typedef struct _P_QUSD       {    /* pqusd */
  ULONG   unit;                   /* requested unit                          */
  ULONG   byteCount;              /* byte count of the device specific data  */
  ULONG   RetByteCount;           /* bytes returned (output parm)            */
  ULONG   rc;                     /* return code    (output parm)            */
  ULONG   capabilities;           /* capabilities   (output parm)            */
} PQUSD;

/* Data Packet Format - Device Specific Structure                            */


/* Defines                                                                   */
#define PEN_FUNC_QUSD 0x060       /*  Query Unit Specific Data               */

/* Values for pqusd.capabilities                                             */
#define QUSD_RESEVERD 0x0000FFFF  /* reserved for architected use            */
#define QUSD_OEM      0xFFFF0000  /* reserved for OEM use                    */

/* The following are defined for all device types                            */
#define QUSD_LENGTH   0x00000001  /* first word of unit data is length       */
#define QUSD_STANDARD 0x00000002  /* starts with standard device specific    */

/* The following are locator specific                                        */
#define QUSD_X_INVERT 0x00000004  /* x raw coordinate is inverted            */
#define QUSD_Y_INVERT 0x00000008  /* y raw coordinate is inverted            */

/* Values for pqusd.rc                                                       */
#define QUSD_OK     0             /* all data copied                         */
#define QUSD_TRUNC  1             /* data truncated                          */
#define QUSD_NA     2             /* data is not available, none copied      */

/* standard locator unit specific data prefix                                */
typedef struct _SLUSD        {    /* slusd */
  ULONG   length;                 /* length of entire data area              */

  ULONG   XoriginDefault;         /* default x origin coordinate adjustment  */
  ULONG   Xorigin;                /* x coordinate origin adjustment          */
  ULONG   XmeasuredExtent;        /* mesaured x extent                       */

  ULONG   YoriginDefault;         /* default y origin coordinate adjustment  */
  ULONG   Yorigin;                /* y coordinate origin adjustment          */
  ULONG   YmeasuredExtent;        /* mesaured y extent                       */
} SLUSD;

/**************************************************************************  */
/* Category 90H - Function 61H: Query Unit Variable                          */
/*                                                                           */
/* This command gets the device specific variable from the requested unit.   */
/* By convention, Unit 0, variable 0 returns an error counter. Unit 0,       */
/* variable 1, returns a panic flag word.                                    */

/* Parameter Packet Format                                                   */
typedef struct _P_QUV        {    /* pquv */
  ULONG   unit;                   /* requested unit                          */
  ULONG   index;                  /* index of variable to set                */
} PQUV;

/* Data Packet Format - Device Specific Structure                            */
typedef struct _D_QUV        {    /* dquv */
  ULONG   value;                  /* value returned                          */
} DQUV;

/* Defines                                                                   */
#define PEN_FUNC_QUV 0x061        /* Query unit variable                     */

/* Panic values - return by unit 0, variable 1                               */
/**************************************************************************  */
/* Category 90H - Function 62H: Query Unit Capabilities                      */
/*                                                                           */
/* This command returns the capabilities for the unit.                       */

/* Parameter Packet Format                                                   */
typedef struct _P_QUC        {    /* pquc */
  ULONG   unit;                   /* requested unit                          */
  ULONG   byteCount;              /* size in bytes of area to receive data   */
  ULONG   RetByteCount;           /* bytes returned (output parm)            */
  ULONG   rc;                     /* return code    (output parm)            */
} PQUC;

/* Data Packet Format - area to receive extended information registration    */
/* packet                                                                    */

/* Defines                                                                   */
#define PEN_FUNC_QUC 0x062        /* Query unit capabilities                 */

/* Values for pquc.rc same as for spqusd.rc                                  */

/**************************************************************************  */
/* Category 90H - Function 63H: Query Trace Table                            */
/*                                                                           */
/* This command returns the valid entries in the trace table. Each entry is  */
/* double word (4 bytes) and can be considered an array of ULONGs. The first */
/* entry has the number of valid entries to follow.                          */

/* Parameter Packet Format                                                   */
typedef struct _P_QTT        {    /* pqtt  */
  ULONG   size;                   /* Number of LONGs in allocated table      */
} PQTT;

/* Data Packet Format - PLONG to trace table arrary                          */

/* Defines  - trace entry format                                             */
#define PEN_FUNC_QTT 0x063        /* Query Trace Table                       */

/* Each entry has a trace code describing the contents of the entry          */

#define TRACE_MASK      0x0FF000000 /* isolate trace code from entry         */
#define TRACE_MASK_SUB  0x0F0000000 /* isolate sub code value                */

#define TRACE_INT       0x0F0000000 /* interrupt event                       */
#define TRACE_INT_H     0x0F000     /*                                       */

#define TRACE_TICK      0x0C0000000 /* timer tick, low word is tick count    */
#define TRACE_TICK_H    0x0C000

#define TRACE_ABS       0x010000000 /* absolute packet sub trace code        */
#define TRACE_ABS_E     0x01E000000 /* -- Mouse button event is low word     */
#define TRACE_ABS_EH    0x01E00
#define TRACE_ABS_X     0x011000000 /* -- x coordinate is low word           */
#define TRACE_ABS_XH    0x01100
#define TRACE_ABS_Y     0x012000000 /* -- y coordinate is low word           */
#define TRACE_ABS_YH    0x01200
#define TRACE_ABS_Z     0x014000000 /* -- z coordinate is low word           */
#define TRACE_ABS_ZH    0x01400
#define TRACE_ABS_D     0x015000000 /* -- EI device bits                     */
#define TRACE_ABS_DH    0x01500
#define TRACE_ABS_C     0x016000000 /* -- EI control word                    */
#define TRACE_ABS_CH    0x01600

#define TRACE_ERROR     0x0E0000000 /* error trace, word is error count      */
#define TRACE_ERROR_H   0x0E000

#define TRACE_DATA      0x000000000 /* raw data trace, byte is in low byte   */
#define TRACE_DATA_1    0x001000000 /* -- 1st byte of a packet (optional)    */
#define TRACE_DATA_1H   0x00100
#define TRACE_DATA_H    0x00000     /* -- not 1st byte                       */

#define TRACE_SYS       0x020000000 /* System device Event (EMI only)        */
#define TRACE_SYS_H     0x02000     /*                                       */

#define TRACE_BUTTON    0x0B0000000 /* button event sub trace code           */
#define TRACE_BREL      0x0B0000000 /* button release mask is low word       */
#define TRACE_BREL_H    0x0B000
#define TRACE_BACT      0x0B1000000 /* button activation mask is low word    */
#define TRACE_BACT_H    0x0B100

#define TRACE_DISPLAY   0x0D0000000 /* display event sub trace code          */
#define TRACE_DOFF      0x0D0000000 /* display turned off                    */
#define TRACE_DOFF_H    0x0D000
#define TRACE_DON       0x0D1000000 /* display turned on                     */
#define TRACE_DON_H     0x0D100

#define TRACE_DD        0x090000000 /* trace device dependent                */
                                    /* low word is data, second byte is index*/
#define TRACE_DD_H      0x09000

/**************************************************************************  */
/* Category 90H - Function 64H: Query Trace Table Size                       */
/*                                                                           */
/* This command returns the size of the entire trace table. This function can*/
/* be used to obtain the memory allocation size to be used for the Query     */
/* Trace Table function.                                                     */

/* Parameter Packet Format - None                                            */

/* Data Packet Format                                                        */
typedef struct _D_QTTS       {    /* dqtts */
  ULONG   size;                   /* Number of LONG values in table          */
                                  /*  (number of bytes / 4)                  */
} DQTTS;

/* defines                                                                   */
#define PEN_FUNC_QTTS 0x064       /* Query Trace Table Size                  */

/*****************************************************************************/
/* Category 91H - Function 50H: Set Locator Offset                           */
/*                                                                           */
/* This function is used to change the digitizer finger offset.              */
/* An offset may be negative. Both or either offsets can be changed          */
/* occording to the functions ORed in the command field.                     */

/* Parameter Packet Format                                                   */
typedef struct _P_SLO        {    /* pslo */
  ULONG   unit;                   /* requested unit                          */
  ULONG   command;                /* command                                 */
  LONG    xOffset;                /* x offset in digitizer units             */
  LONG    yOffset;                /* y offset in digitizer units             */
} PSLO;

/* Data Packet Format - None                                                 */

/* Defines                                                                   */
#define PEN_FUNC_SLO 0x050        /* Set Locator Offset                      */

/* Values for pslo.command                                                   */
#define PSLO_SET_X     0x01       /* set x offset                            */
#define PSLO_SET_Y     0x02       /* set y offset                            */

/*****************************************************************************/
/* Category 91H - Function 51H: Set Locator Pass Rate                        */
/*                                                                           */
/* This function is used to change the OS/2 event rate.                      */
/* If rate is equal to 2, then for every 2 digitizer                         */
/* samples, only one is reported to the OS/2 PM as a mouse event. All samples*/
/* are always reported to OS/2 Pen PM.                                       */
/*                                                                           */
/* If left at 0, Pen PM device driver services will calculate the pass rate  */
/* automatically. This varible should be used only if the automatic value    */
/* requires manual tuning.                                                   */

/* Parameter Packet Format                                                   */
typedef struct _P_SLPR       {    /* pslpr */
  ULONG   unit;                   /* requested unit                          */
  ULONG   passRate;               /* number of ext events for each OS/2 event*/
} PSLPR;

/* Data Packet Format - None                                                 */

/* Defines                                                                   */
#define PEN_FUNC_SLPR 0x051       /* Set Locator Pass Rate                   */

/*****************************************************************************/
/* Category 91H - Function 52H: Set Locator Sample Rate                      */
/*                                                                           */
/* This function is used to change the sample rate.                          */
/* The device should round to the closest value.                             */

/* Parameter Packet Format                                                   */
typedef struct _P_SLSR       {    /* pslsr */
  ULONG   unit;                   /* requested unit                          */
  ULONG   sampleRate;             /* sample rate in samples per second       */
} PSLSR;

/* Data Packet Format - none                                                 */

/* Defines                                                                   */
#define PEN_FUNC_SLSR 0x052       /* Set Locator Sample Rate                 */


/*****************************************************************************/
/* Category 91H - Function 60H: Query Locator Variables                      */
/*                                                                           */
/* This function returns the pen PM locator variables.                       */

/* Parameter Packet Format                                                   */
typedef struct _P_QLV        {    /* pqlv  */
  ULONG   unit;                   /* requested unit                          */
} PQLV;

/* Data Packet Format                                                        */
typedef struct _D_QLV        {    /* dqlv  */
  LONG    xOffset;                /* x offset in digitizer units             */
  LONG    yOffset;                /* y offset in digitizer units             */
  ULONG   passRate;               /* pass rate                               */
  ULONG   sampleRate;             /* sample rate in samples per second       */
} DQLV;

/* Defines                                                                   */
#define PEN_FUNC_QLV 0x060        /* Query Locator Variables                 */

/*****************************************************************************/
/* Category 91H - Function 61H: Query Locator Raw Coordinate                 */
/*                                                                           */
/* This function returns the next valid raw locator coordinate. The dqlrc.rc */
/* value reflects whether a coordinate value was available within specified  */
/* timeout period.                                                           */

/* Parameter Packet Format                                                   */
typedef struct _P_QLRC       {    /* pqlrc */
  ULONG   unit;                   /* requested unit                          */
  ULONG   timeout;                /* timeout value in milliseconds           */
} PQLRC;

/* Data Packet Format                                                        */
typedef struct _D_QLRC       {    /* dqlrc */
  LONG    rc;                     /* return code                             */
  LONG    xRaw;                   /* x in raw digitizer units                */
  LONG    yRaw;                   /* y in raw digitizer units                */
} DQLRC;

/* Defines                                                                   */
#define PEN_FUNC_QLRC 0x061        /* Query Locator Raw Coordinate           */

/* Values for dqlrc.rc                                                       */
#define QLRC_VALID     0           /* valid coordinates returned             */
#define QLRC_TIMEOUT   1           /* timed out, coordinates are not valid   */
#define QLRC_BUSY      2           /* only one thread at a time allowed      */

/*****************************************************************************/
/*                                                                           */
/* Category 91H - Function 62H: Set Button Assignment                        */
/*                                                                           */
/* This command returns the default locator extents                          */
/*                                                                           */
/*****************************************************************************/

typedef struct _P_QDLE {   /* pqdle */
   ULONG    unit;          /* requested unit */
} PQDLE;


typedef struct _D_QDLE {   /* dqdle */
   ULONG    rc;            /* return code */
   ULONG    Xdefault;      /* X default extent */
   ULONG    Ydefault;      /* Y default extent */
} DQDLE;

#define  PEN_FUNC_QDLE  0x062

#define  QDLE_OK        0
#define  QDLE_FAIL      1

/*****************************************************************************/
/* Category 92H - Function 50H: Set Button Assignment                        */
/*                                                                           */
/* This command set the activation and release assignment for a button.      */
/* the locator device selected.                                              */

/* Parameter Packet Format                                                   */
typedef struct _P_SBA        {    /* psba  */
  ULONG   unit;                   /* requested unit                          */
  ULONG   buttonIndex;            /* index of button (0 to 15)               */
  ULONG   action;                 /* action to preform                       */
  ULONG   value;                  /* hotKey value for hot key assignment or  */
                                  /* Mouse button selection mask             */
} PSBA;

/* Data Packet Format - none                                                 */

/* Defines                                                                   */
#define PEN_FUNC_SBA 0x050        /* Set Button Assignment                   */

/* Values for psba.action                                                    */
/* NOTE: values MUST match order of capability fields in DCAP struct         */
#define  NOBUTTONACTION     0     /* null - do nothing (the default)         */
#define  SENDHOTKEY         1     /* send hot key; value in PSBA.hotKey      */
#define  SHIFTBUTTON        2     /* set shift for button using mouseButtonMask */
#define  APPLBUTTON         3     /* assign button for application use       */
#define  AUGMENTATIONBUTTON 4     /* assign button for key augmentation      */
#define  GESTUREMODE        5     /* assign button for gesturemode           */

/* Values for psba.value for action = ONETIMEBUTTON and SHIFTBUTTON          */
#define  MOUSEBUTTON1     0x04    /* mouse button 1                          */
#define  MOUSEBUTTON2     0x10    /* mouse button 2                          */
#define  MOUSEBUTTON3     0x40    /* mouse button 3                          */

/* Value for psba.value for action = SENDHOTKEY                              */
#define HOTKEY_CNTRL_ESC    1     /* do a CNTRL-ESC                          */
#define HOTKEY_ALT_ESC      2     /* do an ALT-ESC                           */

/*****************************************************************************/
/* Category 92H - Function 60H: Query Button Assignment                      */
/*                                                                           */
/* This command returns the assignment of a button                           */

/* Parameter Packet Format                                                   */
typedef struct _P_QBA        {    /* pqba  */
  ULONG   unit;                   /* requested unit                          */
  ULONG   buttonIndex;            /* index of button (0 to 15)               */
} PQBA;

/* Data Packet Format                                                        */
typedef struct _D_QBA        {    /* dqba  */
  ULONG   action;                 /* action to preform                       */
  ULONG   value;                  /* hotKey value for hot key assignment or  */
                                  /* Mouse button selection mask             */
} DQBA;

/* Defines - same as Set Button Assignment                                   */
#define PEN_FUNC_QBA 0x060        /* Query Button Assignment                 */

/*****************************************************************************/
/* Category 93H - Function 50H: Set Display State                            */
/*                                                                           */
/* This command is used to turn the backlight either on or off. Turning on   */
/* the backlight restarts the inactivity timer. The inactivity timer is only */
/* used if automatic control is enabled.                                     */

/* Parameter Packet Format                                                   */
typedef struct _P_SDS        {    /* psds  */
  ULONG   unit;                   /* requested unit                          */
  ULONG   command;                /* command to turn on or off               */
} PSDS;

/* Data Packet Format - none                                                 */

/* Defines                                                                   */
#define PEN_FUNC_SDS 0x050        /* Set Display State                       */

#define TURNBACKLIGHTON     1     /* value to turn backlight on              */
#define TURNBACKLIGHTOFF    0     /* value to turn backlight off             */

/*****************************************************************************/
/* Category 93H - Function 51H: Set Display Inactivity Period                */
/*                                                                           */
/* This IOCTL controls how the driver handles automatically turning on and   */
/* off the display backlight. The following can be controlled:               */
/*                                                                           */
/* AutoEnable = (enable | disable)                                           */
/*   When enabled, the backlight will be turned off after a peroid of no     */
/*   user activity. User activity turns the backlight back on. User activity */
/*   consists of input from any locator device, buttons, the OS/2 mouse, or  */
/*   the keyboard.                                                           */
/*                                                                           */
/* Opaque   = (enable | disable)                                             */
/*   When enabled, button actions and locator points from this driver are    */
/*   processed even though the backlight is off. When disabled, button       */
/*   actions are not processed and locator points are sent to the device     */
/*   driver services, but are not processed by OS/2.                         */
/*                                                                           */
/* Suppress = (enable | disable)                                             */
/*   When enabled, button down from the locator or mouse action that turned  */
/*   the backlight on will be ignored and reported as a movement only.       */
/*   Button actions will be ignored.                                         */
/*                                                                           */
/* Period = <seconds>                                                        */
/*   The length of the inactivity period in seconds                          */
/*                                                                           */
/* All of these options are independent. All combination can be specified    */
/* on a single IOCTL call. AutoEnable, Suppress, and Period are processed    */
/* only if the display device capablities allow automatic backlight control. */

/* Parameter Packet Format                                                   */
typedef struct _P_SDIP        {   /* psdip  */
  ULONG   unit;                   /* requested unit                          */
  ULONG   command;                /* command to turn enable and disable      */
  ULONG   period;                 /* inactivity period in seconds            */
} PSDIP;

/* Data Packet Format - none                                                 */

/* Defines                                                                   */
#define PEN_FUNC_SDIP 0x051       /* Set Display Inactivity Period           */

/* psdip.command values                                                      */
#define SDIP_PERIOD        0x01   /* change period value                     */
#define SDIP_EN_AUTO       0x02   /* enable automatic inactivity period      */
#define SDIP_DI_AUTO       0x04   /* disable automatic inactivity period     */
#define SDIP_EN_OPAQUE     0x08   /* process events while backlight is off   */
#define SDIP_DI_OPAQUE     0x10   /* ignore  events while backlight is off   */
#define SDIP_EN_SUPPRESS   0x20   /* suppress after auto turn on             */
#define SDIP_DI_SUPPRESS   0x40   /* don't suppress after auto turn on       */

/*****************************************************************************/
/* Category 93H - Function 60H: Query Display State                          */
/*                                                                           */
/* This command returns whether the automatic inactivity period monitor is   */
/* enabled or disabled.                                                      */

/* Parameter Packet Format                                                   */
typedef struct _P_QDS        {    /* pqds                                    */
  ULONG   unit;                   /* requested unit                          */
} PQDS;

/* Data Packet Format                                                        */
typedef struct _D_QDS        {    /* dqds  */
  ULONG  state;                   /* state of backlight                      */
  ULONG  automatic;               /* automatic options                       */
  ULONG  period;                  /* inactivity period in seconds            */
} DQDS;

/* Defines                                                                   */
#define PEN_FUNC_QDS 0x060        /* Query Display State                     */

/* dqds.state uses same values as psdip.state                                */
/* dqds.automatic uses same values as psdip.command                          */

