;      /*****************************************************************/
;      /*                                                               */
;      /*           Copyright (c) IBM Corporation  1987, 1992           */
;      /*                     All Rights Reserved                       */
;      /*                                                               */
;      /*****************************************************************/
;      /******************* START OF SPECIFICATIONS *********************/
;      /*                                                               */
;      /*  SOURCE FILE NAME: PEN.INC                                    */
;      /*                                                               */
;      /*  DESCRIPTIVE NAME: Pen driver equates                         */
;      /*                                                               */
;      /*  COPYRIGHT:  IBM Corp. 1992                                   */
;      /*                                                               */
;      /*  STATUS:  Version 1.0                                         */
;      /*                                                               */
;      /*  NOTES:                                                       */
;      /*                                                               */
;      /*  ENTRY POINTS:                                                */
;      /*      See public statements                                    */
;      /*  EXTERNAL REFERENCES:                                         */
;      /*      See extrn statements                                     */
;      /*                                                               */
;      /******************* END  OF  SPECIFICATIONS *********************/
;------------------------------------------------------------------------------
; Device Control Block (DCB) - each device has one, its the root of everything
;------------------------------------------------------------------------------

DCB Struc ; Device Type Independent section

  dcb_Link            dw 0 ; link to next dcb, null terminated list
  dcb_DevType         db 0 ; Device type
  dcb_Unit            db 0 ; Unit number
  dcb_Sem1            db 0 ; Semaphore to serialize entry to device engine
  dcb_Flags           db 0 ; device flags (common for all types)

; device service info

  dcb_service_ds      DW 0 ; data segment to load for service routine
  dcb_service_rtn     DD 0 ; 16:16 address for service routine

; pointers to type independent control blocks

  dcb_@RegCaps        dw 0 ; Offset of restigration capabilities
  dcb_@EiEvent        dw 0 ; Offset of extended interface event packet
  dcb_@DeviceData     dw 0 ; Addr of query config device data
  dcb_@UVars          dw 0 ; Offset of Unit Variables

; device type independent routines

  dcb_@Dev_DTTick     dw 0 ; Addr of device type tick handler

; device dependent routines

  dcb_@Dev_Start      dw 0 ; Offset of start routine
  dcb_@Dev_DDTick     dw 0 ; Offset of tick handler
  dcb_@Dev_suv        dw 0 ; Offset of Set Unit Variable IOCTL rtn
  dcb_@Dev_quv        dw 0 ; Offset of Query Unit Variable IOCTL rtn
  dcb_@Dev_susd       dw 0 ; Offset of Set Unit Specific Data IOCTL rtn
  dcb_@Dev_qusd       dw 0 ; Offset of Query Unit Specific Data IOCTL rtn

DCB Ends

; Bits for dcb_Flags
; reserved    equ     00Fh    ; revseved for future base code use
; reserved    equ     0F0h    ; reserved for OEM usage

; Unit variables structure

UVARS   Struc
 uv_numVars    dd  0         ; number of varibles
 uv_vars       dd  0         ; first variable in array
UVARS   Ends

;------------------------------------------------------------------------------
; Driver  Type DCB
;------------------------------------------------------------------------------

DCB_DRV Struc
  db size DCB dup (0)  ; reserve room for common DCB

  dcb_@Dev_ReadEnable  dw 0 ; Offset of report enable routine
  dcb_@Dev_ReadDisable dw 0 ; Offset of report disable routine
  dcb_@Dev_Enable      dw 0 ; Offset of enable interrupts routine
  dcb_@Dev_Disable     dw 0 ; Offset of disable interrupts routine
  dcb_@Dev_CallBack    dw 0 ; Offset of video mode change routine
  dcb_@Dev_VMChange    dw 0 ; Offset of video mode change routine
  dcb_@Dev_APM         dw 0 ; Offset of power management routine
DCB_DRV ends

;------------------------------------------------------------------------------
; Locator Type DCB
;------------------------------------------------------------------------------

FAKE_EXTENT equ 1000    ; used to keep traps out if extents accidently set to 0
FAKE_SAMPLE_RATE equ 100 ; used to keep traps out if rate is 0

DEFAULT_REPORT_TIMEOUT equ 100 ; default deadman timeout for hardware to report
                               ; the next sample point. Used to detect leaving
                               ; proximity or contact on ballistic liftoffs.
                               ; (in milliseconds)

DEFAULT_PROX_FILTER equ 10*1000; default time limit for stationary proximity
                               ; points before they are ignored.
                               ; (in milliseconds)
DEFAULT_BOX_SIZE    equ 20     ; default size for the proximity filter box

;------------------------------------------------------------------------------
; Locator cooridinate transformation structure. Raw digitizer cooridinates
; need to be 'adjusted' due to manufacturing fluctuations. First an constant
; is added (origin adjust), then the result is scaled (ext_adj) so that the
; maximum measured cooridinate comes out to the expected fixed extent.
; Adjustments are calibrated based on the PM screen group and proportioned
; for other video modes.
LOC_TRANS struc
  trn_flags              dw 0 ; flag word
  trn_offset             dw 0 ; finger offset (intended for LOCTYPE_FINGER)

  trn_ext_max            dd 0 ; maximum extent based on current video mode
  trn_ext_max_PM         dd 0 ; maximum extent based on PM screen group V mode
  trn_ext_adj            dd 0 ; ratio used to adjust coords based on video mode
  trn_ext_adj_default    dd 0 ; default adjustment ratio based on PM SG
  trn_ext_adj_calibrated dd 0 ; calibrated adjustment ratio based on PM SG

  trn_org_adj            dd 0 ; origin used to adjust coords based on video mode
  trn_org_default        dd 0 ; default adjustment based on PM screen group
  trn_org_calibrated     dd 0 ; calibrated adjustment based on PM screen group
LOC_TRANS ends

; bits for trn_flags
INVERTED_COORD equ 0001h ; cooridinate is inverted
STANDARD_USD   equ 0002h ; unit specific data contains transformation info

;------------------------------------------------------------------------------
; box filter structure (used for box filter routines, allocated in device
; dependent section of the DCB.

BOX_FILTER struc
  box_flags     dw 0    ; flag word
  box_ClearCnt  dw 0    ; used to clear box after prox pts
  box_Size      dd 0    ; size of box (2= box measures 5 on each side)
  box_LocLastX  dd 0    ; last X coordinate
  box_LocLastY  dd 0    ; last Y coordinate
  box_TickCount dw 0    ; tick count for number of prox pts in the box
  box_TickLimit dw 0    ; tick count limit to start ignoring pts in the box
BOX_FILTER ends

; bits for box_flags
BOX_SMOOTH     equ 0001h ; update new coordinates to last position when in box

;------------------------------------------------------------------------------
; locator specific dcb structure
DCB_LOC Struc
  db size DCB dup (0)  ; reserve room for common DCB


; The following are set by the device dependent code

  dcb_LocNewState     dw 0 ; State of locator now
  dcb_LocNewX         dd 0 ; Raw coordinates now    ; ddxy
  dcb_LocNewY         dd 0 ;                        ; ddxy
  dcb_LocNewZ         dw 0 ;

; the following are figured out based by the engine

  dcb_LocFlags        db 0 ; Locator flags
  dcb_LocMouBut       db 0 ; Simulated mouse buttons (for whole stroke)
  dcb_LocNDCX         dd 0 ; Normalized device coordinates ;ddxy
  dcb_LocNDCY         dd 0 ;

; these are saved for next time the engine is called

  dcb_LocLastState    dw 0 ; Last state of the engine (clear, in prox, contact)
  dcb_LocLastX        dd 0 ; Last raw coordinates    ;ddxy
  dcb_LocLastY        dd 0 ;
  dcb_LocLastZ        dw 0 ;
  dcb_LocLastCntrl    dw 0 ; Last lev_cntrl

; coordinate transformaton values

  dcb_Xtrans  db size LOC_TRANS dup (0)  ; x coordinate transformation info
  dcb_Ytrans  db size LOC_TRANS dup (0)  ; x coordinate transformation info

; device dependent routines called from common routines

  dcb_@Dev_ForceClear dw 0 ; Addr of device force to clear state
  dcb_@Adjust         dw 0 ; Addr of routine to adjust cooridinates
  dcb_@slsr           dw 0 ; Addr of set sample rate routine

; miscellaneous

  dcb_StateTimeout    dw 0 ; timeout used to detect proxity exit
  dcb_TimeoutLimProx  dw 0 ; timeout limit
  dcb_TimeoutLimCont  dw 0 ; timeout limit

DCB_LOC Ends

; bit definition for dcb_LocFlags
QLRC_REQUEST  equ     001h    ; QLRC pending
LOC_MOTION    equ     002h    ; Motion detected on this point

; Values for dcb_LocNewState and dcb_LocLastState

STATE_CLEAR      EQU    00h       ;out of prox
; reserved       EQU    02h
STATE_PROX       EQU    04h       ;proximity state
STATE_CONTACT    EQU    06h       ;contact state

;------------------------------------------------------------------------------
; Button  Type DCB
;------------------------------------------------------------------------------

BUT_DEF Struc
  but_action   db ?    ; action
  but_value    db ?    ; mouse button mask or hot key value
  but_state    db 0    ; 0 = released, 0FFh = activated
  but_flags    db 0    ; flags
BUT_DEF Ends
BUT_DEF_SIZE_SHIFT equ 2

BUT_ONESHOT    EQU  01h    ; 1=one shot is pending
BUT_USED       EQU  02h    ; 1=shift has been used during a stroke

DCB_BUT Struc
  db size DCB dup (0)      ; reserve room for common DCB
  dcb_NumButDefs    dw 0   ; number of BUT_DEF structure in array to process
  dcb_@ButDefArray  dw 0   ; address of BUT_DEF arrary
DCB_BUT Ends

;------------------------------------------------------------------------------
; Display Type DCB
;------------------------------------------------------------------------------

; video mode LCD types for standard video mode change support
VMC_TYPE_NONE     equ 0  ; do not modify for video mode change
VMC_TYPE_TOP      equ 1  ; squeeze to the top
VMC_TYPE_CENTER   equ 2  ; center

DCB_DISP Struc
  db size DCB dup (0)  ; reserve room for common DCB

  dcb_DspFlags      dw 0 ; display engine flags
  dcb_InactPeriod   dd 0 ; inactivity period in seconds
  dcb_LastActivity  dd 0 ; last activity count reading
  dcb_TicksPerCheck dw 0 ; how often to check for activity
  dcb_NumberChecks  dd 0 ; how many checks before auto turn off
  dcb_CountDown1    dw 0 ; Count down for dcb_TicksPerCheck
  dcb_CountDown2    dd 0 ; Count down for dcb_TicksTimeOut

; device dependent routines called from common routines

  dcb_@Backlight      dw 0 ; Addr of routine to turn backlight on/off

DCB_DISP Ends

; bits for dcb_DspFlags
; state information
DSP_STATE_ON     equ 0001h     ; Display state 1==on 0==off
DSP_AUTO_ON      equ 0002h     ; Auto on  request is outstanding
DSP_AUTO_OFF     equ 0004h     ; Auto off request is outstanding

; options
DSP_AUTO_ENABLED equ 0100h     ; Enable Auto   1==on 0==off
DSP_OPAQUE       equ 0200h     ; report events when backlight is off 1=yes 0=no
DSP_SUPPRESS     equ 0400h     ; Suppress strokes after auto turn on 1=yes 0=no

;------------------------------------------------------------------------------
; Macros
;------------------------------------------------------------------------------

DISABLE   MACRO
  cli
ENDM

ENABLE    MACRO
 sti
ENDM

TraceInt  MACRO
ifndef Trc_Int
  extrn Trc_Int : near
endif
  call Trc_Int
ENDM

TraceByte MACRO
ifndef Trc_Byte
  extrn Trc_Byte : near
endif
  call Trc_Byte
ENDM

TraceByte1 MACRO
ifndef Trc_Byte1
  extrn Trc_Byte1 : near
endif
  call Trc_Byte1
ENDM

TraceTick MACRO
ifndef Trc_Tick
  extrn Trc_Tick : near
endif
  call Trc_Tick
ENDM

TraceAbs  MACRO
ifndef Trc_ABS
  extrn Trc_ABS  : near
endif
  call Trc_ABS
ENDM

TraceDD   MACRO index,value
ifndef Trc_DD
  extrn Trc_DD   : near
endif
  push ax
  push cx
  mov  cl,index
  mov  ax,value
  call Trc_DD
  pop  cx
  pop  ax
ENDM

TraceDDb  MACRO index,value
ifndef Trc_DD
  extrn Trc_DD   : near
endif
  push ax
  push cx
  mov  cl,index
  xor  ah,ah
  mov  al,value
  call Trc_DD
  pop  cx
  pop  ax
ENDM

GetCritSec MACRO  sem
  mov  al, 1
  xchg sem, al
  or   al,al
ENDM

ClearCritSec MACRO sem
  mov sem, 0
ENDM

CALL_ALL   MACRO rtn
ifndef Gio_CallAll
  extrn Gio_CallAll  : near
endif
  mov  si, offset rtn
  call Gio_CallAll
ENDM

CALL_TYPE  MACRO rtn,type
ifndef Gio_CallType
  extrn Gio_CallType : near
endif
  mov  ax, type
  mov  si, offset rtn
  call Gio_CallType
ENDM

CALL_UNIT  MACRO rtn,unit
ifndef Gio_CallUnit
  extrn Gio_CallUnit : near
endif
  mov  al, unit
  mov  si, offset rtn
  call Gio_CallUnit
ENDM

CALL_NZ  MACRO rtn
  .if <rtn ne 0>
     call rtn
  .endif
ENDM
CALL_NZ_OK  MACRO rtn
  .if <rtn ne 0>
     call rtn
  .else
     xor ax,ax
  .endif
ENDM
CALL_NZ_ERR MACRO rtn
  .if <rtn ne 0>
     call rtn
  .else
     mov ax,1
     stc
  .endif
ENDM

PANIC     MACRO value
ifndef Gio_Panic
  extrn Gio_Panic : near
endif
  mov  al,value
  call Gio_Panic
ENDM
UNPANIC     MACRO value
ifndef Gio_UnPanic
  extrn Gio_UnPanic : near
endif
  mov  al,value
  call Gio_UnPanic
ENDM
;------------------------------------------------------------------------------
; Panic values
;------------------------------------------------------------------------------
PANIC_DDS       equ 1  ; init: device services did not contact us
PANIC_LEVELS    equ 2  ; idc: sinfo levels don't match on startdevice
PANIC_INVALID_IDC equ 3 ; idc: invalid IDC, out of range
PANIC_REG_ERR   equ 4  ; idc: Registration error from DDS (device services)
PANIC_DEVHLP1   equ 5  ; init: GetDosVar failed
PANIC_DEVHLP2   equ 6  ; init: RegisterDevClass failed
PANIC_DEVINIT   equ 7  ; init: Dev_Init failed
PANIC_SERNOLID  equ 8  ; serial: no serial LID
PANIC_SERNOPORT equ 9  ; serial: serial port not available
PANIC_SERNOIRQ  equ 10 ; serial: IRQ busy
PANIC_GETINFO   equ 11 ; timer: DosGetInfo failed
PANIC_DEVHLP3   equ 12 ; timer: TickCount failed
PANIC_CALL0     equ 13 ; strat: call to location 0
PANIC_EXTZERO   equ 14 ; loc: zero extent
PANIC_RATEZERO  equ 15 ; loc: zero sample rate
;
; device dependent value base
PANIC_BASEDD    equ 200
;
; device dependent values should use the following as a base, for example:
;   PANIC_DD_ERR0 equ PANIC_DDBASE+0
;   PANIC_DD_ERR1 equ PANIC_DDBASE+1
; these should be defined in a device dependent include file
