;      /*****************************************************************/
;      /*                                                               */
;      /*           Copyright (c) IBM Corporation  1987, 1992           */
;      /*                     All Rights Reserved                       */
;      /*                                                               */
;      /*****************************************************************/
;      /******************* START OF SPECIFICATIONS *********************/
;      /*                                                               */
;      /*  SOURCE FILE NAME: DISPNUL.ASM                                */
;      /*                                                               */
;      /*  DESCRIPTIVE NAME: Null display routine                       */
;      /*                                                               */
;      /*  COPYRIGHT:  IBM Corp. 1992                                   */
;      /*                                                               */
;      /*  STATUS:  Version 1.0                                         */
;      /*                                                               */
;      /*  NOTES: This routine should be linked into the driver instead */
;      /*         of DISPLAY.ASM if the driver will not have a display  */
;      /*         logical device. This routine provides all the entry   */
;      /*         points needed.                                        */
;      /*                                                               */
;      /*  ENTRY POINTS:                                                */
;      /*      See public statements                                    */
;      /*  EXTERNAL REFERENCES:                                         */
;      /*      See extrn statements                                     */
;      /*                                                               */
;      /******************* END  OF  SPECIFICATIONS *********************/
.xlist
  include pensegs.inc
.list

.286p
;------------------------------------------------------------------------------
; external data references
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; external routines
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; local equates
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; local data declarations
;------------------------------------------------------------------------------

DSEG   segment
DSEG   ends

CSEG SEGMENT
     ASSUME    CS:CGROUP, SS:nothing, ES:nothing, DS:DGROUP

;---- ROUTINES TO SET DISPLAY STATE -------------------------------------------
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; Set the diplay state (turn it on or off)
;  al = command 1=turn on backlight 0=turn off backlight
;  bx = dcb
;------------------------------------------------------------------------------
public Dsp_SDS
Dsp_SDS proc
  stc
  ret
Dsp_SDS endp

;---- ROUTINES TO MANAGE DISPLAY ENGINE ---------------------------------------
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; Update display engine with backlight state info. Called by device dependent
; code to update display engine.
;  al = 1=backlight is on 0=backlight is off
;  bx = dcb
;------------------------------------------------------------------------------
public Dsp_Engine
Dsp_Engine    proc
  stc
  ret
Dsp_Engine endp

;---- AUTOMATIC BACKLIGHT CONTROL ---------------------------------------------
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; Process requests to activate and disable automatic control. This should be
; called when ever the inactivity peroid changes or if the automatic enable
; changes.
;   bx = dcb
;------------------------------------------------------------------------------
public Dsp_SetInactPeriod
Dsp_SetInactPeriod proc
  stc
  ret
Dsp_SetInactPeriod endp

;------------------------------------------------------------------------------
; Convert inactivity peroid in seconds to number of ticks between checks and
; number of checks needed.
;   bx = dcb
;------------------------------------------------------------------------------
public Dsp_Convert
Dsp_Convert proc
  stc
  ret
Dsp_Convert endp

;------------------------------------------------------------------------------
; process callback after system activity to automatically turn display on
; bx = dcb
;------------------------------------------------------------------------------
public Dsp_callback
Dsp_callback    proc
  ret
Dsp_callback    endp

;------------------------------------------------------------------------------
; Get control bits for suppressing activity while the backlight is off
; returns
;   dx = 0
;------------------------------------------------------------------------------
public Dsp_GetSuppress
Dsp_GetSuppress proc
  xor dx,dx
  ret
Dsp_GetSuppress endp

CSEG ends
;---- INITIALIZATION ROUTINES -------------------------------------------------
;
; note: this code is truncated from the driver after the INIT command returns
;       to OS/2
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; Initialize engine
;  bx = dcb
;------------------------------------------------------------------------------
CSEGI segment
public Dsp_Init
Dsp_Init proc
  ret
Dsp_Init endp
CSEGI ends
end
