;      /*****************************************************************/
;      /*                                                               */
;      /*           Copyright (c) IBM Corporation  1987, 1992           */
;      /*                     All Rights Reserved                       */
;      /*                                                               */
;      /*****************************************************************/
;      /******************* START OF SPECIFICATIONS *********************/
;      /*                                                               */
;      /*  SOURCE FILE NAME: BUTNUL.ASM                                 */
;      /*                                                               */
;      /*  DESCRIPTIVE NAME: Null button handler                        */
;      /*                                                               */
;      /*  COPYRIGHT:  IBM Corp. 1992                                   */
;      /*                                                               */
;      /*  STATUS:  Version 1.0                                         */
;      /*                                                               */
;      /*  NOTES: Link this module instead of BUTTON.ASM if the         */
;      /*         driver does not have any buttons. This module         */
;      /*         supplies all the BUTTON.ASM entry point and takes     */
;      /*         up minimum space and overhead.                        */
;      /*                                                               */
;      /*  ENTRY POINTS:                                                */
;      /*      See public statements                                    */
;      /*  EXTERNAL REFERENCES:                                         */
;      /*      See extrn statements                                     */
;      /*                                                               */
;      /******************* END  OF  SPECIFICATIONS *********************/
.xlist
  include pensegs.inc
  include penei.inc
.list

.286p

;------------------------------------------------------------------------------
; external data references
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; external routines
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; local equates
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; local data declarations
;------------------------------------------------------------------------------

DSEG   segment
public buttons
buttons   dw 0           ; state of buttons, 1=activated, 0=released

DSEG   ends


CSEG SEGMENT
     ASSUME    CS:CGROUP, SS:nothing, ES:nothing, DS:DGROUP

;---- ROUTINES TO HANDLE EVENTS -----------------------------------------------
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; process an event for a device dependent locator device
;  dl = 0 released -1=activated
;  bx = button dcb
;  cx = button index (0 to 15)
;
;------------------------------------------------------------------------------
public But_Engine
But_Engine    proc
  stc
  ret
But_Engine endp

;------------------------------------------------------------------------------
; return button emulation
; returns
;  al=emulated mouse buttons
;  dx=bits for loc_cntl
;
; This routine is called at the start of a stroke by the locator engine to
; latch mouse emulated buttons for the duration of the stroke. One Time shifts
; can be cleared now.
;------------------------------------------------------------------------------
public But_GetButtonShift
But_GetButtonShift proc
  mov al, EV_BUTTON1
  xor dx,dx
  ret
But_GetButtonShift endp

;------------------------------------------------------------------------------
; returns
;  ax=current button state
;------------------------------------------------------------------------------
public But_GetButtons
But_GetButtons proc
  mov  ax, buttons
  ret
But_GetButtons endp

;---- MISCELLANEOUS ROUTINES --------------------------------------------------
; bx = dcb
;------------------------------------------------------------------------------
public But_CalcCaps
But_CalcCaps proc
  ret
But_CalcCaps endp

CSEG ends
;---- INITIALIZATION ROUTINES -------------------------------------------------
;
; note: this code is truncated from the driver after the INIT command returns
;       to OS/2
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; Initialize engine
;  bx = dcb
;------------------------------------------------------------------------------
CSEGI segment
public But_Init
But_Init proc
  ret
But_Init endp
CSEGI ends
end
