/* SCCSID = "src/dev/usb/USBMOUSE/MOUTYPE.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  MOUTYPE.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB Mouse Device Driver TYPEDEF include file.         */
/*                                                                            */
/*   FUNCTION: This module is the USB Mouse DD TYPEDEF include file           */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer         Comment                              */
/*  ----    --------  ----------         -------                              */
/*          98/01/29  Vjacheslav Chibis                                       */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

RPH    FAR *pRP; /* request packet */

#define  AXE_X 0x1
#define  AXE_Y 0x2


/*************/
/* Item type */
/*************/
#define ITEM_TYPE_ABSOLUTE_RELATIVE 4 
#define ITEM_TYPE_ARRAY_VARIABLE    2
#define ITEM_TYPE_DATA_CONSTANT     1


#define MAX_USB_CMD     0x1f /*  max strategy command # */

typedef  struct _MouseData
{
   UCHAR DeviceStatus; /* mouse status value */
   UCHAR DeltaX; /* relative X coordinate   */
   UCHAR DeltaY; /* relative Y coordinate   */
   UCHAR Wheel;  /* relative wheel coordinate */
}     MouseData;


#define  MAX_DEVICES 16 /* maximum devices allowed */


#define  USB_IDC_FUNCTION_SINGLE_DEVICE 0x50 /* IDC function # to switch to single device mode */
#define  MAX_INIT_MESSAGE_COUNT     2 /* */


// initialization time message IDs
#define  INIT_MESSAGE_LOADED        0
#define  INIT_MESSAGE_NO_HID        1
#define  INIT_MESSAGE_INVNUMERIC    2
#define  INIT_MESSAGE_UNKNOWNKWD    3
#define  INIT_MESSAGE_NO_LEGACY     4
#define  INIT_MESSAGE_INVLEGACY     5





#define  REQTYPE_RECIPIENT_DEVICE      0
#define  REQTYPE_RECIPIENT_INTERFACE   1
#define  REQTYPE_RECIPIENT_ENDPOINT    2
#define  REQTYPE_RECIPIENT_OTHER       3


// I/O request flags used in HID processing
#define  HID_IRQ_STATUS_SETCONF    1
#define  HID_IRQ_STATUS_SETINTF    2
#define  HID_IRQ_STATUS_READINT    3
#define  HID_IRQ_STATUS_INTRCVED   4
#define  HID_IRQ_STATUS_SERVCLIENT 5


#define CLIENT_IRQ_SETIDLE    1  // Set idle ID
#define CLIENT_IRQ_READPIPE   2  // Read Interrupt pipe ID
#define CLIENT_IRQ_GETREPORT  3  // Get Report ID
#define CLIENT_IRQ_CLRSTALL   4  // Clear stalled ID
#define CLIENT_IRQ_SETINTF    5  // Set Interface ID


#define BUTTON_1 1  /* USB mouse button 1 ID */
#define BUTTON_2 2  /* USB mouse button 2 ID */
#define BUTTON_3 3  /* USB mouse button 3 ID */

#define HID_GDESKTOP_USAGE_WHEEL 56  /* mouse wheel id */


#define INTERRUPT_BUFFER_LENGTH 0x2F /* maximal interrupt buffer length */


typedef struct _itemInfo
{
   ULONG    itemOffset;  /* in bits */
   ULONG    itemSize;    /* in bits */
   UCHAR    indexInBuffer; /* item index in interrupt buffer */
   UCHAR    mask;        /* mask to calculate item value */
   USHORT   itemType;
   BOOL      used;
   USHORT   lastAbsoluteData;

} ItemInfo;



#define REPORT_ITEM_AXE_X    0
#define REPORT_ITEM_AXE_Y    1
#define REPORT_ITEM_WHEEL    2
#define REPORT_ITEM_BUTTON_1 3
#define REPORT_ITEM_BUTTON_2 4
#define REPORT_ITEM_BUTTON_3 5
#define REPORT_ITEM_THE_LAST 6

typedef struct _devData
{
   ItemInfo items[REPORT_ITEM_THE_LAST];
   UCHAR    deviceReportID;   // report #

} DevData;


typedef struct _devList
{
   UCHAR                      used;             /* 0-if not used,  else used */
   DeviceInfo FAR             *pDeviceInfo;     /* far pointer to device data */
   UCHAR                      IntBuffer[INTERRUPT_BUFFER_LENGTH]; /* interrupt data */
   SetupPacket                stdPacket;        /* standard packet */
   USHORT                     intBufferLength;  /* Interrupt Buffer length */
   UCHAR                      ReportInterface;  /* Interface # */
   DevData                    DeviceData;       /* USB mouse data */
}  DevList;

#define CLIENT_IRQ_SETINTF    5  /* Set Interface ID */


