/* SCCSID = "src/dev/usb/USBMOUSE/MOUEXTRN.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  MOUEXTRN.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  External data declarations for the USB Mouse          */
/*                      Device Driver.                                        */
/*                                                                            */
/*   FUNCTION: This module is the USB Mouse DD external data declarations     */
/*             include file. See moudata.c for the data items being           */
/*             externalized.                                                  */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer         Comment                              */
/*  ----    --------  ----------         -------                              */
/*          98/02/01  Vjacheslav Chibis                                       */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

  
  


extern USHORT  (*Strat1[])();

extern USHORT  (*vidcRouteTable[])();
extern void    (*IOCTLRouteTable[])();

extern PFN           Device_Help;


extern BYTE          InitDataStart;  // Data segment end


/*   RM stuff  */
extern ULONG         RMFlags;
extern PFN           RM_Help0;
extern PFN           RM_Help3;
/*             */

extern HDRIVER    ghDriver;  // Driver handler
extern HADAPTER   ghAdapter; // Adapter handler


extern CHAR       USBDriverName[]; // HID driver name
extern CHAR       LMouseDriverName[]; // legacy mouse driver name

extern IDCTABLE   DDTable;                   
extern PUSBIDCEntry   gpUSBHIDIDC;  // HID driver IDC entry point
extern USHORT         gdsUSBIDC;    // HID ds segment value


extern DevList  gActiveMice[MAX_DEVICES];   // active device list served by USBMOUSE

extern PUSBIDCEntry   pLMOUSEIDC;  // Legacy mouse driver IDC routine entry point
extern USHORT         dsLMOUSEIDC; // Legacy mouse driver ds segment value

extern UCHAR gMiceCounter; // active mice counter
extern UCHAR gUseIdleTime; // temporary variable

extern DRIVERSTRUCT gDriverStruct; // Driver description
extern ADAPTERSTRUCT gAdapterStruct; // Adapter description

extern USHORT gAbsolute;


extern void FAR LMOUcallIDC( PUSBIDCEntry idcEntry, USHORT callingDS, RP_GENIOCTL FAR *pRP );





extern USHORT     gVerbose; //verbose variable (init time)
extern UCHAR      gMouseNo;  //active mouse # (single device mode only)
extern UCHAR      gMouseNoBak;  //active mouse # (single device mode only)
extern MSGTABLE   InitMsg;
extern UCHAR gWheel;

extern PDDD_PARM_LIST pDDD_Parm_List;

extern MSGTABLE   gInitMsg; 

#ifdef   DEBUG
   extern   USHORT       gUSBMOUMsgLevel;       // debug message level
#endif
extern   LastCode;

/*       Verbose stuff        */
extern USHORT            gMessageIDs[MAX_INIT_MESSAGE_COUNT];
extern PSZ               gVMessages[];  // Verbose messages
extern USHORT            gMessageCount; // Verbose messages counter
/*                            */
                                 
