/* SCCSID = "src/dev/usb/USBMOUSE/MOUDATA.C, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  MOUDATA.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB Mouse Device Driver data                          */
/*                                                                            */
/*   FUNCTION: This module allocates the global data area for the             */
/*             USB Mouse DD                                                   */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             None                                                           */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer         Comment                              */
/*  ----    --------  ----------         -------                              */
/*          98/02/01  Vjacheslav Chibis                                       */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "mouse.h" //USB mouse driver main header

/*-----------------------------*/
/* Table for strategy commands */
/*-----------------------------*/

USHORT (*StratList[])() =
{                    /*--------------------------------------*/
  usbmouseInit,      /* 0x00  initialize device driver       */
  CmdError,          /* 0x01  check the media                */
  CmdError,          /* 0x02  build BPB                      */
  CmdError,          /* 0x03  reserved                       */
  CmdError,          /* 0x04  read                           */
  CmdError,          /* 0x05  non-destructive read           */
  CmdError,          /* 0x06  input status                   */
  CmdError,          /* 0x07  input flush                    */
  CmdError,          /* 0x08  write                          */
  CmdError,          /* 0x09  write with verify              */
  CmdError,          /* 0x0A  get output status              */
  CmdError,          /* 0x0B  flush output                   */
  CmdError,          /* 0x0C  reserved                       */
  CmdError,          /* 0x0D  open                           */
  CmdError,          /* 0x0E  close                          */
  CmdError,          /* 0x0F  removable media                */
  CmdError,          /* 0x10  generic IOCTL                  */
  CmdError,          /* 0x11  reset uncertain media          */
  CmdError,          /* 0x12  get Logical Drive Map          */
  CmdError,          /* 0x13  set Logical Drive Map          */
  CmdError,          /* 0x14  de-Install this device         */
  CmdError,          /* 0x15  reserved                       */
  CmdError,          /* 0x16  get number of partitions       */
  CmdError,          /* 0x17  get unit map                   */
  CmdError,          /* 0x18  no caching read                */
  CmdError,          /* 0x19  no caching write               */
  CmdError,          /* 0x1A  no caching write/verify        */
  CmdError,          /* 0x1B  initialize device driver       */
  CmdError,          /* 0x1C  reserved for Request List code */
  CmdError,          /* 0x1D  get driver capabilities        */
  CmdError,          /* 0x1E  reserved                       */
  usbmouseInitComplete /* 0x1F  initialization complete      */
 
 };
/*--------------------------------------*/

PFN      Device_Help    = NULL;  /* devhelp entry point; used by dhcalls.lib */

/*----------------------------------------------*/
/* GLOBAL VARS FOR RM                           */
/*                                              */
/* RM.LIB needs these declared                  */
/*----------------------------------------------*/
ULONG       RMFlags     = 0L;
PFN         RM_Help0    = 0L;
PFN         RM_Help3    = 0L;

/*--------------------------------------------------------*/
/* Set the DRIVERSTRUCT and DETECTEDSTRUCT data areas     */
/*--------------------------------------------------------*/

char  near  DDName[];                  /* device driver name */
char  near  DDDesc[];                  /* device driver description */
char  near  VendorID[];                /* vendor identification */
char  near  AdapterName[];             /* adapter name */

/*----------------------------------------------*/
/* Driver Description   (rmbase.h)              */
/*----------------------------------------------*/
DRIVERSTRUCT gDriverStruct =
{
   DDName,                             /* DrvrName                */
   DDDesc,                             /* DrvrDescript            */
   VendorID,                           /* VendorName              */
   CMVERSION_MAJOR,                    /* MajorVer                */
   CMVERSION_MINOR,                    /* MinorVer                */
   1998,06,26,                         /* Date  yyyy,mm,dd        */
   DRF_STATIC,                         /* DrvrFlags               */
   DRT_OS2,                            /* DrvrType                */
   DRS_CHAR,                           /* DrvrSubType             */
   NULL                                /* DrvrCallback            */
};

/*----------------------------------------------*/
/* Adapter Description                          */
/*----------------------------------------------*/
ADAPTERSTRUCT gAdapterStruct =
{
   AdapterName,                        /* AdaptDescriptName; */
   AS_NO16MB_ADDRESS_LIMIT,            /* AdaptFlags;        */
   AS_BASE_INPUT,                      /* BaseType;          */
   AS_SUB_MOUSE,                       /* SubType;           */
   AS_BASE_COMM,                       /* InterfaceType;     */
   NULL,                               /* HostBusType;       */
   AS_BUSWIDTH_32BIT,                  /* HostBusWidth;      */
   NULL,                               /* pAdjunctList;      */
   NULL                                /* reserved           */
};

/*----------------------------------------------*/
/* GLOBAL HANDLE VARIABLES                      */
/*                                              */
/* These variables are assigned the handles for */
/* drivers, detected hardware and resources.    */
/*----------------------------------------------*/

HDRIVER     ghDriver     = NULL;        /* global handle to driver          */
HADAPTER    ghAdapter    = NULL;        //adapter handler


CHAR        USBDriverName[9]    = "USBHID$ ";//Human Interface Device driver name
CHAR        LMouseDriverName[9] = "MOUSE$  ";//Legacy mouse driver name


USHORT gAbsolute=FULL_WORD;


IDCTABLE    DDTable =  { { 0, 0, 0 }, 0, 0 }; //Device Driver Table (used by DevHelp_AttachDD)

PUSBIDCEntry   gpUSBHIDIDC = NULL; //Human Interface Device driver name

USHORT         gdsUSBIDC = 0;      //Human Interface Device driver ds segment

PUSBIDCEntry   pLMOUSEIDC = NULL;  //Legacy Mouse driver IDC entry point
USHORT         dsLMOUSEIDC = 0;    //Legacy Mouse driver ds segment




#ifdef   DEBUG
   USHORT         gUSBMOUMsgLevel=DBG_CRITICAL;       // debug message level
#endif


DevList  gActiveMice[MAX_DEVICES];   // active devices list served by HID

UCHAR       gMiceCounter=0;   // active devices counter
UCHAR       gUseIdleTime=0;   // temporary variable


USHORT         gUSBMISCMsgLevel=0;  //debug message level (not used)



PDDD_PARM_LIST pDDD_Parm_List       = { 0 };

UCHAR         gMouseNo = FULL_BYTE; // active mouse number (single device mode only)
UCHAR         gMouseNoBak = FULL_BYTE; // active mouse number (single device mode only)
UCHAR gWheel=0;

BYTE          InitDataStart = 0;   /* Marks the end of the data segment. */
USHORT        gVerbose = 0; //Verbose parameter


/* ****************************************************************************************
                              VERBOSE STUFF
* *************************************************************************************** */            
USHORT            gMessageIDs[MAX_INIT_MESSAGE_COUNT];//verbose messages
USHORT            gMessageCount=0;//verbose messages counter

/* Verbose messages */
PSZ               gVMessages[]={ "IUSBMOUSE.SYS: USB MOUSE driver v.%dd.%dd loaded",
                                 "EUSBMOUSE.SYS: HID driver not loaded",
                                 "EUSBMOUSE.SYS: Invalid numeric value in CONFIG.SYS line at column %dddd",
                                 "EUSBMOUSE.SYS: Invalid key value in CONFIG.SYS line at column %dddd",
                                 "EUSBMOUSE.SYS: MOUSE.SYS not loaded",
                                 };
/* *************************************************************************************** */


#define MSG_REPLACEMENT_STRING  1178
MSGTABLE  gInitMsg = { MSG_REPLACEMENT_STRING, 1, 0 };	//	structure used to write out message during initialization
