/* SCCSID = "src/dev/usb/USBKBD/KBDTYPE.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  KBDTYPE.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB keyboard driver typedefs                          */
/*                                                                            */
/*   FUNCTION: This module is the USB Keyboard driver TYPEDEF include file.   */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/06/30  LR                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#define  MAX_INIT_MESSAGE_COUNT     2
/*
    Initialization time message IDs
*/    
#define  INIT_MESSAGE_LOADED        0
#define  INIT_MESSAGE_NO_HID        1
#define  INIT_MESSAGE_INVNUMERIC    2
#define  INIT_MESSAGE_UNKNOWNKWD    3
#define  INIT_MESSAGE_NO_LEGACY     4

#define MAX_KBDS          16
#define MAX_BUFFER_LENGTH 16

#define LegKBDIDC 20

/*
    USB keyboard client IRQ switch values
*/
#define KBD_IRQ_STATUS_IDLESET  1
#define KBD_IRQ_STATUS_DURATION 2
#define KBD_IRQ_STATUS_INTPIPE  3
#define KBD_IRQ_STATUS_SETACK   4
#define KBD_IRQ_STATUS_STALLED  5

/*
    Legacy keyboard I/O flags (functions)
*/
#define SET_TYPEMATIC   10
#define SET_LEDS        11

/*
    Typematic bit fields
*/
#define TYPEMATIC_A     0x07
#define TYPEMATIC_B     0x18
#define TYPEMATIC_DELAY 0x60

/*
    Set_Idle request Duration
*/
#define DURATION_INFINITY   0
#define DURATION_MIN        1   //    4 ms
#define DURATION_RATE      14   //   56 ms - OS/2 default typematic rate
#define DURATION_DELAY     63   //  252 ms - OS/2 default typematic delay
#define DURATION_MAX      255   // 1020 ms

/*
    Legacy Keyboard Scan Codes
*/
#define SCAN_ESC      1
#define SCAN_1        2
#define SCAN_2        3
#define SCAN_3        4
#define SCAN_4        5
#define SCAN_5        6
#define SCAN_6        7
#define SCAN_7        8
#define SCAN_8        9
#define SCAN_9       10
#define SCAN_0       11
#define SCAN_MINUS   12
#define SCAN_PLUS    13
#define SCAN_BACKSP  14
#define SCAN_TAB     15
#define SCAN_Q       16
#define SCAN_W       17
#define SCAN_E       18
#define SCAN_R       19
#define SCAN_T       20
#define SCAN_Y       21
#define SCAN_U       22
#define SCAN_I       23
#define SCAN_O       24
#define SCAN_P       25
#define SCAN_LBRACE  26
#define SCAN_RBRACE  27
#define SCAN_ENTER   28
#define SCAN_CTRL    29     // left Ctrl, right Ctrl sends SCAN_E0, SCAN_CTRL
#define SCAN_PAUSE2  29
#define SCAN_A       30
#define SCAN_S       31
#define SCAN_D       32
#define SCAN_F       33
#define SCAN_G       34
#define SCAN_H       35
#define SCAN_J       36
#define SCAN_K       37
#define SCAN_L       38
#define SCAN_COLON   39
#define SCAN_APOSTR  40
#define SCAN_ACCENT  41
#define SCAN_LSHIFT  42
#define SCAN_BACKSL  43
#define SCAN_Z       44
#define SCAN_X       45
#define SCAN_C       46
#define SCAN_V       47
#define SCAN_B       48
#define SCAN_N       49
#define SCAN_M       50
#define SCAN_COMMA   51
#define SCAN_POINT   52
#define SCAN_SLASH   53
#define SCAN_RSHIFT  54
#define SCAN_ASTER   55
#define SCAN_ALT     56     // left Alt, right Alt sends SCAN_E0, SCAN_ALT
#define SCAN_SP      57
#define SCAN_CLOCK   58
#define SCAN_F1      59
#define SCAN_F2      60
#define SCAN_F3      61
#define SCAN_F4      62
#define SCAN_F5      63
#define SCAN_F6      64
#define SCAN_F7      65
#define SCAN_F8      66
#define SCAN_F9      67
#define SCAN_F10     68
#define SCAN_NLOCK   69
#define SCAN_PAUSE3  69
#define SCAN_SLOCK   70
#define SCAN_BREAK2  70
#define SCAN_HOME    71
#define SCAN_UP      72
#define SCAN_PGUP    73
#define SCAN_KMINUS  74
#define SCAN_LEFT    75
#define SCAN_K5      76
#define SCAN_RIGHT   77
#define SCAN_KPLUS   78
#define SCAN_END     79
#define SCAN_DOWN    80
#define SCAN_PGDOWN  81
#define SCAN_INS     82
#define SCAN_DEL     83
#define SCAN_SYSRQ   84

#define SCAN_NUSBSL  86     // non-US \ and |
#define SCAN_F11     87
#define SCAN_F12     88

#define SCAN_LGUI    91     // with SCAN_E0 prefix
#define SCAN_RGUI    92     // with SCAN_E0 prefix
#define SCAN_APPL    93     // with SCAN_E0 prefix

#define SCAN_REL    128     // SCAN code ORed with 0x80 when a key is RELeased

#define SCAN_LSHPR  170     //  left shift pressed prefix = 0xAA

#define SCAN_RSHPR  182     // right shift pressed prefix = 0xB6

#define SCAN_E0     224     // prefix = 0xE0
#define SCAN_E1     225     // Pause prefix = 0xE1, SCAN_PAUSE2, SCAN_PAUSE3

#define FIRST   0
#define SECOND  1
#define TURNOFF 0
#define TURNON  1
#define BIT_0   1
#define PRESET  4
#define ACTIVE  8

/*
    USB Keyboard Usage Index
*/
#define UI_MIN      0   // reserved (no event indicated)
#define UI_ROVER    1   // ErrorRollOver
#define UI_PFAIL    2   // POSTFail
#define UI_ERROR    3   // ErrorUndefined
#define UI_A        4   // a and A
#define UI_CLOCK   57
#define UI_F10     67
#define UI_PRTSCR  70   // PrintScreen
#define UI_SLOCK   71
#define UI_PAUSE   72
#define UI_INS     73
#define UI_UP      82
#define UI_NLOCK   83
#define UI_KSLASH  84   // Keypad /
#define UI_KASTER  85
#define UI_KPLUS   87
#define UI_KENTER  88   // Keypad Enter
#define UI_K1      89
#define UI_NUSBSL 100   // non-US \ and |, 84-key-end
#define UI_APPL   101   // keyboard APPLication key (Microsoft WIN key)
#define UI_MAX    101

#define UI_LCTRL  224
#define UI_LSHIFT 225
#define UI_LALT   226
#define UI_LGUI   227   // Windowing environment key (Microsoft LEFT WIN key)
#define UI_RCTRL  228
#define UI_RSHIFT 229
#define UI_RALT   230
#define UI_RGUI   231   // Windowing environment key (Microsoft RIGHT WIN key)

#define UI_RESERV 255   // Reserved

#define UI_LED_UNDEF 0
#define UI_LED_NLOCK 1
#define UI_LED_CLOCK 2
#define UI_LED_SLOCK 3

/*
    Modifier Byte Bits
*/
#define LCTRL    1
#define LSHIFT   2
#define LALT     4
#define LGUI     8
#define RCTRL   16
#define RSHIFT  32
#define RALT    64
#define RGUI   128

/*
    Legacy Keyboard LED Bits
*/
#define LEG_LED_SLOCK 1                       
#define LEG_LED_NLOCK 2
#define LEG_LED_CLOCK 4

typedef struct _kbdList
{
   UCHAR       active;
   UCHAR       kbdAddr;
   UCHAR       controllerID;
   SetupPacket setITpack;
   SetupPacket setLEDpack;
   UCHAR       interruptPipeAddress;
   UCHAR       inReportID;
   UCHAR       inInterface;
   UCHAR       outReportID;
   UCHAR       outInterface;
   USHORT      keyOff;
   USHORT      inReportLength;
   USHORT      outReportLength;
   UCHAR       modOff[UI_RGUI-UI_LCTRL+1];
   UCHAR       prevBuff[MAX_BUFFER_LENGTH];
   UCHAR       buffer[MAX_BUFFER_LENGTH];
   UCHAR       LEDoff[UI_LED_SLOCK+1];
   UCHAR       LEDs[MAX_BUFFER_LENGTH];
}     KBDList;

typedef USHORT (FAR *PKBDDDIDC) (USHORT Func, USHORT Var1, USHORT Var2);

