/* SCCSID = "src/dev/usb/USBKBD/KBD.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  KBD.H                                                 */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB Keyboard driver master include file               */
/*                                                                            */
/*   FUNCTION: This module is the USB Keyboard driver master                  */
/*             include file.                                                  */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/06/30  LR                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/*
    USBKBD specific debug definitions
*/    
#ifdef DEBUG
   #define     dsPrint(l,s)          dsPrint5x(gUKBDMsg,(l),(s),0,0,0,0,0)
   #define     dsPrint1(l,s,a)       dsPrint5x(gUKBDMsg,(l),(s),(a),0,0,0,0)
   #define     dsPrint2(l,s,a,b)     dsPrint5x(gUKBDMsg,(l),(s),(a),(b),0,0,0)
   #define     dsPrint3(l,s,a,b,c)   dsPrint5x(gUKBDMsg,(l),(s),(a),(b),(c),0,0)
   #define     dsPrint4(l,s,a,b,c,d) dsPrint5x(gUKBDMsg,(l),(s),(a),(b),(c),(d),0)
#endif

#include "usbcmmon.h"   /* USB device driver stack common definitions and
                           OS/2 relateded includes.   */
#include "usbmisc.h"    /* Commom USB device driver stack function prototypes
                           defined in usbmisc.lib.    */
#include "usbchid.h"
#include "kbdtype.h"    // USB Keyboard driver typedefs
#include "kbdproto.h"   // USB Keyboard driver function prototypes
#include "kbdextrn.h"   // USB Keyboard driver external data declarations

#define FP_SEG(fp) (*((USHORT FAR *)&(fp)+1))
#define FP_OFF(fp) (*((USHORT FAR *)&(fp)))
#define MK_FP(seg,off) (void FAR *)(((ULONG)(((ULONG)(seg)<<16)+(ULONG)(off))))

