/* SCCSID = "src/dev/usb/USBD/USBPROTO.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  USBPROTO.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Function prototypes provided by the USBD              */
/*                      device driver.                                        */
/*                                                                            */
/*   FUNCTION: This module is the USB port device driver                      */
/*             function prototype include file.                               */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          96/03/01  MB                                         */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/* USBSTRAT.C */
void FAR USBStrategy();
void CmdError( RPH FAR *pRP);
void USBInitComplete( RPH FAR *pRP);

/* USBDATA.C */
USHORT (*gStratList[])( RPH FAR *pRP );

/* USBIDC.C */
void FAR USBDidc( RP_GENIOCTL FAR *pRP_GENIOCTL );
void USBRegisterHCD( RP_GENIOCTL FAR *pRP_GENIOCTL );
void USBRegisterClass( RP_GENIOCTL FAR *pRP_GENIOCTL );
void USBSetConfiguration( RP_GENIOCTL FAR *pRP_GENIOCTL );
void USBSetInterface( RP_GENIOCTL FAR *pRP_GENIOCTL );
void USBAcceptIO( RP_GENIOCTL FAR *pRP_GENIOCTL );
void USBCancelIO( RP_GENIOCTL FAR *pRP_GENIOCTL ); // 07/11/98 MB
void ClearStalledPipe( RP_GENIOCTL FAR *pRP_GENIOCTL );

/* USBIRQ.C */
void USBProcessIRQ( RP_GENIOCTL FAR *pRP_GENIOCTL );
void ClearUSBDStalledPipe( RP_GENIOCTL FAR *pRP_GENIOCTL );
void GetDeviceDesc( RP_GENIOCTL FAR *pRP_GENIOCTL, UCHAR controllerId, BOOL lowSpeedDevice, USHORT parentHubIndex, UCHAR portNum );
void GetDescCompleted( RP_GENIOCTL FAR *pRP_GENIOCTL );
void SetAddrCompleted( RP_GENIOCTL FAR *pRP_GENIOCTL );
void DefAddrFailed( RP_GENIOCTL FAR *pRP_GENIOCTL );
void GetConfLenCompleted( RP_GENIOCTL FAR *pRP_GENIOCTL );
void GetConfCompleted( RP_GENIOCTL FAR *pRP_GENIOCTL );
void SetConfCompleted( RP_GENIOCTL FAR *pRP_GENIOCTL );
void GetHConfLenCompleted( RP_GENIOCTL FAR *pRP_GENIOCTL );
void GetHConfCompleted( RP_GENIOCTL FAR *pRP_GENIOCTL );
void ListenStatusChangedPipe( RP_GENIOCTL FAR *pRP_GENIOCTL );
void HubStatusChanged( RP_GENIOCTL FAR *pRP_GENIOCTL );
void GetPortStatus( RP_GENIOCTL FAR *pRP_GENIOCTL );
void HubPortStatusRetrieved( RP_GENIOCTL FAR *pRP_GENIOCTL );
void HubAckStatusChanges( RP_GENIOCTL FAR *pRP_GENIOCTL );
void HubSetPortFeature( RP_GENIOCTL FAR *pRP_GENIOCTL, USHORT featureSelector, ULONG irqSwitch );
void PortStatusChanged( RP_GENIOCTL FAR *pRP_GENIOCTL );
void ExtConfSet( RP_GENIOCTL FAR *pRP_GENIOCTL );
void ExtIntfaceSet( RP_GENIOCTL FAR *pRP_GENIOCTL );

/* USBINIT.C */
void USBInit( RPH FAR *pRP );


