/* SCCSID = "src/dev/usb/COM/COMTYPE.H, usb, c.basedd 98/10/26" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  COMTYPE.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB Communication Device Class Driver typedefs        */
/*                                                                            */
/*   FUNCTION: This module is the USB Communication Device Class Driver       */
/*             typedef include file.                                          */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/10/26  LR                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#define  MAX_MDMS    16    // max number of modems
#define  TURNOFF     0
#define  TURNON      1

#define  MAX_STRAT_CMD  0x1F  // max strategy command (initialization complete)

#define  COM_IOCTL_CAT     1  // COM device IOCtl Category
#define  MIN_IOCTL_FUNC 0x41  // min COM IOCtl Function (set bit rate)
#define  MAX_IOCTL_FUNC 0x74  // max COM IOCtl Function (query enhanced mode parameters)
#define  SELECTOR_MASK  0xFFF8

#define  READ_SEL       0
#define  WRITE_SEL      1
#define  MAX_GDT_SEL    2
/*
   Request Packet List
*/
#define  FIRST          0
#define  SECOND         1
#define  LAST           1
#define  CURRENT        2
#define  NUM_POINTERS   3

// initialization time message IDs
#define  INIT_MESSAGE_LOADED     0
#define  INIT_MESSAGE_NO_USBD    1
#define  INIT_MESSAGE_UNKNOWNKWD 2
#define  INIT_MESSAGE_INVNUMERIC 3

#define MAX_INIT_MESSAGE_COUNT   2
#define MSG_REPLACEMENT_STRING   1178

#define  COM_RESPONSE_LENGTH     8
#define  COM_COMMAND_LENGTH      8
#define  COM_RECDATA_LENGTH      64
#define  COM_SENDATA_LENGTH      64
/*
             IRQs
*/   
#define  COM_IRQ_SETCONF         0
#define  COM_IRQ_NOTIFICATION    1
#define  COM_IRQ_REQUEST         2
#define  COM_IRQ_LINECOD         3
#define  COM_IRQ_GETRESP         4
#define  COM_IRQ_SENDCMD         5
#define  COM_IRQ_RECDATA         6
#define  COM_IRQ_SENDATA         7
#define  COM_IRQ_BREAKON         8
#define  COM_IRQ_BREAKOFF        9
#define  COM_IRQ_SENDBYTE       10
#define  COM_IRQ_FEATURE        11

/*
   Class-specific codes for COM devices
*/
#define  DEV_SUBCL_RESERVED          0
#define  DEV_PROTOCOL_RESERVED       0
#define  INTERFACE_CLASS_COM         2
#define  INTERFACE_CLASS_DATA     0x0A
#define  INTERFACE_SUBCL_RESERVED    0
#define  INTERFACE_SUBCL_ACM         2    // Abstract Control Model
#define  INTERFACE_PROTOCOL_RESERVED 0
#define  INTERFACE_PROTOCOL_AT       1    // common AT commands (V.25ter)
#define  NUMBER_COM_INTERFACES       2
#define  CS_INTERFACE             0x24
#define  CS_HEADER                   0
#define  CS_CALL                     1    // Call management
#define  CS_ACM                      2    // Abstract Control Management
#define  CS_UNION                    6
/*
   ACM Requests (bRequest)
*/
#define  SEND_ENCAPSULATED_COMMAND  0     // Issues a command in the format of the supported control protocol
#define  GET_ENCAPSULATED_RESPONSE  1     // Requests a response in the format of the supported control protocol
#define  SET_COMM_FEATURE           2     // Controls the settings for a particular communication feature
#define  GET_COMM_FEATURE           3     // Returns the current settings for the communication feature
#define  CLEAR_COMM_FEATURE         4     // Clears the settings for a particular communication feature
#define  SET_LINE_CODING         0x20     // Configures DTE rate, stop-bits, parity, and number-of-character bits
#define  GET_LINE_CODING         0x21     // Requests current DTE rate, stop-bits, parity, and number-of-character bits
#define  SET_CONTROL_LINE_STATE  0x22     // RS-232 signal used to tell the DCE device the DTE device is now present
#define  SEND_BREAK              0x23     // Sends special carrier modulation used to specify RS-232 style break

#define  SET_LINE_CODING_TO      5000     // TimeOut in ms

#define  SEND_BREAK_ON           0xFFFF   // USB COM device will send a break until
#define  SEND_BREAK_OFF          0

#define  ABSTRACT_STATE             1     // This Communication Feature Selector is only valid for ACM
#define  ABSTRACT_STATE_LENGTH      2
#define  CM_DATA_MULTIPLEXING       2     // enables the multiplexing of call management
                                          // on data interface
/*
   ACM Notifications
*/
#define  NETWORK_CONNECTION         0     // Notification to host of network connection status
#define  RESPONSE_AVAILABLE         1     // Notification to host to issue a GET_ENCAPSULATED_RESPONSE request
#define  SERIAL_STATE            0x20     // Returns the current state of the carrier detect, DSR, break, and ring signal
#define  MAX_NOTIF_LEN             10     // Length of SERIAL_STATE Notification = 8 + 2
#define  SERIAL_STATE_INDEX         8     // SERIAL_STATE Notification bitmap index
#define  SERIAL_STATE_LENGTH        2     // SERIAL_STATE Notification bitmap length
/*
   SERIAL_STATE Notification bitmap
*/
                                       // MSR = Modem Status Register
#define  SERIAL_STATE_bRxCarrier    1  // Data Carrier Detect (DCD, V.24 signal 109)
#define  SERIAL_STATE_bTxCarrier    2  // Clear To Send       (CTS, V.24 signal 106)
#define  SERIAL_STATE_bRingSignal   8  // Ring Indicator       (RI, V.24 signal 125)
                                       // LSR = Line Status Register
#define  SERIAL_STATE_bBreak        4  // BREAK received
#define  SERIAL_STATE_bFraming     16  // Framing ERROR
#define  SERIAL_STATE_bParity      32  // Parity  ERROR
#define  SERIAL_STATE_bOverRun     64  // Overrun ERROR
/*
   Call Management Capabilities
*/
#define  CM_DATA_SUPPORT            2     // device can send/receive CM info over
                                          // data interface
#define  CM_DEVICE_SUPPORT          1     // device handles call management itself
/*
   ACM Capabilities
*/
#define  NETWORK_CONNECTION_SUPPORT    8  // device supports the notification
                                          // NETWORK_CONNECTION
#define  SEND_BREAK_SUPPORT            4  // device supports the request SEND_BREAK
#define  LINE_SUPPORT                  2  // device supports the request combination of
                                          // SET_LINE_CODING, GET_LINE_CODING,
                                          // SET_CONTROL_LINE_STATE,
                                          // and the notification SERIAL_STATE
#define  COMM_FEATURE_SUPPORT          1  // device supports the request combination of
                                          // SET_COMM_FEATURE, GET_COMM_FEATURE, and
                                          // CLEAR_COMM_FEATURE
/*
   Data Toggle bits
*/
#define  NOTIF_DATA_TOGGLE          1
#define  RECEIVE_DATA_TOGGLE        2
#define  SEND_DATA_TOGGLE           4
#define  SEND_DATA_INPROGRESS       8
#define  SEND_CMD_INPROGRESS       16
#define  INPUT_FLUSH_INPROGRESS    32
#define  OUTPUT_FLUSH_INPROGRESS   64
#define  SEND_BYTE_INPROGRESS     128
#define  STOP_TRANSMIT            256
#define  XOFF_SENT                512

#define  MAX_DATA_LEN        64
/*
   Functional descriptor
*/
typedef struct _FuncDescriptor
{
   DeviceDescHead head;
   UCHAR          bmCapabilities;

} FuncDescriptor;
/*
   Line Coding Structure
*/
typedef struct _LineCoding
{
   ULONG    dwDTERate;     // Data terminal rate, in bits per second
   UCHAR    bCharFormat;   // Stop bits: 0 - 1, 1 - 1.5, 2 - 2
   UCHAR    bParityType;   // Parity: 0 - None, 1 - Odd, 2 - Even, 3 - Mark, 4 - Space
   UCHAR    bDataBits;     // Data bits (5, 6, 7, 8 or 16???)

} LineCoding;

typedef struct _BITRATE
{
   ULONG    dwBitRate;
   UCHAR    bBitRate;
   ULONG    dwMin;
   UCHAR    bMin;
   ULONG    dwMax;
   UCHAR    bMax;

}  BITRATE, FAR *PBITRATE;
/*
   Modem service data structure
*/   
typedef struct _deviceList
{
   UCHAR    active;
   UCHAR    bConfValue;
   UCHAR    bComInterface;
   UCHAR    cmCapabilities;      // Call Management flags
   UCHAR    acmCapabilities;     // Abstract Control Management flags
   UCHAR    bIntEndpoint;   
   UCHAR    bDataInterface;
   UCHAR    bInEndpoint;
   UCHAR    bOutEndpoint;
   USHORT   wMaxInSize;
   USHORT   wMaxOutSize;

   DeviceInfo FAR *pDeviceInfo;

} DeviceList;
/*
   Data bits
*/
#define  MIN_DATABITS      5
#define  MAX_DATABITS      8
#define  DEFAULT_DATABITS  MAX_DATABITS
/*
   Parity
*/
#define  NO_PARITY      0
#define  ODD_PARITY     1
#define  EVEN_PARITY    2
#define  MARK_PARITY    3          // parity bit always 1
#define  SPACE_PARITY   4          // parity bit always 0
#define  DEFAULT_PARITY NO_PARITY
/*
   Stop Bits
*/
#define  ONE_STOPBIT       0
#define  ONE5_STOPBITS     1        // 1.5 stop bits
#define  TWO_STOPBITS      2
#define  DEFAULT_STOPBITS  ONE_STOPBIT
/*
   Input/Output Queue.
   When input queue goes above high water, send XOFF
   When input queue goes below low  water, send XON
*/
#define  IO_QUEUE_LENGTH   5114
#define  IN_QUEUE_HIGH     IO_QUEUE_LENGTH-1024    // In queue high water mark
#define  IN_QUEUE_LOW      IO_QUEUE_LENGTH/2       // In queue low  water mark

typedef struct _IOQueue
{
   UCHAR    bBuffer[IO_QUEUE_LENGTH];
   USHORT   iIn;
   USHORT   iOut;
   USHORT   wCount;

} IOQueue;

typedef struct _COMDCB
{                       // Device Control Block
   USHORT   wWriteTO;   // write timeout
   USHORT   wReadTO;    // read  timeout
   UCHAR    bmF1;       // 1st flags byte
   UCHAR    bmF2;       // 2nd flags byte
   UCHAR    bmF3;       // 3rd flags byte
   UCHAR    bError;     // error replacement char
   UCHAR    bBreak;     // break replacement char
   UCHAR    bXON;       // XON  character
   UCHAR    bXOFF;      // XOFF character

} COMDCB, FAR *PCOMDCB;

typedef struct _COMInfo
{
   UCHAR       iModem;     // modem index
   USHORT      wFeature;
   USHORT      wNOpens;    // Number of outstanding opens

   COMDCB      dcb;        // device control block

   LineCoding  prevline;
   LineCoding  line;
   ULONG       dwMinDTERate;
   ULONG       dwMaxDTERate;

   UCHAR    bTxImm;
   UCHAR    bTxBreak;   // 1 = currently transmitting break
   UCHAR    bMCR;       // Modem Control Register
   UCHAR    bMSR;       // Modem Status  Register
   
   USHORT   wDataToggle;
   USHORT   wWcount;
   USHORT   wRcount;
   USHORT   wError;
   USHORT   wEvent;

   SEL      wGDTSel[MAX_GDT_SEL];         // GDT selectors for the read and write buffers
   PRP_RWV  pRPRead[NUM_POINTERS];        // Read Request Packet List
   PRP_RWV  pRPWrite[NUM_POINTERS];       // Write Request Packet List

   SetupPacket setPack;
   SetupPacket setPackS;                  // for SetSignals;   

   UCHAR    bRecNotif[MAX_NOTIF_LEN];     // Received Notification
   UCHAR    bReqData[sizeof(LineCoding)]; // COM Request Data buffer
   UCHAR    bRecData[MAX_DATA_LEN];       // Received Data

   IOQueue  inq;                          // Input  queue
   IOQueue  outq;                         // Output queue

   UCHAR    bValidLineInit;
   UCHAR    bValidLine[TWO_STOPBITS+1][SPACE_PARITY+1][MAX_DATABITS-MIN_DATABITS+1];

} COMInfo, *PCOMInfo;
/*
   Device Control Block Flags1 definitions
*/
#define  F1_DTR_MASK       0x03  // DTR control mask (bits 1,0)
#define  F1_DTR_DISABLE    0x00  //  DTR disable
#define  F1_DTR_ENABLE     0x01  //  DTR enable
#define  F1_DTR_FLOW       0x02  //  DTR input handshaking
#define  F1_DTR_INVALID    0x03  //  DTR invalid input, resulting in a general failure error
#define  F1_OUT_FLOW       0x38  // Output handshaking mask (bits 5,4,3)
#define  F1_OUT_CTS_FLOW   0x08  //  output handshaking using CTS
#define  F1_OUT_DSR_FLOW   0x10  //  output handshaking using DSR
#define  F1_OUT_DCD_FLOW   0x20  //  output handshaking using DCD
#define  F1_IN_DSR_SENSE   0x40  // Enable input sensitivity using DSR
#define  F1_RESERVED       0x84  // Reserved bits 7,2. Set to 0
/*
   Device Control Block Flags2 definitions
*/
#define  F2_OUT_XO         0x01  // Enable Automatic Transmit Control Flow (XON/XOFF)
#define  F2_IN_XO          0x02  // Enable Automatic Receive  Control Flow (XON/XOFF)
#define  F2_ERR_CHAR       0x04  // Enable error replacement character
#define  F2_NULL_STRIP     0x08  // Enable null stripping
#define  F2_BRK_CHAR       0x10  // Enable break replacement character
#define  F2_FULL_DUP       0x20  // Automatic Receive Flow Control (0 = Normal, 1 = Full Duplex)
#define  F2_RTS_MASK       0xc0  // RTS control mask (bits 7,6)
#define  F2_RTS_DISABLE    0x00  //  RTS disable
#define  F2_RTS_ENABLE     0x40  //  RTS enable
#define  F2_RTS_FLOW       0x80  //  RTS input handshaking
#define  F2_RTS_TOGGLE     0xC0  //  RTS toggling on transmit
/*
   Device Control Block Flags3 definitions
*/
#define  F3_W_INF_TO       0x01  // Enable Write Infinite Timeout processing
#define  F3_READ_TO_MASK   0x06  // Read Timeout mask (bits 2,1)
#define  F3_READ_TO_BAD    0x00  //  Invalid input. Results in a general failure error
#define  F3_READ_TO_NORM   0x02  //  Normal Read Timeout processing
#define  F3_READ_TO_WFS    0x04  //  Wait-For-Something Read Timeout processing
#define  F3_READ_TO_NW     0x06  //  No-Wait Read Timeout processing
#define  F3_FIFO_MASK      0x18  // FIFO (Extended Hardware Buffering) mask (bits 4,3)
#define  F3_FIFO_NA        0x00  //  FIFO not supported
#define  F3_FIFO_OFF       0x08  //  FIFO disabled
#define  F3_FIFO_ON        0x10  //  FIFO enabled
#define  F3_FIFO_APO       0x18  //  FIFO Automatic Protocol Override
#define  F3_FIFO_HW_ON     0x10  //  FIFO HW is on (either ON or APO)
#define  F3_RX_MASK        0x60  // Receive Trigger Level mask (bits 6,5)
#define  F3_RX_1           0x00  //   1 character
#define  F3_RX_4           0x20  //   4 characters
#define  F3_RX_8           0x40  //   8 characters
#define  F3_RX_14          0x60  //  14 characters
#define  F3_TX_16          0x80  // Transmit Buffer Load Count (0 = 1 char, 1 = 16 chars)
#define  F3_FIFO_ALL       0xF1  // All the FIFO bits
/*
   Initial values
*/
#define  WRITE_TO_INIT     6000  // 60 seconds
#define  READ_TO_INIT      6000  // 60 seconds

#define  XON_INIT          0x11  // DC1 ^Q
#define  XOFF_INIT         0x13  // DC3 ^S
/*
   Bit Rates (bits per second)
*/
#define  MIN_BITRATE          300   // 600, 1200,...
#define  MAX_BITRATE_WORD   57600
#define  MAX_BITRATE       921600   // 460800, 230400, 115200,...
#define  DEFAULT_BITRATE     9600
/*
   Modem Control Register
*/
#define  MCR_DTR  1
#define  MCR_RTS  2
/*
   Modem Status Register
*/
#define  MSR_DCD    128    // Data Carrier Detect  (V.24 signal 109)
#define  MSR_RI      64    // Ring Indicator       (V.24 signal 125)
#define  MSR_DSR     32    // Data Set Ready       (V.24 signal 107)
#define  MSR_CTS     16    // Clear To Send        (V.24 signal 106)
/*
   COM Error Word
*/
#define  COMERR_FRAMING    8  // LSR
#define  COMERR_PARITY     4  // LSR
#define  COMERR_OVERRUN    2  // LSR
#define  COMERR_QOVERRUN   1  // receive queue overrun
#define  COMERR_MASK      15
/*
   COM Event Word
*/
#define  COMEVENT_RING     256   // Trailing Edge Ring Indicator (MSR bit 2)
#define  COMEVENT_ERROR    128   // COM Error Word
#define  COMEVENT_BREAK     64   // Break Interrupt (LSR bit 4)
#define  COMEVENT_DCD       32   // Delta Data Carrier Detect (MSR bit 3)
#define  COMEVENT_DSR       16   // Delta Data Set Ready (MSR bit 1)
#define  COMEVENT_CTS        8   // Delta Clear to Send (MSR bit 0)
#define  COMEVENT_LAST       4   // last byte is sent
#define  COMEVENT_INQ        1   // byte is placed in IN Queue
/*
   COM Status Byte
*/
#define  COMSTATUS_DSR_REC    128   // receive waiting for DSR to be turned on
#define  COMSTATUS_TRIMM       64   // byte waiting to transmit immeadiately
#define  COMSTATUS_BREAK       32   // transmit waiting because break being transmitted
#define  COMSTATUS_XOFF_TR     16   // transmit waiting because XOFF transmitted
#define  COMSTATUS_XOFF_REC     8   // transmit waiting because XOFF received
#define  COMSTATUS_DCD          4   // transmit waiting for DCD to be turned on
#define  COMSTATUS_DSR_TR       2   // transmit waiting for DSR to be turned on
#define  COMSTATUS_CTS          1   // transmit waiting for CTS to be turned on

