/* SCCSID = "src/dev/usb/USBAUDIO/usbextrn.h, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  usbextrn.h                                              */
/*                                                                            */
/*   DESCRIPTIVE NAME: global external definitions for USBAUDIO DD            */
/*                                                                            */
/*                                                                            */
/*   FUNCTION:   global external definitions for USBAUDIO DD                  */
/*                                                                            */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*                                                                            */
/*   EXTERNAL REFERENCES:	N/A     										               */
/*				                                                                  */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer          Comment                             */
/*  ----    --------  ----------          -------                             */
/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/


//  FUNCTIONS DEFINITION BLOCK //

extern   Strategy();       // IOCTL entry point
extern   VOID ReportFreeBuffer(PSTREAM pStream); // report free buffer to the stream handler
extern   VOID ReportEvent(PSTREAM pStream, BOOL bResetEvent);  // reports events to the stream handler
extern   VOID GetUSBDIDC();  // gets USB driver IDc routine entry point
extern   VOID SetStreamState(PSTREAM pStream, USHORT usState); // sets active stream state
extern   ServeIDCCall();              // Device driver command entry point
extern   VOID FAR USBDIDCEntry(); // USB  driver IDC processing routine
extern   USHORT   RegisterClass();  // registrates USB Audio driver within USBD
extern   VOID   USBAUDIOProcessIRQ(); // process USB interrupts from Audio devices 
extern   VOID   SetConf();  // sets configuration for the device
extern   USHORT DetachDevice(); // process device detacj idc call
extern   VOID SetUnitControl( USHORT deviceIndex, UCHAR bControlSelector, UCHAR  ucChannelNo, USHORT wBufferSize, PUCHAR pData); // sets unit control value for the specified value
extern   VOID FAR PASCAL CTXReportBuffer( VOID ); // re : report free buffer
extern   VOID GetUnitControl( USHORT deviceIndex, UCHAR bControlSelector, UCHAR  ucChannelNo, USHORT wBufferSize, PUCHAR pData, UCHAR ucRequest); // get the ranges for the unit control values
extern   VOID USBSetInterface( USHORT deviceIndex, USHORT altInterface, PSTREAM pStream, BOOL bEnablePlay, USHORT usByPass ); // sets interface for the secified device
extern   VOID USBAUDIOClearStalled( RP_GENIOCTL FAR *pRP_GENIOCTL );// processes USB data transmittion error
extern   ULONG   Audio_IOCTL_Capability(PREQPACKET pPR); // IOCTL capability routine
extern   RC InitNewDevice( VOID ); // initializes new attached devices
extern   UCHAR    CreateStream(ULONG ulSysFileNum); // creates new stream with associated sysfilenum
extern   UCHAR    DestroyStream(USHORT usSysFileNum); // destoys stream
extern   RC       StartDevicePlay(PSTREAM pStream, BOOL bSetInteraface, USHORT usByPass); // initialize isohronous data transmitting interface for the specified device
extern   RC       ResumeDevicePlay(PSTREAM pStream); // resume USB Audio device playing
extern   PULONG GetStreamTime (PSTREAM pStream);  // What is present time in stream
extern   ULONG    GetBuffSize(PSTREAM pStream); // calculates USB related data buffer size
extern   SHORT SetSystemTimer(USHORT); // sets system timer for the specified valu  of interrupts in second
extern   USHORT DevHlp_ResetTimer (PVOID TimerHandler);  // resets system timer irq handler
extern   VOID FAR TimerInterruptHandler(VOID); // system timer irq handler
extern   RC MixerIOCTL(); // mixer IO controls
extern   BOOL     CheckChannelFeature( FUnitDescriptor FAR *featureDesc, USHORT feature, UCHAR channel); // sets cahnnel capabilities
extern   UCHAR    GetChannelCount( FUnitDescriptor FAR *featureDesc); //  gets device channel number
extern   VOID     SetControlCapabilities(UCHAR deviceIndex, ULONG FAR *pulFlags); // sets device control capabilities global data
extern   VOID     SetChannelsCapabilities(USHORT deviceIndex, FUnitDescriptor FAR *featureDesc); // sets channel capabilities for the device in globl data structures
extern   VOID GenerateDetach(UCHAR    controllerId,  UCHAR    deviceAddress);  // emulates detach procedure
extern   RC (*gAudioIOCTLFuncs[])(PREQPACKET pRP); // generic IOCTL`s processing routine 
extern   RC ISOOpen( PSTREAM pStream, USHORT usFrameLength); // opens isohronous data transfer for USB
extern   RC ISOSendBuffer( PSTREAM , USHORT); // sends data buffer to the USB Audio device
extern   RC ISOClose(VOID); // closes isohrounous data transfer pipe for the device
extern   RC ISOStatus( UCHAR FAR *FAR *ppBuffer, USHORT FAR *usBytes); // returns current status of iso buffer having played
extern   RC ISOCancel( CHAR FAR *FAR * ppBuffer, USHORT FAR *ulBytes); // cancels device to play remained buffers
extern   BOOL GetBestFit( UCHAR   FAR *configurationData, // calculates best fit for the current active device and current stream data format
                                UCHAR     bNumConfigurations,
                                UCHAR     bConfigurationValue,
                                UCHAR     interface,
                                ULONG FAR     *dataType,
                                ULONG FAR    *samplingRate,
                                ULONG FAR    *channels,
                                ULONG FAR    *bitsPerSample,
                                UCHAR FAR    *altInterface
                               );
extern   USHORT GetUnitControlValue(USHORT usValue, USHORT usMinValue, USHORT usMaxValue ); // gets current unit control value for the device

#ifdef CONVERTER
extern   void SignConverter(ULONG FAR *pBuffer, USHORT usBuffLen); // converter  PCM8->PCM and vv
#endif




//  STRUCTURES DEFINITIONS BLOCK //
extern   GLOBAL GlobalTable; // Gloabl variables table
extern   IDCTABLE gDDTable;  // Device Driver table
extern   HRESOURCE hResPorts[];    // global handles to port resources
extern   AudioDevice gAudioDevices[MAX_AUDIO_DEVICES];   // active device list served by USBAUDIO
extern   USB_AUDIO_CHANGE gUSBAC; // audio cahnge control block for USB Audio
extern   EVENT_QUEUE aEventQueue[DEFAULTSTREAMS][MAX_EVENT_QUEUE]; // Events queue
extern   MCI_AUDIO_CHANGE FAR *gpRP_AC; // MCI audio change control block
extern   MCI_AUDIO_CHANGE  gAC;     // MCI audio change control block
extern   MCI_AUDIO_CHANGE  gOLDAC;  // MCI audio change control block
extern   USBSetConf gSC; // Set configuration control block
extern   SetupPacket gSetupPacket[]; // Setup packet control block
extern   SetupPacket gReadSetupPacket[]; // Setup packet control block
extern   SetupPacket gsp ; // Setup packet control block
extern   USBDetach gDetachData; // Detach data
extern   RP_GENIOCTL gRP; // Generic IOCTL request packet
extern   PRP_GENIOCTL gpRP; // poiner to the Generic IOCTL request packet
extern   DRIVERSTRUCT gDriverStruct; // driver`s structure 




//   VARIABLES DEFINITIONS //

extern   ULONG gDevOperation;  // current device operation
extern   ULONG gulSamplingFreq;  //  sampling freq for the current stream
extern   ULONG gulBitsPerSample;  // bits per sample value for the current stream
extern   ULONG gFlags; // current stream flags
extern   ULONG gPCMTable[NUMFREQS][BPSTYPES][MONOSTEREO]; // PCM datatypes 3d array
extern   ULONG gALaw[NUMFREQS][MONOSTEREO]; // ALAW datatypes 2D array
extern   ULONG gMuLaw[NUMFREQS][MONOSTEREO]; // MULAW datatypes 2D array
extern   ULONG gRBHandle; // RB handle

extern   USHORT gMaxAudioIOCTLFuncs; // number of audio IOCTL functions
extern   USHORT gTicks; // system timer ticks value
extern   USHORT gusChannels; // channels no for the current active stream
extern   USHORT gMessageIDs[]; // Verbose messages
extern   USHORT gMessageCount; // Verbose messages counter
extern   USHORT EndOfData;  // end of data pointer
extern   USHORT usInUse;   
extern   USHORT gVerbose; // Verbose parameter
extern   USHORT gNoOfActiveAudioDevices; // number of active USB Audio devices
extern   USHORT gNumOfOpens; // number of opens for the USB Audio  driver
extern   USHORT gUSBDds; // USB Driver Data segment value


extern   CHAR   gUSBDName[]; // USB driver name
extern   UCHAR  gSPIdx;  // setup packet index
extern   UCHAR  gReadSPIdx; // read setup packet index
extern   UCHAR  gAltInterface; // current alternative interface for the active device
extern          LastCode;  // `end of data` pointer


extern   BOOL   gbTimerIntHooked; // shows, if system timer` int is hooked
extern   BOOL   gbActiveDeviceSupport; // shows if the current active device supports current stream sound data format
extern   BOOL   gbISOOpened; // shows if isohrounous pipe is open
extern   BOOL   gbByPassBuffer; // shows, have we to bypass next data bufffer or not (if all USB Audio devices are detached )
extern   BOOL   gStartReject; // shows, if we have to start reject buffers ( for ALL attached devices)

extern   PSZ    gVMessages[];  // Verbose messages
extern   PFN    Device_Help; // devhlp entry handler
extern   PUSBIDCEntry   gpUSBDIDC; // USB driver IDC entry point handler
extern   PSTREAM pStreamVirt;   // virtual address of the stream saved in InitStreams()


#ifdef DEBUG
extern USHORT gAMsg; // debug print message level
#endif



