/* SCCSID = "src/dev/usb/USBAUDIO/RMHELP.C, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  RMHELP.C                                              */
/*                                                                            */
/*   DESCRIPTIVE NAME: Helpers to interface RM subsystem to usbaudio code.    */
/*                                                                            */
/*                                                                            */
/*   FUNCTION:  (see above)                                                   */
/*                                                                            */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*                                                                            */
/*                                                                            */
/*                                                                            */         
/*                                                                            */
/*   EXTERNAL REFERENCES:													               */
/*				                                                                  */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer          Comment                             */
/*  ----    --------  ----------          -------                             */
/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/


#define INCL_NOPMAPI
#include <os2.h>

#include "rmhelp.h"  // brings in rmcalls.h


/* Set the DRIVERSTRUCT and ADAPTERSTRUCT data areas      */


/* Driver Description   (rmbase.h)              */
DRIVERSTRUCT gDriverStruct =
{
   NULL,                                     /* DrvrName     */
   "USB Audio Device Driver",                /* DrvrDescript */
   "IBM",                                    /* VendorName   */
   CMVERSION_MAJOR,                          /* MajorVer     */
   CMVERSION_MINOR,                          /* MinorVer     */
   1998,10,26,                               /* Date         */
   DRF_STATIC,                               /* DrvrFlags    */
   DRT_AUDIO,                                /* DrvrType     */
   0,                                        /* DrvrSubType  */
   NULL                                      /* DrvrCallback */
};

/* Adapter Description  (rmbase.h)              */
ADAPTERSTRUCT gAdapterStruct =
{
  "USB Audio Class Adapter",         /* AdaptDescriptName; */
  AS_NO16MB_ADDRESS_LIMIT,           /* AdaptFlags;        */
  AS_BASE_MMEDIA,                    /* BaseType;          */
  AS_SUB_MM_AUDIO,                   /* SubType;           */
  AS_INTF_GENERIC,                   /* InterfaceType;     */
  AS_HOSTBUS_PCI,                    /* HostBusType;       */
  AS_BUSWIDTH_32BIT,                 /* HostBusWidth;      */
  NULL                               /* pAdjunctList;      */
};


/************************************************/
/* GLOBAL VARS FOR RM                           */
/*                                              */
/* RM.LIB needs these declared                  */
/************************************************/
PFN             RM_Help               = 0L;  /*VPNP*/
PFN             RM_Help0              = 0L;  /*VPNP*/
PFN             RM_Help3              = 0L;  /*VPNP*/
ULONG           RMFlags               = 0L;  /*VPNP*/

/************************************************/
/* GLOBAL HANDLE VARIABLES                      */
/*                                              */
/* These variables get the handles for          */
/* drivers, adapter (only 1), and resources.    */
/* The RMHELP wrappers are written so that most */
/* drivers using RMHELP as a template will not  */
/* have to reference these directly.            */
/*                                              */
/************************************************/

HDRIVER   hDriver = NULL;      // global handle to driver
HADAPTER  hAdapter = NULL;     // global handle to adapter


/**********************************************************/
/* RMHELP_CreateDriver - registers to RM susbsystem       */
/*                       (which initializes the DD to     */
/*                        RM connection)                  */
/*                                                        */
/* ARGS:                                                  */
/*                                                        */
/* PSZ DrvrName - ptr to driver name (taken from command  */
/*                line)                                   */
/*                                                        */
/* HINT (Using this generically):                         */
/*                                                        */
/* This function is a thin wrapper for the RMCreateDriver */
/* call. Modifications for specific drivers might include */
/* adding more parameters to be set into the              */
/* DriverStruct and actually returning the hDriver        */
/* to the caller (instead of maintaining it in a global   */
/* var). In any case, modifications to the gDriverStruct   */
/* declared above will have to made.                      */
/**********************************************************/

USHORT RMHELP_CreateDriver( PSZ DrvrName)
{
   gDriverStruct.DrvrName = DrvrName;   // set the driver name
   return( RMCreateDriver( &gDriverStruct, &hDriver)); // Allocate Driver Handle 

}

/**********************************************************/
/* RMHELP_DestroyDriver - deregisters the driver from     */
/*                        RM sub-system and releases all  */
/*                        claimed resources               */
/*                                                        */
/* HINT (Using this generically):                         */
/*                                                        */
/* This function is a thin wrapper for the RMDestroyDriver*/
/* call. Modifications for specific drivers might include */
/* adding a parameter for hDriver, if RMCreateDriver has  */
/* been modified to return it to the DD layer.            */
/*                                                        */
/**********************************************************/

VOID RMHELP_DestroyDriver( VOID)
{
   RMDestroyDriver( hDriver);
}

/**********************************************************/
/* RMHELP_CreateAdapter - tells RM to associate adapter   */
/*                        to driver and resources to      */
/*                        adapater                        */
/*                                                        */
/* HINT (Using this generically):                         */
/*                                                        */
/* This function builds up the AHRESOURCE array for the   */
/* the call to RMCreateAdapter. To modify this for a      */
/* specfic DD the handles to resource variables set into  */
/* the array will have to be touched along with the lines */
/* that set the NumResource. Also, gAdapterStruct (see    */
/* above) will have to be set up apropriately.            */
/*                                                        */
/**********************************************************/

USHORT RMHELP_CreateAdapter( VOID)
{
   UCHAR       ResourceBuf[12];
   PAHRESOURCE pResourceList = (PAHRESOURCE)ResourceBuf;
   ADJUNCT     AdjAdaptNum;

   pResourceList->NumResource  = 0;
   AdjAdaptNum.pNextAdj        = NULL;
   AdjAdaptNum.AdjLength       = sizeof(ADJUNCT);
   AdjAdaptNum.AdjType         = ADJ_ADAPTER_NUMBER;
   AdjAdaptNum.Adapter_Number  = 0;
   gAdapterStruct.pAdjunctList = &AdjAdaptNum;


   return ( RMCreateAdapter( hDriver,
                             &hAdapter,
                             &gAdapterStruct,
                             NULL,
                             pResourceList));
}


