/* SCCSID = "src/dev/usb/USBAUDIO/CDEVHELP.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  CDEVHELP.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  C functional prototype interface for OS/2 DevHlp      */
/*                      services.                                             */
/*                                                                            */
/*   FUNCTION:                                                                */
/*                                                                            */
/*                                                                            */
/*   NOTES:            Uses 'C' calling conventions                           */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:   N/A                                                      */
/*                                                                            */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer          Comment                             */
/*  ----    --------  ----------          -------                             */
/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/


//  allocates Global Descriptor table selector
USHORT  DevHlp_AllocGDTSelector ( ULONG ulNumGDTSelectors, PVOID paGDTSel );
// allocates physical memory 
USHORT  DevHlp_AllocPhys ( ULONG  BlockSize, USHORT Location, PVOID pRetAddr );
// attaches DD :)
USHORT  DevHlp_AttachDD  ( PUCHAR TargetDDname, PATTACHAREA AttachDDArea );
// gets tick count from the timer
USHORT DevHlp_TickCount (PVOID TimerHandler, USHORT tickCount);
// converts physical address to Global Descriptor Table selector
USHORT  DevHlp_PhysToGDTSelector (  PVOID  PhysAddress, ULONG  ByteLength, USHORT Selector );
// converts physical address to virtual
USHORT  DevHlp_PhysToVirt (  PVOID  PhysAddress, LONG Size, PVOID pRetAddress );
// registers Physical device driver
USHORT  DevHlp_RegisterPDD (  NPSZ  pszPDDName, PVOID pfnPDDFunction );
// converts virtual adress to linear
USHORT  DevHlp_VirtToLin (  USHORT  Selector, ULONG OffsetAddress, PVOID pRetLinAddress);
// converts virtual address to physical
USHORT  DevHlp_VirtToPhys ( PVOID  VirtAddress, PVOID pRetPhysAddress );
// resets timer int handler
USHORT  DevHlp_ResetTimer  ( PVOID TimerHandler );
