;/* SCCSID = "src/dev/usb/USBAUDIO/CDEVHLP.ASM, usb, c.basedd 98/07/10" */
;/*
;*   Licensed Material -- Property of IBM
;*
;*   (c) Copyright IBM Corp. 1998  All Rights Reserved
;*/
;************************** START OF SPECIFICATIONS *****************************/
;*                                                                              */
;*   SOURCE FILE NAME:  CDEVHLP.ASM                                             */
;*                                                                              */
;*   DESCRIPTIVE NAME:  'C' interface for OS/2 devhelp calls                    */
;*                                                                              */
;*                                                                              */
;*   FUNCTION: This module provides the interface mechanism to translate a 'C'  */
;*             stacked based devhelp call to a MASM register based OS/2 devhelp */
;*             call.                                                            */
;*   NOTES:                                                                     */
;*      DEPENDENCIES: None                                                      */
;*      RESTRICTIONS: None                                                      */
;*                                                                              */
;*   ENTRY POINTS: _DevHlp_AllocGDTSelector                                     */
;*                 _DevHlp_AllocPhys                                            */
;*                 _DevHlp_PhysToGDTSelector                                    */
;*                 _DevHlp_PhysToVirt                                           */
;*                 _DevHlp_VirtToLin                                            */
;*                 _DevHlp_VirtToPhys                                           */
;*                 _DevHlp_ABIOSCall                                            */
;*                 _DevHlp_GetLIDEntry                                          */
;*                 _DevHlp_FreeLIDEntry                                         */         
;*                                                                              */
;*   EXTERNAL REFERENCES (system):  Far calls to OS/2 kernal DevHlp routines.   */
;*				                                                 */
;*                                                                              */
;* Change Log                                                                   */
;*                                                                              */
;*  Mark    yy/mm/dd  Programmer          Comment                               */
;*  ----    --------  ----------          -------                               */
;*          98/10/17  Vjacheslav Chibis   Original developer.                   */
;*                                                                              */
;**************************** END OF SPECIFICATIONS *****************************/
        PAGE    80,132
        .386p

REGISTERPDD       EQU 050H
SETTIMER          EQU 01DH
SETIRQ            EQU 01BH
UNSETIRQ          EQU 1CH
RESETTIMER        EQU 1EH
ALLOCPHYS         EQU 018H
FREEPHYS          EQU 019H
ALLOCGDTSELECTOR  EQU 02DH
PHYSTOGDTSEL      EQU 054H
VMALLOC           EQU 57H
VIRTTOLIN         EQU 05BH
VMFREE            EQU 058H
LINTOGDTSELECTOR  EQU 05CH
PHYSTOUVIRT       EQU 17H


        TITLE   CDEVHLP - 'C' INTERFACE FOR DEVHELP CALLS
        SUBTTL  'C' DEVHLP
        NAME    DEVHLPs




;******************************************************************************
;                       I N C L U D E S
;******************************************************************************

.xlist
include devhlp.inc
.list

;******************************************************************************
;                       E X T E R N S
;******************************************************************************
_DATA   SEGMENT WORD PUBLIC USE16 'DATA'
        EXTRN   _DevHlp:DWORD
_DATA   ENDS

;******************************************************************************
;                   D A T A   D E C L A R A T I O N S
;******************************************************************************

;******************************************************************************
;                           C O D E
;******************************************************************************

_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'
        ASSUME cs:_TEXT

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_AllocGDTSelector
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_AllocGDTSelector
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: ULONG block size in bytes
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document ES:DI contains locaton of array
;*               of words of GDT's.
;*
;* EXIT_ERROR: 'Carry flag set' and AX=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_AllocGDTSelector
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_AllocGDTSelector proc near
        PUBLIC  _DevHlp_AllocGDTSelector
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
NumGDTSelectors EQU     <[bp+4]>
paGDTSel        EQU     <[bp+8]>        ; seg:off of GDT array
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    cx
        push    dx
        push    di
        push    es

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     es,WORD PTR paGDTSel+2          ; get seg.
        mov     di,WORD PTR paGDTSel            ; get off.
        mov     cx,NumGDTSelectors
        mov     dl,DevHlp_AllocGDTSelector
        call    [_DevHlp]
        jc      allocgdt
        xor     ax,ax                           ; clear for no error
allocgdt:
        pop     es
        pop     di
        pop     dx
        pop     cx
        pop     bp
        ret
_DevHlp_AllocGDTSelector endp

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_AllocPhys
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_AllocPhys
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: ULONG block size in bytes
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document ax:bx = 32 bit physical addr
;*               AX = 0
;*
;* EXIT_ERROR: AX=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_AllocPhys
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_AllocPhys proc near
        PUBLIC  _DevHlp_AllocPhys
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
BytesLo         EQU     <[bp+4]>        ; memory block size
BytesHi         EQU     <[bp+6]>
Location        EQU     <[bp+8]>        ; above or below 1MB
pRetAddress     EQU     <[bp+10]>       ; 32bit address to allocated memory blk

        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    bx
        push    dx
        push    es

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     bx,BytesLo
        mov     ax,BytesHi
        mov     dh,BYTE PTR Location            ; 0=above 1MB
        mov     dl,DevHlp_AllocPhys             ; 1=below 1MB
        call    [_DevHlp]
        jc      allocphyss

        mov     dx,bx                           ; Need bx for addressing
        les     bx,pRetAddress                  ; Dereference address of
                                                ; callers variable
        mov     es:[bx+2],ax                    ; Return high 16 bits and
        mov     es:[bx],dx                      ; Low 16 bits (flat pointer)

        xor     ax,ax                           ; clear ax => no error
allocphyss:
        pop     es
        pop     dx
        pop     bx
        pop     bp                              ; restore callers frame
        ret
_DevHlp_AllocPhys endp

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_AttachDD
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_AttachDD
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: seg:offset of target dd name, offset of attach area
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_AttachDD        PROC    NEAR
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
TargetDDName    EQU     <[bp+4]>        ; get offset only
AttachDDArea    EQU     <[bp+8]>
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    bx
        push    di
        push    dx

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        xor     ax,ax                           ; clear ax for return code
        mov     bx,WORD PTR TargetDDName
        mov     di,WORD PTR AttachDDArea
        mov     dl,DevHlp_AttachDD
        call    [_DevHlp]
        jc      attachdd_err
        jmp     attachdd_ok

attachdd_err:
        mov     ax,-1                           ; set error for 'C' code
        jmp     attachdd_exit

attachdd_ok:
        xor     ax,ax                           ; clear for no error
attachdd_exit:
        pop     dx
        pop     di
        pop     bx
        pop     bp
        ret
_DevHlp_AttachDD        ENDP
;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_PhysToGDTSelector
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_PhysToGDTSelector
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: 32bit physical address, length of segment, selector to setup
;*
;* EXIT-NORMAL: Refer to OS/2 devhelp api document
;*              ptr that contained 32bit physaddrr is now a sel:off.
;*              AX = 0
;*
;* EXIT_ERROR: ax=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_PhysToGDTSelector
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_PhysToGDTSelector proc near
        PUBLIC  _DevHlp_PhysToGDTSelector
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
PhysAddress     EQU     <[bp+4]>
ByteLength      EQU     <[bp+8]>
Selector        EQU     <[bp+12]>
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    bx
        push    cx
        push    dx
        push    si

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR PhysAddress+2
        mov     bx,WORD PTR PhysAddress
        mov     cx,ByteLength
        mov     si,Selector
        mov     dl,DevHlp_PhysToGDTSelector
        call    DWORD PTR [_DevHlp]      ; return error in ax if CF
        jc      physToGDT
        xor     ax,ax
physToGDT:
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     bp
        ret
_DevHlp_PhysToGDTSelector endp



;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_PhysToVirt
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_PhysVirt
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: ULONG block size in bytes
;*
;* EXIT-NORMAL: Refer to OS/2 devhelp api document ax:bx = 32 bit physical addr
;*              AX = 0
;*
;* EXIT_ERROR: ax=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_PhysToVirt
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_PhysToVirt proc near
        PUBLIC  _DevHlp_PhysToVirt
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
PhysAddress     EQU     <[bp+4]>        ; physical address
BlockSize       EQU     <[bp+8]>        ; block size
pRetAddress     EQU     <[bp+12]>       ; address of returned virtual pointer
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx
        push    es
        push    di
        push    ds
        push    si

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR PhysAddress+2
        mov     bx,WORD PTR PhysAddress
        mov     cx,BlockSize
        xor     dh,dh
        mov     dl,DevHlp_PhysToVirt
        call    [_DevHlp]
        jc      physvirterr

        les     di,pRetAddress                  ; de-reference pointer
        mov     es:[di+2],ds                    ; hi word (return ds:si)
        mov     es:[di],si                      ; lo word
        xor     ax,ax                           ; clear for no error

physvirterr:
        pop     si
        pop     ds
        pop     di
        pop     es
        pop     dx
        pop     bp
        ret
_DevHlp_PhysToVirt endp

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_RegisterPDD
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_RegisterPDD
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL: Refer to OS/2 devhelp api document
;*              AX = 0
;*
;* EXIT_ERROR: ax = -1
;*
;* EFFECTS:  Registers:
;*                               
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_RegisterPDD
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_RegisterPDD proc near
        PUBLIC  _DevHlp_RegisterPDD
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
pszPDDName      EQU     <[bp+4]>        ; word
pfnPDDFunction  EQU     <[bp+6]>        ; dword
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    si
        push    dx
        push    ds
        push    es

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     si,pszPDDName           ; DS:SI = ptr to ASCIIZ PDD name
        mov     es,pfnPDDFunction+2     ; ES:DI = ptr to PDD entry point
        mov     di,pfnPDDFunction
        mov     dl,DevHlp_RegisterPDD
        call    DWORD PTR [_DevHlp]     ; return error in ax if CF
        jc      RegisterPDDErr

        xor     ax, ax                  ; Success, RC = zero
        jmp     RegisterPDDDone

RegisterPDDErr:
        mov     ax,-1

RegisterPDDDone:
        pop     es
        pop     ds
        pop     dx
        pop     si
        pop     bp
        ret
_DevHlp_RegisterPDD endp

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_VirtToLin
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_VirtToLin
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_VirtToLin
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_VirtToLin       PROC    NEAR
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
Selector        EQU     <[bp+4]>                ; word
OffsetAddress   EQU     <[bp+6]>                ; dword
pRetLinAddress  EQU     <[bp+10]>               ; pVOID
        push    bp
        mov     bp,sp                           ; allocate NULL stack frame
        push    ebx
        push    esi
        push    edx

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR Selector
        or      ax,ax
        jnz     VirtLinSel
        mov     ax,_DATA
VirtLinSel:
        mov     esi,OffsetAddress
        mov     dl,DevHlp_VirtToLin
        call    DWORD PTR [_DevHlp]             ; return error in ax if CF
        jc      VirtLinErr

        xor     ebx,ebx
        push    ds
        lds     bx,pRetLinAddress               ; load full ptr
        mov     [ebx],eax
        pop     ds
        xor     eax,eax                         ; clear any 'c' error

VirtLinErr:
        pop     edx
        pop     esi
        pop     ebx
        pop     bp
        ret
_DevHlp_VirtToLin       ENDP

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_VirtToPhys
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_VirtToPhys
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL: Refer to OS/2 devhelp api document
;*              AX = 0
;*
;* EXIT_ERROR: ax = -1
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_VirtToPhys
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_VirtToPhys proc near
        PUBLIC  _DevHlp_VirtToPhys
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
VirtAddress     EQU     <[bp+4]>        ; dword
pRetPhysAddress EQU     <[bp+8]>        ; dword
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    si
        push    dx
        push    ds

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        lds     si,VirtAddress
        mov     dl,DevHlp_VirtToPhys
        call    DWORD PTR [_DevHlp]     ; return error in ax if CF
        jc      VirtPhysErr

        les     si,pRetPhysAddress      ; de-reference pointer
        mov     es:[si+2],ax            ; Return high word
        mov     es:[si],bx              ; Return low word
        xor     ax, ax                  ; Success, RC = zero
        jmp     VirtPhysDone

VirtPhysErr:
        mov     ax,-1

VirtPhysDone:
        pop     ds
        pop     dx
        pop     si
        pop     bp
        ret
_DevHlp_VirtToPhys endp

public _SetSystemTimer
_SetSystemTimer proc near
;    This function adds a timer handler to the list of timer handlers to be
; called on every timer tick.
;    The function receives the address of the service routine on the stack.
;    The function returns the value 0 if successful. Otherwise, the function
; returns the value -1.

SERV_ROUTINE_OFFSET equ <[bp+4]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   dx

    ; set up pdd's function address offset in ax
        mov    ax,SERV_ROUTINE_OFFSET

    ; set up code for device help function
        mov    dl,SETTIMER

    ; call device help function
        call   dword ptr [_Devhlp]
        mov    ax,0
        jnc    done2
        mov    ax,-1

   ;restore registers
done2:  pop    dx
        pop    bp

   ;done
        ret
_SetSystemTimer endp

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_ResetTimer
;*
;* DESCRIPTIVE NAME: Remove a timer handler for the physical device driver
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:    OS/2 timer ticks are at 32ms interval.   
;*
;* ENTRY POINTS:  _DevHlp_ResetTimer
;* LINKAGE:   CALL NEAR
;*
;* INPUT: PVOID  TimerHandler:  Timer handler
;*
;* EXIT-NORMAL: AX = 0
;*
;* EXIT_ERROR:  AX=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_ResetTimer
;*
;* SEE ALSO: _DevHlp_TickCount, _DevHlp_SetTimer
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_ResetTimer proc near
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
TimerHandler    EQU     <[bp+4]>        ; timer handler address (CS assumed)
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx
        push    es
        push    di
        push    ds
        push    si

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR TimerHandler
        mov     dl,DevHlp_ResetTimer
        call    [_DevHlp]
        jc      resettimererr

        xor     ax,ax                           ; clear for no error
        jmp     resettimernoerr

resettimererr:
        mov     ax,-1

resettimernoerr:
        pop     si
        pop     ds
        pop     di
        pop     es
        pop     dx
        pop     bp
        ret
_DevHlp_ResetTimer endp


;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_TickCount
;*
;* DESCRIPTIVE NAME: Register a new timer handler or modifies a previously
;*                   registered timer handler
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:    OS/2 timer ticks are at 32ms interval.   
;*
;* ENTRY POINTS:  _DevHlp_TickCount
;* LINKAGE:   CALL NEAR
;*
;* INPUT: PVOID  TimerHandler:  Timer handler
;*        USHORT tickCount:     # of tick count expires before timer handler is called
;*
;* EXIT-NORMAL: AX = 0
;*
;* EXIT_ERROR:  AX=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_TickCount
;*
;* SEE ALSO: _DevHlp_SetTimer, _DevHlp_ResetTimer
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_TickCount proc near
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
TimerHandler    EQU     <[bp+4]>        ; timer handler address (CS assumed)
tickCount       EQU     <[bp+8]>        ; number of tick count
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx
        push    es
        push    di
        push    ds
        push    si

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR TimerHandler
        mov     bx,WORD PTR tickCount
        mov     dl,DevHlp_TickCount
        call    [_DevHlp]
        jc      tickcounterr

        xor     ax,ax                           ; clear for no error
        jmp     tickcountnoerr

tickcounterr:
        mov     ax,-1

tickcountnoerr:
        pop     si
        pop     ds
        pop     di
        pop     es
        pop     dx
        pop     bp
        ret
_DevHlp_TickCount endp

_TEXT   ENDS
        END
        
