/* SCCSID = "src/dev/usb/USBAUDIO/AUDSUBS.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  AUDSUBS.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Audio device driver subroutines header                */
/*                                                                            */
/*                                                                            */
/*   FUNCTION: Audio device driver subroutines header                         */
/*                                                                            */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  N/A                                                       */
/*                                                                            */
/*                                                                            */
/*   EXTERNAL REFERENCES:													               */
/*				                                                                  */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer          Comment                             */
/*  ----    --------  ----------          -------                             */
/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/*
** Reference file audsubs.c for information
** on these routines.
*/

/*
** Updates stream position to account for completion
** of present operation and returns a pointer to
** present position (counter).
*/

PULONG   GetStreamTime (   PSTREAM pStream);  // gets current stream time
VOID     SetStreamTime (   PSTREAM pStream, ULONG ulSetPos);  // sets current stream time
VOID     SetStreamState(   PSTREAM pStream, USHORT usState); // sets state for the current stream
VOID     DevClose      (   ULONG ulSysFileNum); // closes the device driver
VOID     DevChange     (   MCI_AUDIO_CHANGE FAR *pRP_AC);         // Change device type
USHORT   DevOpen       (   ULONG ulSysFileNum);  // opens the device driver

SHORT SetSystemTimer(USHORT);  // sets system timer for the specified interrupt time 

// adds event in events queue
RC EnqueueEvent (HEVENT hEvent, ULONG ulCuePoint, PSTREAM pStream);
// removes the event form the events queue
RC DequeueEvent (HEVENT hEvent, PSTREAM pStream);

// searchs for the stream 
PSTREAM GetFileStream (ULONG SysFileNum );

// gets best fit values for the specified audio data format in according with device capabilities
BOOL GetBestFit( UCHAR   FAR *configurationData,
                                UCHAR     bNumConfigurations,
                                UCHAR     bConfigurationValue,
                                UCHAR     interface,
                                ULONG FAR     *dataType,
                                ULONG FAR    *samplingRate,
                                ULONG FAR    *channels,
                                ULONG FAR    *bitsPerSample,
                                UCHAR FAR    *altInterface
                               );

// checks if the channel can perform the specified operation
BOOL CheckChannelFeature( FUnitDescriptor FAR *featureDesc, USHORT feature, UCHAR channel);

// Gets max channel count  for the device
UCHAR GetChannelCount( FUnitDescriptor FAR *featureDesc);

//sets control capabilities in device global data structires
VOID SetControlCapabilities(UCHAR deviceIndex, ULONG FAR *pulFlags);               

//sets channels control capabilities in device global data structires
VOID SetChannelsCapabilities(USHORT deviceIndex, FUnitDescriptor FAR *featureDesc); 

//transoforms control value to USB format
USHORT GetUnitControlValue(USHORT usValue, USHORT usMinValue, USHORT usMaxValue );
