
/* SCCSID = "src/dev/usb/USBAUDIO/AUDIODD.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  AUDIODD.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Audio device driver function                          */
/*                      prototypes and externs of global data.                */
/*                                                                            */
/*   FUNCTION:                                                                */
/*                                                                            */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*                                                                            */
/*   EXTERNAL REFERENCES:													               */
/*				                                                                  */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer          Comment                             */
/*  ----    --------  ----------          -------                             */
/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/****************************************************************************/
/*                       T Y P E  D E F S                                   */
/****************************************************************************/


typedef SHORT (PASCAL FAR  *FPFUNCTION) ();     // Pascal call to DevHlp routines

//ͻ
//                      D E F I N E S                                                      
//ͼ
#define DEFAULTSTREAMS  15
#define MAXIOBUFFS      3
#define MAXIOBUFFSIZE DEFAULT_IOBUFF_SIZE*2

#define NPROTOCOLS      25
#define NUM_TRACKS       2
#define PDD_VERISON     0x0501          // 05 - means the highest ulfunc this PDD can accept from VDD
                                        // 01 - means the highest ulFunc this PDD will send to the VDD

// Global descriptor table definitions
#define  NUMGDTS 2L
#define	GDT_PSTREAM     0

//ͻ
//                 D A T A   S T R U C T U R E S                                          
//ͼ


// Stream data structure definition
typedef struct _stream
   {
   HSTREAM         hStream;            // Unique stream handle
   UCHAR           ucRemained;
   UCHAR           ucBuffers;
   ULONG           ulSysFileNum;       // id from kernel PDDs have associated file handle.
   ULONG           ulOperation;        // eg OPERATION_PLAY
   ULONG           ulFlags;            // State flags for this stream
   PVOID           ADSHEntry;          // IDC entrypoint into stream handler
   EVENT_QUEUE    *pEventQueue;         // pointer to event queue
   USHORT          usTrackNum;         // Which track does this stream use
   USHORT          usFrameSize;        // USB isohronous buffer size
   ULONG           ulCumTime;          // Current real-time stream position
   USHORT          usMode;             // Current stream mode (MIDI, ALAW, MULAW, PCM)
   ULONG           ulSamplingFreq;     // Frequence  
   ULONG           ulBitsPerSample;    // Bits per sample
   ULONG           ulBSize;            // Block size
   USHORT          usChannels;         // Channels no
   USHORT          usCurrIOBuffIndex;  // index into current iobuff struct
   USHORT          usFreeIOBuffIndex;  // index into next iobuff struct
   USHORT          usLastIOBuffIndex;  // index into last played iobuff struct
   USB_AUDIO_IOBUFFER IOBuff[ MAXIOBUFFS ] ;
   } STREAM ;

typedef STREAM far *PSTREAM;


/*   STREAM ulFlags     */
#define     STREAM_STREAMING             0x0002L
#define     STREAM_PAUSED                0x0004L
#define     STREAM_STOPPED               0x0008L
#define     STREAM_REGISTERED            0x0010L

/***************************************
 *   IOBuff usRunFlags
 * These are for the IOBuff defined in
 * Audio.h. (MMPM/2 Toolkit header file)
 ***************************************/
#define     IOB_STOPPED             0x0002L
#define     IOB_PAUSED              0x0004L
#define     IOB_STARTED             0x0008L
#define     IOB_RUNNING             0x0010L
#define     IOB_OVERRUN             0x0020L
#define     IOB_UNDERRUN            0x0040L
#define     IOB_CHAIN_BUFFERS       0x0080L

// Control values setting for USB device 
typedef struct _USB_Audio_Change{
              USHORT usLeftVolume;
              USHORT usRightVolume;
              UCHAR  ucLeftBass;
              UCHAR  ucRightBass;
              UCHAR  ucLeftTreble;
              UCHAR  ucRightTreble;
} USB_AUDIO_CHANGE;

// DD global table
typedef struct _global{
                PSTREAM         paStream;        // array ptr of stream structs
                BOOL            fInited;
                USHORT          usMaxNumStreams; // max # of streams from argument line
                UCHAR           ucActiveDeviceIndex;
                BOOL            bFirstEntry;
                BOOL            bRegistered;
            } GLOBAL;

typedef GLOBAL *PGLOBAL;        // Pointer to statically allocated global data


typedef struct  _protocol_table {
                        ULONG   ulDataType;       // Characteristics of
                        ULONG   ulDataSubType;    // stream types that this
                        ULONG   ulBufSize;        // PDD supports.
                        ULONG   ulNumBufs;        // no of buffers
                        ULONG   ulSampleRate;     // sampling frequence
                        USHORT  usChannels;       // channels number
                        USHORT  usBitsPerSample;  // bits per sample value
                        } PROTOCOLTABLE;


USHORT FindMatchingSampleRate(PULONG pulSampleRate);




/* usInUse Flag */
#define AVAILABLE       0                       // PDD available
#define NOT_AVAILABLE   2                       // PDD  not available for use by VDM
#define VDM             4                       // PDD  in use by VDM


/*************************************************************************/
/* Device driver structures follow.                                      */
/*************************************************************************/

/*  Request Packet status bit values */
#define RPERR     0x8000   /*  error occurred, error code in RPstatuserr   */
#define RPDEV     0x4000   /*  also set ERR; error code defined by DD      */
#define RPBUSY    0x0200   /*  device is busy                              */
#define RPDONE    0x0100   /*  DD all done with request packet             */
#define RPBADCMD  0x0003   /*  DD recieved a bad command                   */
#define RPGENFAIL 0x000C   /* return error: General failure */




#define DDNAME_BUFSIZE 8                      /* size of device driver name */
//#define AUDIO_ATTRIB    DEV_CHAR_DEV | DEV_IOCTL | DEV_SHARE | DEV_30 | DEVLEV_2 | DEV_GIOCTL

/* type definitons */
typedef struct {                   /* template for device header */
   ULONG    next;                  /* next driver in chain */
   USHORT   attrib;                /* attribute */
   USHORT   strategy_entry;        /* offset of strategy routine */
   NPVOID   idc_entry;             /* offset of IDC routine */
   UCHAR    name[DDNAME_BUFSIZE];  /* device driver name */
   UCHAR    reserved[8];           /* reserved */
   ULONG    capablities;           /* capabilities strip */
} DEVHDR;





/*  AttachDD Inter-device driver communication data area */
typedef struct AttachArea {
        USHORT  realOFF;        /* real-mode offset of idc entry point  */
        USHORT  realCS;         /* real-mode CS of IDC entry point      */
        USHORT  realDS;         /* real-mode DS of IDC DD               */
        USHORT  protOFF;        /* protect-mode offset of entry point   */
        USHORT  protCS;         /* protect-mode CS of entry point       */
        USHORT  protDS;         /* protect-mode DS of other DD          */
        } ATTACHAREA;


/*  The Request Packet */
typedef struct {                            // template for request header 

  UCHAR  RPlength;                            // request packet length 
  UCHAR  RPunit;                              // unit code for block DD only 
  UCHAR  RPcommand;                           // command code 
  USHORT RPstatus;                           // return status 
  UCHAR  RPreserved[4];                       // reserved bytes 
  ULONG  RPqlink;                             // queue linkage 

  union {                                  // command-specific data 

     struct {
        UCHAR dummy1;
        FPFUNCTION  DevHlp;              // dev help address 
        CHAR *argP;                        // argument pointer 
        UCHAR dummy3;
     } Init;

     struct {
        UCHAR dummy1;
        USHORT finalCS;                   // final code offset 
        USHORT finalDS;                   // final data offset 
        ULONG dummy2;
        UCHAR dummy3;
     } InitExit;

     struct {
        UCHAR category;                    // category code 
        UCHAR function;                    // function code 
        VOID FAR *parameters;                  // address of parameter buffer 
        VOID FAR *buffer;                   // address of data buffer 
        USHORT sysfilenum;               // system file number 
     } IOCtl;

     struct {
        USHORT sys_file_num;
     } open;

     struct {
        USHORT sys_file_num;

     } close;

  } s;

} REQPACKET;


typedef DEVHDR     near    *PDEVHDR;            // Ptr to device driver header
typedef ATTACHAREA near    *PATTACHAREA;        // Ptr to attachDD area
typedef REQPACKET  far     *PREQPACKET;         // ptr to request packet
typedef PREQPACKET far     *PPREQPACKET;
typedef PREQPACKET         QHEAD;               // Queue Head is &ReqPacket
typedef QHEAD      near    *PQHEAD;



/****************************************************************************/
/*              F U N C T I O N   P R O T O T Y P E S                       */
/****************************************************************************/

//**************************************************
//      IOCTL  routines
//**************************************************
RC  StrategyEntry    (  PREQPACKET pRP);
RC  IOCTL_Init    (  PREQPACKET pRP);
RC  IOCTL_Open    (  PREQPACKET pRP);
RC  IOCTL_Close   (  PREQPACKET pRP);                    
RC  IOCTL_Invalid (  PREQPACKET pRP);
RC  IOCTL_GenIOCtl(  PREQPACKET pRP);
RC  IOCTL_InitComplete (  PREQPACKET pRP);




//**************************************************
//      STANDARD AUDIO IOCTL  routines
//**************************************************
RC   Audio_IOCTL_Init(PREQPACKET pRP);
RC   Audio_IOCTL_Status(PREQPACKET pRP);
RC   Audio_IOCTL_Control(PREQPACKET pRP);
RC   Audio_IOCTL_Buffer(PREQPACKET pRP);
RC   Audio_IOCTL_Load(PREQPACKET pRP);
RC   Audio_IOCTL_Wait(PREQPACKET pRP);
RC   Audio_IOCTL_Hpi(PREQPACKET pRP);
RC   Audio_IOCTL_Load(PREQPACKET pRP);
RC   Audio_IOCTL_Capability(PREQPACKET pRP);
RC   Audio_IOCTL_Update(PREQPACKET pRP);

/*****************************************************/
/*  STREAM routines                                  */
/*****************************************************/
RC      InitStreams(VOID);
UCHAR   CreateStream(ULONG ulSysFileNum);
UCHAR   DestroyStream(USHORT usSysFileNum);


/*****************************************************/
/*  Device Communication routines                    */
/*****************************************************/
RC      StartDevicePlay(PSTREAM pStream, BOOL bSetInterface, USHORT usByPass);
RC      ResumeDevicePlay(PSTREAM pStream);
USHORT  SendFirstBuffers(PSTREAM pStream, USHORT usByPass);
VOID   InitEventQueue(VOID);
