/* SCCSID = "src/dev/usb/USBAUDIO/AUDIODAT.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  AUDIODAT.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB Audio DD Data global definitions                  */
/*                                                                            */
/*                                                                            */
/*   FUNCTION: USB Audio DD Data global definitions                           */
/*                                                                            */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:    N/A                                                     */
/*   EXTERNAL REFERENCES: None 												               */
/*				                                                                  */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer          Comment                             */
/*  ----    --------  ----------          -------                             */
/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/
#define USBAUDIO_MAX_REPORT_LENGTH 0x200
#define MAX_EVENT_QUEUE    15         // max # of events a stream can have
#define MAX_AUDIO_DEVICES  0x10  // Maximal number of USB Audio devices attached simultaniously
#define NO_BYPASS 8
#define BYPASS    4
#define MAX_NUM_BUF_ELEMENTS 10 
#define NULL_HANDLE 0xffffffff


// definitions for audio buffers indexes                                
#define NOT_LAST_BUFFER 1
#define LAST_BUFFER     0x20
#define NEXTLAST_BUFFER 0x40

                                     
   // stream states
#define STREAM_STATE_STOP     0      
#define STREAM_STATE_START    1
#define STREAM_STATE_PAUSE    2
#define STREAM_STATE_RESUME   3

// stream operations
#define STREAM_OPERATION_PLAY     0        
#define STREAM_OPERATION_RECORD   1

// data formats                                              
#define STREAM_DATA_FORMAT_PCM    0           
#define STREAM_DATA_FORMAT_MU_LAW 1
#define STREAM_DATA_FORMAT_A_LAW  2

// possible stream inputs
#define STREAM_INPUT_NULL 0                
#define STREAM_INPUT_STEREO_LINE 1
#define STREAM_INPUT_MIC 2
#define STREAM_INPUT_BOOSTED_MIC 3

// possible stream outputs
#define STREAM_OUTPUT_NULL 0               
#define STREAM_OUTPUT_STEREO_LINE 1


// channel control support flags used in Feature Unit Descriptor
#define  CHANNEL_FEATURE_MUTE       0x0001
#define  CHANNEL_FEATURE_VOLUME     0x0002
#define  CHANNEL_FEATURE_BASS       0x0004
#define  CHANNEL_FEATURE_MID        0x0008
#define  CHANNEL_FEATURE_TREBLE     0x0010
#define  CHANNEL_FEATURE_GEQ        0x0020   // graphic equalizer
#define  CHANNEL_FEATURE_AGAIN      0x0040   // automatic gain
#define  CHANNEL_FEATURE_DELAY      0x0080
#define  CHANNEL_FEATURE_BBOOST     0x0100
#define  CHANNEL_FEATURE_LOUDNESS   0x0200


// definitions for IRQ requests
#define  USBAUD_IRQ_STATUS_SETCONF        1
#define  USBAUD_IRQ_STATUS_SETINTF        2
#define  USBAUD_IRQ_STATUS_READINT        3
#define  USBAUD_IRQ_STATUS_INTRCVED       4
#define  USBAUD_IRQ_STATUS_SERVCLIENT     5
#define  USBAUD_IRQ_STATUS_SETIDLE        6
#define  USBAUD_IRQ_STATUS_SETPROTOCOL    7
#define  USBAUD_IRQ_STATUS_REPRETRIEVED   8
#define  USBAUD_IRQ_STATUS_SETUNITCTRL    9
#define  USBAUD_IRQ_STATUS_SETMIXCTRL     10
#define  USBAUD_IRQ_STATUS_SENDDATA       11
#define  USBAUD_IRQ_STATUS_SETFREQ        12
#define  USBAUD_IRQ_STATUS_GETFREQ        13
#define  USBAUD_IRQ_STATUS_GETUNITCTRL    14
#define  USBAUD_IRQ_STATUS_SETPAUSE       15
#define  USBAUD_IRQ_STATUS_SETRESUME      16
#define  USBAUD_IRQ_STATUS_SETSTOP        17
#define  USBAUD_IRQ_STATUS_ISO_SENDDATA   20

// IRQ clear stalled definition
#define  IRQ_CLEARSTALLED                 0x99

// definitions for data types
#define NUMFREQS   4
#define MONOSTEREO 2
#define BPSTYPES   2


// Definitions for USB controls
#define MASTER_CHANNEL 0x00
#define LEFT_CHANNEL   0x01
#define RIGHT_CHANNEL  0x02


//  Device setup packet`s definitions
#define MAX_SETUP_PACKETS  0xFF
#define MAX_READ_SETUP_PACKETS  0xFF

// definitions for OS/2 maximal control values
#define MAX_VOLUME      0x7FFFFFFl
#define MAX_BASS        0x7FFFFFFl
#define MAX_TREBLE      0x7FFFFFFl

// definitions for maximal USb control  values                                              
#define USB_MAX_VOLUME  0x7FFF
#define USB_MAX_BASS    0x7F
#define USB_MAX_TREBLE  0x7F
#define MAX_USB_CHANNELS 0x10 
#define DEFAULT_IOBUFF_SIZE 0x4000// default value for isohrounous buffer size


// initialization time message IDs
#define  INIT_MESSAGE_LOADED        0
#define  INIT_MESSAGE_NO_USBD       1
#define  INIT_MESSAGE_INVNUMERIC    2
#define  INIT_MESSAGE_UNKNOWNKWD    3

#define  MAX_INIT_MESSAGE_COUNT     2 


                                                
// Audio buffer structure definition
typedef struct _USB_AUDIO_IOBUFFER
{  /* iobuffer */
   BOOL      bEmpty;  // is buffer empty or not
   ULONG     lSize;   // size of buffer in bytes
   CHAR FAR *pHead;   // far pointer to buffer head
   CHAR FAR *pTail;   // far pointer to buffer tail
   LONG      lCount;  // bytes count in buffer in bytes
   ULONG     ulPosition; // current position in the buffer in bytes
   USHORT    usRunFlags; // buffer status flags
   CHAR FAR *pBuffer;    // far pointer to the buffer
} USB_AUDIO_IOBUFFER;

// Event structure definition
typedef struct _eventQueue
{
   HEVENT         hEvent;      // event handle
   ULONG          ulCuePoint;  // que point in ms
} EVENT_QUEUE;

// USB Audio device structure definition
typedef struct _AudioDevice
{
   UCHAR                   ucControlInterface;   // control interface ID for the device
   UCHAR                   ucStreamingInterface; // streaming interface ID for the device
   UCHAR                   ucStreamingPipe;  // streaming pipe ID 
   UCHAR                   ucMIDIInterface;  // MIDI interface 
   UCHAR                   ucMIDIPipe;       // MIDI pipe ID
   UCHAR                   ucFeatureUnitID;  // Feature Unit control ID
   UCHAR                   ucAltInterface;   // alternative interface for the data format for this device
   UCHAR                   ucOldAltInterface;// previous alt interface value
   ULONG                   ulVolume;         // Current device volume setting
   ULONG                   ulBalance;        // Current device balance setting
   ULONG                   ulTreble;         // Current device treble setting
   ULONG                   ulBass;           // current device  Bass setting
   USHORT                  usMaxVolume[MAX_USB_CHANNELS]; // possible max volume value for the device
   USHORT                  usMinVolume[MAX_USB_CHANNELS]; // possible min volume value for the device
   USHORT                  ucMaxBass[MAX_USB_CHANNELS];   // possible max bass value for the device
   USHORT                  ucMinBass[MAX_USB_CHANNELS];   // possible min bass value for the device
   USHORT                  ucMaxTreble[MAX_USB_CHANNELS]; // possible max treble value for the device
   USHORT                  ucMinTreble[MAX_USB_CHANNELS];  // possible min treble value for the device
   DeviceInfo          FAR *pDeviceInfo;     // (00) far pointer to device data
   DeviceConfiguration FAR *devConf;         // (04) far pointer to device configuration data
   SetupPacket             stdPacket;        // (08) setup packet buffer
   SetupPacket             cstPacket;        // (16) setup packet buffer to clear stalled
   UCHAR                   configuration;    // (30) device status buffer
   UCHAR                   bNumConfigurations; // no of configurations for the device
   UCHAR                   ucChannels; // device channels number
   ULONG                   ulDevCh[MAX_USB_CHANNELS];  // device channels capabilities
}  AudioDevice;
