/* SCCSID = "src/dev/usb/USBAUDIO/AUDIOCOM.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  AUDIOCOM.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Audio communication                                   */
/*                                                                            */
/*                                                                            */
/*   FUNCTION: The function of this file is to support  communication with    */
/*                basic USB device drivers                                    */
/*                                                                            */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  N/A                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES:	USBDIDCEntry  - USB Driver IDC entry point         */
/*				                                                                  */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer          Comment                             */
/*  ----    --------  ----------          -------                             */
/*          98/10/17  Vjacheslav Chibis   Original developer.                 */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

VOID     GetUSBDIDC( VOID ); // Get USB Driver IDC entry point
VOID     FAR USBDIDCEntry( PRP_GENIOCTL pRP_GENIOCTL );  // USB driver IDc routine entry point
VOID     CheckForService( PRP_GENIOCTL pRP_GENIOCTL ); // Check new attached device for Audio class 
VOID     USBAUDIOProcessIRQ( PRP_GENIOCTL pRP_GENIOCTL ); // USB interrupts processing routine
VOID     SetUnitControl( USHORT deviceIndex,     // Sets control settings e.g. volume, bass, treble etc.
                         UCHAR bControlSelector,
                         UCHAR  ucChannelNo,
                         USHORT wBufferSize,
                         PUCHAR pData);

VOID     GetUnitControl( USHORT deviceIndex,  // Gets possible setting`s range for the specified conrol e.g. volume, bass, treble
                         UCHAR  bControlSelector,
                         UCHAR  ucChannelNo,
                         USHORT wBufferSize,
                         PUCHAR pData,
                         UCHAR  ucRequest);


VOID     USBSetInterface( USHORT deviceIndex,  // Sets interface for specified USB Audio device
                          USHORT altInterface,
                          PSTREAM pStream,
                          BOOL bEnablePlay ,
                          USHORT usByPass);

VOID     USBAUDIOClearStalled( RP_GENIOCTL FAR *pRP_GENIOCTL );  // Processes error in data transmition
VOID     SetConf( PRP_GENIOCTL pRP_GENIOCTL );  // Sets configuration for the specified device
VOID     GenerateDetach(UCHAR controllerId,  UCHAR deviceAddress);  // Emulates detach operation for the specified device

USHORT   DetachDevice( PRP_GENIOCTL pRP_GENIOCTL ); // Detaches the specified device
USHORT   RegisterClass(VOID);  // Registrates USBAUDIO.SYS with USB Driver 
RC       GetNextBuffer (PSTREAM pStream);  // Gets next buffer to play
static FUnitDescriptor FAR * GetFeatureUnitDesc( UCHAR FAR *configurationData,  // get feauturre unit descriptor value
                               UCHAR bNumConfigurations,
                               UCHAR bConfigurationValue,
                               UCHAR interface);
