/* SCCSID = "src/dev/usb/UHCI/UHCTYPE.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  UHCTYPE.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  UHCI compliant device driver TYPEDEF include file.    */
/*                                                                            */
/*   FUNCTION: This module is UHCI compliant device driver                    */
/*             TYPEDEF and flag definition include file.                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/01/31  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/
#ifndef  _uhctype_h_
   #define  _uhctype_h_

// initialization time message IDs
   #define  INIT_MESSAGE_LOADED        0
   #define  INIT_MESSAGE_LOADED_DET0   1
   #define  INIT_MESSAGE_NODEVICE      2
   #define  INIT_MESSAGE_NOSDEVICE     3
   #define  INIT_MESSAGE_PCISPECS      4
   #define  INIT_MESSAGE_SETIRQFAILED  5
   #define  INIT_MESSAGE_SETCTXFAILED  6
   #define  INIT_MESSAGE_SETTMEFAILED  7
   #define  INIT_MESSAGE_INVNUMERIC    8
   #define  INIT_MESSAGE_UNKNOWNKWD    9

// max no of messages in message queue
   #define  MAX_INIT_MESSAGE_COUNT     3

   #define  ROOT_HUB_TIME_INTERVAL     40    // time interval to serve root hub requests
   #define  ROOT_HUB_RESET_RETRIES     100   // no of times to repeat 1 ms wait intervals to finish host reset
   #define  ROOT_HUB_FEATURE_RETRIES   5     // no of retries to enable root hub port
   #define  ROOT_MAX_REQ               3     // max requests to root hub
   #define  MAX_USB_CMD                0x1f  // max strategy command implemented
   #define  USB_PORT_COUNT             0x14  // no of I/O ports used by USB Host

   #define  MAX_FRAME_LENGTH           4096+8000  // UHCI driver data area size in dwords
   #define  MAX_SCHEDULE_ENTRIES       1024  // no of entries in HC schedule table
   #define  MAX_SCHEDULE_LEHGTH        4096  // HC schedule table length in bytes

   #define  TOP_QH_COUNT               10    // no allocation entries reserved for top level QHs
   #define  BOT_QH_COUNT               10    // no allocation entries reserved for bottom level QHs

   #define  USB_ZERO_PACKET            0x7ff // packet length used to indicate empty packet

/* UHCI compliant USB Host/Controller I/O register offsets      */
   #define  UHCI_IOREGW_USBCMD       0x0000   // R/W   USB Command
   #define  UHCI_IOREGW_USBSTS       0x0002   // R/WC  USB Status
   #define  UHCI_IOREGW_USBINTR      0x0004   // R/W   USB Interrupt Enable
   #define  UHCI_IOREGW_FRNUM        0x0006   // R/W   Frame Number
   #define  UHCI_IOREGD_FRBASEADD    0x0008   // R/W   Frame List Base Address
   #define  UHCI_IOREGB_SOFMOD       0x000c   // R/W   Start Of Frame Modify
   #define  UHCI_IOREGW_PORTSC1      0x0010   // R/WC  Port 1 Status Control
   #define  UHCI_IOREGW_PORTSC2      0x0012   // R/WC  Port 2 Status Control

/* Command Register bit definitions                            */
   #define  UHCI_USBCMD_MAXP64       0x0080   // Max Packet. 1=64 bytes, 0=32 bytes
   #define  UHCI_USBCMD_CF           0x0040   // Configure Flag
   #define  UHCI_USBCMD_SWDBG        0x0020   // Software Debug. 1=Debug Mode. 0=Normal Mode
   #define  UHCI_USBCMD_FGR          0x0010   // Force Global Resume
   #define  UHCI_USBCMD_EGSM         0x0008   // Enter Global Suspemd Mode
   #define  UHCI_USBCMD_GRESET       0x0004   // Global Reset
   #define  UHCI_USBCMD_HCRESET      0x0002   // Host Controller Reset
   #define  UHCI_USBCMD_RS           0x0001   // Run/Stop

/* Status Register bit definitions                            */
   #define  UHCI_USBSTS_HALTED       0x0020   // HCHalted
   #define  UHCI_USBSTS_HCPE         0x0010   // Host Controller Process Error
   #define  UHCI_USBSTS_HSE          0x0008   // Host System error
   #define  UHCI_USBSTS_RDE          0x0004   // Resume Detect
   #define  UHCI_USBSTS_USBEI        0x0002   // USB Error Interrupt
   #define  UHCI_USBSTS_USBI         0x0001   // USB Interrupt (USBINT)

/* Interrupt Enable Register bit definitions                            */
   #define  UHCI_USBINTR_SPIE        0x0008   // Short Packet Interrupt Enable
   #define  UHCI_USBINTR_IOCE        0x0004   // Interrupt on Complete Enable
   #define  UHCI_USBINTR_RIE         0x0002   // Resume Interrupt Enable
   #define  UHCI_USBINTR_TCRCIE      0x0001   // Timeout/CRC Interrupt Enable

/* Frame Number Register bit definitions                            */
   #define  UHCI_FRNUM_MASK          0x03FF   // Frame Number Mask   // 25/08/98 MB

/* Frame List Base Address Register bit definitions                            */
   #define  UHCI_FLBAS_MASK          0xFFFFF000   // Frame List Base Address Mask

/* Port Status and Control Register bit definitions                            */
   #define  UHCI_PORTSC_SUSPEND      0x1000   // Suspend
   #define  UHCI_PORTSC_RESET        0x0200   // Port Reset
   #define  UHCI_PORTSC_LSDA         0x0100   // Low Speed Device Attached
   #define  UHCI_PORTSC_RESUMEDET    0x0040   // Resume Detect
   #define  UHCI_PORTSC_LINESTATUS   0x0030   // Line Status mask
   #define  UHCI_PORTSC_PEDC         0x0008   // Port Enable/Disable Change
   #define  UHCI_PORTSC_PED          0x0004   // Port Enabled/Disabled
   #define  UHCI_PORTSC_CSC          0x0002   // Connect Status Change
   #define  UHCI_PORTSC_CCS          0x0001   // Current Connect Status

// port change bitmap definitions
   #define  UHCI_PORT1_STATUS_CHANGED  0x02
   #define  UHCI_PORT2_STATUS_CHANGED  0x04

/* List Pointer bit definitions                            */
   #define  UHCI_LP_MASK            0xfffffff0   // List Pointer address Mask
   #define  UHCI_LP_V               0x00000004   // Depth/Breadth Select. 1=Depth, 0=Breadth
   #define  UHCI_LP_Q               0x00000002   // QH/TD Select. 1=QH, 0=TD
   #define  UHCI_LP_T               0x00000001   // Treminate. 1= LP field not valid, 0= pointer is valid
   #define  UHCI_LP_UNUSED          0xffffffff   //   unused TD/QH entry mark
   
   #define  UHCI_UNUSED_FRAMEINDEX  0xffff

/* Transfer Descriptor                                            */
typedef struct _TD_
{  // UHCI required fields
   ULONG          LP;                  // (00) Link Pointer to another TD or HQ
   ULONG          ctrlStat;            // (04) TD Control and Status
   ULONG          token;               // (08) TD token
   ULONG          bufferPointer;       // (12) TD buffer pointer
   // implementation defined fields
   ULONG          phyTDAddr;           // (16) TD's physical address
   UCHAR          elementType;         // (20) element type - TD, several QH types
   UCHAR          category;            // (21) IRQ processing category (receiver ID)
   PUCHAR         virtBufferPointer;   // (22) Buffer's virtual address
   struct _TD_    *virtLP;             // (26) Virtual Address of Link Pointer
   PUSBIDCEntry   usbIDC;              // (28) IRQ extension IDC addr
   USHORT         usbDS;               // (32) extension IDC DS value
   UCHAR          deviceAddress;       // (34) device address
   UCHAR          endPointId;          // (35) device endpoint ID
   ULONG          requestData1;        // (36) data to be stored within request
   ULONG          requestData2;        // (40) data to be stored within request
   ULONG          requestData3;        // (44) data to be stored within request
                                       // (48)
}  TD;

   #define  TD_CTRLSTAT_SPD                 0x20000000  // Short Packet Detect
   #define  TD_CTRLSTAT_ERRCNT_MASK         0x18000000  // Error count field mask
   #define  TD_CTRLSTAT_LSD                 0x04000000  // Low Speed Device
   #define  TD_CTRLSTAT_IOS                 0x02000000  // Isohronous Transfer Descriptor
   #define  TD_CTRLSTAT_IOC                 0x01000000  // Interrupt on Complete
   #define  TD_CTRLSTAT_STATUS_MASK         0x00ff0000  // Status field mask
   #define  TD_CTRLSTAT_STATUS_ERRMASK      0x007f0000  // Status field erorr mask
   #define  TD_CTRLSTAT_STATUS_ACTIVE       0x00800000  // Active TD
   #define  TD_CTRLSTAT_STATUS_STALLED      0x00400000  // Device stalled
   #define  TD_CTRLSTAT_STATUS_DBUFERR      0x00200000  // Data Buffer Error
   #define  TD_CTRLSTAT_STATUS_BABBLE       0x00100000  // Babble detected
   #define  TD_CTRLSTAT_STATUS_NAK          0x00080000  // NAK received
   #define  TD_CTRLSTAT_STATUS_CRC          0x00040000  // CRC/Time Out Error
   #define  TD_CTRLSTAT_STATUS_BITSTUFF     0x00020000  // Bitstuff Error
   #define  TD_CTRLSTAT_ACTLEN_MASK         0x000007ff  // Actual length field mask

   #define  TD_TOKEN_MAXLEN_MASK            0xffe00000  // Max length field mask
   #define  TD_TOKEN_DATA_TOGGLE            0x00080000  // Data Toggle
   #define  TD_TOKEN_ENDPOINT_MASK          0x00078000  // Endpoint ID
   #define  TD_TOKEN_DEVADDRESS_MASK        0x00007f00  // Device Address
   #define  TD_TOKEN_PID_IN                 0x00000069  // IN packet
   #define  TD_TOKEN_PID_OUT                0x000000e1  // OUT packet
   #define  TD_TOKEN_PID_SETUP              0x0000002d  // SETUP packet
   #define  TD_TOKEN_PID_MASK               0x000000ff  // packet ID mask

/* Queue Head                                                     */
typedef struct _QH_
{
   ULONG       qhLink;           // (00) Queue Head link pointer
   ULONG       qeLink;           // (04) Queue Element link pointer
   // implementation defined fields
   struct _QH_ *qhLinkVirt;      // (08) Queue Head link pointer
   struct _QH_ *qeLinkVirt;      // (10) Queue Element link pointer
   USHORT      minTime;          // (12) min service time for top level QH, 0 for other level QH's
   USHORT      maxTime;          // (14) max service time for top level QH, 0 for other level QH's
   ULONG       phyTDAddr;        // (16) QH's physical address
   UCHAR       elementType;      // (20) element type - TD, several QH types
   UCHAR       reserved;         // (21) not used
   struct _QH_ *parentQH;        // (22) parent QH virtual address
   struct _QH_ *intrptQH;        // (24) interrupt QH virtual address
   struct _QH_ *controlQH;       // (26) controll QH virtual address
   struct _QH_ *bulkQH;          // (28) bulk QH virtual address
   struct _QH_ *rIntrptQH;       // (30) reclamation interrupt QH virtual address
   struct _QH_ *rControlQH;      // (32) reclamation control QH virtual address
   struct _QH_ *rBulkQH;         // (34) reclamation bulk QH virtual address
   ULONG       pktBandwidth;     // (36) required bandwith to execute TD's pointed by this QH
   struct _QH_ *prevBotQH;       // (40) pointer to previous bottom level QH
   struct _QH_ *nextBotQH;       // (42) pointer to next bottom level QH
                                 // (44)
}  QH;

// QH/TD element types
   #define  ELEMENT_TYPE_TD            1
   #define  ELEMENT_TYPE_LASTD         2
   #define  ELEMENT_TYPE_QH_TOP        3
   #define  ELEMENT_TYPE_QH_STRUC      4
   #define  ELEMENT_TYPE_QH_BOT        5

// root hub processing status definitions
   #define  ROOT_HUB_NOREQ             0
   #define  ROOT_HUB_PROCESSING        1
   #define  ROOT_HUB_REQ               2

typedef struct _root_hub_conf
{
   DeviceConfiguration  configuration;
   DeviceInterface      interface;
   DeviceEndpoint       endpoints;
}  RootHubConfiguration;

// default address request timeout value in root hub polling cycles
   #define  DEFADDR_TIME_OUT           10

// packet transmission time calculation constants
   #define  TTIME_HOST_DELAY            0L
   #define  TTIME_HUB_LS_SETUP          4000L
   
// data structures used for Isohronous request processing
/* Transfer Descriptor                                            */
typedef struct _isoTD_
{  // UHCI required fields
   ULONG          LP;                  // (00) Link Pointer to another TD or HQ
   ULONG          ctrlStat;            // (04) TD Control and Status
   ULONG          token;               // (08) TD token
   ULONG          bufferPointer;       // (12) TD buffer pointer
                                       // (16)
}  ISOTD;

// isohronous buffer information structure
typedef struct _isobuffs_
{
   PUCHAR         buffVirtAddr;  // (00) buffer virtual address
   USHORT         buffLength;    // (04) buffer length
   USHORT         irqFrameIndex; // (06) last frame index with interrupt on complete flag on
   ULONG          buffPhysAddr;  // (08) buffer physical address
   ULONG          lastByteAddr;  // (12) last byte address
   ULONG          lastUsedAddr;  // (16) last scheduled data address
   ULONG          requestData1;  // (20) data to be stored within request
   ULONG          requestData2;  // (24) data to be stored within request
   ULONG          requestData3;  // (28) data to be stored within request
                                 // (32)
}  ISOBUFFS;

// isohronous request data structure
typedef struct _isods_
{
   struct _isods_ FAR      *next;                     // (00)  pointer to next iso data block
   struct _isods_ FAR      *previous;                 // (04)  pointer to previous iso data block
   UCHAR                   deviceAddress;             // (08)  device address
   UCHAR                   endPointId;                // (09)  target endpoint address
   USHORT                  flags;                     // (10)  saved request flags (see IORB)
   ULONG                   physAddress;               // (12)  data block physical address
   SEL                     gdtSelector;               // (16)  data block GDT selector
   ULONG                   targetDevAddr;             // (18)  device&endpoint addrs in TD token form
   USHORT                  maxBuffers;                // (22)  buffInfo table length
   USHORT                  currBuffCount;             // (24)  current buffer count
   USHORT                  activeBuffIndex;           // (22)  last unprocessed buffer index
   USHORT                  lastUsedFrame;             // (24)  last schedule frame index
   USHORT                  isoFrameLength;            // (26)  no of bytes to be transfered during single frame
   ULONG                   tdProcessingTime;          // (28)  required frame bandwidth
   PUSBIDCEntry            usbIDC;                    // (32) IRQ rtne address
   USHORT                  usbDS;                     // (36) IRQ rtne DS value
   UCHAR                   category;                  // (38) callers category
   ULONG                   requestData1;              // (39) data to be stored within request
   ULONG                   requestData2;              // (43) data to be stored within request
   ULONG                   requestData3;              // (47) data to be stored within request
   ULONG                   tdPhyAddr;                 // (51) first TD physical address
   ISOTD                   td[MAX_SCHEDULE_ENTRIES];  // (55)
   ISOBUFFS                bufInfo[1];                // () buffer information
}  ISOINFO;

typedef struct _notifData_
{
   PUCHAR                  buffVirtAddr;              // (00) processed buffer virtual address
   USHORT                  buffLength;                // (04) processed data length
   ULONG                   requestData1;              // (06) user data1
   ULONG                   requestData2;              // (10) user data2
   ULONG                   requestData3;              // (14) user data3
                                                      // (18)
}  NOTIFDATA;

#define  ISO_IRQ_DELAY     512   // 
#define  ISO_SERVICE_DELAY 20    //
 
//
//  Shut Down Request Packet
//
typedef struct _RPSHDOWN  {               /* RPSHDOWN */

  RPH           rph;          // standard request packet header
  UCHAR         functionCode; // shutdown function code - start/end shutdown
  ULONG         reserved;     // reserved for future use
} RPSHDOWN;

#define  START_SHUTDOWN    0
#define  END_SHUTDOWN      1

#endif

