/* SCCSID = "src/dev/usb/UHCI/UHCSTRAT.C, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  UHCSTRAT.C                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  UHCD device driver strategy routine.                  */
/*                                                                            */
/*   FUNCTION: These routines handle the task time routines for the strategy  */
/*             entry point of UHCD device driver.                             */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             UHCIStrategy                                                   */
/*             CmdError                                                       */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/01/31  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include        "uhci.h"

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  UHCIStrategy                                     */
/*                                                                    */
/* DESCRIPTIVE NAME:  Strategy 1 entry point for the UHCD device      */
/*                    driver.                                         */
/*                                                                    */
/* FUNCTION:  The function of this routine is pass the kernel         */
/*            request packet to strategy worker routine.              */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Task/Initialization time                                  */
/*                                                                    */
/* ENTRY POINT:  UHCIStrategy                                         */
/*    LINKAGE:  CALL FAR                                              */
/*                                                                    */
/* INPUT:  es:bx -> kernel request packet                             */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS: None                                                      */
/*                                                                    */
/* INTERNAL REFERENCES:  None                                         */
/*                                                                    */
/* EXTERNAL REFERENCES:  None                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
#pragma optimize("eglt", off)
void far UHCIStrategy()
{
   RPH FAR      *pRP;
   USHORT       Cmd;

   //  get request block address 
   _asm
   {
      mov word ptr pRP[0], bx
      mov word ptr pRP[2], es
   }

   Cmd = pRP->Cmd;
#ifdef DEBUG
   dsPrint1( DBG_HLVLFLOW, "UHCI: UHCIStrategy entered: CMD=%x\r\n", (ULONG)Cmd );
#endif

   if (Cmd > MAX_USB_CMD)
   {
      CmdError( pRP );
   }
   else
   {
      /*---------------------*/
      /* Call Worker Routine */
      /*---------------------*/
      (*gStratList[Cmd])(pRP);
   }
#ifdef DEBUG
   dsPrint2( DBG_HLVLFLOW, "UHCI: UHCIStrategy Exit: CMD = %x, Status=%x\r\n", (ULONG)Cmd, pRP->Status );
#endif

}
#pragma optimize("", on)

/********************** START OF SPECIFICATIONS ***********************/
/*                                                                    */
/* SUBROUTINE NAME:  CmdError                                         */
/*                                                                    */
/* DESCRIPTIVE NAME:  Command not supported in the device driver      */
/*                                                                    */
/* FUNCTION:  The function of this routine is to return command not   */
/*            supported for the request.                              */
/*                                                                    */
/* NOTES: This is an immediate command that is not put on the FIFO    */
/*        queue.                                                      */
/*                                                                    */
/* CONTEXT: Task time                                                 */
/*                                                                    */
/* ENTRY POINT:  CmdError                                             */
/*    LINKAGE:  CALL NEAR                                             */
/*                                                                    */
/* INPUT:  pRP-> kernel request packet                                */
/*                                                                    */
/* EXIT-NORMAL: N/A                                                   */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS: pRP->Status = STDON + STERR + ERROR_I24_BAD_COMMAND       */
/*                                                                    */
/* INTERNAL REFERENCES:  None                                         */
/*                                                                    */
/* EXTERNAL REFERENCES:  None                                         */
/*                                                                    */
/************************ END OF SPECIFICATIONS ***********************/
void CmdError( RPH FAR *pRP)
{
#ifdef DEBUG
   dsPrint1( DBG_CRITICAL, "UHCI: CmdError - Strategy Command = %d\r\n", pRP->Cmd );
#endif

   pRP->Status = STDON + STERR + ERROR_I24_BAD_COMMAND;
   return;
} 
