/* SCCSID = "src/dev/usb/UHCI/UHCIDC.C, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  USBIDC.C                                              */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB device driver inter-device driver                 */
/*                      communication routines.                               */
/*                                                                            */
/*   FUNCTION: These routines handle the PDD-PDD IDC for the                  */
/*             UHCI compliant USB Host device driver.                         */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             UHCIidc          PDD - PDD IDC Entry Point                     */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/01/16  MB              Original developer.                     */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "uhci.h"

/******************* START OF SPECIFICATIONS **************************/
/*                                                                    */
/* SUBROUTINE NAME:  UHCIidc                                          */
/*                                                                    */
/* DESCRIPTIVE NAME:  PDD-PDD IDC entry point and request router      */
/*                                                                    */
/* FUNCTION:  This routine is the PDD-PDD IDC entry point and         */
/*            request router..  IDC function requests are routed      */
/*            to the appropriate worker routine.  The address of      */
/*            this routine is returned to other device drivers via    */
/*            the DevHelp AttachDD call.                              */
/*                                                                    */
/* NOTES:                                                             */
/*                                                                    */
/* CONTEXT: Task Time                                                 */
/*                                                                    */
/* ENTRY POINT :  UHCIidc                                             */
/*    LINKAGE  :  CALL FAR                                            */
/*                                                                    */
/* INPUT:  RP_GENIOCTL FAR *pRP_GENIOCTL                              */
/*                                                                    */
/* EXIT-NORMAL:  N/A                                                  */
/*                                                                    */
/* EXIT-ERROR:  N/A                                                   */
/*                                                                    */
/* EFFECTS:  pRP_GENIOCTL->rph.Status - return code                   */
/*                                                                    */
/* INTERNAL REFERENCES:  UHCICancelIO                                 */
/*    ROUTINES:          UHCIAcceptIO                                 */
/*                       UHCIResetHost                                */
/*                                                                    */
/* EXTERNAL REFERENCES:  None                                         */
/*    ROUTINES:                                                       */
/*                                                                    */
/******************* END  OF  SPECIFICATIONS **************************/
void FAR UHCIidc( RP_GENIOCTL FAR *pRP_GENIOCTL )
{
   if (!pRP_GENIOCTL)
      return;

#ifdef   DEBUG
   dsPrint3(DBG_HLVLFLOW, "UHCI: UHCIidc entered: Category=%x, Function=%x, Status=%x\r\n",
            pRP_GENIOCTL->Category,pRP_GENIOCTL->Function,pRP_GENIOCTL->rph.Status);
#endif

   pRP_GENIOCTL->rph.Status=USB_IDC_RC_OK;

   // check for correct command request and non-zero parameter packet address
   if (pRP_GENIOCTL->rph.Cmd!=CMDGenIOCTL || !pRP_GENIOCTL->ParmPacket)
      pRP_GENIOCTL->rph.Status=USB_IDC_RC_PARMERR;

   if (pRP_GENIOCTL->rph.Status==USB_IDC_RC_OK)
      switch (pRP_GENIOCTL->Category)
      {
      case USB_IDC_CATEGORY_HOST:
         switch (pRP_GENIOCTL->Function)
         {
         case USB_IDC_FUNCTION_CANCEL:
            UHCICancelIO( pRP_GENIOCTL );
            break;
         case USB_IDC_FUNCTION_ACCIO:
            UHCIAcceptIO( pRP_GENIOCTL );         
            break;
         case USB_IDC_FUNCTION_RSTHOST:
            UHCIResetHost( pRP_GENIOCTL );         
            break;
#ifdef   DEBUG
         case USB_IDC_FUNCTION_FINIO:
            UHCIFinIO( pRP_GENIOCTL );         
            break;
#endif
         default:
            pRP_GENIOCTL->rph.Status=USB_IDC_RC_WRONGFUNC;
            break;
         }
         break;
      default:
         pRP_GENIOCTL->rph.Status=USB_IDC_RC_WRONGCAT;
         break;
      }
   pRP_GENIOCTL->rph.Status|=STATUS_DONE;   

#ifdef   DEBUG
   dsPrint3(DBG_HLVLFLOW, "UHCI: UHCIidc finished: Category=%x, Function=%x, Status=%x\r\n",
            pRP_GENIOCTL->Category,pRP_GENIOCTL->Function,pRP_GENIOCTL->rph.Status);
#endif
}

