/* SCCSID = "src/dev/usb/UHCI/UHCI.H, usb, c.basedd 98/07/29" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  UHCI.H                                                */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Universal Host Controller Interface (UHCI)            */
/*                      structure and flag definitons.                        */
/*                                                                            */
/*   FUNCTION: This header file contains UHCI specific data structure and     */
/*                      flag definitions                                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          97/12/18  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/
#ifndef _UHCI_h_
   #define _UHCI_h_

// UHCI specific debug definitions
   #ifdef   DEBUG
      #define         dsPrint(l,s)              dsPrint5x(gUHCIMsgLevel,(l),(s),0,0,0,0,0)
      #define         dsPrint1(l,s,a)           dsPrint5x(gUHCIMsgLevel,(l),(s),(a),0,0,0,0)
      #define         dsPrint2(l,s,a,b)         dsPrint5x(gUHCIMsgLevel,(l),(s),(a),(b),0,0,0)
      #define         dsPrint3(l,s,a,b,c)       dsPrint5x(gUHCIMsgLevel,(l),(s),(a),(b),(c),0,0)
      #define         dsPrint4(l,s,a,b,c,d)     dsPrint5x(gUHCIMsgLevel,(l),(s),(a),(b),(c),(d),0)
   #endif

   #include "usbcmmon.h"         //     common USB stack definitions, OS/2 standard includes
   #include "usbmisc.h"          //     common USB routine definitions (defined in usbmisc.lib)

   #include "uhctype.h"          /* UHCI specific typedefs */
   #include "usbpci.h"           /* PCI related definitions  */
   #include "uhcproto.h"         /* function prototypes */
   #include "uhcextrn.h"         /* external data declarations */

#endif
