/* SCCSID = "src/dev/usb/UHCI/UHCEXTRN.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  UHCEXTRN.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  External data declarations for the Universal Host     */
/*                      Controller Interface compliant device driver.         */
/*                                                                            */
/*   FUNCTION: This module is the USBUHCI device driver external              */
/*             data declarations include file. See uhcdata.c for the data     */
/*             items being externalized.                                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          96/03/01  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

extern   USHORT         (*gStrat1[])();   // Dispatch table for strategy commands (pre FIFO queue)

extern   PFN            Device_Help;      //  devhelp entry point; used by dhcalls.lib

extern   ULONG          RMFlags;          // RM.LIB needs these declared
extern   PFN            RM_Help0;         // RM.LIB needs these declared
extern   PFN            RM_Help3;         // RM.LIB needs these declared

extern   UCHAR          gDevName[8];      // driver's name

/*--------------------------------------------------------*/
/* Set the DRIVERSTRUCT and DETECTEDSTRUCT data areas     */
/*--------------------------------------------------------*/
extern   char  near     gDDName[];        // device driver name
extern   char  near     gDDDesc[];        // device driver description
extern   char  near     gVendorID[];      // vendor identification
extern   char  near     gAdapterName[];   // adapter name 

extern   DRIVERSTRUCT   gDriverStruct;    // Driver Description
extern   ADAPTERSTRUCT  gAdapterStruct;   // Adapter Description

/*----------------------------------------------*/
/* GLOBAL HANDLE VARIABLES                      */
/*                                              */
/* These variables are assigned the handles for */
/* drivers, detected hardware and resources.    */
/*----------------------------------------------*/
extern   HDRIVER        ghDriver;          // global handle to driver
extern   HADAPTER       ghAdapter;         // global handle to adapter
extern   UCHAR          gusbIRQ;           // UHC IRQ number
extern   UCHAR          gusbPIN;           // UHC interrupt pin number
extern   USHORT         gusbIOBase;        // USB IO Spce Base Address
extern   USHORT         gusbCmdReg;        // USB Command register address
extern   USHORT         gusbStsReg;        // USB Status register address
extern   USHORT         gusbIntrReg;       // USB Interrupt Enable register address
extern   USHORT         gusbFrnumReg;      // Frame Number register
extern   USHORT         gusbBaseAddReg;    // Frame List Base Address
extern   USHORT         gusbSofModReg;     // Start of Frame Modify register
extern   USHORT         gusbPortSc1Reg;    // Port 0 Status & Control
extern   USHORT         gusbPortSc2Reg;    // Port 1 Status & Control

extern   HRESOURCE      girqResource;
extern   HRESOURCE      gioResource;
extern   PUSBIDCEntry   gpUSBDIDC;
extern   USHORT         gdsUSBIDC;
extern   UCHAR          ghcdID;
extern   UCHAR          gRootHubAddress;
extern   UCHAR          gRootHubConfig;
extern   BOOL           gHostReset;

extern   CHAR           gOEMDriverName[9];
extern   CHAR           gUSBDriverName[9];

// root hub structure definitons
extern   DeviceDescriptor     gRootDescriptor;

extern   RootHubConfiguration gRootConfiguration;

extern   HubDescriptor        gRootHubConfiguration;
extern   RP_GENIOCTL          gRootHubRP[ROOT_MAX_REQ];  // structures to store
extern   USBRB                gRootHubRB[ROOT_MAX_REQ];  // root hub I/O requests

extern   ULONG                gCTXHookHandle;            // task time thread context hook handle
extern   ULONG                gRHubHookHandle;           // task time thread context hook handle
extern   ULONG                gAddIsoHookHandle;         // add buffers to schedule task time thread
extern   UCHAR                gRootReqStatus;            // root hub request status
extern   ULONG                gIsoIrqHookHandle;         // iso IRQ processing task time thread
extern   ULONG                gInterruptFlags;           // last USB status register flags
extern   USHORT               gMaxReclPktSize;           // max packet length that can be used in bandwidth reclamation

extern   USHORT               g0Time;                    // timer count for default address request
extern   QH                   *g0QH;                     // default address request QH


extern   IDCTABLE       gDDTable;

extern   DEVICESTRUCT gDeviceStruct;

// UHCI host data area definitions, pointers and indexes
extern   LONG           *gFrameListAddr;     // virtual frame list address
extern   LONG           gPhyFrameListAddr;   // physical frame list address
extern   TD             *gTDListStart;       // QH/TD array start address
extern   USHORT         gTDCount;            // no of elements in QH/TD array
extern   USHORT         gLastTDId;           // last used QH/TD element index
extern   LONG           gFrameData[MAX_FRAME_LENGTH]; // buffer used for schedule and QH/TD array allocation
extern   QH             *gFirstBottomQH;              // pointer to the first bottom level QH
extern   QH             *gLastBottomQH;               // pointer to the last bottom level QH
extern   QH             *gNextForIRQ;  // pointer to QH to be processed next during IRQ processing
extern   BOOL           gInterruptsDisabled; // TRUE if interrupts disabled during iso IRQ processing
extern   ISOINFO FAR    *gFirstIso;    // pointer to the 1st iso request information structure
extern   ISOINFO FAR    *gLastIso;     // pointer to the last iso request information structure
extern   ULONG          gIsoPktSize;   // total isohronous request frame size

extern   BOOL           gStopHostOnShutDown; // if TRUE stops host during shutdown process

#ifdef   DEBUG
extern   USHORT         gUHCIMsgLevel;   // debug message level
#endif

//-------------initialization time data follows----------------------------------------------
extern   BYTE           gInitDataStart;   // Marks the end of the data segment.

extern   UCHAR          gPCIMajorVer;
extern   UCHAR          gPCIMinorVer;
extern   UCHAR          gMaxPCIBuses; // no of PCI buses detected
extern   UCHAR          gRevision;  // Vendor's USB Host device revision
extern   UCHAR          gBusNum;    // PCI bus number
extern   UCHAR          gDevFunc;   // PCI device function
extern   UCHAR          gDevicesFound;  // no of USB hosts detected
extern   BOOL           gIRQShared;  // IRQ sharing supported

extern   USHORT         gVerbose;   // console message printout level

#define MSG_REPLACEMENT_STRING  1178


extern   USHORT         gMessageIDs[MAX_INIT_MESSAGE_COUNT];   // console message indexes
extern   USHORT         gMessageCount;                         // console message count
extern   PSZ            gVMessages[];

extern   MSGTABLE       gInitMsg;

