/* SCCSID = "src/dev/usb/INCLUDE/USBPCI.H, usb, c.basedd, currbld 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/**************************************************************************
 *
 * SOURCE FILE NAME =  USBPCI.H
 *
 * DESCRIPTIVE NAME =  USB.SYS  USB Devicer Driver
 *
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Locally defined equates.
 *
 * Purpose:
 *
 *
 *
 *
 */

/*---------------------------------------------*/
/* PCI Defines                                 */
/*---------------------------------------------*/
#define  MAX_ADAPTERS   4

#define PCI_FUNC            0x0b                                   /*@V119250*/
#define PCI_GET_BIOS_INFO   0                                      /*@V119250*/
#define PCI_FIND_DEVICE     1                                      /*@V119250*/
#define PCI_FIND_CLASS_CODE 2                                      /*@V119250*/
#define PCI_READ_CONFIG     3                                      /*@V119250*/
#define PCI_WRITE_CONFIG    4                                      /*@V119250*/

#define PCI_SUCCESSFUL                    0                        /*@V119250*/

#define MAX_PCI_CONFIG_OPS      32                                  /*@V129765*//*@V153620*//*@V156660*/
#define MAX_PCI_BASE_REGS        4                                  /*@VVVVVVV*/
#define MAX_PCI_DEVICES         32      /* max per system */
#define MAX_PCI_FUNCTIONS        8      /* max per device */
#define MAX_PCI_DEVICE_DESCRIPT  6                                  /* [001][004] *//*@V156660*/

/*---------------------------------*/
/*                                 */
/* PCI Configuration Regs          */
/*                                 */
/*---------------------------------*/

#define PCIREG_VENDOR_ID        0x00
#define PCIREG_DEVICE_ID        0x02
#define PCIREG_COMMAND          0x04
#define PCIREG_STATUS           0x06
#define PCIREG_CLASS_CODE       0x08
#define PCIREG_IO_BASE          0x10
#define PCIREG_MEMORY_BASE      0x14
#define PCIREG_USBBA            0x20
#define PCIREG_INT_LINE         0x3C
#define PCIREG_INT_PIN          0x3D
#define PCIREG_SBRNUM           0x60
#define PCIREG_LEGSUP           0xC0   // 01/04/98 MB - added

/*-----------------------------------*/
/* PCI Configuration Register values */
/*-----------------------------------*/

#define PCI_MASS_STORAGE        0x01    /* PCI Base Class code */
#define PCI_SERIAL_BUS_CONTRL   0x0c    /* PCI Base Class code */
#define PCI_IDE_CONTROLLER      0x01    /* PCI Sub Class code  */
#define PCI_USB_HCONTROLLER     0x03    /* PCI Sub Class code  */
#define PCI_IDE_NATIVE_IF1      0x01
#define PCI_IDE_NATIVE_IF2      0x04
#define PCI_USB_UHCI_PROGIF     0x00    /* USB UHCI program interface  */
#define PCI_USB_OHCI_PROGIF     0x01    /* USB OHCI program interface  */

/*------------------------------------*/
/* PCI Legacy Support Register values */
/*------------------------------------*/

#define PCI_USBPIRQDEN          0x2000    /* USB PIRQ Enable flag */
#define PCI_USBSMIEN            0x0010    /* SMI generation enable/disable flag  */

/*
** Indices into the PCIDevice[] array of supported PCI devices,
** defined in s506data.c.
*/
#define PCID_CMD640_0 0    /* First CMD640 */                       /*@VAAAAAA*/
#define PCID_RZ1000_0 1    /* First RZ1000 */                       /*@V129765*/
#define PCID_INTEL82371FB    2  /* [003] Add Intel BM PCI */
#define PCID_PIIX3           3  /* [004] Intel PIIX3 IDE */
#define PCID_SECOND_PIIX     4  /* [004] Second Intel PIIX */
#define PCID_INTEL_ORION     5                                      /*@V156660*/

/*
** Define PCI Configuration space access locations.
*/
#define PCI_CONFIG_ADDRESS   0x0CF8                                 /*@V153743*/
#define PCI_CONFIG_DATA      0x0CFC                                 /*@V153743*/

/*-------------------------------*/                                 /*VVVVVVVV*/
/* PCI Structures                */                                 /*@V119250*/
/* -----------------             */
/*                               */
/*                               */
/*-------------------------------*/

typedef struct _PCI_IDENT
{                                         /*@V129765*/
   USHORT     Device;                                               /*@V129765*/
   USHORT     Vendor;                                               /*@V129765*/
   UCHAR      Index;                                                /*@V129765*/
   UCHAR      Revision;   /* Vendor's device revision  */           /*@V129765*/
   /* PCI device specific functions to call:           */           /*@V147576*/
   BOOL       (FAR *PCIFunc_Init)( struct _ACB NEAR * );            /*@V147576*/
   BOOL       (FAR *PCIFunc_InitComplete)( struct _ACB NEAR * );    /*@V147576*/
   SHORT      (FAR *PCIFunc_PortState)( struct _ATBL NEAR * );      /*@V147576*/
   SHORT      (FAR *PCIFunc_TurnPort)( struct _ATBL NEAR *, SHORT );/*@V147576*/
}PCI_IDENT, NEAR *NPPCI_IDENT;                                      /*@V129765*/

/* Discovered at initialization, run-time resident, 1 per IDE IF */ /*@V129765*/
typedef struct _PCI_INFO
{
   BOOL       Present;                                              /*@V129765*/
   PCI_IDENT  Ident;                                                /*@V129765*/
   /* First element of the PCIConfigOp array for this device */     /*@V129765*/
   UCHAR      FirstConfigRec;                                       /*@V129765*/
   UCHAR      BusNum;           /* PCI address component */
   UCHAR      DevFunc;          /* PCI address component */
   UCHAR      Reserved;                                             /*@V159935*/
} PCI_INFO, NEAR *NPPCI_INFO;                                       /*@V119250*/

/* Identifies PCI devices, 1 per supported PCI device. */
typedef struct _PCI_DEVICE
{
   PCI_IDENT  Ident;                                                /*@V129765*/
   /* Verbose mode identification string               */           /*@V129765*/
   NPSZ       npDeviceMsg;                                          /*@V129765*/
   UCHAR      FirstConfigRec[MAX_ADAPTERS];                         /*@V129765*//*@V155162*/
} PCI_DEVICE, NEAR *NPPCI_DEVICE;                                   /*@V129765*/

typedef struct
{
   UCHAR      PCISubFunc;
   PCI_IDENT  Ident;                                                /*@V129765*/
   UCHAR  Index;
}PCI_PARM_FIND_DEV;

typedef struct
{
   UCHAR  PCISubFunc;
   ULONG  ClassCode;
   UCHAR  Index;
}PCI_PARM_FIND_CLASSCODE;

typedef struct
{
   UCHAR  PCISubFunc;
   UCHAR  BusNum;
   UCHAR  DevFunc;
   UCHAR  ConfigReg;
   UCHAR  Size;
}PCI_PARM_READ_CONFIG;

typedef struct
{
   UCHAR  PCISubFunc;
   UCHAR  BusNum;
   UCHAR  DevFunc;
   UCHAR  ConfigReg;
   UCHAR  Size;
   ULONG  Data;
}PCI_PARM_WRITE_CONFIG;

typedef struct _PCI_DATA
{
   UCHAR bReturn;
   union
   {
      struct
      {
         UCHAR HWMech;
         UCHAR MajorVer;
         UCHAR MinorVer;
         UCHAR LastBus;
      } Data_Bios_Info;
      struct
      {
         UCHAR  BusNum;
         UCHAR  DevFunc;
      }Data_Find_Dev;
      union
      {
         ULONG  ulData;                                             /*@V129765*/
         USHORT usData;                                             /*@V129765*/
         UCHAR  ucData;                                             /*@V129765*/
      }Data_Read_Config;
   };
} PCI_DATA, FAR *PPCI_DATA;

typedef struct _PCI_CONFIG_OPERATION                                /*@V129765*/
{
   USHORT Phase;
   /*
   ** Bitmask of phase(s) to perform this configuration operation.
   ** Phase is a bit mask with the definitions listed below.  If it becomes
   ** necessary to add additional initialization phases, this bit mask
   ** must be extended.  The specified PCI configuration operation executes
   ** as long as the Phase bit matching the current Phase is set.  The phase
   ** records are defined in the static, PCIConfigOp[], in S506DATA.C
   **
   ** Note: PCIC = PCI Configuration operation bits
   */
#define PCIC_SUSPEND        0x0001    /* Kernel suspend    */       /*@V153620*/
#define PCIC_RESUME         0x0002    /* Kernel resume     */       /*@V153620*/
#define PCIC_START          0x0010    /* Before driver initializes the HW, bios initialized state */
#define PCIC_START_COMPLETE 0x0020    /* After driver initializes the HW, berfore returning to bios */
#define PCIC_INIT_COMPLETE  0x0040    /* All Driver's initialization is complete, BIOS is done with HW */
   USHORT SavePhase; /* Phase(s) during which to save      */       /*@V156660*/
   USHORT RestPhase; /* Phase(s) during which to restore   */       /*@V156660*/
   UCHAR  ConfigReg; /* PCI configuration register address */
   UCHAR  Size;      /* data size ib bytes 1,2, or 4       */
   ULONG  OrOn;      /* bits verified to be set, postitive mask */
   ULONG  AndOff;    /* bits verified to be reset, negative mask */ /*@VAAAAAA*/
} PCI_CONFIG_OPERATION, NEAR *NPPCI_CONFIG_OPERATION;

/*-------------------------------*/
/* Adapter Table                 */
/* -------------                 */
/*                               */
/* One per controller.           */
/*                               */
/*-------------------------------*/

typedef struct _ATBL
{
   USHORT        BasePort;
   USHORT        StatusPort;                                         /*@V153620*/
   USHORT        IRQLevel;

   USHORT        Flags;
   USHORT        Status;

   PCI_INFO      PCIInfo;                                            /*@V129765*/
                                                                     /*VVVVVVVV*/
   /*
   ** Just in case you are wondering, the next field: npPCIDeviceMsg
   ** is not in the PCI_INFO struct because this pointer becomes
   ** invalid after initialization is complete and PCIInfo is wholly
   ** copied to the ACB for use at task and interrupt time.
   */                                                                /*AAAAAAAA*/
   NPSZ          npPCIDeviceMsg;                                     /*@V129765*/
   HADAPTER      hAdapter;                                           /*@V98451*/
   USHORT        cUnits;
   UCHAR         ResourceBuf[sizeof(AHRESOURCE)+sizeof(HRESOURCE)*3]; /*@V98451*/
   USHORT        SysDMAType;
   USHORT        DMA_Channel;
   USHORT        DMA_Count_port;
   USHORT        DMA_Addr_port;
   USHORT        DMA_Addr_page_port;
   USHORT        DMA_Mode_port;
   USHORT        DMA_Chain_mode;
   USHORT        DMA_Ext_Mode_port;
   USHORT        DMA_Mask_port;
   USHORT        DMA_Clr_Byte_ptr;
   USHORT        DMA_SGD_Cmd_port;
   USHORT        DMA_SGD_Ptr_port;
   USHORT        BM_Overides;                /* Bus Master DMA switch overides */
   USHORT        BM_BaseAddress;
} ATBL;

