#ifndef _usbidc_h_
   #define _usbidc_h_
/* SCCSID = "src/dev/usb/INCLUDE/USBIDC.H, usb, c.basedd, currbld 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  USBIDC.H                                              */
/*                                                                            */
/*   DESCRIPTIVE NAME:  USB device driver stack intercommunication routine    */ 
/*                      definitions.                                          */
/*                                                                            */
/*   FUNCTION: USB device driver stack function prototypes.                   */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/02/02  MB                                                      */
/*          98/08/14  MB              Changed configuration buffer length to  */
/*                                    support Labtec speakers                 */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

   #include "usbcmmon.h"

typedef VOID (USBIDCEntry) (PRP_GENIOCTL pRP_GENIOCTL);
typedef USBIDCEntry FAR *PUSBIDCEntry;

void USBCallIDC( PUSBIDCEntry idcEntry, USHORT callingDS, RP_GENIOCTL FAR *pRP );


USHORT GetReportLength(PRP_GENIOCTL pRP_GENIOCTL, UCHAR ReportType, UCHAR ReportID, UCHAR Interface );
USHORT GetUsageOffset(PRP_GENIOCTL pRP_GENIOCTL, UCHAR ReportType, UCHAR ReportID, UCHAR interface, USHORT UsagePage, USHORT UsageID);
ULONG GetUsageSize(PRP_GENIOCTL pRP_GENIOCTL, UCHAR ReportType, UCHAR ReportID, UCHAR interface, USHORT UsagePage, USHORT UsageID);




//    USB driver stack IDC(IOCTL) call categories
   #define  USB_IDC_CATEGORY_HOST      0x90
   #define  USB_IDC_CATEGORY_USBD      0x91
   #define  USB_IDC_CATEGORY_CLASS     0x92
   #define  USB_IDC_CATEGORY_CLIENT    0x93
   #define  USB_IDC_CATEGORY_LEGACY    0x94

//    USB driver stack IDC(IOCTL) call functions
   #define  USB_IDC_FUNCTION_ACCIO     0x41
   #define  USB_IDC_FUNCTION_CANCEL    0x42
   #define  USB_IDC_FUNCTION_REGISTER  0x43
   #define  USB_IDC_FUNCTION_PRCIRQ    0x44
   #define  USB_IDC_FUNCTION_CHKSERV   0x45
   #define  USB_IDC_FUNCTION_DETDEV    0x46
   #define  USB_IDC_FUNCTION_RSTHOST   0x47
   #define  USB_IDC_FUNCTION_SETCONF   0x48
   #define  USB_IDC_FUNCTION_SETINTF   0x49
   #define  USB_IDC_FUNCTION_CLRSTALL  0x4a
   #define  USB_IDC_FUNCTION_FINIO     0x4b  // only for debug

// USB IDC routine error codes
   #define  USB_IDC_OK                 0x0000
   #define  USB_IDC_WRONGCAT           0x0010	// wrong call category
   #define  USB_IDC_WRONGFUNC          0x0011	// wrong call function
   #define  USB_IDC_WFCATCOMB          0x0012	// wrong category/function combination
   #define  USB_IDC_PARMERR            0x0013	// wrong parameter values
   #define  USB_IDC_ALLOCERR           0x0014	// failed to allocate internal data structures
   #define  USB_IDC_NOBANDWIDTH        0x0015	// not enough bandwidth to execute  request
   #define  USB_IDC_EXCEEDSMAX         0x0016	// number of registered drivers exceeds maximum allowed
   #define  USB_IDC_CANCELED           0x0017	// I/O canceled
   #define  USB_IDC_ADDRINV            0x0018	// device or endpoint not exists
   #define  USB_IDC_SERVREJCTD         0x0019	// service rejected
   #define  USB_IDC_IOFAILED           0x0020	// I/O failed

// USB IDC routine return codes
   #define  USB_IDC_RC_OK              (STATUS_DONE|USB_IDC_OK)
   #define  USB_IDC_RC_WRONGCAT        (STATUS_DONE|STERR|USB_IDC_WRONGCAT)	// wrong call category
   #define  USB_IDC_RC_WRONGFUNC       (STATUS_DONE|STERR|USB_IDC_WRONGFUNC)	// wrong call function
   #define  USB_IDC_RC_WFCATCOMB       (STATUS_DONE|STERR|USB_IDC_WFCATCOMB)	// wrong category/function combination
   #define  USB_IDC_RC_PARMERR         (STATUS_DONE|STERR|USB_IDC_PARMERR)	   // wrong parameter values
   #define  USB_IDC_RC_ALLOCERR        (STATUS_DONE|STERR|USB_IDC_ALLOCERR)	// failed to allocate internal data structures
   #define  USB_IDC_RC_NOBANDWIDTH     (STATUS_DONE|STERR|USB_IDC_NOBANDWIDTH)// not enough bandwidth to execute  request
   #define  USB_IDC_RC_EXCEEDSMAX      (STATUS_DONE|STERR|USB_IDC_EXCEEDSMAX)	// number of registered drivers exceeds maximum allowed
   #define  USB_IDC_RC_CANCELED        (STATUS_DONE|STERR|USB_IDC_CANCELED)	// I/O canceled
   #define  USB_IDC_RC_ADDRINV         (STATUS_DONE|STERR|USB_IDC_ADDRINV)	   // device or endpoint not exists
   #define  USB_IDC_RC_SERVREJCTD      (STATUS_DONE|USB_IDC_SERVREJCTD)	      // service rejected
   #define  USB_IDC_RC_IOFAILED        (STATUS_DONE|STERR|USB_IDC_IOFAILED)	// I/O failed

// 98/08/14  MB - changed configuration buffer length to support Labtec speakers   
   #define  MAX_CONFIG_LENGTH          512      // USB device configuration data length

// USB device data structure
typedef struct _DeviceInfo
{
   UCHAR              ctrlID;              // (00) controller ID, not used, should be set to 0
   UCHAR              deviceAddress;       // (01) USB device address
   UCHAR              bConfigurationValue; // (02) USB device configuration value
   UCHAR              bInterfaceNumber;    // (03) 0 based index in interface array for this item
   UCHAR              lowSpeedDevice;      // (04) 0 for full speed device, nonzero - low speed device
   UCHAR              portNum;             // (05) port number to which device is attached
   USHORT             parentHubIndex;      // (06) index in hub table to parent hub, -1 for root hub device
   HDEVICE            rmDevHandle;         // (08) Resource Manager device handle
   SetupPacket        clearStalled;        // (12) setup packet for USBD internal use
   DeviceDescriptor   descriptor;          // (20) Device descriptor
   UCHAR              configurationData[MAX_CONFIG_LENGTH];  // (38) device configuration data
   // (550)
}  DeviceInfo;

// USB I/O request block
typedef struct _USBRb
{
   UCHAR    controllerId;  //	(00) controller ID, not used, should be set to 0
   UCHAR    deviceAddress; // (01) USB device address. Valid range - [1,127], 0 are used for unconfigured devices
   UCHAR    endPointId;    // (02) device endpoint ID, valid range - [0,15]
   UCHAR    status;        // (03) device status on request complete
   USHORT   flags;         // (04) Low order byte sets  transfer type, High order byte gives packet details
   PUCHAR   buffer1;       // (06) Virtual address of data buffer
   USHORT   buffer1Length; // (10) Buffer length in bytes
   PUCHAR   buffer2;       // (12) Virtual address of second data buffer.
   USHORT   buffer2Length; // (16) Buffer length in bytes
   USHORT   serviceTime;   // (18) Required service frequency in ms. Valid range - [0,255].
   USHORT   maxPacketSize; // (20) maximum packet size to be used for specified endpoint
   PUSBIDCEntry   usbIDC;  // (22) Address of IRQ processing routine to be called for this request
   USHORT   usbDS;         // (26) DS value for IRQ processing routine
   UCHAR    category;      // (28) callers category (used in IRQ extension calls)
   ULONG    requestData1;  // (29) data to be stored within request
   ULONG    requestData2;  // (33) data to be stored within request
   ULONG    requestData3;  // (37) data to be stored within request
   UCHAR    maxErrorCount; // (41) maximum error count. Valid range - [0,3]. 0 - no error limit.
   struct _USBRb  FAR *nextRb;  // (42) far pointer to chained request block, not used
   UCHAR    altInterface;  // (46) 27/08/98 MB - alt interface index support, used when USRB_FLAGS_ALT_INTF is on
   // fields used for isohronous requests (USRB_FLAGS_DET_ISOHR is set in 'flags' field) //  15/10/98
   UCHAR    isoFlags;      // (47) ishronous request flags (opening call, regular call, last call, cancel call, info call)
   USHORT   isoFrameLength;// (48) no of bytes to be sent in a frame (used only for opening call)
   USHORT   isoBuffers;    // (50) max no of active buffers( used only for opening call)
                           // (52)

} USBRB;

   #define  USRB_STATUS_STALLED     0x40
   #define  USRB_STATUS_BUFFERR     0x20
   #define  USRB_STATUS_BABBLE      0x10
   #define  USRB_STATUS_NAK         0x08
   #define  USRB_STATUS_CRC         0x04
   #define  USRB_STATUS_BITSTUFF    0x02

   #define  USRB_FLAGS_TTYPE_MASK   0xfff8
   #define  USRB_FLAGS_TTYPE_IN     0x0001
   #define  USRB_FLAGS_TTYPE_OUT    0x0002
   #define  USRB_FLAGS_TTYPE_SETUP  0x0004
   #define  USRB_FLAGS_DET_ISOHR    0x8000  
   #define  USRB_FLAGS_DET_INTRPT   0x4000
   #define  USRB_FLAGS_DET_BULK     0x2000
   #define  USRB_FLAGS_DETT_MASK    0xe000      // request type mask
   #define  USRB_FLAGS_DET_LOWSPEED 0x1000
   #define  USRB_FLAGS_DET_DTGGLEON 0x0800
   #define  USRB_FLAGS_DET_AEPKT    0x0400
   #define  USRB_FLAGS_ALT_INTF     0x0200      // 27/08/98 MB - alternate interface support

// isohronous request flags   // 15/10/98 MB
   #define  USRB_ISOFLAGS_OPEN      0x0001      
   #define  USRB_ISOFLAGS_CLOSE     0x0002      
   #define  USRB_ISOFLAGS_CANCEL    0x0004      
   #define  USRB_ISOFLAGS_INFO      0x0008      


// structure used in cancel I/O requests
typedef struct _USBCancel
{
   UCHAR    controllerId;     // (00) controller ID, not used, should be set to 0
   UCHAR    deviceAddress;    // (01) USB device address.
   UCHAR    endPointId;       // (02) device endpoint ID   // 08/11/98 MB
                              // (03)
}  USBCancel;

   #define  USBCANCEL_CANCEL_ALL 0xff  // used as endpoint ID to cancel all requests to given device address

typedef struct _RMDATA
{
   HDRIVER     hDriver;       // (00) HCD layer driver's RM driver handle
   HADAPTER    hAdapter;      // (04) HCD layer driver's RM adapter handle
                              // (08)
}  RMData;

// HCD layer driver registration structure
typedef struct _USBHCD
{
   PUSBIDCEntry  usbIDC;      // (00) Address of HDC IDC routine
   USHORT        usbDS;       // (04) HCD data segment value
   PUCHAR        hcdID;       // (06) Pointer to store assigned by USBD controller ID
   UCHAR         hcdCount;    // (10) Number of served Host Controllers
   RMData        rmData[1];   // (11) RM handle bundle for each Host Controller
                              // (19)
}  USBHCD;


// class driver registration structure
typedef struct _USBDClass
{
   PUSBIDCEntry   usbIDC;     // (00) Address of Device Class driver IDC routine
   USHORT         usbDS;      // (04) Device Class driver data segment value
                              // (06)
}  USBDClass;

// check device for service structure 
typedef struct _USBCDServe
{
   DeviceInfo FAR       *pDeviceInfo;  // (00) far pointer to USB device data stored in USBD
                                       // (04)
}     USBCDServe;

// device detached request data structure
typedef struct _USBDetach
{
   UCHAR controllerId;        // (00) controller ID, not used, should be set to 0
   UCHAR deviceAddress;       // (01) USB device address
                              // (02)
}     USBDetach;

// set configuration request data structure
typedef struct _USBSetConf
{
   UCHAR             controllerId;        // (00) controller ID, not used, should be set to 0
   UCHAR             deviceAddress;       // (01) USB device address
   USHORT            classDriverDS;       // (02) class driver data segment value (used to identify driver)
   UCHAR             configurationValue;  // (04) desired configuration value (type depends on call function)
   ULONG             irqSwitchValue;      // (05) value used in class driver IRQ processor worker switch
   UCHAR             category;            // (09) IRQ processor category
   SetupPacket FAR   *setConfiguration;   // (10) ptr USB setup packet structure
                                          // (14)
}     USBSetConf;

// register client data structure
typedef struct _USBRegClient
{
   PUSBIDCEntry   clientIDCAddr; // (00) Client driver IDC routine address
   UINT  clientDS;               // (04) client data segment address
                                 // (06)
}  USBRegClient;


// "clear stalled pipe" request data structure
typedef struct _USBClearStalled
{
   UCHAR             controllerId;        // (00) controller ID, not used, should be set to 0
   UCHAR             deviceAddress;       // (01) USB device address
   UCHAR             endPointId;          // (02) stalled endpoint ID
   PUSBIDCEntry      clientIDCAddr;       // (03) Caller IDC routine address
   USHORT            clientDS;            // (07) caller data segment address
   ULONG             irqSwitchValue;      // (09) value used in class driver IRQ processor worker switch
   ULONG             requestData2;        // (13) data to be stored within clear stalled pipe request
   ULONG             requestData3;        // (17) data to be stored within clear stalled pipe request
   UCHAR             category;            // (21) IRQ processor category
   SetupPacket FAR   *clearStalled;       // (22) ptr USB setup packet structure
                                          // (26)
}     USBClearStalled;

// "finish I/O" request data structure (only for debug)
typedef struct _USBFinIO
{
   UCHAR             controllerId;        // (00) controller ID, not used, should be set to 0
   UCHAR             deviceAddress;       // (01) USB device address
   UCHAR             endPointId;          // (02) stalled endpoint ID
   UCHAR             status;              // (03) required status value
   PUCHAR            buffer;              // (04) Virtual address of data buffer
   USHORT            bufferLength;        // (08) Buffer length in bytes
                                          // (10)
}     USBFinIO;

#endif

