/* SCCSID = "src/dev/usb/INCLUDE/USBAUDIO.H, usb, c.basedd, currbld 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  USBAUDIO.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Universal Host Controller Interface (UHCI)            */
/*                      structure and flag definitons.                        */
/*                                                                            */
/*   FUNCTION: This header file contains USB Audio class specific data        */
/*                       structure and flag definitions                       */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/08/18  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/
#ifndef _USBAUDIO_h_
   #define _USBAUDIO_h_






/* Audio Class-Specific Request Codes */
#define  REQUEST_CODE_UNDEFINED  0x00
#define  SET_CUR                 0x01
#define  GET_CUR                 0x81
#define  SET_MIN                 0x02
#define  GET_MIN                 0x82
#define  SET_MAX                 0x03
#define  GET_MAX                 0x83
#define  SET_RES                 0x04
#define  GET_RES                 0x84
#define  SET_MEM                 0x05
#define  GET_MEM                 0x85
#define  GET_STAT                0xff


/* Feature Unit Control Selector */
#define  FU_CONTROL_UNDEFINED       0x00
#define  MUTE_CONTROL               0x01
#define  VOLUME_CONTROL             0x02
#define  BASS_CONTROL               0x03
#define  MID_CONTROL                0x04
#define  TREBLE_CONTROL             0x05
#define  GRAPHIC_EQUALIZER_CONTROL  0x06
#define  AUTOMATIC_GAIN_CONTROL     0x07
#define  DELAY_CONTROL              0x08
#define  BASS_BOOST_CONTROL         0x09
#define  LOUDNESS_CONTROL           0x0A


/* Up/Down-mix Processing Unit Control Selectors */
#define  UD_CONTROL_UNDEFINED       0x00
#define  UD_ENBLE_CONTROL           0x01
#define  UD_MODE_SELECT_CONTROL     0x02


/* Endpoint Control Selectors */
#define  EP_CONTROL_UNDEFINED       0x00
#define  SAMPLING_FREQ_CONTROL      0x01
#define  PITCH_CONTROL              0x02


/* Reverberation Processing Unit Control Selectors */
#define  RV_CONTROL_UNDEFINED       0x00
#define  RV_ENABLE_CONTROL          0x01
#define  REVERB_LEVEL_CONTROL       0x02
#define  REVERB_TIME_CONTROL        0x03
#define  REVERB_FEEDBACK_CONTROL    0x04


/* 3D Stereo Extender Processing Unit Control Selectors */
#define  _3D_CONTROL_UNDEFINED       0x00
#define  _3D_ENABLE_CONTROL          0x01
#define  SPACIOUSNESS_CONTROL       0x03


/* Chorus Processing Unit Control Selectors */
#define  CH_CONTROL_UNDEFINED       0x00
#define  CH_ENABLE_CONTROL          0x01
#define  CHORUS_LEVEL_CONTROL       0x02
#define  CHORUS_RATE_CONTROL        0x03
#define  CHORUS_DEPTH_CONTROL       0x04

/* Dolby Prologic(TM) Processing Unit Control Selectors */
#define  DP_CONTROL_UNDEFINED       0x00
#define  DP_ENABLE_CONTROL          0x01
#define  DP_MODE_SELECT_CONTROL     0x02

/* Extension Unit Control Selectors */
#define  XU_CONTROL_UNDEFINED       0x00
#define  XU_ENABLE_CONTROL          0x01

/* Dynamic Range Processing Unit Control Selectors */
#define  DR_CONTROL_UNDEFINED       0x00
#define  DR_ENABLE_CONTROL          0x01
#define  COMPRESSION_RATE_CONTROL   0x02
#define  MAXAMPL_CONTROL            0x03
#define  THRESHOLD_CONTROL          0x04
#define  ATTACK_TIME                0x05
#define  REEASE_TIME                0x06


/* Terminal Control Selectors */
#define  TE_CONTROL_UNDEFINED       0x00
#define  COPY_PROTECT_CONTROL       0x01


/* Audio Class-Specific Endpoint Descriptor Subtypes */
#define  DESCRIPTOR_UNDEFINED       0x00
#define  EP_GENERAL                 0x01


/* Processing Unit Process Selectors */
#define  PROCESS_UNDEFINED          0x00
#define  UP_DOWN_MIX_PROCESS        0x01
#define  DOLBY_PROLOGIC_PROCESS     0x02
#define  _3D_STEREO_EXTENDER_PROCESS 0x03
#define  REVERBERATION_PROCESS      0x04
#define  CHORUS_PROCESS             0x05
#define  DYN_RANGE_COMP_PROCESS     0x06


/* Audio Class-Specific AS Interface Descriptor Subtypes */
#define  AS_DESCRIPTOR_UNDEFINED    0x00
#define  AS_GENERAL                 0x01
#define  FORMAT_TYPE                0x02
#define  FORMAT_SPECIFIC            0x03


/* Audio Class-Specific AC Interface Descriptor Subtypes */
#define  AC_DESCRIPTOR_UNDEFINED    0x00
#define  HEADER                     0x01
#define  INPUT_TERMINAL             0x02
#define  OUTPUT_TERMINAL            0x03
#define  MIXER_UNIT                 0x04
#define  SELECTOR_UNIT              0x05
#define  FEATURE_UNIT               0x06
#define  PROCESSING_UNIT            0x07
#define  EXTENSION_UNIT             0x08


/* Audio Interface Class Code */
#define  AUDIO                      0x01


/* Audio Interface Subclass Codes */
#define  SUBCLASS_UNDEFINED         0x00
#define  AUDIOCONTROL               0x01
#define  AUDIOSTREAMING             0x02
#define  MIDISTREAMING              0x03


/* Audio Class-Specific Descriptor Types */
#define  CS_UNDEFINED               0x20
#define  CS_DEVICE                  0x21
#define  CS_CONFIGURATION           0x22
#define  CS_STRING                  0x23
#define  CS_INTERFACE               0x24
#define  CS_ENDPOINT                0x25


/* Audio Interface Protocol Codes */
#define  PR_PROTOCOL_UNDEFINED      0x00


                                    




typedef struct _AC_HDR_descriptor_
{
   UCHAR    bLength;             // Size of descriptor in bytes
   UCHAR    bDescriptorType;     // 0x24 - CS_INTERFACE Descriptor type
   UCHAR    bDescriptorSubtype;  // 0x01 - header Descriptor subtype
   USHORT   bcdADC;              // Audio Device Class Specification Release Number
   USHORT   wTotalLength;        // no of bytes for the class specific descriptors
   UCHAR    bInCollection;       // Interface collection count (n)
   UCHAR    baInterfaceNr[1];    // Interface no for the last interface in collection
}  ACHdrDescriptor;

typedef struct _input_terminal_descriptor_
{
   UCHAR    bLength;             // Size of descriptor in bytes (12)
   UCHAR    bDescriptorType;     // 0x24 - CS_INTERFACE Descriptor type
   UCHAR    bDescriptorSubtype;  // 0x02 - input terminal Descriptor subtype
   UCHAR    bTerminalID;         // input terminal ID
   USHORT   wTerminalType;       // terminal type flags
   UCHAR    bAssocTerminal;      // ID of associated Output Terminal
   UCHAR    bNrChannels;         // no of logical output channels
   USHORT   wChannelConfig;      // spatial location of logical channels
   UCHAR    iChannelNames;       // index to string describing 1st logical channel
   UCHAR    iTerminal;           // index to string describing the input terminal
}  ITermDescriptor;

typedef struct _output_terminal_descriptor_
{
   UCHAR    bLength;             // Size of descriptor in bytes (9)
   UCHAR    bDescriptorType;     // 0x24 - CS_INTERFACE Descriptor type
   UCHAR    bDescriptorSubtype;  // 0x03 - output terminal Descriptor subtype
   UCHAR    bTerminalID;         // output terminal ID
   USHORT   wTerminalType;       // terminal type flags
   UCHAR    bAssocTerminal;      // ID of associated Input Terminal
   UCHAR    bSourceID;           // ID of the unit to which this terminal is connected
   UCHAR    iTerminal;           // index to string describing the output terminal
}  OTermDescriptor;

typedef struct _feature_unit_descriptor_
{
   UCHAR    bLength;             // Size of descriptor in bytes
   UCHAR    bDescriptorType;     // 0x24 - CS_INTERFACE Descriptor type
   UCHAR    bDescriptorSubtype;  // 0x06 - feature unit Descriptor subtype
   UCHAR    bUnitID;             // feature unit ID
   UCHAR    bSourceID;           // Unit ID to which this unit is connected
   UCHAR    bControlSize;        // control array element count (n)
   UCHAR    bmaControls[1];      // feature flags: n bytes for each channel
   UCHAR    iTerminal;           // index to string describing the feature unit
}  FUnitDescriptor;

typedef struct _AS_interface_descriptor_
{
   UCHAR    bLength;             // Size of descriptor in bytes (7)
   UCHAR    bDescriptorType;     // 0x24 - CS_INTERFACE Descriptor type
   UCHAR    bDescriptorSubtype;  // 0x01 - AS_GENERAL Descriptor subtype
   UCHAR    bTerminalLink;       // Terminal ID to which endpoint is connected
   UCHAR    bDelay;              // delay introduced by the data path
   USHORT   wFormatTag;          // audio format to be used with this interface
}  ASIntfDescriptor;

typedef struct _Type1_descriptor_
{
   UCHAR    bLength;             // Size of descriptor in bytes
   UCHAR    bDescriptorType;     // 0x24 - CS_INTERFACE Descriptor type
   UCHAR    bDescriptorSubtype;  // 0x02 - FORMAT_TYPE Descriptor subtype
   UCHAR    bFormatType;         // FORMAT_TYPE_I audio streaming type
   UCHAR    bNrChannels;         // No of pgysical channels in stream
   UCHAR    bSubFrameSize;       // No of bytes in audio subframe
   UCHAR    bBitResolution;      // effectively used bits in subframe
   UCHAR    bSamFreqType;        // sampling frequency programming type
   UCHAR    tSamFreq[3][1];      // sampling frequency data
}  Type1FDescriptor;

typedef struct _AS_endpoint_descriptor_
{
   UCHAR    bLength;             // Size of descriptor in bytes (7)
   UCHAR    bDescriptorType;     // 0x25 - CS_ENDPOINT Descriptor type
   UCHAR    bDescriptorSubtype;  // 0x01 - EP_GENERAL Descriptor subtype
   UCHAR    bmAttributes;        // feature flags for this endpoint
   UCHAR    bLockDelayUnits;     // units used in wLockDelay field
   USHORT   wLockDelay;          // endpoint time to lock internal clock
}  ASEndpointDescriptor;

#endif

