/* SCCSID = "src/dev/usb/HID/HIDTYPE.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  HIDTYPE.H                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  HID Class device driver TYPEDEF  and flag definition  */
/*                      include file.                                         */
/*                                                                            */
/*   FUNCTION: This module is the HID Class device driver                     */
/*             TYPEDEF and flag definition include file.                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/01/31  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

//    max strategy command number
#define  MAX_USB_CMD             0x1f

// initialization time message IDs
#define  INIT_MESSAGE_LOADED     0
#define  INIT_MESSAGE_NO_USBD    1
#define  INIT_MESSAGE_INVNUMERIC 2
#define  INIT_MESSAGE_UNKNOWNKWD 3

// max no of messages in message queue
#define  MAX_INIT_MESSAGE_COUNT  2

#define  MAX_CLIENTS             8
#define  HID_MAX_REPORT_LENGTH   128

#define  MAX_REP_ITEMS           64
#define  MAX_ITEM_USAGES         32
#define  MAX_ITEM_DESIGNATORS    16
#define  MAX_ITEM_STRINGS        16


// registered client driver data structure
typedef struct _driverList
{
   PUSBIDCEntry   clientIDCAddr;                // client's IDC routine address
   USHORT         clientDS;                     // client's data segment value
}  DriverList;

#define  MAX_DEVICES             16

// HID service data structure
typedef struct _deviceList
{
   DeviceInfo FAR             *pDeviceInfo;     // (00) far pointer to device data
   DeviceConfiguration FAR    *devConf;         // (04) far pointer to device configuration data
   SetupPacket                stdPacket;        // (08) setup packet buffer
   SetupPacket                cstPacket;        // (16) setup packet buffer to clear stalled
   USHORT                     versionFlags;     // (24) specific version flags (HID drafts)   
   USHORT                     reportItemIndex;  // (26) 1st report item index in report item table
   USHORT                     protocolSetIndex; // (28) 0xff when all protocols set to report protocol
   UCHAR                      configuration;    // (30) device status buffer
   UCHAR                      reportData[HID_MAX_REPORT_LENGTH];     // (31) ptr to device specific data
}  DeviceList;


// I/O request flags used in HID processing
#define  HID_IRQ_STATUS_SETCONF        1
#define  HID_IRQ_STATUS_SETINTF        2
#define  HID_IRQ_STATUS_READINT        3
#define  HID_IRQ_STATUS_INTRCVED       4
#define  HID_IRQ_STATUS_SERVCLIENT     5
#define  HID_IRQ_STATUS_SETIDLE        6
#define  HID_IRQ_STATUS_SETPROTOCOL    7
#define  HID_IRQ_STATUS_REPRETRIEVED   8

