/* SCCSID = "src/dev/usb/HID/HIDEXTRN.H, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  HIDEXTRN.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  External data declarations for the HID Class          */
/*                      device driver.                                        */
/*                                                                            */
/*   FUNCTION: This module is the HID Class device driver external            */
/*             data declarations include file. See hiddata.c for the data     */
/*             items being externalized.                                      */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/01/31  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

extern USHORT         (*gStrat1[])();

extern PFN            Device_Help;

extern BYTE           gInitDataStart;

extern ULONG          RMFlags;
extern PFN            RM_Help0;
extern PFN            RM_Help3;

extern DRIVERSTRUCT   gDriverStruct;
extern ADAPTERSTRUCT  gAdapterStruct;

extern HDRIVER        ghDriver;
extern HADAPTER       ghAdapter;

extern CHAR           gOEMDriverName[];
extern CHAR           gUSBDriverName[];
extern IDCTABLE       gDDTable;

extern PUSBIDCEntry   gpUSBDIDC;
extern USHORT         gdsUSBIDC;


extern USHORT         gMaxClients;
extern USHORT         gMaxDevices;

extern USHORT         gNoOfRegisteredClients;
extern DriverList     gClientDrivers[MAX_CLIENTS];   // registered client driver table
extern USHORT         gNoOfActiveDevices;
extern DeviceList     gActiveDevices[MAX_DEVICES];   // active device list served by HID

// report data storing
extern USHORT         gMaxRepItems;
extern USHORT         gMaxItemUsages;
extern USHORT         gMaxItemDesignators;
extern USHORT         gMaxItemStrings;

extern ReportItemData gReportItemData[MAX_REP_ITEMS];
extern ItemUsage      gItemUsage[MAX_ITEM_USAGES];
extern ItemDesignator gItemDesignator[MAX_ITEM_DESIGNATORS];
extern ItemString     gItemString[MAX_ITEM_STRINGS];

#ifdef   DEBUG
extern   USHORT       gHIDMsgLevel;       // debug message level
#endif

extern USHORT         gVerbose;
extern USHORT         gMessageIDs[MAX_INIT_MESSAGE_COUNT];
extern PSZ            gVMessages[];
extern USHORT         gMessageCount;

