/* SCCSID = "src/dev/usb/HID/HIDDATA.C, usb, c.basedd 98/07/10" */
/*
*   Licensed Material -- Property of IBM
*
*   (c) Copyright IBM Corp. 1997, 1998  All Rights Reserved
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  HIDDATA.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Human Interface Device Class driver data segment      */
/*                                                                            */
/*   FUNCTION: This module allocates the global data area for the             */
/*             HID Class device driver.                                       */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             None                                                           */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          98/01/31  MB                                                      */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "hid.h"

/*--------------------------------------------------------*/
/* Dispatch table for strategy commands (pre FIFO queue)  */
/*--------------------------------------------------------*/
USHORT (*gStratList[])() =
{                     /*--------------------------------------*/
   CmdError,          /* 0x00  initialize device driver       */
   CmdError,          /* 0x01  check the media                */
   CmdError,          /* 0x02  build BPB                      */
   CmdError,          /* 0x03  reserved                       */
   CmdError,          /* 0x04  read                           */
   CmdError,          /* 0x05  non-destructive read           */
   CmdError,          /* 0x06  input status                   */
   CmdError,          /* 0x07  input flush                    */
   CmdError,          /* 0x08  write                          */
   CmdError,          /* 0x09  write with verify              */
   CmdError,          /* 0x0A  get output status              */
   CmdError,          /* 0x0B  flush output                   */
   CmdError,          /* 0x0C  reserved                       */
   CmdError,          /* 0x0D  open                           */
   CmdError,          /* 0x0E  close                          */
   CmdError,          /* 0x0F  removable media                */
   CmdError,          /* 0x10  generic IOCTL                  */
   CmdError,          /* 0x11  reset uncertain media          */
   CmdError,          /* 0x12  get Logical Drive Map          */
   CmdError,          /* 0x13  set Logical Drive Map          */
   CmdError,          /* 0x14  de-Install this device         */
   CmdError,          /* 0x15  reserved                       */
   CmdError,          /* 0x16  get number of partitions       */
   CmdError,          /* 0x17  get unit map                   */
   CmdError,          /* 0x18  no caching read                */
   CmdError,          /* 0x19  no caching write               */
   CmdError,          /* 0x1A  no caching write/verify        */
   HIDInit,           /* 0x1B  initialize device driver       */
   CmdError,          /* 0x1C  reserved for Request List code */
   CmdError,          /* 0x1D  get driver capabilities        */
   CmdError,          /* 0x1E  reserved                       */
   HIDInitComplete    /* 0x1F  initialization complete        */
};                    /*--------------------------------------*/

PFN      Device_Help    = NULL;  /* devhelp entry point; used by dhcalls.lib */

/*----------------------------------------------*/
/* GLOBAL VARS FOR RM                           */
/*                                              */
/* RM.LIB needs these declared                  */
/*----------------------------------------------*/
ULONG       RMFlags     = 0L;
PFN         RM_Help0    = 0L;
PFN         RM_Help3    = 0L;

/*--------------------------------------------------------*/
/* Set the DRIVERSTRUCT and DETECTEDSTRUCT data areas     */
/*--------------------------------------------------------*/

char  near  gDDName[];                  /* device driver name */
char  near  gDDDesc[];                  /* device driver description */
char  near  gVendorID[];                /* vendor identification */
char  near  gAdapterName[];             /* adapter name */

/*----------------------------------------------*/
/* Driver Description   (rmbase.h)              */
/*----------------------------------------------*/
DRIVERSTRUCT gDriverStruct =
{
   gDDName,                            /* DrvrName                */
   gDDDesc,                            /* DrvrDescript            */
   gVendorID,                          /* VendorName              */
   CMVERSION_MAJOR,                    /* MajorVer                */
   CMVERSION_MINOR,                    /* MinorVer                */
   1998,10,26,                         /* Date                    */
   DRF_STATIC,                         /* DrvrFlags               */
   DRT_OS2,                            /* DrvrType                */
   DRS_CHAR,                           /* DrvrSubType             */
   NULL                                /* DrvrCallback            */
};

/*----------------------------------------------*/
/* Adapter Description                          */
/*----------------------------------------------*/
ADAPTERSTRUCT gAdapterStruct =
{
   gAdapterName,                       /* AdaptDescriptName; */
   AS_NO16MB_ADDRESS_LIMIT,            /* AdaptFlags;        */
   AS_BASE_INPUT,                      /* BaseType;          */
   AS_SUB_OTHER,                       /* SubType;           */
   AS_BASE_COMM,                       /* InterfaceType;     */
   NULL,                               /* HostBusType;       */
   AS_BUSWIDTH_32BIT,                  /* HostBusWidth;      */
   NULL,                               /* pAdjunctList;      */
   NULL                                /* reserved           */
};

/*----------------------------------------------*/
/* GLOBAL HANDLE VARIABLES                      */
/*                                              */
/* These variables are assigned the handles for */
/* drivers, detected hardware and resources.    */
/*----------------------------------------------*/

HDRIVER        ghDriver     = NULL;        // global handle to driver
HADAPTER       ghAdapter    = NULL;        //   global handle to adapter

CHAR           gOEMDriverName[9] = "OEMHLP$ ";
CHAR           gUSBDriverName[9] = "USBD$   ";

IDCTABLE       gDDTable =  { { 0, 0, 0}, 0, 0};

PUSBIDCEntry   gpUSBDIDC = NULL;
USHORT         gdsUSBIDC = 0;

USHORT         gMaxClients = MAX_CLIENTS;
USHORT         gMaxDevices = MAX_DEVICES;

USHORT         gNoOfRegisteredClients = 0;
DriverList     gClientDrivers[MAX_CLIENTS];   // registered client driver table
USHORT         gNoOfActiveDevices = 0;
DeviceList     gActiveDevices[MAX_DEVICES];   // active device list served by HID

// report data storing
USHORT         gMaxRepItems = MAX_REP_ITEMS;
USHORT         gMaxItemUsages = MAX_ITEM_USAGES;
USHORT         gMaxItemDesignators = MAX_ITEM_DESIGNATORS;
USHORT         gMaxItemStrings = MAX_ITEM_STRINGS;

ReportItemData gReportItemData[MAX_REP_ITEMS];
ItemUsage      gItemUsage[MAX_ITEM_USAGES];
ItemDesignator gItemDesignator[MAX_ITEM_DESIGNATORS];
ItemString     gItemString[MAX_ITEM_STRINGS];

#ifdef   DEBUG
USHORT         gHIDMsgLevel=DBG_CRITICAL;       // debug message level
#endif

BYTE           gInitDataStart = 0;  // Marks the end of the data segment

USHORT         gVerbose       = 0;  // output message level

#define MSG_REPLACEMENT_STRING  1178

USHORT         gMessageIDs[MAX_INIT_MESSAGE_COUNT]={0};
USHORT         gMessageCount=0;
PSZ            gVMessages[]={ "IUSBHID.SYS: USB Human Interface Device Class driver v.%dd.%dd loaded",
   "EUSBHID.SYS: USBD.SYS driver not loaded",
   "EUSBHID.SYS: Invalid numeric value in CONFIG.SYS line at column %dddd",
   "EUSBHID.SYS: Invalid key value in CONFIG.SYS line at column %dddd"};

MSGTABLE       gInitMsg = { MSG_REPLACEMENT_STRING, 1, 0};

