;/*****************************************************************************
;*
;* SOURCE FILE NAME = TOUIO.INC
;*
;* DESCRIPTIVE NAME =
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         07/12/91
;*
;* DESCRIPTION
;*
;* FUNCTIONS    print,          pstr,           putstr,         putch,
;*              getch,          phword,         crlf.
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*****************************************************************************/

public          putstr, pstr, print, crlf, phword


;/***************************************************************************
;*
;* FUNCTION NAME = print
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

print           proc    near

        pusha
        mov     bp,sp
        mov     bp, [bp+6]              ; bp = original sp
        push    ds
        push    es

        mov     di, [bp]                ; get return addr
        push    di                      ; save string start

        push    cs                      ; set segment
        pop     es
        mov     cx, 255                 ; max length
        xor     al, al                  ; null terminated
        cld
        repne   scasb                   ; search for end
        jz      print1                  ; jif found

        ;*
        ;* here if not found, so cannot return!
        ;*

        mov     ax, offset print_err
        mov     cx, print_err_len
        push    DSEG
        call    pstr
printx: jmp     printx                  ; panic!

print1:
        ;*
        ;* make cx string length excluding null
        ;*

        not     cl
        dec     cl
        mov     ch,0                    ; not needed

        mov     [bp], di                ; return following string

        pop     ax                      ; get back string start
        push    cs                      ; set segment
        pop     ds
        call    pstr

        pop     es
        pop     ds
        popa

        ret

print           endp


;/***************************************************************************
;*
;* FUNCTION NAME = pstr
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = ax - string offset in dseg
;*                 cx - length
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

pstr            proc    near

        push    STDOUT
        push    ds
        push    ax
        push    cx
        push    DSEG
        push    offset xfer_len
        call    DOSWRITE

        ret

pstr            endp


;/***************************************************************************
;*
;* FUNCTION NAME = putstr
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

PROCEDURE       putstr  near

PARAMETER       string  WORD

BEGINPROC

        push    ds
        push    es
        pusha

        mov     ax, ds                  ; ds -> es
        mov     es, ax

        mov     di, string              ; get offset
        mov     cx, 255                 ; max length
        xor     al, al                  ; null terminated
        cld
        repne   scasb                   ; search for end
        jnz     puts_leave              ; jif not found

        not     cl
        dec     cl
        mov     ch,0                    ; ucbw

        mov     ax, string
        call    pstr

puts_leave:

        popa
        pop     es
        pop     ds

ENDPROC         putstr


;/***************************************************************************
;*
;* FUNCTION NAME = putch
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

putch           proc    near

        mov     char_buff, al
        mov     ax, offset char_buff
        mov     cx, 1
        jmp     pstr

putch           endp


;/***************************************************************************
;*
;* FUNCTION NAME = getch
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

getch           proc    near

        pusha
        push    ds
        push    es
        push    STDIN
        push    ds
        push    offset char_buff
        push    1
        push    ds
        push    offset xfer_len
        call    DOSREAD
        pop     es
        pop     ds
        popa

        mov     al, char_buff

        ret

getch           endp


;/***************************************************************************
;*
;* FUNCTION NAME = phword
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

phword          proc    near

        pusha

        mov     si, offset hex
        mov     di, offset hex_buff
        mov     cx, 4

phword1:
        mov     bl, ah
        shr     bl, 4
        mov     bh,0
        mov     bl, byte ptr [bx+si]
        mov     [di], bl
        inc     di
        shl     ax,4
        loop    phword1

        mov     ax, offset hex_buff
        mov     cx, 4
        call    pstr

        popa

        ret

phword          endp


;/***************************************************************************
;*
;* FUNCTION NAME = crlf
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

crlf            proc    near

        push    ax
        push    cx

        mov     ax, offset mcrlf
        mov     cx, mcrlf_len
        call    pstr

        pop     cx
        pop     ax

        ret

crlf            endp

;*
;* end
;*
