;/*****************************************************************************
;*
;* SOURCE FILE NAME = TOUFILT.INC
;*
;* DESCRIPTIVE NAME = Tables of Filter Constants
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         11/12/91
;*
;* DESCRIPTION
;*              Default Filter Values at Cut-Off Frequency
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*****************************************************************************/

;*
;* Remember to change 'FILT_F_MAX' & 'FILT_T_MAX' in TOUEQU.INC
;*


if1
%out *** Filters loaded
endif

;* Prescott (Bessel) 4.00, 2.75, 4.00, 5.00, 6.00

;*
;* 4.00Hz (0,0)
;*
FILT <094CA0002H,0EA3B0101H,0F93800FFH,0E17600F9H,\
0E17600F9H,0964F00F8H,0964F00F8H,50H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,00H,00H,00H,10H,00H,00H,10H,11H,12H,\
12H,22H,32H,23H,22H,21H,10H,10H,00H,00H>

;*
;* 2.75Hz (0,1)
;*
FILT <0A1B20002H,089270102H,09C200000H,0A22600F8H,\
0A22600F8H,0D83300F6H,0D83300F6H,50H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,10H,09H,10H,10H,10H,01H,11H,11H,12H,\
22H,12H,13H,21H,02H,11H,01H,00H,00H,00H>

;*
;* 4.00Hz (0,2)
;*
FILT <094CA0002H,0EA3B0101H,0F93800FFH,0E17600F9H,\
0E17600F9H,0964F00F8H,0964F00F8H,50H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,00H,00H,00H,10H,00H,00H,10H,11H,12H,\
12H,22H,32H,23H,22H,21H,10H,10H,00H,00H>

;*
;* 5.00Hz (0,3)
;*
FILT <08AD70002H,0CDEB0101H,0CFFB00FFH,0CB9800FAH,\
0CB9800FAH,087BB00F9H,087BB00F9H,50H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,11H,\
11H,22H,22H,23H,33H,22H,12H,01H,00H,00H>

;*
;* 6.00Hz (0,4)
;*
FILT <081380002H,0B4990101H,0AD7700FFH,0A30B00FBH,\
0A30B00FBH,0D96400F9H,0D96400F9H,50H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,00H,00H,00H,10H,00H,00H,00H,00H,00H,\
11H,11H,32H,32H,33H,23H,22H,10H,00H,00H>


;* GJC ; Touch Panel (Bessel) 8.00, 5.50, 8.00, 10.00, 12.00
;* new   Touch Panel (Bessel) 12.00, 6.00, 12.00, 24.00, 48.00

;*
;* ---- Bessel Low Pass Filter Constants (12.00Hz) ------- default
;*
FILT <09B3D0001H, 09B5B0100H, 0E61000FDH, 0D85D00FDH,\
0D85D00FDH, 0903E00FCH, 0903E00FCH, 50H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,00H,00H,20H,54H,55H,34H,11H,00H>

;*
;* ---- Bessel Low Pass Filter Constants ( 6.00Hz) ------- slow
;*
FILT <081380002H, 0B4990101H, 0AD7700FFH, 0A30B00FBH,\
0A30B00FBH, 0D96400F9H, 0D96400F9H, 50H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,11H,11H,\
32H,32H,33H,23H,22H,10H,00H,00H>

;*
;* ---- Bessel Low Pass Filter Constants (12.00Hz) ------- medium
;*
FILT <09B3D0001H, 09B5B0100H, 0E61000FDH, 0D85D00FDH,\
0D85D00FDH, 0903E00FCH, 0903E00FCH, 50H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,20H,54H,55H,34H,11H,00H>

;*
;* ---- Bessel Low Pass Filter Constants (24.00Hz) ------- fast
;*
FILT <0B5AD01FCH, 0A37901FEH, 0B98C00F8H, 0E6A000FFH,\
0E6A000FFH, 099C000FEH, 099C000FEH, 28H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,00H,00H,72H,77H,67H,02H>

;*
;* ---- Bessel Low Pass Filter Constants (48.00Hz) ------- rapido
;*
FILT <0FEAB0101H, 0AF0D0101H, 0A43401FFH, 0E08A0001H,\
0E08A0001H, 095B10000H, 095B10000H, 14H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,00H,\
00H,00H,00H,00H,00H,30H,77H,77H>

;*
;* end
;*
