;/*****************************************************************************
;*
;* SOURCE FILE NAME = TOUEQU.INC
;*
;* DESCRIPTIVE NAME =
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         07/12/91
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*****************************************************************************/

SET_QSIZE       equ     1       ; 0=off 1=on, allow settable q size

;* DEBUG        equ     1       ; define for debug code
DEBSYM          equ     1       ; define for debug symbols

IFDEF   DEBUG
        IF1
                %OUT    *************
                %OUT    DEBUG Enabled
                %OUT    *************
                %OUT
        ENDIF
ENDIF


x       macro mess, name
IF1
%OUT *** mess name
ENDIF
        endm

IF1
%OUT *** Version 2.00.06
ENDIF
VERSION         equ     "2.00.06"
VERS_BCD        equ     0200h
;* x <Version >, %VERSION

IF1
;%OUT *** Micro Code Level 210
ENDIF
MC_LEVEL        equ     210
MC_LVL_BCD      equ     0021h

;*
;* Mouse & Touch Status Flags
;*
MS_REAL_MOUSE           equ     1
MS_DI_ATTACHED          equ     2
MS_PROT_EMUL            equ     4
MS_REAL_EMUL            equ     8
MS_EMUL_BEEP            equ     16

TS_CALIBRATED           equ     1


;*
;* BIOS DAta Area
;*
BIOS_DATA_AREA          equ     40h     ; segment/selector
BDA_EQUIPMENT           equ     10h     ; offset
BDA_EQUIP_PD            equ     4       ; bit


;*
;* Mouse Interrupt Definitions
;*
MOU_INT_NUM             equ     12
MOU_AUX_MASK            equ     1 shl (MOU_INT_NUM-8)


;*
;* Prescott Default values, set at init time
;*
SET_DEFAULTS            equ     -32768  ; set defaults

DEF_REP_RATE            equ     3       ; report rate

DEF_USER_MPI            equ     200     ; mickeys per inch

DEF_FXED_MPI_X          equ     1760    ; 110
DEF_FXED_MPI_Y          equ     2400    ; 150

;* Threshold ito z-scale
DEF_THRE_OTH_Z          equ     46      ; on-screen threshold
DEF_THRE_PTH_Z          equ     96      ; push threshold
DEF_THRE_PHY_Z          equ     80      ; push hysteresis

DEF_THRE_SFACT          equ     956     ; scale factor

PFLOAT_0                equ     0               ; floating point 0.0
PFLOAT_1                equ     80000001h       ; floating point 1.0

DEF_CLK_SIZE            equ     300     ; click lock area (prescott coords)
DEF_CLK_TIME            equ     500     ; click lock time-out (ms)
DEF_CLK_TYPE            equ     2       ; click lock type (0,1,2)

DEF_FILT_TYPE           equ     0       ; filter type
DEF_FILT_FREQ           equ     0       ; filter frequency

DEF_X_OFFSET            equ     0       ;
DEF_Y_OFFSET            equ     0       ;

;*
;* ABIOS equates
;*
ABIOS_START             equ     0
ABIOS_INT               equ     1

ABIOS_OK                equ     0       ; opperation successful
ABIOS_SOI               equ     1       ; stage on interrupt
ABIOS_SOT               equ     2       ; stage on time
ABIOS_SOI_NMI           equ     5       ; not my int, SOI
ABIOS_SOI_ATTN          equ     9       ; attention, SOI, data available
ABIOS_DIU               equ     8000h   ; device in use
ABIOS_ERR               equ     8000h   ; error bit
ABIOS_RESEND            equ     8001h   ; resend
ABIOS_NAK               equ     8004h   ; negative acknowledge
ABIOS_NAK_RESEND        equ     0FFFFh  ; NAK during resend

ABIOS_DEFINT            equ     00H     ; default interupt handler
ABIOS_GETLIDP           equ     01H     ; return logical ID parameters
;* reserved             equ     02H     ; reserved ?
ABIOS_GETPARMS          equ     03H     ; read device parameters
;* reserved             equ     04H     ; set device parameters
ABIOS_RESET             equ     05H     ; reset/init device
ABIOS_ENABLE            equ     06H     ; enable
ABIOS_DISABLE           equ     07H     ; disable
ABIOS_CONTREAD          equ     08H     ; continuous read
;* reserved             equ     09H     ; write
;* reserved             equ     0AH     ; additional data transfer
ABIOS_SETRATE           equ     0BH     ; set sample rate
ABIOS_SETRESOL          equ     0CH     ; set resolution
ABIOS_SETSCALE          equ     0DH     ; set scaling
ABIOS_RETIDENT          equ     0EH     ; read ID code
ABIOS_SBS               equ     0FH     ; send byte string

;*
;* Prescott IO Commands
;*

PIO_FIRST_CMD           equ     0b0h

PIO_WRITE_MEM           equ     0b0h    ; write memory
PIO_READ_MEM            equ     0b1h    ; read memory
PIO_STAT_REQ            equ     0b2h    ;
PIO_RES_WRAP            equ     0b3h    ;
PIO_READ_LEVEL          equ     0b4h    ;
PIO_SET_WRAP            equ     0b5h    ;
PIO_RAM_EXE             equ     0b6h    ;
PIO_READ_POST           equ     0b7h    ;
PIO_READ_TYPE           equ     0b8h    ;
PIO_ACQ_OFF             equ     0b9h    ;
PIO_RESEND              equ     0bah    ;
PIO_RESET               equ     0bbh    ;
;*                      equ     0bch    ;
PIO_SET_COORD           equ     0bdh    ;
;*                      equ     0beh    ;
PIO_SET_FDFWD           equ     0bfh    ;
PIO_LD_THRE             equ     0c0h    ;
PIO_SET_STREAM          equ     0c1h    ;
PIO_READ_DATA           equ     0c2h    ;
PIO_SET_REMOTE          equ     0c3h    ;
PIO_SET_SAMPLE          equ     0c4h    ;
PIO_EN_STREAM           equ     0c5h    ;
PIO_DIS_STREAM          equ     0c6h    ;
PIO_SET_DEF             equ     0c7h    ;
PIO_SET_MISC            equ     0c8h    ;
PIO_EN_RAW              equ     0c9h    ;
PIO_EN_XYZ              equ     0cah
;*                      equ     0cbh
PIO_DMC                 equ     0cch
PIO_SET_ENV             equ     0cdh
PIO_SET_CALIB           equ     0ceh
PIO_SET_FILT            equ     0cfh

PIO_LAST_CMD            equ     0cfh

PD_DEVID                equ     0bh     ; pointing device ID
CALIB_SIZE              equ     40      ; number calibration bytes


;*
;* ASCII Characters
;*
CR                      equ     0dh
LF                      equ     0ah
TAB                     equ     09h


;*
;* GP Flags
;*
OFF                     equ     0
ON                      equ     1
NO                      equ     0
YES                     equ     1
FALSE                   equ     0
TRUE                    equ     not FALSE


;*
;* Standard IO Handles
;*
STDIN                   equ     0
STDOUT                  equ     1


;*
;* Length of Device Driver Name
;*
NAME_LEN                equ     8


;*
;* Mode Flags
;*
BOTH                    equ     0
REAL                    equ     1
PROT                    equ     2


;*
;* Device Header Attributes
;*
DATT_KBD                equ     0001h   ; STDIN device
DATT_SCR                equ     0002h   ; STDOUT device
DATT_NUL                equ     0004h   ; NULL device
DATT_CLK                equ     0008h   ; CLOCK device
;*                              0010h   ; RESERVED
;*                              0020h   ; RESERVED
;*                              0040h   ; RESERVED
DATT_L1                 equ     0080h   ; driver function level
DATT_L2                 equ     0100h   ; driver function level
DATT_L3                 equ     0180h   ; driver function level
DATT_L4                 equ     0200h   ; driver function level
DATT_LSHFT              equ     7       ; driver function level shift factor
;*                              0400h   ; RESERVED
DATT_OPN                equ     0800h   ; open/close mandatory (char)
DATT_SHR                equ     1000h   ; shared device checking (char)
DATT_IBM                equ     2000h   ; o/p until busy (char)
DATT_IDC                equ     4000h   ; idc interface supported
DATT_CHR                equ     8000h   ; character device driver


;*
;* Touch INT15 AH& AL Values
;*
TOU_INT15_AH            equ     0c2h    ; pointing device
TOU_INT15_AL_MIN        equ     10h     ; first func for touch
TOU_INT15_AL_MAX        equ     25h     ; last func for touch


;*
;* Touch INT7f AX and BX Values
;*
TOU_INT7F_AX            equ     0ABCDh  ; touch int7f ax value
TOU_INT7F_BX            equ     0       ; touch int7f bx value


;*
;* DevHlp Get Dos Var Index Numbers
;*
DH_GDV_GIS              equ     1       ; global info segment
DH_GDV_LIS              equ     2       ; local info segment


;*
;* Strategy Request Packet Commands
;*
CMD_INIT                equ     0
CMD_IFLUSH              equ     7
CMD_OPEN                equ     0dh
CMD_CLOSE               equ     0eh
CMD_IOCTL               equ     10h
CMD_DEINS               equ     14h
CMD_SHTDWN              equ     1ch


;*
;* Status Returns for Strategy Request Packet
;*
STAT_NOERR              equ     0       ; no error
STAT_DONE               equ     0100h   ; RB completed
STAT_BUSY               equ     0200h   ; RB busy
STAT_DERR               equ     4000h   ; RB device error
STAT_GERR               equ     8000h   ; RB general error

STAT_UCMD               equ     8003h   ; unknown command RB error
STAT_GENF               equ     800ch   ; general failure RB error
STAT_CINT               equ     8011h   ; char i/o call interrupted
STAT_MNS                equ     8012h   ; monitors not supported
STAT_PINV               equ     8013h   ; invalid parms RB error
STAT_ABORT              equ     802fh   ; fatal init error, abort DD load
STAT_PBAD               equ     804fh   ; config parms init error
STAT_ERROR              equ     808fh   ; serious init error, shutdown DD

;* ??? the following may need changing
;* STAT_QMT             equ     80fbh   ; event q empty
;* STAT_NOTFG           equ     80fch   ; session not in foreground
;* STAT_NOEMUL          equ     80fdh   ; no emulation available
;* STAT_NODCC           equ     80feh   ; no calibration constants
;* STAT_HUPF            equ     80ffh   ; hardware update failure
;* CLOSE_HUPF           equ     8006h   ; as above (same as seek error)
;* OPEN_HUPF            equ     8006h   ; as above (same as seek error)
                                        ; gets translated to 0x0019 on exit
                                        ; from DosOpen & DosClose

;*
;* Status Requests for Strategy Routine (OPEN/CLOSE ONLY)
;*
STAT_MONITOR            equ     0008h   ; monitor open/close request


;*
;* Touch Category
;*
IOCTL_TOU_CAT           equ     129     ;TEMP


;*
;* Monitor Category
;*
IOCTL_MON_CAT           equ     10
IOCTL_REG_MON           equ     40h


;*
;* General Category
;*
IOCTL_GEN_CAT           equ     11
IOCTL_SSN_NOTIFI        equ     41h
IOCTL_Q_MONSUP          equ     60h


;*
;* Device Status Bits Used in sgcb_dev_stat
;*
;* system settable flags
DS_BUSY                 equ     0001h
DS_BLOCK                equ     0002h
DS_QFLUSH               equ     0004h
DS_USS                  equ     0008h

;* user settable flags
DS_RAWMODE              equ     0200h
DS_SQ                   equ     0400h

DS_SYS                  equ     000ffh
DS_USER                 equ     0ff00h


;*
;* Touch IOCTL parameters & range checks
;*
;* IOC_SEM_MASK         equ     0FBBFh  ; xyz & raw     ???TEMP
IOC_SEM_XYZ             equ     00BBFh  ; xyz only mask
IOC_SEM_RAW             equ     0F880h  ; raw only mask

IOC_SDS_MASK            equ     DS_SQ
;* IOC_SDS_MASK         equ     DS_SQ or DS_RAWMODE

;* IOC_SEO_CURR         equ     0001h   ; emul current
;* IOC_SEO_DEF          equ     0002h   ; emul default
;* IOC_SEO_DFLAG        equ     8000h   ; default flag
;* IOC_SEO_MASK         equ     1       ; ** 0.21c

IOC_SEO_MASK            equ     8001h   ; ** 0.21c
IOC_SEO_DEF             equ     1       ; ** 0.21c
IOC_SEO_CURR            equ     8000h   ; ** 0.21c

IOC_SCO_MAX             equ     1       ; coord origin

IOC_SSM_MASK            equ     7       ; selection mech valid bits
IOC_SSM_LO              equ     1       ; selection mech lift off bit
IOC_SSM_ST              equ     2       ; selection mech single touch
IOC_SSM_SP              equ     4       ; selection mech stable point
IOC_SSM_POINTS_MAX      equ     40
IOC_SSM_TOL_MAX         equ     4095
IOC_SSM_STACK_MAX       equ     40

IOC_SRR_MAX             equ     4       ; report rate

IOC_REQ_WAIT            equ     1       ; read event q, wait value
IOC_REQ_MAX             equ     1       ; read event q, max flag

IOC_SDC_TYPE_MAX        equ     2       ; dbl clk, prot mode
IOC_SDC_DOSTYPE_MAX     equ     1
IOC_SDC_SIZE_MAX        equ     4095
IOC_SDC_TIME_MAX        equ     65535
;* IOC_SCK_MAX          equ     1       ; clk lock, dos mode

SPM_MASK                equ     1
MEO_MASK                equ     1


FILT_F_MAX              equ     4       ; maximum default frequency
FILT_T_MAX              equ     1       ; maximum default type


IOC_SCS_XMAX            equ     4095    ; coord system, x max
IOC_SCS_YMAX            equ     4095    ; coord system, y max
IOC_SCS_ZMAX            equ     255     ; coord system, z max
IOC_SCS_HMAX            equ     32767   ; coord system, ? max

IOC_SCO_OMAX            equ     1       ; coord origin parameter

SSM_SMAX                equ     1       ; selection mechanism
SRR_RMAX                equ     4       ; report rate
REQ_WMAX                equ     1       ; read event queue, wait pararameter
SEO_LEGAL               equ     1       ; emulation on/off

IOC_DBM_MASK            equ     7       ; data block mask

;* IOC_CM_MASK          equ     01FFh   ; TEMP
IOC_CM_XYZ              equ     01FFh   ; valid call mask xyz mode
;* IOC_CM_RAW           equ     8000h   ; valid call mask raw mode ; --0.21c
IOC_CM_RAW              equ     8e40h   ; valid call mask raw mode ; ++0.21c

IOC_CM_RAW_MODE         equ     8000h   ; call mask raw mode


;*
;* Touch IOCTL Read Event Queue Status bits
;*
if 0
IOC_REQS_DXY            equ     0001h   ; delta x or y
IOC_REQS_DZ             equ     0002h   ; delta z
IOC_REQS_OS             equ     0010h   ; on-screen
IOC_REQS_SD             equ     0020h   ; selection detection
;* IOC_REQS_UL          equ     0040h   ; NOT USED
IOC_REQS_CP             equ     0800h   ; channel pegged
IOC_REQS_HW_ERR         equ     0080h   ; hardware error (ge, fp, oe)
IOC_REQS_DSD1           equ     0008h   ; selection detection going on
IOC_REQS_DSD0           equ     0200h   ; selection detection going off
IOC_REQS_DOS1           equ     0004h   ; on-screen going on, touch down
IOC_REQS_DOS0           equ     0100h   ; on-screen going off, lift off
;* not used             equ     0400h   ; NOT USED
IOC_REQS_OE             equ     1000h   ; offset error
IOC_REQS_FE             equ     2000h   ; floating point error
IOC_REQS_AO             equ     4000h   ; adjust occurred
IOC_REQS_RAW            equ     8000h   ; raw mode

;*
;* data is in error if these bits are set
;*
IOC_REQS_ERROR          equ     IOC_REQS_CP or IOC_REQS_HW_ERR

;*
;* prot mode does not report these bits in xyz mode
;*
IOC_REQS_XYZ_ERR_MASK   equ     IOC_REQS_OE or IOC_REQS_FE or IOC_REQS_AO

else
IDC_STAT_TS2            equ     0001h
IDC_STAT_TS1            equ     0002h
IDC_STAT_SD             equ     0004h
IDC_STAT_ERR            equ     8000h

endif


;*
;* Prescott data packet statuses
;*
PRES_S1_HE              equ     01h     ; hardware error
PRES_S1_OE              equ     02h     ; offset error
PRES_S1_FE              equ     04h     ; float error
PRES_MOU_IND            equ     08h     ; mouse indicator (_S1/_S2, _R1/_R2)
PRES_S1_CP              equ     10h     ; channel pegged
PRES_S1_ADJ             equ     20h     ; adjust occured
;* PRES_S1_TI           equ     40h     ; NOT USED
PRES_PKT_IND            equ     80h     ; packet indicator,p1==0,p2==1 (_R1/2)
PRES_S1_ERR             equ     37h     ; error: he, oe, fe, cp, adj

PRES_S2_TS2             equ     10h     ; TS2 (previous on-screen status)
PRES_S2_TS1             equ     20h     ; TS1 (current on-screen status)
PRES_S2_SD              equ     40h     ; selection detection

PRES_R1_CP              equ     40h     ; raw channel pegged
PRES_R2_AO              equ     04h     ; raw adjust occured
PRES_R2_OE              equ     40h     ; raw offset error


;*
;* Local Info Seg Process Types
;*
LIS_PT_FULLSCRN         equ     0
LIS_PT_REAL             equ     1
LIS_PT_VIOWIN           equ     2
LIS_PT_PRESMGR          equ     3
LIS_PT_DETACHED         equ     4


;*
;* Session or Screen Group IDs
;*
SG_SHELL                equ     1       ; SG ID of shell/pm
SG_REAL                 equ     2       ; SG ID of real mode
SG_VIOPOP               equ     3       ; SG ID of VIO pop session
SG_MAX                  equ     16      ; max number of sessions supported


;*
;* Event Queue Data
;*
EQ_MAX                  equ     100     ; max number of event queue elements


;*
;* Session Switch or Termination Notification Bits
;*
SSTN_SAVE               equ     1
SSTN_SWAP               equ     2
SSTN_REST               equ     4
SSTN_TERM               equ     8


;*
;* Single Queue Funtions
;*
SQ_INIT                 equ     1
SQ_WRITE                equ     2
SQ_END                  equ     3
SQ_UPDATE               equ     4


;*
;* Hardware Update Flags
;*
HUP_DEFAULT             equ     0       ; defaults set
HUP_SCS_MAIN            equ     0001h   ; set coord sys
HUP_DFC                 equ     0002h   ; download filt cons
HUP_SRR                 equ     0004h   ; set report rate
HUP_STH                 equ     0008h   ; set thresholds
HUP_RAW1                equ     0010h   ; set raw mode
HUP_MISC                equ     0020h   ; set all misc data
HUP_SETDEF              equ     0040h   ; set defaults needed
HUP_EMUL                equ     0080h   ; set emulation parms
;* HUP_ACQ              equ     0100h   ; set acquire offsets
HUP_DCC                 equ     0200h   ; download calib const

;* HUP_RRAW             equ     0400h   ; read raw data
;* HUP_RXYZ             equ     0800h   ; read XYZ data

HUP_HW_FAILED           equ     1000h   ; test if HW failed
HUP_RDMEM               equ     2000h   ; read memory
HUP_WRMEM               equ     4000h   ; write memory
;* HUP_                 equ     8000h   ; ?


HUP_SCS                 equ     HUP_SCS_MAIN or HUP_MISC; set coord system
HUP_SCO                 equ     HUP_MISC                ; set coord org
HUP_SSM                 equ     HUP_MISC                ; set selection mech

;*
;* session switch restore
;*
HUP_REST        equ     HUP_SCS or HUP_SRR or HUP_STH or HUP_SCO or HUP_SSM or \
                        HUP_MISC or HUP_EMUL or HUP_DFC or HUP_RAW1
;* HUP_REST     equ     HUP_SCS or HUP_SRR or HUP_STH or HUP_SCO or HUP_SSM or
;*                      HUP_MISC or HUP_EMUL
;* HUP_REST     equ     HUP_SCS or HUP_SRR or HUP_STH or HUP_SCO or HUP_SSM or
;*                      HUP_RAW or HUP_MISC or HUP_SETDEF or HUP_EMUL or HUP_DFC


;*
;* TOUCHDD Device Status bits
;*
DEVS_READ_EN            equ     1       ; read enable rxed from DIDD
DEVS_ATTACHED           equ     2       ; attach to DIDD successful
DEVS_ABIOS              equ     4       ; abios installed
DEVS_DEINS              equ     8       ; deinstall cmd rxed from DIDD
DEVS_EN_DEV             equ     10h     ; enable dev rxed from DIDD
DEVS_DCC                equ     20h     ; download calib const rxed


;*
;* DOS mode interrupt stuff
;*
DOS_NEST_MAX            equ     2       ; max dos user proc nesting level


;*
;* Dos INT 7F error returns
;*
I7F_OK                  equ     0       ; no error
I7F_IP_ERR              equ     1       ; invalid input
I7F_IF_ERR              equ     2       ; interface error
I7F_UN_ERR              equ     3       ; unable to perform cmd


;*
;* Dos Block Mask for INT 7F Calls (set data block mask)
;*
DOS_BLK_ALL             equ     1
;* DOS_BLK_UL           equ     2       ; not used
DOS_BLK_CP              equ     4


;*
;* Dos Call Mask for INT7F Calls (set/swap user subr, user subr condition mask)
;*
DOS_CALL_DXY            equ     0001h
DOS_CALL_DZ             equ     0002h
DOS_CALL_SD10           equ     0004h
DOS_CALL_SD01           equ     0008h
DOS_CALL_LO             equ     0010h
DOS_CALL_TD             equ     0020h
;* dos mou emul         equ     0040h
;* dos mou emul         equ     0080h
;* dos mou emul         equ     0100h
DOS_CALL_RAW            equ     8000h


;*
;* Dos Statuses for INT7F Calls (get current position & status, get xxx info)
;*
DOS_STAT_TS2            equ     0001h
DOS_STAT_TS1            equ     0002h
DOS_STAT_SD             equ     0004h
;* DOS_STAT_UL          equ     0008h   ; not used
DOS_STAT_CP             equ     0010h
;* DOS_STAT_AO          equ     0100h   ; adjust occurred
;* DOS_STAT_FE          equ     0200h   ;
;* DOS_STAT_OE          equ     0400h
DOS_STAT_CP_RAW         equ     0040h
DOS_STAT_OE_RAW         equ     0200h
DOS_STAT_AO_RAW         equ     0800h
DOS_STAT_RAW            equ     8000h


;*
;* Dos mode SG CB offset
;*
REAL_SGCB       equ     offset sgcb_start + (SG_REAL * size SGCB)

;*
;* end
;*
