;/*****************************************************************************
;*
;* SOURCE FILE NAME = PROC.INC
;*
;* DESCRIPTIVE NAME = Procedure reference macros
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         07/12/91
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*****************************************************************************/

if1
$in?    macro   item,list
        $in = 0
        irp     x,<list>
                ifidn   <item>,<x>
                        $in = 1
                endif
        endm
endm

Procedure macro ProcName,ProcSize,Scope
                                        ProcName proc ProcSize
$VarCount  =    0
$InProc    =    1
$ProcBegun =    0
$VarFrame  =    0
$VarSize   =    0
$ParmSize  =    0
$ParmFrame =    2 - (2 * (type ProcName))
ifnb <scope>
        $in? scope,<public,PUBLIC>
        if $in
                                        public ProcName
        else
                $in? scope,<local,LOCAL>
                ife $in
                        .err
                        %out error -- invalid scope
                endif
        endif
endif
endm

BeginProc macro
if $InProc eq 0
        .err
        %out error -- not in procedure
exitm
endif
$ProcBegun =    1
;*
;*                                      push bp
;*                                      mov  bp,sp
;* if $VarSize ne 0
;*                                      sub  sp,$VarSize
;* endif
;*
enter $VarSize,0
endm

EndProc macro   ProcName
if $VarCount ne 0
        .err
        %out error -- all variables not yet freed
;* ;;;; exitm
endif

if $InProc eq 0
        .err
        %out error -- not in procedure
exitm
endif
if ($ProcBegun eq 0) and (($VarSize ne 0) or ($ParmSize ne 0))
        .err
        %out error -- BeginProc missing
exitm
endif
$InProc = 0
;*
;* if $VarSize ne 0
;*                                      mov sp,bp
;* endif
;*
if $ProcBegun
;*                                      pop bp
leave
endif
if $ParmSize ne 0
                                        ret $ParmSize
else
                                        ret
endif
                                        ProcName endp
endm

$Define macro SymName,ptype,value
SymName equ (ptype ptr [bp+value])
endm

Parameter macro ParmName,ParmSize
if $InProc eq 0
        .err
        %out error -- not in procedure
        exitm
endif
$in?    <ParmSize>,<byte,BYTE>
if      $in ne 0
        $Define ParmName,byte,%($ParmFrame+$ParmSize)
        $ParmSize = $ParmSize + 2
        exitm
endif
$in?    <ParmSize>,<word,WORD>
if      $in ne 0
        $Define ParmName,word,%($ParmFrame+$ParmSize)
        $ParmSize = $ParmSize + 2
        exitm
endif
$in?    <ParmSize>,<dword,DWORD>
if      $in ne 0
        $Define ParmName,dword,%($ParmFrame+$ParmSize)
        $ParmSize = $ParmSize + 4
        exitm
endif
$in?    <ParmSize>,<qword,QWORD>
if      $in ne 0
        $Define ParmName,qword,%($ParmFrame+$ParmSize)
        $ParmSize = $ParmSize + 8
        exitm
endif
$in?    <ParmSize>,<tbyte,TBYTE>
if      $in ne 0
        $Define ParmName,tbyte,%($ParmFrame+$ParmSize)
        $ParmSize = $ParmSize + 10
        exitm
endif

$Define ParmName,byte,%($ParmFrame+$ParmSize)
$ParmSize = $ParmSize+ParmSize
if      ($ParmSize mod 2) eq 1
        $ParmSize = $ParmSize + 1
endif
endm

Variable macro  VarName,VarSize,VarLen,VarInit
        local   $$initvar
if $InProc eq 0
        .err
        %out error -- not in procedure
        exitm
endif

$VarCount = $VarCount+1

$in?    <VarSize>,<nbyte,NBYTE>
if      $in ne 0
        $VarSize = $VarSize + VarLen + (VarLen AND 1)   ; even boundary
        $Define Varname,byte,%($VarFrame-$VarSize)
;*
;*  not tested
;*  ifnb VarInit
;*      initialise nbyte array with VarInit, if it is not blank
;*      push    si
;*      push    cx
;*      lea     si,Varname
;*      mov     cx,VarLen
;*  $$initvar:
;*      mov     byte ptr ss:[si],VarInit
;*      inc     si
;*      loop    $$initvar
;*      pop     cx
;*      pop     si
;*  endif
;*
        exitm
endif
$in?    <VarSize>,<byte,BYTE>
if      $in ne 0
        $VarSize = $VarSize + 2
        $Define Varname,byte,%($VarFrame-$VarSize)
        exitm
endif
$in?    <VarSize>,<word,WORD>
if      $in ne 0
        $VarSize = $VarSize + 2
        $Define Varname,word,%($VarFrame-$VarSize)
        exitm
endif
$in?    <VarSize>,<dword,DWORD>
if      $in ne 0
        $VarSize = $VarSize + 4
        $Define Varname,dword,%($VarFrame-$VarSize)
        exitm
endif
$in?    <VarSize>,<qword,QWORD>
if      $in ne 0
        $VarSize = $VarSize + 8
        $Define Varname,qword,%($VarFrame-$VarSize)
        exitm
endif
$in?    <VarSize>,<tbyte,TBYTE>
if      $in ne 0
        $VarSize = $VarSize + 10
        $Define Varname,tbyte,%($VarFrame-$VarSize)
        exitm
endif
$VarSize = $VarSize+VarSize
if      ($VarSize mod 2) eq 1
        $VarSize = $VarSize + 1
endif
$Define Varname,byte,%($VarFrame-$VarSize)
endm

else
$InProc =       0
endif

FreeVar macro   var
if $InProc eq 0
        .err
        if2
        .err
        %out error -- not in procedure
        endif
        exitm
endif

if $VarCount le 0
        .err
        if2
        %out error -- freeing too many variables
        endif
        exitm
endif

;*
;*  if var eq [bp-bp]
;*     .err
;*     %out error -- freeing already free variable
;*  endif
;*

$VarCount = $VarCount - 1

var     equ     [bp-bp]                         ; guaranteed to fail !!

        endm
